/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.test.FlakyTest;
import android.test.UiThreadTest;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;

public class InstrumentationTestCase
extends TestCase {
    private Instrumentation mInstrumentation;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runMethod(Method method, int n) throws Throwable {
        Throwable throwable;
        int n2 = 0;
        do {
            Object var4_4 = null;
            try {
                Object[] objectArray = var4_4;
                Object object = method.invoke(this, objectArray);
                throwable = null;
                ++n2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    Throwable throwable2 = invocationTargetException.fillInStackTrace();
                    throwable = invocationTargetException.getTargetException();
                    ++n2;
                    continue;
                    catch (IllegalAccessException illegalAccessException) {
                        Throwable throwable3 = illegalAccessException.fillInStackTrace();
                        throwable = illegalAccessException;
                        ++n2;
                    }
                }
                catch (Throwable throwable4) {
                    int n3 = n2 + 1;
                    throw throwable4;
                }
            }
        } while (n2 < n && throwable != null);
        if (throwable != null) throw throwable;
    }

    public Instrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    @Deprecated
    public void injectInsrumentation(Instrumentation instrumentation) {
        this.injectInstrumentation(instrumentation);
    }

    public void injectInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = instrumentation;
    }

    public final <T extends Activity> T launchActivity(String string2, Class<T> clazz, Bundle bundle) {
        Intent intent = new Intent("android.intent.action.MAIN");
        if (bundle != null) {
            Intent intent2 = intent.putExtras(bundle);
        }
        return this.launchActivityWithIntent(string2, clazz, intent);
    }

    public final <T extends Activity> T launchActivityWithIntent(String string2, Class<T> clazz, Intent intent) {
        String string3 = clazz.getName();
        Intent intent2 = intent.setClassName(string2, string3);
        Intent intent3 = intent.addFlags(0x10000000);
        Activity activity = this.getInstrumentation().startActivitySync(intent);
        this.getInstrumentation().waitForIdleSync();
        return (T)activity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runTest() throws Throwable {
        String string2 = this.getName();
        InstrumentationTestCase.assertNotNull(string2);
        Method method = null;
        try {
            Method method2;
            Class<? extends Object> clazz = this.getClass();
            Class[] classArray = null;
            method = method2 = clazz.getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InstrumentationTestCase.fail("Method \"" + string2 + "\" not found");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            InstrumentationTestCase.fail("Method \"" + string2 + "\" should be public");
        }
        int n = 1;
        if (method.isAnnotationPresent(FlakyTest.class)) {
            n = method.getAnnotation(FlakyTest.class).tolerance();
        }
        if (!method.isAnnotationPresent(UiThreadTest.class)) {
            this.runMethod(method, n);
            return;
        }
        final int n2 = n;
        final Method method3 = method;
        final Throwable[] throwableArray = new Throwable[1];
        Instrumentation instrumentation = this.getInstrumentation();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    InstrumentationTestCase instrumentationTestCase = InstrumentationTestCase.this;
                    Method method = method3;
                    int n = n2;
                    instrumentationTestCase.runMethod(method, n);
                    return;
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                    return;
                }
            }
        };
        instrumentation.runOnMainSync(runnable);
        if (throwableArray[0] == null) {
            return;
        }
        throw throwableArray[0];
    }

    public void runTestOnUiThread(final Runnable runnable) throws Throwable {
        final Throwable[] throwableArray = new Throwable[1];
        Instrumentation instrumentation = this.getInstrumentation();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                    return;
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                    return;
                }
            }
        };
        instrumentation.runOnMainSync(runnable2);
        if (throwableArray[0] == null) {
            return;
        }
        throw throwableArray[0];
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendKeys(String var1_1) {
        var2_2 = var1_1.split(" ");
        var3_3 = var2_2.length;
        var4_4 = this.getInstrumentation();
        var5_5 = 0;
        block7: while (true) {
            block15: {
                if (var5_5 >= var3_3) {
                    var4_4.waitForIdleSync();
                    return;
                }
                var6_6 = var2_2[var5_5];
                var7_7 = var6_6.indexOf(42);
                if (var7_7 == -1) {
                    var8_8 = 1;
                } else {
                    var14_14 = 0;
                    try {
                        var8_8 = var15_15 = Integer.parseInt(var6_6.substring(var14_14, var7_7));
                    }
                    catch (NumberFormatException var16_16) {
                        var17_17 = "Invalid repeat count: " + var6_6;
                        var18_18 = Log.w("ActivityTestCase", var17_17);
                        break block15;
                    }
                }
                if (var7_7 != -1) {
                    var9_9 = var7_7 + 1;
                    var6_6 = var6_6.substring(var9_9);
                }
                block8: for (var10_10 = 0; var10_10 < var8_8; ++var10_10) {
                    var11_11 = "KEYCODE_" + var6_6;
                    var13_13 = var12_12 = KeyEvent.class.getField(var11_11).getInt(null);
                    try {
                        var4_4.sendKeyDownUpSync(var13_13);
lbl31:
                        // 2 sources

                        continue block8;
                    }
                    catch (SecurityException var25_25) {
                        ** continue;
                    }
                }
            }
lbl36:
            // 3 sources

            while (true) {
                ++var5_5;
                continue block7;
                break;
            }
            break;
        }
        catch (NoSuchFieldException var19_19) {
            var20_20 = "Unknown keycode: KEYCODE_" + var6_6;
            var21_21 = Log.w("ActivityTestCase", var20_20);
            ** GOTO lbl36
        }
        catch (IllegalAccessException var22_22) {
            var23_23 = "Unknown keycode: KEYCODE_" + var6_6;
            var24_24 = Log.w("ActivityTestCase", var23_23);
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendKeys(int ... nArray) {
        int n = nArray.length;
        Instrumentation instrumentation = this.getInstrumentation();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                instrumentation.waitForIdleSync();
                return;
            }
            try {
                int n3 = nArray[n2];
                instrumentation.sendKeyDownUpSync(n3);
            }
            catch (SecurityException securityException) {}
            ++n2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendRepeatedKeys(int ... nArray) {
        int n = nArray.length;
        if ((n & 1) == 1) {
            throw new IllegalArgumentException("The size of the keys array must be a multiple of 2");
        }
        Instrumentation instrumentation = this.getInstrumentation();
        int n2 = 0;
        block2: while (true) {
            if (n2 >= n) {
                instrumentation.waitForIdleSync();
                return;
            }
            int n3 = nArray[n2];
            int n4 = n2 + 1;
            int n5 = nArray[n4];
            int n6 = 0;
            while (true) {
                if (n6 < n3) {
                    instrumentation.sendKeyDownUpSync(n5);
                } else {
                    n2 += 2;
                    continue block2;
                    catch (SecurityException securityException) {}
                }
                ++n6;
            }
            break;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        super.tearDown();
    }
}

