/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.GetChars;
import android.text.Spanned;
import android.text.TextUtils;

public class AlteredCharSequence
implements CharSequence,
GetChars {
    private char[] mChars;
    private int mEnd;
    private CharSequence mSource;
    private int mStart;

    private AlteredCharSequence(CharSequence charSequence, char[] cArray, int n, int n2) {
        this.mSource = charSequence;
        this.mChars = cArray;
        this.mStart = n;
        this.mEnd = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlteredCharSequence make(CharSequence charSequence, char[] cArray, int n, int n2) {
        if (!(charSequence instanceof Spanned)) return new AlteredCharSequence(charSequence, cArray, n, n2);
        CharSequence charSequence2 = charSequence;
        char[] cArray2 = cArray;
        int n3 = n;
        int n4 = n2;
        return new AlteredSpanned(charSequence2, cArray2, n3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public char charAt(int n) {
        int n2 = this.mStart;
        if (n < n2) return this.mSource.charAt(n);
        int n3 = this.mEnd;
        if (n >= n3) return this.mSource.charAt(n);
        char[] cArray = this.mChars;
        int n4 = this.mStart;
        int n5 = n - n4;
        return cArray[n5];
    }

    @Override
    public void getChars(int n, int n2, char[] cArray, int n3) {
        TextUtils.getChars(this.mSource, n, n2, cArray, n3);
        int n4 = Math.max(this.mStart, n);
        int n5 = Math.min(this.mEnd, n2);
        if (n4 <= n5) {
            return;
        }
        char[] cArray2 = this.mChars;
        int n6 = this.mStart;
        int n7 = n4 - n6;
        int n8 = n5 - n4;
        System.arraycopy(cArray2, n7, cArray, n3, n8);
    }

    @Override
    public int length() {
        return this.mSource.length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        CharSequence charSequence = this.mSource.subSequence(n, n2);
        char[] cArray = this.mChars;
        int n3 = this.mStart - n;
        int n4 = this.mEnd - n;
        return AlteredCharSequence.make(charSequence, cArray, n3, n4);
    }

    @Override
    public String toString() {
        int n = this.length();
        char[] cArray = new char[n];
        this.getChars(0, n, cArray, 0);
        return String.valueOf(cArray);
    }

    void update(char[] cArray, int n, int n2) {
        this.mChars = cArray;
        this.mStart = n;
        this.mEnd = n2;
    }

    private static class AlteredSpanned
    extends AlteredCharSequence
    implements Spanned {
        private Spanned mSpanned;

        private AlteredSpanned(CharSequence charSequence, char[] cArray, int n, int n2) {
            Spanned spanned;
            AlteredSpanned alteredSpanned = this;
            CharSequence charSequence2 = charSequence;
            char[] cArray2 = cArray;
            int n3 = n;
            int n4 = n2;
            super(charSequence2, cArray2, n3, n4);
            this.mSpanned = spanned = (Spanned)charSequence;
        }

        @Override
        public int getSpanEnd(Object object) {
            return this.mSpanned.getSpanEnd(object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return this.mSpanned.getSpanFlags(object);
        }

        @Override
        public int getSpanStart(Object object) {
            return this.mSpanned.getSpanStart(object);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return this.mSpanned.getSpans(n, n2, clazz);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return this.mSpanned.nextSpanTransition(n, n2, clazz);
        }
    }
}

