/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.view.View;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class AutoText {
    private static final int DEFAULT = 14337;
    private static final int INCREMENT = 1024;
    private static final int RIGHT = 9300;
    private static final int TRIE_C = 0;
    private static final int TRIE_CHILD = 2;
    private static final int TRIE_NEXT = 3;
    private static final char TRIE_NULL = '\uffff';
    private static final int TRIE_OFF = 1;
    private static final int TRIE_ROOT = 0;
    private static final int TRIE_SIZEOF = 4;
    private static AutoText sInstance;
    private static Object sLock;
    private Locale mLocale;
    private int mSize;
    private String mText;
    private char[] mTrie;
    private char mTrieUsed;

    static {
        Resources resources = Resources.getSystem();
        sInstance = new AutoText(resources);
        sLock = new Object();
    }

    private AutoText(Resources resources) {
        Locale locale;
        this.mLocale = locale = resources.getConfiguration().locale;
        this.init(resources);
    }

    private void add(String string2, char c) {
        int n;
        int n2 = string2.length();
        int n3 = 0;
        this.mSize = n = this.mSize + 1;
        int n4 = 0;
        while (true) {
            block6: {
                if (n4 >= n2) {
                    return;
                }
                char c2 = string2.charAt(n4);
                boolean bl = false;
                while (true) {
                    block8: {
                        block7: {
                            if (this.mTrie[n3] == '\uffff') break block7;
                            char[] cArray = this.mTrie;
                            int n5 = this.mTrie[n3] + '\u0000';
                            char c3 = cArray[n5];
                            if (c2 == c3) break block8;
                            int n6 = n2 - 1;
                            if (n4 != n6) {
                                char[] cArray2 = this.mTrie;
                                int n7 = this.mTrie[n3] + '\u0001';
                                cArray2[n7] = c;
                                return;
                            }
                            n3 = this.mTrie[n3] + 2;
                            bl = true;
                        }
                        if (!bl) {
                            char c4;
                            this.mTrie[n3] = c4 = this.newTrieNode();
                            char[] cArray = this.mTrie;
                            int n8 = this.mTrie[n3] + '\u0000';
                            cArray[n8] = c2;
                            char[] cArray3 = this.mTrie;
                            int n9 = this.mTrie[n3] + '\u0001';
                            cArray3[n9] = 65535;
                            char[] cArray4 = this.mTrie;
                            int n10 = this.mTrie[n3] + 3;
                            cArray4[n10] = 65535;
                            char[] cArray5 = this.mTrie;
                            int n11 = this.mTrie[n3] + 2;
                            cArray5[n11] = 65535;
                            int n12 = n2 - 1;
                            if (n4 == n12) break;
                            char[] cArray6 = this.mTrie;
                            int n13 = this.mTrie[n3] + '\u0001';
                            cArray6[n13] = c;
                            return;
                        }
                        break block6;
                    }
                    n3 = this.mTrie[n3] + 3;
                }
                n3 = this.mTrie[n3] + 2;
            }
            ++n4;
        }
    }

    public static String get(CharSequence charSequence, int n, int n2, View view) {
        return AutoText.getInstance(view).lookup(charSequence, n, n2);
    }

    private static AutoText getInstance(View view) {
        Resources resources = view.getContext().getResources();
        Locale locale = resources.getConfiguration().locale;
        Object object = sLock;
        synchronized (object) {
            AutoText autoText = sInstance;
            Locale locale2 = autoText.mLocale;
            if (!locale.equals(locale2)) {
                sInstance = autoText = new AutoText(resources);
            }
            return autoText;
        }
    }

    private int getSize() {
        return this.mSize;
    }

    public static int getSize(View view) {
        return AutoText.getInstance(view).getSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Resources resources) {
        XmlResourceParser xmlResourceParser = resources.getXml(0x10B0001);
        StringBuilder stringBuilder = new StringBuilder(9300);
        char[] cArray = new char[14337];
        this.mTrie = cArray;
        this.mTrie[0] = 65535;
        this.mTrieUsed = '\u0001';
        try {
            XmlUtils.beginDocument(xmlResourceParser, "words");
            String string2 = "";
            char c = '\u0000';
            while (true) {
                char c2;
                XmlUtils.nextElement(xmlResourceParser);
                String string3 = xmlResourceParser.getName();
                if (string3 == null || !string3.equals("word")) {
                    String string4;
                    resources.flushLayoutCache();
                    this.mText = string4 = stringBuilder.toString();
                    return;
                }
                String string5 = null;
                String string6 = xmlResourceParser.getAttributeValue(string5, "src");
                if (xmlResourceParser.next() != 4) continue;
                String string7 = xmlResourceParser.getText();
                if (string7.equals(string2)) {
                    c2 = c;
                } else {
                    c2 = (char)stringBuilder.length();
                    char c3 = (char)string7.length();
                    StringBuilder stringBuilder2 = stringBuilder.append(c3);
                    StringBuilder stringBuilder3 = stringBuilder.append(string7);
                }
                this.add(string6, c2);
                continue;
                break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            xmlResourceParser.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String lookup(CharSequence charSequence, int n, int n2) {
        char c = this.mTrie[0];
        int n3 = n;
        while (n3 < n2) {
            char c2 = charSequence.charAt(n3);
            while (true) {
                block7: {
                    block6: {
                        int n4;
                        char[] cArray;
                        if (c == '\uffff') break block6;
                        char[] cArray2 = this.mTrie;
                        int n5 = c + '\u0000';
                        char c3 = cArray2[n5];
                        if (c2 == c3) break block7;
                        int n6 = n2 - 1;
                        if (n3 != n6 && (cArray = this.mTrie)[n4 = c + '\u0001'] != '\uffff') {
                            char[] cArray3 = this.mTrie;
                            int n7 = c + '\u0001';
                            char c4 = cArray3[n7];
                            char c5 = this.mText.charAt(c4);
                            String string2 = this.mText;
                            int n8 = c4 + '\u0001';
                            int n9 = c4 + '\u0001' + c5;
                            return string2.substring(n8, n9);
                        }
                        char[] cArray4 = this.mTrie;
                        int n10 = c + 2;
                        c = cArray4[n10];
                    }
                    if (c != '\uffff') break;
                    return null;
                }
                char[] cArray = this.mTrie;
                int n11 = c + 3;
                c = cArray[n11];
            }
            ++n3;
        }
        return null;
    }

    private char newTrieNode() {
        char c;
        int n = this.mTrieUsed + 4;
        int n2 = this.mTrie.length;
        if (n > n2) {
            char[] cArray = new char[this.mTrie.length + 1024];
            char[] cArray2 = this.mTrie;
            int n3 = this.mTrie.length;
            System.arraycopy(cArray2, 0, cArray, 0, n3);
            this.mTrie = cArray;
        }
        char c2 = this.mTrieUsed;
        this.mTrieUsed = c = (char)(this.mTrieUsed + 4);
        return c2;
    }
}

