/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.Layout;
import android.text.Spanned;
import android.text.Styled;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ParagraphStyle;
import android.util.FloatMath;

public class BoringLayout
extends Layout
implements TextUtils.EllipsizeCallback {
    private static final char FIRST_RIGHT_TO_LEFT = '\u0590';
    private static final TextPaint sTemp = new TextPaint();
    int mBottom;
    private int mBottomPadding;
    int mDesc;
    private String mDirect;
    private int mEllipsizedCount;
    private int mEllipsizedStart;
    private int mEllipsizedWidth;
    private float mMax;
    private Paint mPaint;
    private int mTopPadding;

    public BoringLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        super(charSequence, textPaint, n, alignment, f, f2);
        this.mEllipsizedWidth = n;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        BoringLayout boringLayout = this;
        CharSequence charSequence2 = charSequence;
        TextPaint textPaint2 = textPaint;
        int n2 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        Metrics metrics2 = metrics;
        boolean bl2 = bl;
        boringLayout.init(charSequence2, textPaint2, n2, alignment2, f3, f4, metrics2, bl2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BoringLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        super(charSequence, textPaint, n, alignment, f, f2);
        boolean bl2;
        TextUtils.TruncateAt truncateAt2;
        TextUtils.TruncateAt truncateAt3;
        TextUtils.TruncateAt truncateAt4;
        if (truncateAt == null || (truncateAt4 = truncateAt) == (truncateAt3 = (truncateAt2 = TextUtils.TruncateAt.MARQUEE))) {
            this.mEllipsizedWidth = n;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            bl2 = true;
        } else {
            int n3;
            float f3 = n2;
            CharSequence charSequence2 = charSequence;
            TextPaint textPaint2 = textPaint;
            TextUtils.TruncateAt truncateAt5 = truncateAt;
            BoringLayout boringLayout = this;
            CharSequence charSequence3 = TextUtils.ellipsize(charSequence2, textPaint2, f3, truncateAt5, true, boringLayout);
            BoringLayout boringLayout2 = this;
            TextPaint textPaint3 = textPaint;
            int n4 = n;
            Layout.Alignment alignment2 = alignment;
            float f4 = f;
            float f5 = f2;
            boringLayout2.replaceWith(charSequence3, textPaint3, n4, alignment2, f4, f5);
            this.mEllipsizedWidth = n3 = n2;
            bl2 = false;
        }
        CharSequence charSequence4 = this.getText();
        BoringLayout boringLayout = this;
        TextPaint textPaint4 = textPaint;
        int n5 = n;
        Layout.Alignment alignment3 = alignment;
        float f6 = f;
        float f7 = f2;
        Metrics metrics2 = metrics;
        boolean bl3 = bl;
        boringLayout.init(charSequence4, textPaint4, n5, alignment3, f6, f7, metrics2, bl3, bl2);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint) {
        return BoringLayout.isBoring(charSequence, textPaint, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Metrics isBoring(CharSequence object, TextPaint textPaint, Metrics object2) {
        int n;
        Spanned spanned;
        boolean bl;
        Object object3;
        char[] cArray = TextUtils.obtain(500);
        int n2 = object.length();
        int n3 = 0;
        block3: while (true) {
            if (n3 < n2) {
                int n4 = n3 + 500;
                if (n4 > n2) {
                    n4 = n2;
                }
                TextUtils.getChars(object, n3, n4, cArray, 0);
                object3 = n4 - n3;
            } else {
                bl = true;
                break;
            }
            for (int i = 0; i < object3; ++i) {
                char c = cArray[i];
                if (c != '\n' && c != '\t' && c < '\u0590') continue;
                bl = false;
                break block3;
            }
            n3 += 500;
        }
        TextUtils.recycle(cArray);
        if (bl && object instanceof Spanned && (spanned = (Spanned)object).getSpans(0, n = object.length(), ParagraphStyle.class).length > 0) {
            return false;
        }
        if (!bl) {
            return false;
        }
        object3 = object2;
        if (object3 == false) {
            Metrics metrics = new Metrics();
        }
        object2 = sTemp;
        synchronized (object2) {
            TextPaint textPaint2 = sTemp;
            int n5 = object.length();
            TextPaint textPaint3 = textPaint;
            CharSequence charSequence = object;
            object = (int)FloatMath.ceil(Styled.measureText(textPaint3, textPaint2, charSequence, 0, n5, (Paint.FontMetricsInt)object3));
        }
        ((Metrics)object3).width = (int)object;
        return object3;
    }

    public static BoringLayout make(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        CharSequence charSequence2 = charSequence;
        TextPaint textPaint2 = textPaint;
        int n2 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        Metrics metrics2 = metrics;
        boolean bl2 = bl;
        return new BoringLayout(charSequence2, textPaint2, n2, alignment2, f3, f4, metrics2, bl2);
    }

    public static BoringLayout make(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        CharSequence charSequence2 = charSequence;
        TextPaint textPaint2 = textPaint;
        int n3 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        Metrics metrics2 = metrics;
        boolean bl2 = bl;
        TextUtils.TruncateAt truncateAt2 = truncateAt;
        int n4 = n2;
        return new BoringLayout(charSequence2, textPaint2, n3, alignment2, f3, f4, metrics2, bl2, truncateAt2, n4);
    }

    @Override
    public void draw(Canvas canvas, Path path, Paint paint, int n) {
        if (this.mDirect != null && path == null) {
            String string2 = this.mDirect;
            int n2 = this.mBottom;
            int n3 = this.mDesc;
            float f = n2 - n3;
            Paint paint2 = this.mPaint;
            canvas.drawText(string2, 0.0f, f, paint2);
            return;
        }
        super.draw(canvas, path, paint, n);
    }

    @Override
    public void ellipsized(int n, int n2) {
        int n3;
        this.mEllipsizedStart = n;
        this.mEllipsizedCount = n3 = n2 - n;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getEllipsisCount(int n) {
        return this.mEllipsizedCount;
    }

    @Override
    public int getEllipsisStart(int n) {
        return this.mEllipsizedStart;
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getHeight() {
        return this.mBottom;
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return false;
    }

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public int getLineDescent(int n) {
        return this.mDesc;
    }

    @Override
    public final Layout.Directions getLineDirections(int n) {
        return Layout.DIRS_ALL_LEFT_TO_RIGHT;
    }

    @Override
    public float getLineMax(int n) {
        return this.mMax;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getLineStart(int n) {
        if (n != 0) return this.getText().length();
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getLineTop(int n) {
        if (n != 0) return this.mBottom;
        return 0;
    }

    @Override
    public int getParagraphDirection(int n) {
        return 1;
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void init(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string2;
        Layout.Alignment alignment2;
        this.mDirect = charSequence instanceof String && alignment == (alignment2 = Layout.Alignment.ALIGN_NORMAL) ? (string2 = ((Object)charSequence).toString()) : null;
        this.mPaint = textPaint;
        if (bl) {
            int n7 = metrics.bottom;
            int n8 = metrics.top;
            n6 = n7 - n8;
        } else {
            int n9 = metrics.descent;
            int n10 = metrics.ascent;
            n6 = n9 - n10;
        }
        if (f != 1.0f || f2 != 0.0f) {
            n6 = (int)((float)n6 * f + f2 + 0.5f);
        }
        this.mBottom = n6;
        this.mDesc = bl ? (n5 = metrics.top + n6) : (n4 = metrics.ascent + n6);
        if (bl2) {
            float f3;
            this.mMax = f3 = (float)metrics.width;
        } else {
            TextPaint textPaint2 = sTemp;
            synchronized (textPaint2) {
                float f4;
                TextPaint textPaint3 = sTemp;
                int n11 = charSequence.length();
                TextPaint textPaint4 = textPaint;
                CharSequence charSequence2 = charSequence;
                this.mMax = f4 = (float)((int)FloatMath.ceil(Styled.measureText(textPaint4, textPaint3, charSequence2, 0, n11, null)));
            }
        }
        if (!bl) {
            return;
        }
        int n12 = metrics.top;
        int n13 = metrics.ascent;
        this.mTopPadding = n3 = n12 - n13;
        int n14 = metrics.bottom;
        int n15 = metrics.descent;
        this.mBottomPadding = n2 = n14 - n15;
    }

    public BoringLayout replaceOrMake(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        this.replaceWith(charSequence, textPaint, n, alignment, f, f2);
        this.mEllipsizedWidth = n;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        BoringLayout boringLayout = this;
        CharSequence charSequence2 = charSequence;
        TextPaint textPaint2 = textPaint;
        int n2 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        Metrics metrics2 = metrics;
        boolean bl2 = bl;
        boringLayout.init(charSequence2, textPaint2, n2, alignment2, f3, f4, metrics2, bl2, true);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BoringLayout replaceOrMake(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        boolean bl2;
        TextUtils.TruncateAt truncateAt2;
        TextUtils.TruncateAt truncateAt3;
        TextUtils.TruncateAt truncateAt4;
        if (truncateAt == null || (truncateAt4 = truncateAt) == (truncateAt3 = (truncateAt2 = TextUtils.TruncateAt.MARQUEE))) {
            this.replaceWith(charSequence, textPaint, n, alignment, f, f2);
            this.mEllipsizedWidth = n;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            bl2 = true;
        } else {
            int n3;
            float f3 = n2;
            CharSequence charSequence2 = charSequence;
            TextPaint textPaint2 = textPaint;
            TextUtils.TruncateAt truncateAt5 = truncateAt;
            BoringLayout boringLayout = this;
            CharSequence charSequence3 = TextUtils.ellipsize(charSequence2, textPaint2, f3, truncateAt5, true, boringLayout);
            BoringLayout boringLayout2 = this;
            TextPaint textPaint3 = textPaint;
            int n4 = n;
            Layout.Alignment alignment2 = alignment;
            float f4 = f;
            float f5 = f2;
            boringLayout2.replaceWith(charSequence3, textPaint3, n4, alignment2, f4, f5);
            this.mEllipsizedWidth = n3 = n2;
            bl2 = false;
        }
        CharSequence charSequence4 = this.getText();
        BoringLayout boringLayout = this;
        TextPaint textPaint4 = textPaint;
        int n5 = n;
        Layout.Alignment alignment3 = alignment;
        float f6 = f;
        float f7 = f2;
        Metrics metrics2 = metrics;
        boolean bl3 = bl;
        boringLayout.init(charSequence4, textPaint4, n5, alignment3, f6, f7, metrics2, bl3, bl2);
        return this;
    }

    public static class Metrics
    extends Paint.FontMetricsInt {
        public int width;

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = super.toString();
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" width=");
            int n = this.width;
            return stringBuilder2.append(n).toString();
        }
    }
}

