/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.IClipboard;

public class ClipboardManager {
    private static IClipboard sService;
    private Context mContext;

    public ClipboardManager(Context context, Handler handler) {
        this.mContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IClipboard getService() {
        if (sService == null) return sService = IClipboard.Stub.asInterface(ServiceManager.getService("clipboard"));
        return sService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getText() {
        try {
            CharSequence charSequence = ClipboardManager.getService().getClipboardText();
            return charSequence;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasText() {
        try {
            boolean bl = ClipboardManager.getService().hasClipboardText();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setText(CharSequence charSequence) {
        try {
            ClipboardManager.getService().setClipboardText(charSequence);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

