/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.Editable;
import android.text.Layout;
import android.text.PackedIntVector;
import android.text.PackedObjectVector;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.UpdateLayout;
import android.text.style.WrapTogetherSpan;
import java.io.PrintStream;
import java.lang.ref.WeakReference;

public class DynamicLayout
extends Layout {
    private static final int COLUMNS_ELLIPSIZE = 5;
    private static final int COLUMNS_NORMAL = 3;
    private static final int DESCENT = 2;
    private static final int DIR = 0;
    private static final int DIR_MASK = -1073741824;
    private static final int DIR_SHIFT = 30;
    private static final int ELLIPSIS_COUNT = 4;
    private static final int ELLIPSIS_START = 3;
    private static final int ELLIPSIS_UNDEFINED = Integer.MIN_VALUE;
    private static final int PRIORITY = 128;
    private static final int START = 0;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int TAB = 0;
    private static final int TAB_MASK = 0x20000000;
    private static final int TOP = 1;
    private static Object sLock;
    private static StaticLayout sStaticLayout;
    private CharSequence mBase;
    private int mBottomPadding;
    private CharSequence mDisplay;
    private boolean mEllipsize;
    private TextUtils.TruncateAt mEllipsizeAt;
    private int mEllipsizedWidth;
    private boolean mIncludePad;
    private PackedIntVector mInts;
    private PackedObjectVector<Layout.Directions> mObjects;
    private int mTopPadding;
    private ChangeWatcher mWatcher;

    static {
        sStaticLayout = new StaticLayout(true);
        sLock = new Object();
    }

    public DynamicLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        DynamicLayout dynamicLayout = this;
        CharSequence charSequence2 = charSequence;
        CharSequence charSequence3 = charSequence;
        TextPaint textPaint2 = textPaint;
        int n2 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        boolean bl2 = bl;
        dynamicLayout(charSequence2, charSequence3, textPaint2, n2, alignment2, f3, f4, bl2);
    }

    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        DynamicLayout dynamicLayout = this;
        CharSequence charSequence3 = charSequence;
        CharSequence charSequence4 = charSequence2;
        TextPaint textPaint2 = textPaint;
        int n2 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        boolean bl2 = bl;
        dynamicLayout(charSequence3, charSequence4, textPaint2, n2, alignment2, f3, f4, bl2, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        int n3;
        Layout.Directions directions;
        int[] nArray;
        boolean bl2;
        CharSequence charSequence3;
        CharSequence charSequence4;
        CharSequence charSequence5;
        if (truncateAt == null) {
            charSequence5 = charSequence2;
        } else if (charSequence2 instanceof Spanned) {
            Layout.SpannedEllipsizer spannedEllipsizer;
            Layout.SpannedEllipsizer spannedEllipsizer2 = spannedEllipsizer;
            CharSequence charSequence6 = charSequence2;
            spannedEllipsizer2(charSequence6);
            charSequence5 = spannedEllipsizer;
        } else {
            Layout.Ellipsizer ellipsizer;
            Layout.Ellipsizer ellipsizer2 = ellipsizer;
            CharSequence charSequence7 = charSequence2;
            ellipsizer2(charSequence7);
            charSequence5 = ellipsizer;
        }
        DynamicLayout dynamicLayout = this;
        TextPaint textPaint2 = textPaint;
        int n4 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        super(charSequence5, textPaint2, n4, alignment2, f3, f4);
        this.mBase = charSequence4 = charSequence;
        this.mDisplay = charSequence3 = charSequence2;
        if (truncateAt != null) {
            TextUtils.TruncateAt truncateAt2;
            int n5;
            PackedIntVector packedIntVector;
            this.mInts = packedIntVector = new PackedIntVector(5);
            this.mEllipsizedWidth = n5 = n2;
            this.mEllipsizeAt = truncateAt2 = truncateAt;
        } else {
            TextUtils.TruncateAt truncateAt3;
            int n6;
            PackedIntVector packedIntVector;
            this.mInts = packedIntVector = new PackedIntVector(3);
            this.mEllipsizedWidth = n6 = n;
            this.mEllipsizeAt = truncateAt3 = truncateAt;
        }
        PackedObjectVector packedObjectVector = new PackedObjectVector(1);
        this.mObjects = packedObjectVector;
        this.mIncludePad = bl2 = bl;
        if (truncateAt != null) {
            boolean bl3;
            TextUtils.TruncateAt truncateAt4;
            int n7;
            Layout.Ellipsizer ellipsizer = (Layout.Ellipsizer)this.getText();
            DynamicLayout dynamicLayout2 = this;
            ellipsizer.mLayout = dynamicLayout2;
            ellipsizer.mWidth = n7 = n2;
            ellipsizer.mMethod = truncateAt4 = truncateAt;
            this.mEllipsize = bl3 = true;
        }
        if (truncateAt != null) {
            nArray = new int[5];
            nArray[3] = Integer.MIN_VALUE;
        } else {
            nArray = new int[3];
        }
        Layout.Directions[] directionsArray = new Layout.Directions[]{directions = DIRS_ALL_LEFT_TO_RIGHT};
        Paint.FontMetricsInt fontMetricsInt = textPaint.getFontMetricsInt();
        int n8 = fontMetricsInt.ascent;
        int n9 = fontMetricsInt.descent;
        nArray[0] = 0x40000000;
        nArray[1] = 0;
        nArray[2] = n9;
        PackedIntVector packedIntVector = this.mInts;
        int n10 = 0;
        int[] nArray2 = nArray;
        packedIntVector.insertAt(n10, nArray2);
        nArray[1] = n3 = n9 - n8;
        PackedIntVector packedIntVector2 = this.mInts;
        int n11 = 1;
        int[] nArray3 = nArray;
        packedIntVector2.insertAt(n11, nArray3);
        this.mObjects.insertAt(0, (Layout.Directions[])directionsArray);
        int n12 = charSequence.length();
        DynamicLayout dynamicLayout3 = this;
        CharSequence charSequence8 = charSequence;
        int n13 = 0;
        int n14 = 0;
        int n15 = n12;
        dynamicLayout3.reflow(charSequence8, n13, n14, n15);
        if (!(charSequence instanceof Spannable)) {
            return;
        }
        if (this.mWatcher == null) {
            ChangeWatcher changeWatcher;
            ChangeWatcher changeWatcher2;
            ChangeWatcher changeWatcher3 = changeWatcher2;
            DynamicLayout dynamicLayout4 = this;
            changeWatcher3(dynamicLayout4);
            this.mWatcher = changeWatcher = changeWatcher2;
        }
        Spannable spannable = (Spannable)charSequence;
        int n16 = spannable.length();
        Spannable spannable2 = spannable;
        int n17 = 0;
        int n18 = n16;
        Class<ChangeWatcher> clazz = ChangeWatcher.class;
        ChangeWatcher[] changeWatcherArray = spannable2.getSpans(n17, n18, clazz);
        int n19 = 0;
        while (true) {
            int n20;
            int n21;
            int n22;
            if ((n22 = ++n19) >= (n21 = (n20 = changeWatcherArray.length))) {
                ChangeWatcher changeWatcher = this.mWatcher;
                int n23 = charSequence.length();
                Spannable spannable3 = spannable;
                ChangeWatcher changeWatcher4 = changeWatcher;
                int n24 = 0;
                int n25 = n23;
                int n26 = 8388626;
                spannable3.setSpan(changeWatcher4, n24, n25, n26);
                return;
            }
            ChangeWatcher changeWatcher = changeWatcherArray[n19];
            Spannable spannable4 = spannable;
            ChangeWatcher changeWatcher5 = changeWatcher;
            spannable4.removeSpan(changeWatcher5);
        }
    }

    private void dump(boolean bl) {
        int n = this.getLineCount();
        for (int i = 0; i < n; ++i) {
            PrintStream printStream = System.out;
            StringBuilder stringBuilder = new StringBuilder().append("line ").append(i).append(": ");
            int n2 = this.getLineStart(i);
            StringBuilder stringBuilder2 = stringBuilder.append(n2).append(" to ");
            int n3 = this.getLineEnd(i);
            String string2 = stringBuilder2.append(n3).append(" ").toString();
            printStream.print(string2);
            if (bl) {
                PrintStream printStream2 = System.out;
                CharSequence charSequence = this.getText();
                int n4 = this.getLineStart(i);
                int n5 = this.getLineEnd(i);
                CharSequence charSequence2 = charSequence.subSequence(n4, n5);
                printStream2.print(charSequence2);
            }
            System.out.println("");
        }
        System.out.println("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void reflow(CharSequence charSequence, int n, int n2, int n3) {
        int[] nArray;
        int n4;
        int n5;
        int n6;
        CharSequence charSequence2 = charSequence;
        CharSequence charSequence3 = this.mBase;
        CharSequence charSequence4 = charSequence3;
        if (charSequence2 != charSequence4) {
            return;
        }
        CharSequence charSequence5 = this.mDisplay;
        int n7 = charSequence5.length();
        int n8 = n - 1;
        int n9 = TextUtils.lastIndexOf(charSequence5, '\n', n8);
        int n10 = n9 < 0 ? 0 : n9 + 1;
        int n11 = n - n10;
        int n12 = n2 + n11;
        int n13 = n3 + n11;
        int n14 = (n -= n11) + n13;
        int n15 = TextUtils.indexOf(charSequence5, '\n', n14);
        int n16 = n15 < 0 ? n7 : n15 + 1;
        int n17 = n + n13;
        int n18 = n16 - n17;
        n2 = n12 + n18;
        n3 = n13 + n18;
        if (charSequence5 instanceof Spanned) {
            boolean bl;
            Spanned spanned = (Spanned)charSequence5;
            do {
                int n19;
                int n20;
                int n21;
                bl = false;
                int n22 = n + n3;
                Spanned spanned2 = spanned;
                int n23 = n;
                int n24 = n22;
                Class<WrapTogetherSpan> clazz = WrapTogetherSpan.class;
                WrapTogetherSpan[] wrapTogetherSpanArray = spanned2.getSpans(n23, n24, clazz);
                int n25 = 0;
                while ((n21 = ++n25) < (n20 = (n19 = wrapTogetherSpanArray.length))) {
                    int n26;
                    int n27;
                    int n28;
                    WrapTogetherSpan wrapTogetherSpan = wrapTogetherSpanArray[n25];
                    Spanned spanned3 = spanned;
                    WrapTogetherSpan wrapTogetherSpan2 = wrapTogetherSpan;
                    int n29 = spanned3.getSpanStart(wrapTogetherSpan2);
                    WrapTogetherSpan wrapTogetherSpan3 = wrapTogetherSpanArray[n25];
                    Spanned spanned4 = spanned;
                    WrapTogetherSpan wrapTogetherSpan4 = wrapTogetherSpan3;
                    int n30 = spanned4.getSpanEnd(wrapTogetherSpan4);
                    int n31 = n29;
                    int n32 = n;
                    if (n31 < n32) {
                        bl = true;
                        int n33 = n - n29;
                        int n34 = n2 + n33;
                        int n35 = n3 + n33;
                        int n36 = n - n33;
                    }
                    if ((n28 = n30) <= (n27 = (n26 = n + n3))) continue;
                    bl = true;
                    int n37 = n + n3;
                    int n38 = n30 - n37;
                    int n39 = n2 + n38;
                    int n40 = n3 + n38;
                }
            } while (bl);
        }
        DynamicLayout dynamicLayout = this;
        int n41 = n;
        int n42 = dynamicLayout.getLineForOffset(n41);
        DynamicLayout dynamicLayout2 = this;
        int n43 = n42;
        int n44 = dynamicLayout2.getLineTop(n43);
        int n45 = n + n2;
        DynamicLayout dynamicLayout3 = this;
        int n46 = n45;
        int n47 = dynamicLayout3.getLineForOffset(n46);
        int n48 = n + n3;
        int n49 = n7;
        if (n48 != n49) {
            n47 = this.getLineCount();
        }
        DynamicLayout dynamicLayout4 = this;
        int n50 = n47;
        int n51 = dynamicLayout4.getLineTop(n50);
        int n52 = n47;
        int n53 = this.getLineCount();
        int n54 = n53;
        boolean bl = n52 != n54;
        Object object = sLock;
        // MONITORENTER : object
        StaticLayout staticLayout = sStaticLayout;
        sStaticLayout = null;
        // MONITOREXIT : object
        if (staticLayout == null) {
            staticLayout = new StaticLayout(true);
        }
        int n55 = n + n3;
        TextPaint textPaint = this.getPaint();
        int n56 = this.getWidth();
        Layout.Alignment alignment = this.getAlignment();
        float f = this.getSpacingMultiplier();
        float f2 = this.getSpacingAdd();
        boolean bl2 = this.mEllipsize;
        float f3 = this.mEllipsizedWidth;
        TextUtils.TruncateAt truncateAt = this.mEllipsizeAt;
        int n57 = n;
        staticLayout.generate(charSequence5, n57, n55, textPaint, n56, alignment, f, f2, false, true, bl2, f3, truncateAt);
        int n58 = staticLayout.getLineCount();
        int n59 = n + n3;
        int n60 = n7;
        if (n59 != n60 && (n6 = staticLayout.getLineStart(n5 = n58 - 1)) != (n4 = n + n3)) {
            n58 += -1;
        }
        PackedIntVector packedIntVector = this.mInts;
        int n61 = n47 - n42;
        PackedIntVector packedIntVector2 = packedIntVector;
        int n62 = n42;
        int n63 = n61;
        packedIntVector2.deleteAt(n62, n63);
        PackedObjectVector<Layout.Directions> packedObjectVector = this.mObjects;
        int n64 = n47 - n42;
        PackedObjectVector<Layout.Directions> packedObjectVector2 = packedObjectVector;
        int n65 = n42;
        int n66 = n64;
        packedObjectVector2.deleteAt(n65, n66);
        StaticLayout staticLayout2 = staticLayout;
        int n67 = n58;
        int n68 = staticLayout2.getLineTop(n67);
        int n69 = 0;
        int n70 = 0;
        if (this.mIncludePad && n42 == 0) {
            int n71;
            this.mTopPadding = n71 = (n69 = staticLayout.getTopPadding());
            n68 -= n69;
        }
        if (this.mIncludePad && bl) {
            int n72;
            this.mBottomPadding = n72 = (n70 = staticLayout.getBottomPadding());
            n68 += n70;
        }
        PackedIntVector packedIntVector3 = this.mInts;
        int n73 = n3 - n2;
        PackedIntVector packedIntVector4 = packedIntVector3;
        int n74 = n42;
        int n75 = 0;
        int n76 = n73;
        packedIntVector4.adjustValuesBelow(n74, n75, n76);
        PackedIntVector packedIntVector5 = this.mInts;
        int n77 = n44 - n51 + n68;
        PackedIntVector packedIntVector6 = packedIntVector5;
        int n78 = n42;
        int n79 = 1;
        int n80 = n77;
        packedIntVector6.adjustValuesBelow(n78, n79, n80);
        if (this.mEllipsize) {
            nArray = new int[5];
            nArray[3] = Integer.MIN_VALUE;
        } else {
            nArray = new int[3];
        }
        Layout.Directions[] directionsArray = new Layout.Directions[1];
        int n81 = 0;
        while (true) {
            Layout.Directions directions;
            int n82;
            int n83;
            int n84;
            if ((n84 = ++n81) >= (n83 = n58)) {
                Object object2 = sLock;
                // MONITORENTER : object2
                sStaticLayout = staticLayout;
                // MONITOREXIT : object2
                return;
            }
            int n85 = 0;
            StaticLayout staticLayout3 = staticLayout;
            int n86 = n81;
            int n87 = staticLayout3.getLineStart(n86);
            StaticLayout staticLayout4 = staticLayout;
            int n88 = n81;
            int n89 = staticLayout4.getParagraphDirection(n88) << 30;
            int n90 = n87 | n89;
            StaticLayout staticLayout5 = staticLayout;
            int n91 = n81;
            int n92 = staticLayout5.getLineContainsTab(n91) ? 0x20000000 : 0;
            nArray[n85] = n82 = n90 | n92;
            StaticLayout staticLayout6 = staticLayout;
            int n93 = n81;
            int n94 = staticLayout6.getLineTop(n93) + n44;
            if (n81 > 0) {
                n94 -= n69;
            }
            nArray[1] = n94;
            StaticLayout staticLayout7 = staticLayout;
            int n95 = n81;
            int n96 = staticLayout7.getLineDescent(n95);
            int n97 = n81;
            int n98 = n58 - 1;
            int n99 = n98;
            if (n97 != n99) {
                n96 += n70;
            }
            nArray[2] = n96;
            StaticLayout staticLayout8 = staticLayout;
            int n100 = n81;
            directionsArray[0] = directions = staticLayout8.getLineDirections(n100);
            if (this.mEllipsize) {
                int n101;
                int n102;
                StaticLayout staticLayout9 = staticLayout;
                int n103 = n81;
                nArray[3] = n102 = staticLayout9.getEllipsisStart(n103);
                StaticLayout staticLayout10 = staticLayout;
                int n104 = n81;
                nArray[4] = n101 = staticLayout10.getEllipsisCount(n104);
            }
            PackedIntVector packedIntVector7 = this.mInts;
            int n105 = n42 + n81;
            PackedIntVector packedIntVector8 = packedIntVector7;
            int n106 = n105;
            int[] nArray2 = nArray;
            packedIntVector8.insertAt(n106, nArray2);
            PackedObjectVector<Layout.Directions> packedObjectVector3 = this.mObjects;
            int n107 = n42 + n81;
            PackedObjectVector<Layout.Directions> packedObjectVector4 = packedObjectVector3;
            int n108 = n107;
            Layout.Directions[] directionsArray2 = directionsArray;
            packedObjectVector4.insertAt(n108, (Layout.Directions[])directionsArray2);
        }
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getEllipsisCount(int n) {
        if (this.mEllipsizeAt != null) return this.mInts.getValue(n, 4);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getEllipsisStart(int n) {
        if (this.mEllipsizeAt != null) return this.mInts.getValue(n, 3);
        return 0;
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getLineContainsTab(int n) {
        if ((this.mInts.getValue(n, 0) & 0x20000000) == 0) return false;
        return true;
    }

    @Override
    public int getLineCount() {
        return this.mInts.size() - 1;
    }

    @Override
    public int getLineDescent(int n) {
        return this.mInts.getValue(n, 2);
    }

    @Override
    public final Layout.Directions getLineDirections(int n) {
        return this.mObjects.getValue(n, 0);
    }

    @Override
    public int getLineStart(int n) {
        return this.mInts.getValue(n, 0) & 0x1FFFFFFF;
    }

    @Override
    public int getLineTop(int n) {
        return this.mInts.getValue(n, 1);
    }

    @Override
    public int getParagraphDirection(int n) {
        return this.mInts.getValue(n, 0) >> 30;
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    private static class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private WeakReference mLayout;

        public ChangeWatcher(DynamicLayout dynamicLayout) {
            WeakReference<DynamicLayout> weakReference;
            this.mLayout = weakReference = new WeakReference<DynamicLayout>(dynamicLayout);
        }

        private void reflow(CharSequence charSequence, int n, int n2, int n3) {
            DynamicLayout dynamicLayout = (DynamicLayout)this.mLayout.get();
            if (dynamicLayout != null) {
                dynamicLayout.reflow(charSequence, n, n2, n3);
                return;
            }
            if (!(charSequence instanceof Spannable)) {
                return;
            }
            ((Spannable)charSequence).removeSpan(this);
        }

        @Override
        public void afterTextChanged(Editable editable) {
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        @Override
        public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
            if (!(object instanceof UpdateLayout)) {
                return;
            }
            int n3 = n2 - n;
            int n4 = n2 - n;
            this.reflow(spannable, n, n3, n4);
        }

        @Override
        public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
            if (!(object instanceof UpdateLayout)) {
                return;
            }
            int n5 = n2 - n;
            int n6 = n2 - n;
            this.reflow(spannable, n, n5, n6);
            int n7 = n4 - n3;
            int n8 = n4 - n3;
            this.reflow(spannable, n3, n7, n8);
        }

        @Override
        public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
            if (!(object instanceof UpdateLayout)) {
                return;
            }
            int n3 = n2 - n;
            int n4 = n2 - n;
            this.reflow(spannable, n, n3, n4);
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            this.reflow(charSequence, n, n2, n3);
        }
    }
}

