/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.HtmlToSpannedConverter;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Html {
    private Html() {
    }

    public static Spanned fromHtml(String string2) {
        return Html.fromHtml(string2, null, null);
    }

    public static Spanned fromHtml(String string2, ImageGetter imageGetter, TagHandler tagHandler) {
        Parser parser = new Parser();
        try {
            HTMLSchema hTMLSchema = HtmlParser.schema;
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)hTMLSchema);
            return new HtmlToSpannedConverter(string2, imageGetter, tagHandler, parser).convert();
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new RuntimeException(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new RuntimeException(sAXNotSupportedException);
        }
    }

    public static String toHtml(Spanned spanned) {
        StringBuilder stringBuilder = new StringBuilder();
        Html.withinHtml(stringBuilder, spanned);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinBlockquote(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        StringBuilder stringBuilder2 = stringBuilder.append("<p>");
        int n3 = n;
        while (true) {
            if (n3 >= n2) {
                StringBuilder stringBuilder3 = stringBuilder.append("</p>\n");
                return;
            }
            int n4 = TextUtils.indexOf((CharSequence)spanned, '\n', n3, n2);
            if (n4 < 0) {
                n4 = n2;
            }
            int n5 = 0;
            while (n4 < n2 && spanned.charAt(n4) == '\n') {
                ++n5;
                ++n4;
            }
            int n6 = n4 - n5;
            boolean bl = n4 != n2;
            StringBuilder stringBuilder4 = stringBuilder;
            Spanned spanned2 = spanned;
            Html.withinParagraph(stringBuilder4, spanned2, n3, n6, n5, bl);
            n3 = n4;
        }
    }

    private static void withinDiv(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            QuoteSpan[] quoteSpanArray;
            int n4 = spanned.nextSpanTransition(n3, n2, QuoteSpan.class);
            for (QuoteSpan quoteSpan : quoteSpanArray = spanned.getSpans(n3, n4, QuoteSpan.class)) {
                StringBuilder stringBuilder2 = stringBuilder.append("<blockquote>");
            }
            Html.withinBlockquote(stringBuilder, spanned, n3, n4);
            for (QuoteSpan quoteSpan : quoteSpanArray) {
                StringBuilder stringBuilder3 = stringBuilder.append("</blockquote>\n");
            }
            n3 = n4;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinHtml(StringBuilder stringBuilder, Spanned spanned) {
        int n = spanned.length();
        int n2 = 0;
        int n3;
        while (n2 < (n3 = spanned.length())) {
            int n4;
            int n5 = spanned.nextSpanTransition(n2, n, ParagraphStyle.class);
            ParagraphStyle[] paragraphStyleArray = spanned.getSpans(n2, n5, ParagraphStyle.class);
            String string2 = " ";
            boolean bl = false;
            for (int i = 0; i < (n4 = paragraphStyleArray.length); ++i) {
                Layout.Alignment alignment;
                if (!(paragraphStyleArray[i] instanceof AlignmentSpan)) continue;
                Layout.Alignment alignment2 = ((AlignmentSpan)paragraphStyleArray[i]).getAlignment();
                bl = true;
                Layout.Alignment alignment3 = Layout.Alignment.ALIGN_CENTER;
                string2 = alignment2 == alignment3 ? "align=\"center\" " + string2 : (alignment2 == (alignment = Layout.Alignment.ALIGN_OPPOSITE) ? "align=\"right\" " + string2 : "align=\"left\" " + string2);
            }
            if (bl) {
                String string3 = "<div " + string2 + ">";
                StringBuilder stringBuilder2 = stringBuilder.append(string3);
            }
            Html.withinDiv(stringBuilder, spanned, n2, n5);
            if (bl) {
                StringBuilder stringBuilder3 = stringBuilder.append("</div>");
            }
            n2 = n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinParagraph(StringBuilder stringBuilder, Spanned spanned, int n, int n2, int n3, boolean bl) {
        int n4 = n;
        while (true) {
            int n5;
            CharacterStyle[] characterStyleArray;
            int n6;
            if (n4 < n2) {
                n6 = spanned.nextSpanTransition(n4, n2, CharacterStyle.class);
                characterStyleArray = spanned.getSpans(n4, n6, CharacterStyle.class);
            } else {
                String string2 = bl ? "" : "</p>\n<p>";
                if (n3 == 1) {
                    StringBuilder stringBuilder2 = stringBuilder.append("<br>\n");
                    return;
                }
                if (n3 == 2) {
                    StringBuilder stringBuilder3 = stringBuilder.append(string2);
                    return;
                }
                int n7 = 2;
                while (true) {
                    if (n7 >= n3) {
                        StringBuilder stringBuilder4 = stringBuilder.append(string2);
                        return;
                    }
                    StringBuilder stringBuilder5 = stringBuilder.append("<br>");
                    int n8 = n7 + 1;
                }
            }
            for (int i = 0; i < (n5 = characterStyleArray.length); ++i) {
                int n9;
                if (characterStyleArray[i] instanceof StyleSpan) {
                    int n10 = ((StyleSpan)characterStyleArray[i]).getStyle();
                    if ((n10 & 1) != 0) {
                        StringBuilder stringBuilder6 = stringBuilder.append("<b>");
                    }
                    if ((n10 & 2) != 0) {
                        StringBuilder stringBuilder7 = stringBuilder.append("<i>");
                    }
                }
                if (characterStyleArray[i] instanceof TypefaceSpan && ((TypefaceSpan)characterStyleArray[i]).getFamily().equals("monospace")) {
                    StringBuilder stringBuilder8 = stringBuilder.append("<tt>");
                }
                if (characterStyleArray[i] instanceof SuperscriptSpan) {
                    StringBuilder stringBuilder9 = stringBuilder.append("<sup>");
                }
                if (characterStyleArray[i] instanceof SubscriptSpan) {
                    StringBuilder stringBuilder10 = stringBuilder.append("<sub>");
                }
                if (characterStyleArray[i] instanceof UnderlineSpan) {
                    StringBuilder stringBuilder11 = stringBuilder.append("<u>");
                }
                if (characterStyleArray[i] instanceof StrikethroughSpan) {
                    StringBuilder stringBuilder12 = stringBuilder.append("<strike>");
                }
                if (characterStyleArray[i] instanceof URLSpan) {
                    StringBuilder stringBuilder13 = stringBuilder.append("<a href=\"");
                    String string3 = ((URLSpan)characterStyleArray[i]).getURL();
                    StringBuilder stringBuilder14 = stringBuilder.append(string3);
                    StringBuilder stringBuilder15 = stringBuilder.append("\">");
                }
                if (characterStyleArray[i] instanceof ImageSpan) {
                    StringBuilder stringBuilder16 = stringBuilder.append("<img src=\"");
                    String string4 = ((ImageSpan)characterStyleArray[i]).getSource();
                    StringBuilder stringBuilder17 = stringBuilder.append(string4);
                    StringBuilder stringBuilder18 = stringBuilder.append("\">");
                    n9 = n4 = n6;
                } else {
                    n9 = n4;
                }
                if (characterStyleArray[i] instanceof AbsoluteSizeSpan) {
                    StringBuilder stringBuilder19 = stringBuilder.append("<font size =\"");
                    int n11 = ((AbsoluteSizeSpan)characterStyleArray[i]).getSize() / 6;
                    StringBuilder stringBuilder20 = stringBuilder.append(n11);
                    StringBuilder stringBuilder21 = stringBuilder.append("\">");
                }
                if (characterStyleArray[i] instanceof ForegroundColorSpan) {
                    StringBuilder stringBuilder22 = stringBuilder.append("<font color =\"#");
                    String string5 = Integer.toHexString(((ForegroundColorSpan)characterStyleArray[i]).getForegroundColor() + 0x1000000);
                    while (string5.length() < 6) {
                        string5 = "0" + string5;
                    }
                    StringBuilder stringBuilder23 = stringBuilder.append(string5);
                    StringBuilder stringBuilder24 = stringBuilder.append("\">");
                }
                int n12 = n9;
            }
            Html.withinStyle(stringBuilder, spanned, n4, n6);
            for (int i = characterStyleArray.length - 1; i >= 0; i += -1) {
                if (characterStyleArray[i] instanceof ForegroundColorSpan) {
                    StringBuilder stringBuilder25 = stringBuilder.append("</font>");
                }
                if (characterStyleArray[i] instanceof AbsoluteSizeSpan) {
                    StringBuilder stringBuilder26 = stringBuilder.append("</font>");
                }
                if (characterStyleArray[i] instanceof URLSpan) {
                    StringBuilder stringBuilder27 = stringBuilder.append("</a>");
                }
                if (characterStyleArray[i] instanceof StrikethroughSpan) {
                    StringBuilder stringBuilder28 = stringBuilder.append("</strike>");
                }
                if (characterStyleArray[i] instanceof UnderlineSpan) {
                    StringBuilder stringBuilder29 = stringBuilder.append("</u>");
                }
                if (characterStyleArray[i] instanceof SubscriptSpan) {
                    StringBuilder stringBuilder30 = stringBuilder.append("</sub>");
                }
                if (characterStyleArray[i] instanceof SuperscriptSpan) {
                    StringBuilder stringBuilder31 = stringBuilder.append("</sup>");
                }
                if (characterStyleArray[i] instanceof TypefaceSpan && ((TypefaceSpan)characterStyleArray[i]).getFamily().equals("monospace")) {
                    StringBuilder stringBuilder32 = stringBuilder.append("</tt>");
                }
                if (!(characterStyleArray[i] instanceof StyleSpan)) continue;
                int n13 = ((StyleSpan)characterStyleArray[i]).getStyle();
                if ((n13 & 1) != 0) {
                    StringBuilder stringBuilder33 = stringBuilder.append("</b>");
                }
                if ((n13 & 2) == 0) continue;
                StringBuilder stringBuilder34 = stringBuilder.append("</i>");
            }
            n4 = n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void withinStyle(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = spanned.charAt(n3);
            if (c == '<') {
                StringBuilder stringBuilder2 = stringBuilder.append("&lt;");
            } else if (c == '>') {
                StringBuilder stringBuilder3 = stringBuilder.append("&gt;");
            } else if (c == '&') {
                StringBuilder stringBuilder4 = stringBuilder.append("&amp;");
            } else if (c > '~' || c < ' ') {
                String string2 = "&#" + c + ";";
                StringBuilder stringBuilder5 = stringBuilder.append(string2);
            } else if (c == ' ') {
                int n4;
                while (n3 + 1 < n2 && spanned.charAt(n4 = n3 + 1) == ' ') {
                    StringBuilder stringBuilder6 = stringBuilder.append("&nbsp;");
                    ++n3;
                }
                StringBuilder stringBuilder7 = stringBuilder.append(' ');
            } else {
                StringBuilder stringBuilder8 = stringBuilder.append(c);
            }
            ++n3;
        }
        return;
    }

    private static class HtmlParser {
        private static final HTMLSchema schema = new HTMLSchema();

        private HtmlParser() {
        }
    }

    public static interface TagHandler {
        public void handleTag(boolean var1, String var2, Editable var3, XMLReader var4);
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1);
    }
}

