/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class HtmlToSpannedConverter
implements ContentHandler {
    private static HashMap<String, Integer> COLORS;
    private static final float[] HEADER_SIZES;
    private Html.ImageGetter mImageGetter;
    private XMLReader mReader;
    private String mSource;
    private SpannableStringBuilder mSpannableStringBuilder;
    private Html.TagHandler mTagHandler;

    static {
        HEADER_SIZES = new float[]{1069547520, 0x3FB33333, 1067869798, 1067030938, 1066192077, 1065353216};
        COLORS = HtmlToSpannedConverter.buildColorMap();
    }

    public HtmlToSpannedConverter(String string2, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser) {
        SpannableStringBuilder spannableStringBuilder;
        this.mSource = string2;
        this.mSpannableStringBuilder = spannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
    }

    private static HashMap<String, Integer> buildColorMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer n = 65535;
        Integer n2 = hashMap.put("aqua", n);
        Integer n3 = 0;
        Integer n4 = hashMap.put("black", n3);
        Integer n5 = 255;
        Integer n6 = hashMap.put("blue", n5);
        Integer n7 = 0xFF00FF;
        Integer n8 = hashMap.put("fuchsia", n7);
        Integer n9 = 32768;
        Integer n10 = hashMap.put("green", n9);
        Integer n11 = 0x808080;
        Integer n12 = hashMap.put("grey", n11);
        Integer n13 = 65280;
        Integer n14 = hashMap.put("lime", n13);
        Integer n15 = 0x800000;
        Integer n16 = hashMap.put("maroon", n15);
        Integer n17 = 128;
        Integer n18 = hashMap.put("navy", n17);
        Integer n19 = 0x808000;
        Integer n20 = hashMap.put("olive", n19);
        Integer n21 = 0x800080;
        Integer n22 = hashMap.put("purple", n21);
        Integer n23 = 0xFF0000;
        Integer n24 = hashMap.put("red", n23);
        Integer n25 = 0xC0C0C0;
        Integer n26 = hashMap.put("silver", n25);
        Integer n27 = 32896;
        Integer n28 = hashMap.put("teal", n27);
        Integer n29 = 0xFFFFFF;
        Integer n30 = hashMap.put("white", n29);
        Integer n31 = 0xFFFF00;
        Integer n32 = hashMap.put("yellow", n31);
        return hashMap;
    }

    private static void end(SpannableStringBuilder spannableStringBuilder, Class clazz, Object object) {
        int n = spannableStringBuilder.length();
        Object object2 = HtmlToSpannedConverter.getLast(spannableStringBuilder, clazz);
        int n2 = spannableStringBuilder.getSpanStart(object2);
        spannableStringBuilder.removeSpan(object2);
        if (n2 != n) {
            return;
        }
        spannableStringBuilder.setSpan(object, n2, n, 33);
    }

    private static void endA(SpannableStringBuilder spannableStringBuilder) {
        int n = spannableStringBuilder.length();
        Object object = HtmlToSpannedConverter.getLast(spannableStringBuilder, Href.class);
        int n2 = spannableStringBuilder.getSpanStart(object);
        spannableStringBuilder.removeSpan(object);
        if (n2 != n) {
            return;
        }
        Href href = (Href)object;
        if (href.mHref == null) {
            return;
        }
        String string2 = href.mHref;
        URLSpan uRLSpan = new URLSpan(string2);
        spannableStringBuilder.setSpan(uRLSpan, n2, n, 33);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void endFont(SpannableStringBuilder spannableStringBuilder) {
        int n = spannableStringBuilder.length();
        SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
        Class<Font> clazz = Font.class;
        Object object = HtmlToSpannedConverter.getLast(spannableStringBuilder2, clazz);
        SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder;
        Object object2 = object;
        int n2 = spannableStringBuilder3.getSpanStart(object2);
        SpannableStringBuilder spannableStringBuilder4 = spannableStringBuilder;
        Object object3 = object;
        spannableStringBuilder4.removeSpan(object3);
        int n3 = n2;
        int n4 = n;
        if (n3 != n4) {
            return;
        }
        Font font = (Font)object;
        if (!TextUtils.isEmpty(font.mColor)) {
            if (font.mColor.startsWith("@")) {
                String string2;
                String string3;
                String string4;
                String string5;
                Resources resources = Resources.getSystem();
                Resources resources2 = resources;
                int n5 = resources2.getIdentifier(string5 = (string4 = font.mColor.substring(1)), string3 = "color", string2 = "android");
                if (n5 != 0) {
                    Resources resources3 = resources;
                    int n6 = n5;
                    ColorStateList colorStateList = resources3.getColorStateList(n6);
                    int n7 = 0;
                    ColorStateList colorStateList2 = null;
                    TextAppearanceSpan textAppearanceSpan = new TextAppearanceSpan(null, 0, n7, colorStateList, colorStateList2);
                    SpannableStringBuilder spannableStringBuilder5 = spannableStringBuilder;
                    TextAppearanceSpan textAppearanceSpan2 = textAppearanceSpan;
                    int n8 = n2;
                    int n9 = n;
                    int n10 = 33;
                    spannableStringBuilder5.setSpan(textAppearanceSpan2, n8, n9, n10);
                }
            } else {
                int n11 = HtmlToSpannedConverter.getHtmlColor(font.mColor);
                if (n11 != -1) {
                    int n12 = 0xFF000000 | n11;
                    ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(n12);
                    SpannableStringBuilder spannableStringBuilder6 = spannableStringBuilder;
                    ForegroundColorSpan foregroundColorSpan2 = foregroundColorSpan;
                    int n13 = n2;
                    int n14 = n;
                    int n15 = 33;
                    spannableStringBuilder6.setSpan(foregroundColorSpan2, n13, n14, n15);
                }
            }
        }
        if (font.mFace == null) {
            return;
        }
        String string6 = font.mFace;
        TypefaceSpan typefaceSpan = new TypefaceSpan(string6);
        SpannableStringBuilder spannableStringBuilder7 = spannableStringBuilder;
        TypefaceSpan typefaceSpan2 = typefaceSpan;
        int n16 = n2;
        int n17 = n;
        int n18 = 33;
        spannableStringBuilder7.setSpan(typefaceSpan2, n16, n17, n18);
    }

    private static void endHeader(SpannableStringBuilder spannableStringBuilder) {
        int n;
        int n2;
        Object object = HtmlToSpannedConverter.getLast(spannableStringBuilder, Header.class);
        int n3 = spannableStringBuilder.getSpanStart(object);
        spannableStringBuilder.removeSpan(object);
        for (n2 = spannableStringBuilder.length(); n2 > n3 && spannableStringBuilder.charAt(n = n2 - 1) == '\n'; n2 += -1) {
        }
        if (n3 != n2) {
            return;
        }
        Header header = (Header)object;
        float[] fArray = HEADER_SIZES;
        int n4 = header.mLevel;
        float f = fArray[n4];
        RelativeSizeSpan relativeSizeSpan = new RelativeSizeSpan(f);
        spannableStringBuilder.setSpan(relativeSizeSpan, n3, n2, 33);
        StyleSpan styleSpan = new StyleSpan(1);
        spannableStringBuilder.setSpan(styleSpan, n3, n2, 33);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getHtmlColor(String string2) {
        HashMap<String, Integer> hashMap = COLORS;
        String string3 = string2.toLowerCase();
        Integer n = hashMap.get(string3);
        if (n != null) {
            return n;
        }
        int n2 = -1;
        try {
            int n3 = XmlUtils.convertValueToInt(string2, n2);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getLast(Spanned spanned, Class clazz) {
        int n = spanned.length();
        T[] TArray = spanned.getSpans(0, n, clazz);
        if (TArray.length == 0) {
            return null;
        }
        int n2 = TArray.length - 1;
        return TArray[n2];
    }

    private static void handleBr(SpannableStringBuilder spannableStringBuilder) {
        Editable editable = spannableStringBuilder.append("\n");
    }

    private void handleEndTag(String string2) {
        if (string2.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("em")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            StyleSpan styleSpan = new StyleSpan(1);
            HtmlToSpannedConverter.end(spannableStringBuilder, Bold.class, styleSpan);
            return;
        }
        if (string2.equalsIgnoreCase("b")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            StyleSpan styleSpan = new StyleSpan(1);
            HtmlToSpannedConverter.end(spannableStringBuilder, Bold.class, styleSpan);
            return;
        }
        if (string2.equalsIgnoreCase("strong")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            StyleSpan styleSpan = new StyleSpan(2);
            HtmlToSpannedConverter.end(spannableStringBuilder, Italic.class, styleSpan);
            return;
        }
        if (string2.equalsIgnoreCase("cite")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            StyleSpan styleSpan = new StyleSpan(2);
            HtmlToSpannedConverter.end(spannableStringBuilder, Italic.class, styleSpan);
            return;
        }
        if (string2.equalsIgnoreCase("dfn")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            StyleSpan styleSpan = new StyleSpan(2);
            HtmlToSpannedConverter.end(spannableStringBuilder, Italic.class, styleSpan);
            return;
        }
        if (string2.equalsIgnoreCase("i")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            StyleSpan styleSpan = new StyleSpan(2);
            HtmlToSpannedConverter.end(spannableStringBuilder, Italic.class, styleSpan);
            return;
        }
        if (string2.equalsIgnoreCase("big")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            RelativeSizeSpan relativeSizeSpan = new RelativeSizeSpan(1.25f);
            HtmlToSpannedConverter.end(spannableStringBuilder, Big.class, relativeSizeSpan);
            return;
        }
        if (string2.equalsIgnoreCase("small")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            RelativeSizeSpan relativeSizeSpan = new RelativeSizeSpan(0.8f);
            HtmlToSpannedConverter.end(spannableStringBuilder, Small.class, relativeSizeSpan);
            return;
        }
        if (string2.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            QuoteSpan quoteSpan = new QuoteSpan();
            HtmlToSpannedConverter.end(spannableStringBuilder, Blockquote.class, quoteSpan);
            return;
        }
        if (string2.equalsIgnoreCase("tt")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            TypefaceSpan typefaceSpan = new TypefaceSpan("monospace");
            HtmlToSpannedConverter.end(spannableStringBuilder, Monospace.class, typefaceSpan);
            return;
        }
        if (string2.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.endA(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("u")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            UnderlineSpan underlineSpan = new UnderlineSpan();
            HtmlToSpannedConverter.end(spannableStringBuilder, Underline.class, underlineSpan);
            return;
        }
        if (string2.equalsIgnoreCase("sup")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            SuperscriptSpan superscriptSpan = new SuperscriptSpan();
            HtmlToSpannedConverter.end(spannableStringBuilder, Super.class, superscriptSpan);
            return;
        }
        if (string2.equalsIgnoreCase("sub")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            SubscriptSpan subscriptSpan = new SubscriptSpan();
            HtmlToSpannedConverter.end(spannableStringBuilder, Sub.class, subscriptSpan);
            return;
        }
        if (string2.length() == 2 && Character.toLowerCase(string2.charAt(0)) == 'h' && string2.charAt(1) >= '1' && string2.charAt(1) <= '6') {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endHeader(this.mSpannableStringBuilder);
            return;
        }
        if (this.mTagHandler == null) {
            return;
        }
        Html.TagHandler tagHandler = this.mTagHandler;
        SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
        XMLReader xMLReader = this.mReader;
        tagHandler.handleTag(false, string2, spannableStringBuilder, xMLReader);
    }

    private static void handleP(SpannableStringBuilder spannableStringBuilder) {
        int n;
        int n2 = spannableStringBuilder.length();
        if (n2 >= 1 && spannableStringBuilder.charAt(n = n2 - 1) == '\n') {
            int n3;
            if (n2 >= 2 && spannableStringBuilder.charAt(n3 = n2 - 2) == '\n') {
                return;
            }
            Editable editable = spannableStringBuilder.append("\n");
            return;
        }
        if (n2 == 0) {
            return;
        }
        Editable editable = spannableStringBuilder.append("\n\n");
    }

    private void handleStartTag(String string2, Attributes attributes) {
        if (string2.equalsIgnoreCase("br")) {
            return;
        }
        if (string2.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            return;
        }
        if (string2.equalsIgnoreCase("em")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Bold bold = new Bold();
            HtmlToSpannedConverter.start(spannableStringBuilder, bold);
            return;
        }
        if (string2.equalsIgnoreCase("b")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Bold bold = new Bold();
            HtmlToSpannedConverter.start(spannableStringBuilder, bold);
            return;
        }
        if (string2.equalsIgnoreCase("strong")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Italic italic = new Italic();
            HtmlToSpannedConverter.start(spannableStringBuilder, italic);
            return;
        }
        if (string2.equalsIgnoreCase("cite")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Italic italic = new Italic();
            HtmlToSpannedConverter.start(spannableStringBuilder, italic);
            return;
        }
        if (string2.equalsIgnoreCase("dfn")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Italic italic = new Italic();
            HtmlToSpannedConverter.start(spannableStringBuilder, italic);
            return;
        }
        if (string2.equalsIgnoreCase("i")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Italic italic = new Italic();
            HtmlToSpannedConverter.start(spannableStringBuilder, italic);
            return;
        }
        if (string2.equalsIgnoreCase("big")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Big big = new Big();
            HtmlToSpannedConverter.start(spannableStringBuilder, big);
            return;
        }
        if (string2.equalsIgnoreCase("small")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Small small = new Small();
            HtmlToSpannedConverter.start(spannableStringBuilder, small);
            return;
        }
        if (string2.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.startFont(this.mSpannableStringBuilder, attributes);
            return;
        }
        if (string2.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Blockquote blockquote = new Blockquote();
            HtmlToSpannedConverter.start(spannableStringBuilder, blockquote);
            return;
        }
        if (string2.equalsIgnoreCase("tt")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Monospace monospace = new Monospace();
            HtmlToSpannedConverter.start(spannableStringBuilder, monospace);
            return;
        }
        if (string2.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.startA(this.mSpannableStringBuilder, attributes);
            return;
        }
        if (string2.equalsIgnoreCase("u")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Underline underline = new Underline();
            HtmlToSpannedConverter.start(spannableStringBuilder, underline);
            return;
        }
        if (string2.equalsIgnoreCase("sup")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Super super_ = new Super();
            HtmlToSpannedConverter.start(spannableStringBuilder, super_);
            return;
        }
        if (string2.equalsIgnoreCase("sub")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Sub sub = new Sub();
            HtmlToSpannedConverter.start(spannableStringBuilder, sub);
            return;
        }
        if (string2.length() == 2 && Character.toLowerCase(string2.charAt(0)) == 'h' && string2.charAt(1) >= '1' && string2.charAt(1) <= '6') {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            int n = string2.charAt(1) - 49;
            Header header = new Header(n);
            HtmlToSpannedConverter.start(spannableStringBuilder, header);
            return;
        }
        if (string2.equalsIgnoreCase("img")) {
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            Html.ImageGetter imageGetter = this.mImageGetter;
            HtmlToSpannedConverter.startImg(spannableStringBuilder, attributes, imageGetter);
            return;
        }
        if (this.mTagHandler == null) {
            return;
        }
        Html.TagHandler tagHandler = this.mTagHandler;
        SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
        XMLReader xMLReader = this.mReader;
        tagHandler.handleTag(true, string2, spannableStringBuilder, xMLReader);
    }

    private static void start(SpannableStringBuilder spannableStringBuilder, Object object) {
        int n = spannableStringBuilder.length();
        spannableStringBuilder.setSpan(object, n, n, 17);
    }

    private static void startA(SpannableStringBuilder spannableStringBuilder, Attributes attributes) {
        String string2 = attributes.getValue("", "href");
        int n = spannableStringBuilder.length();
        Href href = new Href(string2);
        spannableStringBuilder.setSpan(href, n, n, 17);
    }

    private static void startFont(SpannableStringBuilder spannableStringBuilder, Attributes attributes) {
        String string2 = attributes.getValue("", "color");
        String string3 = attributes.getValue("", "face");
        int n = spannableStringBuilder.length();
        Font font = new Font(string2, string3);
        spannableStringBuilder.setSpan(font, n, n, 17);
    }

    private static void startImg(SpannableStringBuilder spannableStringBuilder, Attributes attributes, Html.ImageGetter imageGetter) {
        String string2 = attributes.getValue("", "src");
        Drawable drawable2 = null;
        if (imageGetter != null) {
            drawable2 = imageGetter.getDrawable(string2);
        }
        if (drawable2 == null) {
            drawable2 = Resources.getSystem().getDrawable(17302326);
            int n = drawable2.getIntrinsicWidth();
            int n2 = drawable2.getIntrinsicHeight();
            drawable2.setBounds(0, 0, n, n2);
        }
        int n = spannableStringBuilder.length();
        Editable editable = spannableStringBuilder.append("\ufffc");
        ImageSpan imageSpan = new ImageSpan(drawable2, string2);
        int n3 = spannableStringBuilder.length();
        spannableStringBuilder.setSpan(imageSpan, n, n3, 33);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                Editable editable = this.mSpannableStringBuilder.append(stringBuilder);
                return;
            }
            int n4 = n3 + n;
            char c = cArray[n4];
            if (c == ' ' || c == '\n') {
                int n5;
                int n6 = stringBuilder.length();
                if (n6 == 0) {
                    n6 = this.mSpannableStringBuilder.length();
                    if (n6 == 0) {
                        n5 = 10;
                    } else {
                        SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
                        int n7 = n6 - 1;
                        n5 = spannableStringBuilder.charAt(n7);
                    }
                } else {
                    int n8 = n6 - 1;
                    n5 = stringBuilder.charAt(n8);
                }
                if (n5 != 32 && n5 != 10) {
                    StringBuilder stringBuilder2 = stringBuilder.append(' ');
                }
            } else {
                StringBuilder stringBuilder3 = stringBuilder.append(c);
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Spanned convert() {
        int n;
        ParagraphStyle[] paragraphStyleArray;
        this.mReader.setContentHandler(this);
        try {
            XMLReader xMLReader = this.mReader;
            String string2 = this.mSource;
            StringReader stringReader = new StringReader(string2);
            InputSource inputSource = new InputSource(stringReader);
            xMLReader.parse(inputSource);
            SpannableStringBuilder spannableStringBuilder = this.mSpannableStringBuilder;
            int n2 = this.mSpannableStringBuilder.length();
            paragraphStyleArray = spannableStringBuilder.getSpans(0, n2, ParagraphStyle.class);
            n = 0;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        int n3;
        while (n < (n3 = paragraphStyleArray.length)) {
            int n4;
            SpannableStringBuilder spannableStringBuilder;
            int n5;
            SpannableStringBuilder spannableStringBuilder2;
            SpannableStringBuilder spannableStringBuilder3 = this.mSpannableStringBuilder;
            ParagraphStyle paragraphStyle = paragraphStyleArray[n];
            int n6 = spannableStringBuilder3.getSpanStart(paragraphStyle);
            SpannableStringBuilder spannableStringBuilder4 = this.mSpannableStringBuilder;
            ParagraphStyle paragraphStyle2 = paragraphStyleArray[n];
            int n7 = spannableStringBuilder4.getSpanEnd(paragraphStyle2);
            if (n7 - 2 >= 0 && (spannableStringBuilder2 = this.mSpannableStringBuilder).charAt(n5 = n7 - 1) == '\n' && (spannableStringBuilder = this.mSpannableStringBuilder).charAt(n4 = n7 - 2) == '\n') {
                n7 += -1;
            }
            if (n7 != n6) {
                SpannableStringBuilder spannableStringBuilder5 = this.mSpannableStringBuilder;
                ParagraphStyle paragraphStyle3 = paragraphStyleArray[n];
                spannableStringBuilder5.removeSpan(paragraphStyle3);
            } else {
                SpannableStringBuilder spannableStringBuilder6 = this.mSpannableStringBuilder;
                ParagraphStyle paragraphStyle4 = paragraphStyleArray[n];
                spannableStringBuilder6.setSpan(paragraphStyle4, n6, n7, 51);
            }
            ++n;
        }
        return this.mSpannableStringBuilder;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        this.handleEndTag(string3);
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        this.handleStartTag(string3, attributes);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }

    private static class Header {
        private int mLevel;

        public Header(int n) {
            this.mLevel = n;
        }
    }

    private static class Href {
        public String mHref;

        public Href(String string2) {
            this.mHref = string2;
        }
    }

    private static class Font {
        public String mColor;
        public String mFace;

        public Font(String string2, String string3) {
            this.mColor = string2;
            this.mFace = string3;
        }
    }

    private static class Sub {
        private Sub() {
        }
    }

    private static class Super {
        private Super() {
        }
    }

    private static class Blockquote {
        private Blockquote() {
        }
    }

    private static class Monospace {
        private Monospace() {
        }
    }

    private static class Small {
        private Small() {
        }
    }

    private static class Big {
        private Big() {
        }
    }

    private static class Underline {
        private Underline() {
        }
    }

    private static class Italic {
        private Italic() {
        }
    }

    private static class Bold {
        private Bold() {
        }
    }
}

