/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

public interface IClipboard
extends IInterface {
    public CharSequence getClipboardText() throws RemoteException;

    public boolean hasClipboardText() throws RemoteException;

    public void setClipboardText(CharSequence var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IClipboard {
        private static final String DESCRIPTOR = "android.text.IClipboard";
        static final int TRANSACTION_getClipboardText = 1;
        static final int TRANSACTION_hasClipboardText = 3;
        static final int TRANSACTION_setClipboardText = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IClipboard asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IClipboard) {
                IClipboard iClipboard = (IClipboard)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CharSequence charSequence = this.getClipboardText();
                    parcel2.writeNoException();
                    if (charSequence != null) {
                        parcel2.writeInt(1);
                        TextUtils.writeToParcel(charSequence, parcel2, 1);
                        return true;
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CharSequence charSequence = parcel.readInt() != 0 ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel) : null;
                    this.setClipboardText(charSequence);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = this.hasClipboardText();
            parcel2.writeNoException();
            int n3 = bl ? 1 : 0;
            parcel2.writeInt(n3);
            return true;
        }

        private static class Proxy
        implements IClipboard {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public CharSequence getClipboardText() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    CharSequence charSequence = parcel2.readInt() != 0 ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel2) : null;
                    return charSequence;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasClipboardText() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setClipboardText(CharSequence charSequence) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (charSequence != null) {
                        parcel.writeInt(1);
                        TextUtils.writeToParcel(charSequence, parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

