/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.emoji.EmojiFactory;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.GetChars;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.Styled;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.text.style.AlignmentSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.ParagraphStyle;
import android.text.style.ReplacementSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;

public abstract class Layout {
    private static final boolean DEBUG = false;
    static final Directions DIRS_ALL_LEFT_TO_RIGHT;
    static final Directions DIRS_ALL_RIGHT_TO_LEFT;
    public static final int DIR_LEFT_TO_RIGHT = 1;
    static final int DIR_REQUEST_DEFAULT_LTR = 2;
    static final int DIR_REQUEST_DEFAULT_RTL = 254;
    static final int DIR_REQUEST_LTR = 1;
    static final int DIR_REQUEST_RTL = 255;
    public static final int DIR_RIGHT_TO_LEFT = 255;
    static final EmojiFactory EMOJI_FACTORY;
    static final int MAX_EMOJI = 0;
    static final int MIN_EMOJI = 0;
    private static final ParagraphStyle[] NO_PARA_SPANS;
    private static final int TAB_INCREMENT = 20;
    private static Rect sTempRect;
    private Alignment mAlignment;
    private RectF mEmojiRect;
    private TextPaint mPaint;
    private float mSpacingAdd;
    private float mSpacingMult;
    private boolean mSpannedText;
    private CharSequence mText;
    private int mWidth;
    TextPaint mWorkPaint;

    /*
     * Enabled aggressive block sorting
     */
    static {
        NO_PARA_SPANS = ArrayUtils.emptyArray(ParagraphStyle.class);
        EMOJI_FACTORY = EmojiFactory.newAvailableInstance();
        if (EMOJI_FACTORY != null) {
            MIN_EMOJI = EMOJI_FACTORY.getMinimumAndroidPua();
            MAX_EMOJI = EMOJI_FACTORY.getMaximumAndroidPua();
        } else {
            MIN_EMOJI = -1;
            MAX_EMOJI = -1;
        }
        sTempRect = new Rect();
        short[] sArray = null;
        sArray[0] = Short.MAX_VALUE;
        DIRS_ALL_LEFT_TO_RIGHT = new Directions(sArray);
        null[0] = 0;
        null[1] = Short.MAX_VALUE;
        short[] sArray2 = null;
        DIRS_ALL_RIGHT_TO_LEFT = new Directions(sArray2);
    }

    protected Layout(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        boolean bl;
        TextPaint textPaint2;
        Alignment alignment2;
        this.mAlignment = alignment2 = Alignment.ALIGN_NORMAL;
        if (n < 0) {
            String string2 = "Layout: " + n + " < 0";
            throw new IllegalArgumentException(string2);
        }
        this.mText = charSequence;
        this.mPaint = textPaint;
        this.mWorkPaint = textPaint2 = new TextPaint();
        this.mWidth = n;
        this.mAlignment = alignment;
        this.mSpacingMult = f;
        this.mSpacingAdd = f2;
        this.mSpannedText = bl = charSequence instanceof Spanned;
    }

    private void addSelection(int n, int n2, int n3, int n4, int n5, Path path) {
        int n6;
        CharSequence charSequence;
        int n7 = this.getLineStart(n);
        int n8 = this.getLineEnd(n);
        Directions directions = this.getLineDirections(n);
        int n9 = n8;
        int n10 = n7;
        if (n9 > n10 && (charSequence = this.mText).charAt(n6 = n8 - 1) == '\n') {
            n8 += -1;
        }
        int n11 = n7;
        int n12 = 0;
        int n13;
        while (n12 < (n13 = directions.mDirections.length)) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            int n26;
            short s = directions.mDirections[n12];
            int n27 = n11 + s;
            int n28 = n27;
            if (n28 > (n26 = n8)) {
                n27 = n8;
            }
            if ((n25 = n2) <= (n24 = n27) && (n23 = n3) >= (n22 = n11) && (n21 = (n20 = Math.max(n19 = n2, n18 = n11))) != (n17 = (n16 = Math.min(n15 = n3, n14 = n27)))) {
                Layout layout2 = this;
                int n29 = n20;
                boolean bl = false;
                boolean bl2 = false;
                int n30 = n;
                float f = layout2.getHorizontal(n29, bl, bl2, n30);
                Layout layout3 = this;
                int n31 = n16;
                boolean bl3 = true;
                boolean bl4 = false;
                int n32 = n;
                float f2 = layout3.getHorizontal(n31, bl3, bl4, n32);
                float f3 = n4;
                float f4 = n5;
                Path.Direction direction = Path.Direction.CW;
                path.addRect(f, f3, f2, f4, direction);
            }
            n11 = n27;
            ++n12;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawText(Canvas canvas, CharSequence charSequence, int n, int n2, int n3, Directions directions, float f, int n4, int n5, int n6, TextPaint textPaint, TextPaint textPaint2, boolean bl, Object[] objectArray) {
        char[] cArray;
        if (!bl) {
            Directions directions2 = directions;
            Directions directions3 = DIRS_ALL_LEFT_TO_RIGHT;
            Directions directions4 = directions3;
            if (directions2 == directions4) {
                Canvas canvas2 = canvas;
                CharSequence charSequence2 = charSequence;
                int n7 = n;
                int n8 = n2;
                int n9 = n3;
                float f2 = f;
                int n10 = n4;
                int n11 = n5;
                int n12 = n6;
                TextPaint textPaint3 = textPaint;
                TextPaint textPaint4 = textPaint2;
                float f3 = Styled.drawText(canvas2, charSequence2, n7, n8, n9, false, f2, n10, n11, n12, textPaint3, textPaint4, false);
                return;
            }
            cArray = null;
        } else {
            cArray = TextUtils.obtain(n2 - n);
            CharSequence charSequence3 = charSequence;
            int n13 = n;
            int n14 = n2;
            char[] cArray2 = cArray;
            int n15 = 0;
            TextUtils.getChars(charSequence3, n13, n14, cArray2, n15);
        }
        float f4 = 0.0f;
        int n16 = 0;
        int n17 = 0;
        while (true) {
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            if ((n25 = ++n17) < (n24 = (n23 = directions.mDirections.length))) {
                int n26;
                int n27;
                short s = directions.mDirections[n17];
                n22 = n16 + s;
                int n28 = n22;
                if (n28 > (n27 = (n26 = n2 - n))) {
                    n22 = n2 - n;
                }
                n21 = n16;
                n20 = bl ? n16 : n22;
            } else {
                if (!bl) {
                    return;
                }
                TextUtils.recycle(cArray);
                return;
            }
            while ((n19 = ++n20) <= (n18 = n22)) {
                int n29;
                EmojiFactory emojiFactory;
                Bitmap bitmap;
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                char[] cArray3;
                int n36;
                int n37;
                int n38;
                int n39;
                boolean bl2;
                float f5;
                int n40 = n20;
                int n41 = n22;
                if (n40 == n41 || cArray[n20] == '\t') {
                    int n42 = n + n21;
                    int n43 = n + n20;
                    boolean bl3 = (n17 & 1) != 0;
                    f5 = f + f4;
                    int n44 = n + n20;
                    int n45 = n2;
                    bl2 = n44 != n45;
                    Canvas canvas3 = canvas;
                    CharSequence charSequence4 = charSequence;
                    int n46 = n3;
                    int n47 = n4;
                    int n48 = n5;
                    int n49 = n6;
                    TextPaint textPaint5 = textPaint;
                    TextPaint textPaint6 = textPaint2;
                    float f6 = Styled.drawText(canvas3, charSequence4, n42, n43, n46, bl3, f5, n47, n48, n49, textPaint5, textPaint6, bl2);
                    f4 += f6;
                    int n50 = n20;
                    int n51 = n22;
                    if (n50 != n51 && cArray[n20] == '\t') {
                        float f7 = n3;
                        float f8 = (float)n3 * f4;
                        CharSequence charSequence5 = charSequence;
                        int n52 = n;
                        int n53 = n2;
                        float f9 = f8;
                        Object[] objectArray2 = objectArray;
                        float f10 = Layout.nextTab(charSequence5, n52, n53, f9, objectArray2);
                        float f11 = f7 * f10;
                    }
                    n21 = n20 + 1;
                    continue;
                }
                if (!bl || cArray[n20] < '\ud800' || cArray[n20] > '\udfff' || (n39 = n20 + 1) >= (n38 = n22) || (n37 = (n36 = Character.codePointAt(cArray3 = cArray, n35 = n20))) < (n34 = (n33 = MIN_EMOJI)) || (n32 = n36) > (n31 = (n30 = MAX_EMOJI)) || (bitmap = (emojiFactory = EMOJI_FACTORY).getBitmapFromAndroidPua(n29 = n36)) == null) continue;
                int n54 = n + n21;
                int n55 = n + n20;
                boolean bl4 = (n17 & 1) != 0;
                f5 = f + f4;
                int n56 = n + n20;
                int n57 = n2;
                bl2 = n56 != n57;
                Canvas canvas4 = canvas;
                CharSequence charSequence6 = charSequence;
                int n58 = n3;
                int n59 = n4;
                int n60 = n5;
                int n61 = n6;
                TextPaint textPaint7 = textPaint;
                TextPaint textPaint8 = textPaint2;
                float f12 = Styled.drawText(canvas4, charSequence6, n54, n55, n58, bl4, f5, n59, n60, n61, textPaint7, textPaint8, bl2);
                float f13 = f4 + f12;
                if (this.mEmojiRect == null) {
                    RectF rectF;
                    this.mEmojiRect = rectF = new RectF();
                }
                TextPaint textPaint9 = textPaint2;
                TextPaint textPaint10 = textPaint;
                textPaint9.set(textPaint10);
                int n62 = n + n20;
                int n63 = n + n20 + 1;
                TextPaint textPaint11 = textPaint;
                TextPaint textPaint12 = textPaint2;
                CharSequence charSequence7 = charSequence;
                float f14 = Styled.measureText(textPaint11, textPaint12, charSequence7, n62, n63, null);
                float f15 = bitmap.getHeight();
                float f16 = -textPaint2.ascent();
                float f17 = f16 / f15;
                float f18 = (float)bitmap.getWidth() * f17;
                RectF rectF = this.mEmojiRect;
                float f19 = f + f13;
                float f20 = (float)n5 - f16;
                float f21 = f + f13 + f18;
                float f22 = n5;
                rectF.set(f19, f20, f21, f22);
                RectF rectF2 = this.mEmojiRect;
                Canvas canvas5 = canvas;
                Bitmap bitmap2 = bitmap;
                Rect rect = null;
                RectF rectF3 = rectF2;
                TextPaint textPaint13 = textPaint;
                canvas5.drawBitmap(bitmap2, rect, rectF3, (Paint)textPaint13);
                f4 = f13 + f18;
                n21 = ++n20 + 1;
            }
            n16 = n22;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ellipsize(int n, int n2, int n3, char[] cArray, int n4) {
        int n5 = this.getEllipsisCount(n3);
        if (n5 == 0) {
            return;
        }
        int n6 = this.getEllipsisStart(n3);
        int n7 = this.getLineStart(n3);
        int n8 = n6;
        int n9;
        while (n8 < (n9 = n6 + n5)) {
            int n10 = n8 != n6 ? 8230 : 65279;
            int n11 = n8 + n7;
            if (n11 >= n && n11 < n2) {
                int n12 = n4 + n11 - n;
                cArray[n12] = n10;
            }
            ++n8;
        }
        return;
    }

    public static float getDesiredWidth(CharSequence charSequence, int n, int n2, TextPaint textPaint) {
        float f = 0.0f;
        TextPaint textPaint2 = new TextPaint();
        int n3 = n;
        while (n3 <= n2) {
            Object[] objectArray;
            CharSequence charSequence2;
            TextPaint textPaint3;
            float f2;
            int n4 = TextUtils.indexOf(charSequence, '\n', n3, n2);
            if (n4 < 0) {
                n4 = n2;
            }
            if ((f2 = Layout.measureText(textPaint3 = textPaint, textPaint2, charSequence2 = charSequence, n3, n4, null, true, objectArray = null)) > f) {
                f = f2;
            }
            n3 = n4 + 1;
        }
        return f;
    }

    public static float getDesiredWidth(CharSequence charSequence, TextPaint textPaint) {
        int n = charSequence.length();
        return Layout.getDesiredWidth(charSequence, 0, n, textPaint);
    }

    private float getHorizontal(int n, boolean bl, boolean bl2) {
        int n2 = this.getLineForOffset(n);
        return this.getHorizontal(n, bl, bl2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private float getHorizontal(int n, boolean bl, boolean bl2, int n2) {
        Layout layout2 = this;
        int n3 = n2;
        int n4 = layout2.getLineStart(n3);
        Layout layout3 = this;
        int n5 = n2;
        int n6 = layout3.getLineVisibleEnd(n5);
        Layout layout4 = this;
        int n7 = n2;
        int n8 = layout4.getParagraphDirection(n7);
        Layout layout5 = this;
        int n9 = n2;
        boolean bl3 = layout5.getLineContainsTab(n9);
        Layout layout6 = this;
        int n10 = n2;
        Directions directions = layout6.getLineDirections(n10);
        Object[] objectArray = null;
        if (bl3 && this.mText instanceof Spanned) {
            objectArray = ((Spanned)this.mText).getSpans(n4, n6, TabStopSpan.class);
        }
        TextPaint textPaint = this.mPaint;
        TextPaint textPaint2 = this.mWorkPaint;
        CharSequence charSequence = this.mText;
        int n11 = n;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        float f = Layout.measureText(textPaint, textPaint2, charSequence, n4, n11, n6, n8, directions, bl4, bl5, bl3, objectArray);
        int n12 = n;
        int n13 = n6;
        if (n12 > n13) {
            if (n8 == -1) {
                TextPaint textPaint3 = this.mPaint;
                TextPaint textPaint4 = this.mWorkPaint;
                CharSequence charSequence2 = this.mText;
                int n14 = n6;
                int n15 = n;
                boolean bl6 = bl3;
                Object[] objectArray2 = objectArray;
                float f2 = Layout.measureText(textPaint3, textPaint4, charSequence2, n14, n15, null, bl6, objectArray2);
                f -= f2;
            } else {
                TextPaint textPaint5 = this.mPaint;
                TextPaint textPaint6 = this.mWorkPaint;
                CharSequence charSequence3 = this.mText;
                int n16 = n6;
                int n17 = n;
                boolean bl7 = bl3;
                Object[] objectArray3 = objectArray;
                float f3 = Layout.measureText(textPaint5, textPaint6, charSequence3, n16, n17, null, bl7, objectArray3);
                f += f3;
            }
        }
        Layout layout7 = this;
        int n18 = n2;
        Alignment alignment = layout7.getParagraphAlignment(n18);
        Layout layout8 = this;
        int n19 = n2;
        int n20 = layout8.getParagraphLeft(n19);
        Layout layout9 = this;
        int n21 = n2;
        int n22 = layout9.getParagraphRight(n21);
        Alignment alignment2 = alignment;
        Alignment alignment3 = Alignment.ALIGN_NORMAL;
        Alignment alignment4 = alignment3;
        if (alignment2 == alignment4) {
            if (n8 != -1) return (float)n20 + f;
            return (float)n22 + f;
        }
        Layout layout10 = this;
        int n23 = n2;
        float f4 = layout10.getLineMax(n23);
        Alignment alignment5 = alignment;
        Alignment alignment6 = Alignment.ALIGN_OPPOSITE;
        Alignment alignment7 = alignment6;
        if (alignment5 == alignment7) {
            if (n8 != -1) return (float)n22 - f4 + f;
            return (float)n20 + f4 + f;
        }
        int n24 = (int)f4 & 0xFFFFFFFE;
        if (n8 != -1) return (float)((n22 - n20 - n24) / 2 + n20) + f;
        int n25 = (n22 - n20 - n24) / 2;
        return (float)(n22 - n25) + f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private float getLineMax(int n, Object[] objectArray, boolean bl) {
        int n2 = this.getLineStart(n);
        int n3 = bl ? this.getLineEnd(n) : this.getLineVisibleEnd(n);
        boolean bl2 = this.getLineContainsTab(n);
        if (objectArray == null && bl2 && this.mText instanceof Spanned) {
            objectArray = ((Spanned)this.mText).getSpans(n2, n3, TabStopSpan.class);
        }
        TextPaint textPaint = this.mPaint;
        TextPaint textPaint2 = this.mWorkPaint;
        CharSequence charSequence = this.mText;
        Object[] objectArray2 = objectArray;
        return Layout.measureText(textPaint, textPaint2, charSequence, n2, n3, null, bl2, objectArray2);
    }

    /*
     * Unable to fully structure code
     */
    private int getLineVisibleEnd(int var1_1, int var2_2, int var3_3) {
        var4_4 = this.mText;
        var5_5 = this.getLineCount() - 1;
        if (var1_1 == var5_5) ** GOTO lbl8
        var6_6 = var3_3;
lbl5:
        // 3 sources

        return var6_6;
lbl-1000:
        // 1 sources

        {
            var3_3 += -1;
lbl8:
            // 2 sources

            if (var3_3 <= var2_2) break;
            var7_7 = var3_3 - 1;
            var8_8 = var4_4.charAt(var7_7);
            if (var8_8 != '\n') continue;
            var6_6 = var3_3 - 1;
            ** GOTO lbl5
            ** while (var8_8 == ' ' || var8_8 == '\t')
        }
lbl15:
        // 2 sources

        var6_6 = var3_3;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getOffsetAtStartOf(int n) {
        int n2;
        int n3;
        char c;
        if (n == 0) {
            return 0;
        }
        CharSequence charSequence = this.mText;
        char c2 = charSequence.charAt(n);
        if (c2 >= '\udc00' && c2 <= '\udfff' && (c = charSequence.charAt(n3 = n - 1)) >= '\ud800' && c <= '\udbff') {
            n += -1;
        }
        if (!this.mSpannedText) return n;
        ReplacementSpan[] replacementSpanArray = ((Spanned)charSequence).getSpans(n, n, ReplacementSpan.class);
        int n4 = 0;
        while (n4 < (n2 = replacementSpanArray.length)) {
            Spanned spanned = (Spanned)charSequence;
            ReplacementSpan replacementSpan = replacementSpanArray[n4];
            int n5 = spanned.getSpanStart(replacementSpan);
            Spanned spanned2 = (Spanned)charSequence;
            ReplacementSpan replacementSpan2 = replacementSpanArray[n4];
            int n6 = spanned2.getSpanEnd(replacementSpan2);
            if (n5 < n && n6 > n) {
                n = n5;
            }
            ++n4;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float measureText(TextPaint textPaint, TextPaint textPaint2, CharSequence charSequence, int n, int n2, int n3, int n4, Directions directions, boolean bl, boolean bl2, boolean bl3, Object[] objectArray) {
        int n5;
        int n6;
        char[] cArray = null;
        if (bl3) {
            cArray = TextUtils.obtain(n3 - n);
            CharSequence charSequence2 = charSequence;
            int n7 = n;
            int n8 = n3;
            char[] cArray2 = cArray;
            int n9 = 0;
            TextUtils.getChars(charSequence2, n7, n8, cArray2, n9);
        }
        char[] cArray3 = cArray;
        float f = 0.0f;
        if (bl2 && (n6 = n4) == (n5 = -1)) {
            bl = !bl;
        }
        int n10 = 0;
        int n11 = 0;
        block0: while (true) {
            int n12;
            int n13;
            int n14;
            if (n11 < (n14 = directions.mDirections.length)) {
                int n15;
                int n16;
                if (bl2) {
                    bl = !bl;
                }
                n13 = (n16 = directions.mDirections[n11] + n10) > (n15 = n3 - n) ? n3 - n : n16;
                n12 = n10;
                if (!bl3) {
                    int n17 = n13;
                }
            } else {
                if (bl3) {
                    TextUtils.recycle(cArray3);
                }
                float f2 = f;
                return f;
            }
            int n18 = n10;
            int n19 = n12;
            float f3 = f;
            while (true) {
                int n20;
                int n21;
                float f4;
                block25: {
                    block22: {
                        Bitmap bitmap;
                        block24: {
                            float f5;
                            block23: {
                                block21: {
                                    int n22;
                                    int n23;
                                    int n24;
                                    int n25;
                                    int n26;
                                    int n27;
                                    int n28;
                                    int n29;
                                    int n30;
                                    int n31;
                                    int n32;
                                    int n33;
                                    int n34;
                                    int n35;
                                    int n36;
                                    int n37;
                                    int n38;
                                    int n39;
                                    int n40;
                                    if ((n40 = n18) > (n39 = n13)) break block21;
                                    int n41 = 0;
                                    Bitmap bitmap2 = null;
                                    if (bl3 && (n38 = n18) < (n37 = n13)) {
                                        n41 = cArray3[n18];
                                    }
                                    if (n41 >= 55296 && n41 <= 57343 && (n36 = n18 + 1) < (n35 = n13) && (n41 = Character.codePointAt(cArray3, n18)) >= (n34 = MIN_EMOJI) && n41 <= (n33 = MAX_EMOJI)) {
                                        bitmap = EMOJI_FACTORY.getBitmapFromAndroidPua(n41);
                                        n32 = n41;
                                    } else {
                                        bitmap = bitmap2;
                                        n32 = n41;
                                    }
                                    if ((n31 = n18) != (n30 = n13) && n32 != 9 && bitmap == null) break block22;
                                    int n42 = n2;
                                    int n43 = n + n18;
                                    int n44 = n43;
                                    if (n42 < n44 || bl && (n29 = n2) <= (n28 = (n27 = n + n18))) {
                                        int n45 = n4;
                                        int n46 = 1;
                                        if (n45 == n46 && (n11 & 1) == 0) {
                                            int n47 = n + n19;
                                            TextPaint textPaint3 = textPaint;
                                            TextPaint textPaint4 = textPaint2;
                                            CharSequence charSequence3 = charSequence;
                                            int n48 = n2;
                                            return Styled.measureText(textPaint3, textPaint4, charSequence3, n47, n48, null) + f3;
                                        }
                                        int n49 = n4;
                                        int n50 = -1;
                                        if (n49 == n50 && (n11 & 1) != 0) {
                                            int n51 = n + n19;
                                            TextPaint textPaint5 = textPaint;
                                            TextPaint textPaint6 = textPaint2;
                                            CharSequence charSequence4 = charSequence;
                                            int n52 = n2;
                                            float f6 = Styled.measureText(textPaint5, textPaint6, charSequence4, n51, n52, null);
                                            return f3 - f6;
                                        }
                                    }
                                    int n53 = n + n19;
                                    int n54 = n + n18;
                                    TextPaint textPaint7 = textPaint;
                                    TextPaint textPaint8 = textPaint2;
                                    CharSequence charSequence5 = charSequence;
                                    float f7 = Styled.measureText(textPaint7, textPaint8, charSequence5, n53, n54, null);
                                    int n55 = n2;
                                    int n56 = n + n18;
                                    int n57 = n56;
                                    if (n55 < n57 || bl && (n26 = n2) <= (n25 = (n24 = n + n18))) {
                                        int n58 = n4;
                                        int n59 = 1;
                                        if (n58 == n59) {
                                            int n60 = n + n19;
                                            TextPaint textPaint9 = textPaint;
                                            TextPaint textPaint10 = textPaint2;
                                            CharSequence charSequence6 = charSequence;
                                            int n61 = n2;
                                            float f8 = Styled.measureText(textPaint9, textPaint10, charSequence6, n60, n61, null);
                                            return f7 - f8 + f3;
                                        }
                                        int n62 = n4;
                                        int n63 = -1;
                                        if (n62 == n63) {
                                            int n64 = n + n19;
                                            TextPaint textPaint11 = textPaint;
                                            TextPaint textPaint12 = textPaint2;
                                            CharSequence charSequence7 = charSequence;
                                            int n65 = n2;
                                            float f9 = Styled.measureText(textPaint11, textPaint12, charSequence7, n64, n65, null);
                                            float f10 = f7 - f9;
                                            return f3 - f10;
                                        }
                                    }
                                    f5 = (n23 = n4) == (n22 = -1) ? f3 - f7 : f3 + f7;
                                    int n66 = n18;
                                    int n67 = n13;
                                    if (n66 == n67 || cArray3[n18] != '\t') break block23;
                                    int n68 = n2;
                                    n10 = n + n18;
                                    int n69 = n10;
                                    if (n68 != n69) {
                                        float f11 = f5;
                                        return f5;
                                    }
                                    float f12 = n4;
                                    float f13 = n4;
                                    float f14 = f5 * f13;
                                    CharSequence charSequence8 = charSequence;
                                    int n70 = n;
                                    int n71 = n3;
                                    float f15 = f14;
                                    Object[] objectArray2 = objectArray;
                                    f3 = Layout.nextTab(charSequence8, n70, n71, f15, objectArray2) * f12;
                                    break block24;
                                }
                                int n72 = n13;
                                ++n11;
                                int n73 = n72;
                                float f16 = f3;
                                continue block0;
                            }
                            f3 = f5;
                        }
                        if (bitmap != null) {
                            TextPaint textPaint13 = textPaint2;
                            TextPaint textPaint14 = textPaint;
                            textPaint13.set(textPaint14);
                            int n74 = n18 + 2;
                            TextPaint textPaint15 = textPaint;
                            TextPaint textPaint16 = textPaint2;
                            CharSequence charSequence9 = charSequence;
                            int n75 = n18;
                            float f17 = Styled.measureText(textPaint15, textPaint16, charSequence9, n75, n74, null);
                            float f18 = bitmap.getWidth();
                            float f19 = -textPaint2.ascent();
                            float f20 = f18 * f19;
                            float f21 = bitmap.getHeight();
                            float f22 = f20 / f21;
                            int n76 = n4;
                            int n77 = -1;
                            f4 = n76 == n77 ? f3 - f22 : f22 + f3;
                            n21 = n18 + 1;
                        } else {
                            n21 = n18;
                            f4 = f3;
                        }
                        n20 = n21 + 1;
                        break block25;
                    }
                    n21 = n18;
                    n20 = n19;
                    f4 = f3;
                }
                n18 = n21 + 1;
                n19 = n20;
                float f23 = f4;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static float measureText(TextPaint textPaint, TextPaint textPaint2, CharSequence charSequence, int n, int n2, Paint.FontMetricsInt fontMetricsInt, boolean bl, Object[] objectArray) {
        char[] cArray = null;
        if (bl) {
            cArray = TextUtils.obtain(n2 - n);
            CharSequence charSequence2 = charSequence;
            int n3 = n;
            int n4 = n2;
            char[] cArray2 = cArray;
            int n5 = 0;
            TextUtils.getChars(charSequence2, n3, n4, cArray2, n5);
        }
        char[] cArray3 = cArray;
        int n6 = n2 - n;
        int n7 = 0;
        float f = 0.0f;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (fontMetricsInt != null) {
            int n12;
            int n13;
            fontMetricsInt.ascent = n13 = 0;
            fontMetricsInt.descent = n12 = 0;
        }
        int n14 = bl ? 0 : n6;
        int n15 = n14;
        int n16 = n11;
        int n17 = n10;
        int n18 = n9;
        float f2 = f;
        int n19 = n8;
        int n20 = n7;
        while (true) {
            float f3;
            int n21;
            int n22;
            block22: {
                block20: {
                    float f4;
                    block17: {
                        block21: {
                            block19: {
                                int n23;
                                int n24;
                                int n25;
                                int n26;
                                int n27;
                                int n28;
                                Bitmap bitmap;
                                int n29;
                                int n30;
                                int n31;
                                char[] cArray4;
                                int n32;
                                int n33;
                                int n34;
                                int n35;
                                int n36;
                                int n37;
                                if ((n37 = n15) > (n36 = n6)) break block19;
                                int n38 = 0;
                                Bitmap bitmap2 = null;
                                if (bl && (n35 = n15) < (n34 = n6)) {
                                    n38 = cArray3[n15];
                                }
                                if (n38 >= 55296 && n38 <= 57343 && (n33 = n15) < (n32 = n6) && (n38 = Character.codePointAt(cArray4 = cArray3, n31 = n15)) >= (n30 = MIN_EMOJI) && n38 <= (n29 = MAX_EMOJI)) {
                                    bitmap = EMOJI_FACTORY.getBitmapFromAndroidPua(n38);
                                    n28 = n38;
                                } else {
                                    bitmap = bitmap2;
                                    n28 = n38;
                                }
                                if ((n27 = n15) != (n26 = n6) && n28 != 9 && bitmap == null) break block20;
                                textPaint2.baselineShift = n25 = 0;
                                int n39 = n + n20;
                                int n40 = n + n15;
                                TextPaint textPaint3 = textPaint;
                                TextPaint textPaint4 = textPaint2;
                                CharSequence charSequence3 = charSequence;
                                Paint.FontMetricsInt fontMetricsInt2 = fontMetricsInt;
                                float f5 = Styled.measureText(textPaint3, textPaint4, charSequence3, n39, n40, fontMetricsInt2);
                                f2 += f5;
                                if (fontMetricsInt != null) {
                                    if (textPaint2.baselineShift < 0) {
                                        int n41;
                                        int n42;
                                        int n43 = fontMetricsInt.ascent;
                                        int n44 = textPaint2.baselineShift;
                                        fontMetricsInt.ascent = n42 = n43 + n44;
                                        int n45 = fontMetricsInt.top;
                                        int n46 = textPaint2.baselineShift;
                                        fontMetricsInt.top = n41 = n45 + n46;
                                    } else {
                                        int n47;
                                        int n48;
                                        int n49 = fontMetricsInt.descent;
                                        int n50 = textPaint2.baselineShift;
                                        fontMetricsInt.descent = n48 = n49 + n50;
                                        int n51 = fontMetricsInt.bottom;
                                        int n52 = textPaint2.baselineShift;
                                        fontMetricsInt.bottom = n47 = n51 + n52;
                                    }
                                }
                                if ((n24 = n15) == (n23 = n6)) break block21;
                                if (bitmap == null) {
                                    CharSequence charSequence4 = charSequence;
                                    int n53 = n;
                                    int n54 = n2;
                                    float f6 = f2;
                                    Object[] objectArray2 = objectArray;
                                    float f7 = Layout.nextTab(charSequence4, n53, n54, f6, objectArray2);
                                    n22 = n15;
                                    f4 = f7;
                                    break block17;
                                } else {
                                    TextPaint textPaint5 = textPaint2;
                                    TextPaint textPaint6 = textPaint;
                                    textPaint5.set(textPaint6);
                                    int n55 = n + n15;
                                    int n56 = n + n15 + 1;
                                    TextPaint textPaint7 = textPaint;
                                    TextPaint textPaint8 = textPaint2;
                                    CharSequence charSequence5 = charSequence;
                                    float f8 = Styled.measureText(textPaint7, textPaint8, charSequence5, n55, n56, null);
                                    float f9 = bitmap.getWidth();
                                    float f10 = -textPaint2.ascent();
                                    float f11 = f9 * f10;
                                    float f12 = bitmap.getHeight();
                                    float f13 = f11 / f12;
                                    float f14 = f2 + f13;
                                    n22 = n15 + 1;
                                    f4 = f14;
                                }
                                break block17;
                            }
                            if (fontMetricsInt != null) {
                                int n57;
                                int n58;
                                int n59;
                                int n60;
                                fontMetricsInt.ascent = n60 = n19;
                                fontMetricsInt.descent = n59 = n18;
                                fontMetricsInt.top = n58 = n17;
                                fontMetricsInt.bottom = n57 = n16;
                            }
                            if (bl) {
                                TextUtils.recycle(cArray3);
                            }
                            return f2;
                        }
                        n22 = n15;
                        f4 = f2;
                    }
                    if (fontMetricsInt != null) {
                        n8 = fontMetricsInt.ascent < n19 ? fontMetricsInt.ascent : n19;
                        n21 = fontMetricsInt.descent > n18 ? fontMetricsInt.descent : n18;
                        int n61 = fontMetricsInt.top;
                        int n62 = n17;
                        int n63 = n61 < n62 ? fontMetricsInt.top : n17;
                        if (fontMetricsInt.bottom > n16) {
                            n11 = fontMetricsInt.bottom;
                            n10 = n63;
                        } else {
                            n11 = n16;
                            n10 = n63;
                        }
                    } else {
                        n11 = n16;
                        n10 = n17;
                        n21 = n18;
                        n8 = n19;
                    }
                    n7 = n22 + 1;
                    f3 = f4;
                    break block22;
                }
                n22 = n15;
                n11 = n16;
                n10 = n17;
                n8 = n19;
                n7 = n20;
                f3 = f2;
                n21 = n18;
            }
            n15 = n22 + 1;
            n16 = n11;
            n17 = n10;
            n18 = n21;
            float f15 = f3;
            n19 = n8;
            n20 = n7;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static float nextTab(CharSequence charSequence, int n, int n2, float f, Object[] objectArray) {
        int n3;
        float f2 = Float.MAX_VALUE;
        boolean bl = false;
        if (!(charSequence instanceof Spanned)) return (int)((f + 20.0f) / 20.0f) * 20;
        if (objectArray == null) {
            objectArray = ((Spanned)charSequence).getSpans(n, n2, TabStopSpan.class);
            bl = true;
        }
        for (int i = 0; i < (n3 = objectArray.length); ++i) {
            int n4;
            if (!bl && !(objectArray[i] instanceof TabStopSpan) || !((float)(n4 = ((TabStopSpan)objectArray[i]).getTabStop()) < f2) || !((float)n4 > f)) continue;
            f2 = n4;
        }
        if (f2 == Float.MAX_VALUE) return (int)((f + 20.0f) / 20.0f) * 20;
        return f2;
    }

    public void draw(Canvas canvas) {
        this.draw(canvas, null, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(Canvas canvas, Path path, Paint paint, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Rect rect = sTempRect;
        synchronized (rect) {
            Rect rect2 = sTempRect;
            Canvas canvas2 = canvas;
            Rect rect3 = rect2;
            if (!canvas2.getClipBounds(rect3)) {
                return;
            }
            n5 = Layout.sTempRect.top;
            n4 = Layout.sTempRect.bottom;
        }
        int n6 = 0;
        int n7 = this.getLineCount();
        Layout layout2 = this;
        int n8 = n7;
        int n9 = layout2.getLineTop(n8);
        int n10 = n5;
        int n11 = n6;
        if (n10 > n11) {
            n6 = n5;
        }
        if ((n3 = n4) < (n2 = n9)) {
            n9 = n4;
        }
        Layout layout3 = this;
        int n12 = n6;
        int n13 = layout3.getLineForVertical(n12);
        Layout layout4 = this;
        int n14 = n9;
        int n15 = layout4.getLineForVertical(n14);
        Layout layout5 = this;
        int n16 = n13;
        int n17 = layout5.getLineTop(n16);
        Layout layout6 = this;
        int n18 = n13;
        int n19 = layout6.getLineStart(n18);
        TextPaint textPaint = this.mPaint;
        CharSequence charSequence = this.mText;
        int n20 = this.mWidth;
        boolean bl = this.mSpannedText;
        Object[] objectArray = NO_PARA_SPANS;
        int n21 = 0;
        int n22 = 0;
        if (bl) {
            int n23;
            int n24;
            n22 = charSequence.length();
            int n25 = n13;
            while ((n24 = ++n25) <= (n23 = n15)) {
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31 = n19;
                int n32 = n25 + 1;
                Layout layout7 = this;
                int n33 = n32;
                n19 = n30 = layout7.getLineStart(n33);
                int n34 = n17;
                int n35 = n25 + 1;
                Layout layout8 = this;
                int n36 = n35;
                n17 = n29 = layout8.getLineTop(n36);
                Layout layout9 = this;
                int n37 = n25;
                int n38 = layout9.getLineDescent(n37);
                int n39 = n29 - n38;
                int n40 = n31;
                int n41 = n21;
                if (n40 >= n41) {
                    Spanned spanned;
                    Spanned spanned2 = spanned = (Spanned)charSequence;
                    int n42 = n31;
                    int n43 = n22;
                    Class<LineBackgroundSpan> clazz = LineBackgroundSpan.class;
                    n21 = spanned2.nextSpanTransition(n42, n43, clazz);
                    Spanned spanned3 = spanned;
                    int n44 = n31;
                    int n45 = n21;
                    Class<LineBackgroundSpan> clazz2 = LineBackgroundSpan.class;
                    objectArray = spanned3.getSpans(n44, n45, clazz2);
                }
                int n46 = 0;
                while ((n28 = ++n46) < (n27 = (n26 = objectArray.length))) {
                    LineBackgroundSpan lineBackgroundSpan = (LineBackgroundSpan)objectArray[n46];
                    Canvas canvas3 = canvas;
                    lineBackgroundSpan.drawBackground(canvas3, textPaint, 0, n20, n34, n39, n29, charSequence, n31, n30, n25);
                }
            }
            n21 = 0;
            Layout layout10 = this;
            int n47 = n13;
            n17 = layout10.getLineTop(n47);
            Layout layout11 = this;
            int n48 = n13;
            n19 = layout11.getLineStart(n48);
            objectArray = NO_PARA_SPANS;
        }
        if (path != null) {
            if (n != 0) {
                float f = n;
                Canvas canvas4 = canvas;
                float f2 = 0.0f;
                float f3 = f;
                canvas4.translate(f2, f3);
            }
            canvas.drawPath(path, paint);
            if (n != 0) {
                float f = -n;
                Canvas canvas5 = canvas;
                float f4 = 0.0f;
                float f5 = f;
                canvas5.translate(f4, f5);
            }
        }
        Alignment alignment = this.mAlignment;
        int n49 = n13;
        int n50;
        int n51;
        while ((n51 = ++n49) <= (n50 = n15)) {
            int n52;
            Alignment alignment2;
            Alignment alignment3;
            Alignment alignment4;
            int n53;
            int n54;
            int n55 = n19;
            int n56 = n49 + 1;
            Layout layout12 = this;
            int n57 = n56;
            n19 = layout12.getLineStart(n57);
            Layout layout13 = this;
            int n58 = n49;
            int n59 = n55;
            int n60 = n19;
            int n61 = layout13.getLineVisibleEnd(n58, n59, n60);
            int n62 = n17;
            int n63 = n49 + 1;
            Layout layout14 = this;
            int n64 = n63;
            n17 = n54 = layout14.getLineTop(n64);
            Layout layout15 = this;
            int n65 = n49;
            int n66 = layout15.getLineDescent(n65);
            int n67 = n54 - n66;
            boolean bl2 = false;
            if (bl) {
                int n68;
                int n69;
                int n70;
                if (n55 == 0 || charSequence.charAt(n70 = n55 - 1) == '\n') {
                    bl2 = true;
                }
                if ((n69 = n55) >= (n68 = n21)) {
                    Spanned spanned;
                    Spanned spanned4 = spanned = (Spanned)charSequence;
                    int n71 = n55;
                    int n72 = n22;
                    Class<ParagraphStyle> clazz = ParagraphStyle.class;
                    int n73 = spanned4.nextSpanTransition(n71, n72, clazz);
                    Spanned spanned5 = spanned;
                    int n74 = n55;
                    int n75 = n73;
                    Class<ParagraphStyle> clazz3 = ParagraphStyle.class;
                    objectArray = spanned5.getSpans(n74, n75, clazz3);
                    alignment = this.mAlignment;
                    for (n53 = objectArray.length - 1; n53 >= 0; n53 += -1) {
                        if (!(objectArray[n53] instanceof AlignmentSpan)) continue;
                        alignment = ((AlignmentSpan)objectArray[n53]).getAlignment();
                        break;
                    }
                }
            }
            Layout layout16 = this;
            int n76 = n49;
            int n77 = layout16.getParagraphDirection(n76);
            int n78 = 0;
            int n79 = this.mWidth;
            if (bl) {
                int n80;
                int n81;
                int n82 = objectArray.length;
                n53 = 0;
                while ((n81 = ++n53) < (n80 = n82)) {
                    if (!(objectArray[n53] instanceof LeadingMarginSpan)) continue;
                    LeadingMarginSpan leadingMarginSpan = (LeadingMarginSpan)objectArray[n53];
                    int n83 = n77;
                    int n84 = -1;
                    if (n83 == n84) {
                        Canvas canvas6 = canvas;
                        TextPaint textPaint2 = textPaint;
                        int n85 = n62;
                        int n86 = n67;
                        int n87 = n54;
                        CharSequence charSequence2 = charSequence;
                        int n88 = n55;
                        int n89 = n61;
                        Layout layout17 = this;
                        leadingMarginSpan.drawLeadingMargin(canvas6, textPaint2, n79, n77, n85, n86, n87, charSequence2, n88, n89, bl2, layout17);
                        LeadingMarginSpan leadingMarginSpan2 = leadingMarginSpan;
                        boolean bl3 = bl2;
                        int n90 = leadingMarginSpan2.getLeadingMargin(bl3);
                        n79 -= n90;
                        continue;
                    }
                    LeadingMarginSpan leadingMarginSpan3 = leadingMarginSpan;
                    Canvas canvas7 = canvas;
                    TextPaint textPaint3 = textPaint;
                    int n91 = n77;
                    int n92 = n62;
                    int n93 = n67;
                    int n94 = n54;
                    CharSequence charSequence3 = charSequence;
                    int n95 = n55;
                    int n96 = n61;
                    boolean bl4 = bl2;
                    Layout layout18 = this;
                    leadingMarginSpan3.drawLeadingMargin(canvas7, textPaint3, n78, n91, n92, n93, n94, charSequence3, n95, n96, bl4, layout18);
                    boolean bl5 = bl2;
                    if (leadingMarginSpan instanceof LeadingMarginSpan.LeadingMarginSpan2) {
                        int n97;
                        int n98 = ((LeadingMarginSpan.LeadingMarginSpan2)leadingMarginSpan).getLeadingMarginLineCount();
                        bl5 = n98 > (n97 = n49);
                    }
                    LeadingMarginSpan leadingMarginSpan4 = leadingMarginSpan;
                    boolean bl6 = bl5;
                    int n99 = leadingMarginSpan4.getLeadingMargin(bl6);
                    n78 += n99;
                }
            }
            if ((alignment4 = alignment) == (alignment3 = (alignment2 = Alignment.ALIGN_NORMAL))) {
                int n100 = n77;
                int n101 = 1;
                n52 = n100 == n101 ? n78 : n79;
            } else {
                Layout layout19 = this;
                int n102 = n49;
                Object[] objectArray2 = objectArray;
                boolean bl7 = false;
                int n103 = (int)layout19.getLineMax(n102, objectArray2, bl7);
                Alignment alignment5 = alignment;
                Alignment alignment6 = Alignment.ALIGN_OPPOSITE;
                Alignment alignment7 = alignment6;
                if (alignment5 == alignment7) {
                    int n104 = n77;
                    int n105 = -1;
                    n52 = n104 == n105 ? n78 + n103 : n79 - n103;
                } else {
                    int n106 = n103 & 0xFFFFFFFE;
                    int n107 = n79 - n78 - n106 >> 1;
                    int n108 = n77;
                    int n109 = -1;
                    n52 = n108 == n109 ? n79 - n107 : n78 + n107;
                }
            }
            Layout layout20 = this;
            int n110 = n49;
            Directions directions = layout20.getLineDirections(n110);
            Layout layout21 = this;
            int n111 = n49;
            boolean bl8 = layout21.getLineContainsTab(n111);
            Directions directions2 = directions;
            Directions directions3 = DIRS_ALL_LEFT_TO_RIGHT;
            Directions directions4 = directions3;
            if (directions2 == directions4 && !bl && !bl8) {
                float f = n52;
                float f6 = n67;
                Canvas canvas8 = canvas;
                CharSequence charSequence4 = charSequence;
                int n112 = n55;
                int n113 = n61;
                TextPaint textPaint4 = textPaint;
                canvas8.drawText(charSequence4, n112, n113, f, f6, (Paint)textPaint4);
                continue;
            }
            float f = n52;
            TextPaint textPaint5 = this.mWorkPaint;
            Layout layout22 = this;
            Canvas canvas9 = canvas;
            CharSequence charSequence5 = charSequence;
            int n114 = n55;
            int n115 = n61;
            int n116 = n77;
            int n117 = n62;
            int n118 = n67;
            int n119 = n54;
            TextPaint textPaint6 = textPaint;
            layout22.drawText(canvas9, charSequence5, n114, n115, n116, directions, f, n117, n118, n119, textPaint6, textPaint5, bl8, objectArray);
        }
        return;
    }

    public final Alignment getAlignment() {
        return this.mAlignment;
    }

    public abstract int getBottomPadding();

    /*
     * Enabled aggressive block sorting
     */
    public void getCursorPath(int n, Path path, CharSequence charSequence) {
        path.reset();
        int n2 = this.getLineForOffset(n);
        int n3 = this.getLineTop(n2);
        int n4 = n2 + 1;
        int n5 = this.getLineTop(n4);
        float f = this.getPrimaryHorizontal(n) - 0.5f;
        float f2 = this.getSecondaryHorizontal(n) - 0.5f;
        int n6 = TextKeyListener.getMetaState(charSequence, 1);
        int n7 = TextKeyListener.getMetaState(charSequence, 65536);
        int n8 = n6 | n7;
        int n9 = TextKeyListener.getMetaState(charSequence, 2);
        int n10 = 0;
        if (n8 != 0 || n9 != 0) {
            n10 = n5 - n3 >> 2;
            if (n9 != 0) {
                n3 += n10;
            }
            if (n8 != 0) {
                n5 -= n10;
            }
        }
        if (f < 0.5f) {
            f = 0.5f;
        }
        if (f2 < 0.5f) {
            f2 = 0.5f;
        }
        if (f == f2) {
            float f3 = n3;
            path.moveTo(f, f3);
            float f4 = n5;
            path.lineTo(f, f4);
        } else {
            float f5 = n3;
            path.moveTo(f, f5);
            float f6 = n3 + n5 >> 1;
            path.lineTo(f, f6);
            float f7 = n3 + n5 >> 1;
            path.moveTo(f2, f7);
            float f8 = n5;
            path.lineTo(f2, f8);
        }
        if (n8 == 2) {
            float f9 = n5;
            path.moveTo(f2, f9);
            float f10 = n10;
            float f11 = f2 - f10;
            float f12 = n5 + n10;
            path.lineTo(f11, f12);
            float f13 = n5;
            path.lineTo(f2, f13);
            float f14 = (float)n10 + f2;
            float f15 = n5 + n10;
            path.lineTo(f14, f15);
        } else if (n8 == 1) {
            float f16 = n5;
            path.moveTo(f2, f16);
            float f17 = n10;
            float f18 = f2 - f17;
            float f19 = n5 + n10;
            path.lineTo(f18, f19);
            float f20 = n10;
            float f21 = f2 - f20;
            float f22 = (float)(n5 + n10) - 0.5f;
            path.moveTo(f21, f22);
            float f23 = (float)n10 + f2;
            float f24 = (float)(n5 + n10) - 0.5f;
            path.lineTo(f23, f24);
            float f25 = (float)n10 + f2;
            float f26 = n5 + n10;
            path.moveTo(f25, f26);
            float f27 = n5;
            path.lineTo(f2, f27);
        }
        if (n9 == 2) {
            float f28 = n3;
            path.moveTo(f, f28);
            float f29 = n10;
            float f30 = f - f29;
            float f31 = n3 - n10;
            path.lineTo(f30, f31);
            float f32 = n3;
            path.lineTo(f, f32);
            float f33 = (float)n10 + f;
            float f34 = n3 - n10;
            path.lineTo(f33, f34);
            return;
        }
        if (n9 != 1) {
            return;
        }
        float f35 = n3;
        path.moveTo(f, f35);
        float f36 = n10;
        float f37 = f - f36;
        float f38 = n3 - n10;
        path.lineTo(f37, f38);
        float f39 = n10;
        float f40 = f - f39;
        float f41 = (float)(n3 - n10) + 0.5f;
        path.moveTo(f40, f41);
        float f42 = (float)n10 + f;
        float f43 = (float)(n3 - n10) + 0.5f;
        path.lineTo(f42, f43);
        float f44 = (float)n10 + f;
        float f45 = n3 - n10;
        path.moveTo(f44, f45);
        float f46 = n3;
        path.lineTo(f, f46);
    }

    public abstract int getEllipsisCount(int var1);

    public abstract int getEllipsisStart(int var1);

    public int getEllipsizedWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        int n = this.getLineCount();
        return this.getLineTop(n);
    }

    public final int getLineAscent(int n) {
        int n2 = this.getLineTop(n);
        int n3 = n + 1;
        int n4 = this.getLineTop(n3);
        int n5 = this.getLineDescent(n);
        int n6 = n4 - n5;
        return n2 - n6;
    }

    public final int getLineBaseline(int n) {
        int n2 = n + 1;
        int n3 = this.getLineTop(n2);
        int n4 = this.getLineDescent(n);
        return n3 - n4;
    }

    public final int getLineBottom(int n) {
        int n2 = n + 1;
        return this.getLineTop(n2);
    }

    public int getLineBounds(int n, Rect rect) {
        if (rect != null) {
            int n2;
            int n3;
            int n4;
            rect.left = 0;
            rect.top = n4 = this.getLineTop(n);
            rect.right = n3 = this.mWidth;
            int n5 = n + 1;
            rect.bottom = n2 = this.getLineTop(n5);
        }
        return this.getLineBaseline(n);
    }

    public abstract boolean getLineContainsTab(int var1);

    public abstract int getLineCount();

    public abstract int getLineDescent(int var1);

    public abstract Directions getLineDirections(int var1);

    public final int getLineEnd(int n) {
        int n2 = n + 1;
        return this.getLineStart(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLineForOffset(int n) {
        int n2 = this.getLineCount();
        int n3 = -1;
        while (n2 - n3 > 1) {
            int n4 = (n2 + n3) / 2;
            if (this.getLineStart(n4) > n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 >= 0) return n3;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLineForVertical(int n) {
        int n2 = this.getLineCount();
        int n3 = -1;
        while (n2 - n3 > 1) {
            int n4 = (n2 + n3) / 2;
            if (this.getLineTop(n4) > n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 >= 0) return n3;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getLineLeft(int n) {
        Alignment alignment;
        int n2 = this.getParagraphDirection(n);
        Alignment alignment2 = this.getParagraphAlignment(n);
        if (alignment2 == (alignment = Alignment.ALIGN_NORMAL)) {
            if (n2 != -1) return 0.0f;
            float f = this.getParagraphRight(n);
            float f2 = this.getLineMax(n);
            return f - f2;
        }
        Alignment alignment3 = Alignment.ALIGN_OPPOSITE;
        if (alignment2 == alignment3) {
            if (n2 == -1) {
                return 0.0f;
            }
            float f = this.mWidth;
            float f3 = this.getLineMax(n);
            return f - f3;
        }
        int n3 = this.getParagraphLeft(n);
        int n4 = this.getParagraphRight(n);
        int n5 = (int)this.getLineMax(n) & 0xFFFFFFFE;
        return (n4 - n3 - n5) / 2 + n3;
    }

    public float getLineMax(int n) {
        return this.getLineMax(n, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getLineRight(int n) {
        Alignment alignment;
        int n2 = this.getParagraphDirection(n);
        Alignment alignment2 = this.getParagraphAlignment(n);
        if (alignment2 == (alignment = Alignment.ALIGN_NORMAL)) {
            if (n2 == -1) {
                return this.mWidth;
            }
            float f = this.getParagraphLeft(n);
            float f2 = this.getLineMax(n);
            return f + f2;
        }
        Alignment alignment3 = Alignment.ALIGN_OPPOSITE;
        if (alignment2 == alignment3) {
            if (n2 != -1) return this.mWidth;
            return this.getLineMax(n);
        }
        int n3 = this.getParagraphLeft(n);
        int n4 = this.getParagraphRight(n);
        int n5 = (int)this.getLineMax(n) & 0xFFFFFFFE;
        int n6 = (n4 - n3 - n5) / 2;
        return n4 - n6;
    }

    public abstract int getLineStart(int var1);

    public abstract int getLineTop(int var1);

    public int getLineVisibleEnd(int n) {
        int n2 = this.getLineStart(n);
        int n3 = n + 1;
        int n4 = this.getLineStart(n3);
        return this.getLineVisibleEnd(n, n2, n4);
    }

    public float getLineWidth(int n) {
        return this.getLineMax(n, null, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getOffsetForHorizontal(int n, float f) {
        int n2 = this.getLineEnd(n) - 1;
        int n3 = this.getLineStart(n);
        Directions directions = this.getLineDirections(n);
        int n4 = n;
        int n5 = this.getLineCount() - 1;
        int n6 = n5;
        if (n4 != n6) {
            ++n2;
        }
        int n7 = n3;
        Layout layout2 = this;
        int n8 = n7;
        float f2 = Math.abs(layout2.getPrimaryHorizontal(n8) - f);
        int n9 = n3;
        int n10 = 0;
        while (true) {
            int n11;
            Layout layout3;
            float f3;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            if ((n22 = ++n10) < (n21 = (n20 = directions.mDirections.length))) {
                short s = directions.mDirections[n10];
                n19 = n9 + s;
                n18 = (n10 & 1) == 0 ? 1 : 65535;
                int n23 = n19;
                int n24 = n2;
                if (n23 > n24) {
                    n19 = n2;
                }
                n17 = n19 - 1 + 1;
                n16 = n9 + 1 - 1;
            } else {
                Layout layout4 = this;
                int n25 = n2;
                float f4 = Math.abs(layout4.getPrimaryHorizontal(n25) - f);
                if (!(f4 < f2)) return n7;
                float f5 = f4;
                return n2;
            }
            while ((n15 = n17 - n16) > (n14 = 1)) {
                float f6;
                float f7;
                Layout layout5 = this;
                Layout layout6 = this;
                int n26 = (n17 + n16) / 2;
                int n27 = n26;
                int n28 = layout6.getOffsetAtStartOf(n27);
                int n29 = n28;
                float f8 = layout5.getPrimaryHorizontal(n29);
                float f9 = f8 * (f7 = (float)n18);
                if (f9 >= (f6 = (float)n18 * f)) {
                    n17 = n26;
                    continue;
                }
                n16 = n26;
            }
            int n30 = n16;
            int n31 = n9 + 1;
            int n32 = n31;
            if (n30 < n32) {
                n16 = n9 + 1;
            }
            if ((n13 = n16) < (n12 = n19)) {
                int n33;
                Layout layout7;
                float f10;
                int n34;
                Layout layout8 = this;
                int n35 = n16;
                n16 = layout8.getOffsetAtStartOf(n35);
                Layout layout9 = this;
                int n36 = n16;
                float f11 = Math.abs(layout9.getPrimaryHorizontal(n36) - f);
                CharSequence charSequence = this.mText;
                int n37 = n16;
                int n38 = TextUtils.getOffsetAfter(charSequence, n37);
                int n39 = n38;
                if (n39 < (n34 = n19) && (f10 = Math.abs((layout7 = this).getPrimaryHorizontal(n33 = n38) - f)) < f11) {
                    f11 = f10;
                    int n40 = n38;
                }
                if (f11 < f2) {
                    f2 = f11;
                    n7 = n16;
                }
            }
            if ((f3 = Math.abs((layout3 = this).getPrimaryHorizontal(n11 = n9) - f)) < f2) {
                f2 = f3;
                n7 = n9;
            }
            n9 = n19;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getOffsetToLeftOf(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Layout layout2;
        int n8;
        CharSequence charSequence;
        int n9;
        int n10;
        Layout layout3;
        float f;
        int n11 = this.getLineForOffset(n);
        Layout layout4 = this;
        int n12 = n11;
        int n13 = layout4.getLineStart(n12);
        Layout layout5 = this;
        int n14 = n11;
        int n15 = layout5.getLineEnd(n14);
        Layout layout6 = this;
        int n16 = n11;
        Directions directions = layout6.getLineDirections(n16);
        int n17 = n11;
        int n18 = this.getLineCount() - 1;
        int n19 = n18;
        if (n17 != n19) {
            n15 += -1;
        }
        float f2 = this.getPrimaryHorizontal(n);
        int n20 = n;
        float f3 = -2.1474836E9f;
        CharSequence charSequence2 = this.mText;
        int n21 = n;
        int n22 = TextUtils.getOffsetBefore(charSequence2, n21);
        if (n22 >= n13 && n22 <= n15 && (f = (layout3 = this).getPrimaryHorizontal(n10 = n22)) < f2 && f > f3) {
            n20 = n22;
            f3 = f;
        }
        if ((n9 = TextUtils.getOffsetAfter(charSequence = this.mText, n8 = n)) >= n13 && n9 <= n15 && (f = (layout2 = this).getPrimaryHorizontal(n7 = n9)) < f2 && f > f3) {
            n20 = n9;
            f3 = f;
        }
        int n23 = n13;
        int n24 = 0;
        while ((n6 = ++n24) < (n5 = (n4 = directions.mDirections.length))) {
            int n25;
            Layout layout7;
            int n26;
            CharSequence charSequence3;
            int n27;
            Layout layout8;
            float f4;
            int n28;
            CharSequence charSequence4;
            int n29;
            int n30;
            Layout layout9;
            short s = directions.mDirections[n24];
            int n31 = n23 + s;
            if (n31 > n15) {
                n31 = n15;
            }
            if ((f = (layout9 = this).getPrimaryHorizontal(n30 = n23)) < f2 && f > f3) {
                n20 = n23;
                f3 = f;
            }
            if ((n29 = TextUtils.getOffsetAfter(charSequence4 = this.mText, n28 = n23)) >= n13 && n29 <= n15 && (f4 = (layout8 = this).getPrimaryHorizontal(n27 = n29)) < f2 && f4 > f3) {
                n20 = n29;
                f3 = f4;
            }
            if ((n9 = TextUtils.getOffsetBefore(charSequence3 = this.mText, n26 = n31)) >= n13 && n9 <= n15 && (f4 = (layout7 = this).getPrimaryHorizontal(n25 = n9)) < f2 && f4 > f3) {
                n20 = n9;
                f3 = f4;
            }
            n23 = n31;
        }
        Layout layout10 = this;
        int n32 = n15;
        float f5 = layout10.getPrimaryHorizontal(n32);
        if (f5 < f2 && f5 > f3) {
            n20 = n15;
            float f6 = f5;
        }
        if ((n3 = n20) != (n2 = n)) {
            return n20;
        }
        Layout layout11 = this;
        int n33 = n11;
        if (layout11.getParagraphDirection(n33) > 0) {
            if (n11 == 0) {
                return n20;
            }
            int n34 = n11 - 1;
            Layout layout12 = this;
            int n35 = n34;
            float f7 = 10000.0f;
            return layout12.getOffsetForHorizontal(n35, f7);
        }
        int n36 = n11;
        int n37 = this.getLineCount() - 1;
        int n38 = n37;
        if (n36 != n38) {
            return n20;
        }
        int n39 = n11 + 1;
        Layout layout13 = this;
        int n40 = n39;
        float f8 = 10000.0f;
        return layout13.getOffsetForHorizontal(n40, f8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getOffsetToRightOf(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Layout layout2;
        int n8;
        CharSequence charSequence;
        int n9;
        int n10;
        Layout layout3;
        float f;
        int n11 = this.getLineForOffset(n);
        Layout layout4 = this;
        int n12 = n11;
        int n13 = layout4.getLineStart(n12);
        Layout layout5 = this;
        int n14 = n11;
        int n15 = layout5.getLineEnd(n14);
        Layout layout6 = this;
        int n16 = n11;
        Directions directions = layout6.getLineDirections(n16);
        int n17 = n11;
        int n18 = this.getLineCount() - 1;
        int n19 = n18;
        if (n17 != n19) {
            n15 += -1;
        }
        float f2 = this.getPrimaryHorizontal(n);
        int n20 = n;
        float f3 = 2.1474836E9f;
        CharSequence charSequence2 = this.mText;
        int n21 = n;
        int n22 = TextUtils.getOffsetBefore(charSequence2, n21);
        if (n22 >= n13 && n22 <= n15 && (f = (layout3 = this).getPrimaryHorizontal(n10 = n22)) > f2 && f < f3) {
            n20 = n22;
            f3 = f;
        }
        if ((n9 = TextUtils.getOffsetAfter(charSequence = this.mText, n8 = n)) >= n13 && n9 <= n15 && (f = (layout2 = this).getPrimaryHorizontal(n7 = n9)) > f2 && f < f3) {
            n20 = n9;
            f3 = f;
        }
        int n23 = n13;
        int n24 = 0;
        while ((n6 = ++n24) < (n5 = (n4 = directions.mDirections.length))) {
            int n25;
            Layout layout7;
            int n26;
            CharSequence charSequence3;
            int n27;
            Layout layout8;
            float f4;
            int n28;
            CharSequence charSequence4;
            int n29;
            int n30;
            Layout layout9;
            short s = directions.mDirections[n24];
            int n31 = n23 + s;
            if (n31 > n15) {
                n31 = n15;
            }
            if ((f = (layout9 = this).getPrimaryHorizontal(n30 = n23)) > f2 && f < f3) {
                n20 = n23;
                f3 = f;
            }
            if ((n29 = TextUtils.getOffsetAfter(charSequence4 = this.mText, n28 = n23)) >= n13 && n29 <= n15 && (f4 = (layout8 = this).getPrimaryHorizontal(n27 = n29)) > f2 && f4 < f3) {
                n20 = n29;
                f3 = f4;
            }
            if ((n9 = TextUtils.getOffsetBefore(charSequence3 = this.mText, n26 = n31)) >= n13 && n9 <= n15 && (f4 = (layout7 = this).getPrimaryHorizontal(n25 = n9)) > f2 && f4 < f3) {
                n20 = n9;
                f3 = f4;
            }
            n23 = n31;
        }
        Layout layout10 = this;
        int n32 = n15;
        float f5 = layout10.getPrimaryHorizontal(n32);
        if (f5 > f2 && f5 < f3) {
            n20 = n15;
            float f6 = f5;
        }
        if ((n3 = n20) != (n2 = n)) {
            return n20;
        }
        Layout layout11 = this;
        int n33 = n11;
        if (layout11.getParagraphDirection(n33) > 0) {
            int n34 = n11;
            int n35 = this.getLineCount() - 1;
            int n36 = n35;
            if (n34 != n36) {
                return n20;
            }
            int n37 = n11 + 1;
            Layout layout12 = this;
            int n38 = n37;
            float f7 = -10000.0f;
            return layout12.getOffsetForHorizontal(n38, f7);
        }
        if (n11 == 0) {
            return n20;
        }
        int n39 = n11 - 1;
        Layout layout13 = this;
        int n40 = n39;
        float f8 = -10000.0f;
        return layout13.getOffsetForHorizontal(n40, f8);
    }

    public final TextPaint getPaint() {
        return this.mPaint;
    }

    public final Alignment getParagraphAlignment(int n) {
        int n2;
        int n3;
        Spanned spanned;
        AlignmentSpan[] alignmentSpanArray;
        int n4;
        Alignment alignment = this.mAlignment;
        if (this.mSpannedText && (n4 = (alignmentSpanArray = (spanned = (Spanned)this.mText).getSpans(n3 = this.getLineStart(n), n2 = this.getLineEnd(n), AlignmentSpan.class)).length) > 0) {
            int n5 = n4 - 1;
            alignment = alignmentSpanArray[n5].getAlignment();
        }
        return alignment;
    }

    public abstract int getParagraphDirection(int var1);

    /*
     * Enabled aggressive block sorting
     */
    public final int getParagraphLeft(int n) {
        int n2;
        CharSequence charSequence;
        int n3 = this.getParagraphDirection(n);
        int n4 = 0;
        boolean bl = false;
        int n5 = this.getLineStart(n);
        if (n5 == 0 || (charSequence = this.mText).charAt(n2 = n5 - 1) == '\n') {
            bl = true;
        }
        if (n3 == 1 && this.mSpannedText) {
            int n6;
            int n7;
            Spanned spanned = (Spanned)this.mText;
            int n8 = this.getLineStart(n);
            int n9 = this.getLineEnd(n);
            LeadingMarginSpan[] leadingMarginSpanArray = spanned.getSpans(n8, n9, LeadingMarginSpan.class);
            for (int i = 0; i < (n6 = leadingMarginSpanArray.length); n4 += n7, ++i) {
                boolean bl2 = bl;
                LeadingMarginSpan leadingMarginSpan = leadingMarginSpanArray[i];
                if (leadingMarginSpan instanceof LeadingMarginSpan.LeadingMarginSpan2) {
                    int n10;
                    int n11 = ((LeadingMarginSpan.LeadingMarginSpan2)leadingMarginSpan).getLeadingMarginLineCount();
                    bl2 = n11 >= (n10 = n);
                }
                n7 = leadingMarginSpan.getLeadingMargin(bl2);
            }
        }
        return n4;
    }

    public final int getParagraphRight(int n) {
        int n2;
        CharSequence charSequence;
        int n3 = this.getParagraphDirection(n);
        int n4 = this.mWidth;
        boolean bl = false;
        int n5 = this.getLineStart(n);
        if (n5 == 0 || (charSequence = this.mText).charAt(n2 = n5 - 1) == '\n') {
            bl = true;
        }
        if (n3 == -1 && this.mSpannedText) {
            int n6;
            Spanned spanned = (Spanned)this.mText;
            int n7 = this.getLineStart(n);
            int n8 = this.getLineEnd(n);
            LeadingMarginSpan[] leadingMarginSpanArray = spanned.getSpans(n7, n8, LeadingMarginSpan.class);
            for (int i = 0; i < (n6 = leadingMarginSpanArray.length); ++i) {
                int n9 = leadingMarginSpanArray[i].getLeadingMargin(bl);
                n4 -= n9;
            }
        }
        return n4;
    }

    public float getPrimaryHorizontal(int n) {
        return this.getHorizontal(n, false, true);
    }

    public float getSecondaryHorizontal(int n) {
        return this.getHorizontal(n, true, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getSelectionPath(int n, int n2, Path path) {
        int n3;
        int n4;
        path.reset();
        int n5 = n;
        int n6 = n2;
        if (n5 != n6) {
            return;
        }
        int n7 = n2;
        int n8 = n;
        if (n7 < n8) {
            int n9 = n2;
            n2 = n;
            n = n9;
        }
        int n10 = this.getLineForOffset(n);
        Layout layout2 = this;
        int n11 = n2;
        int n12 = layout2.getLineForOffset(n11);
        Layout layout3 = this;
        int n13 = n10;
        int n14 = layout3.getLineTop(n13);
        Layout layout4 = this;
        int n15 = n12;
        int n16 = layout4.getLineBottom(n15);
        if (n10 != n12) {
            Layout layout5 = this;
            int n17 = n;
            int n18 = n2;
            Path path2 = path;
            layout5.addSelection(n10, n17, n18, n14, n16, path2);
            return;
        }
        float f = this.mWidth;
        Layout layout6 = this;
        int n19 = n10;
        int n20 = layout6.getLineEnd(n19);
        Layout layout7 = this;
        int n21 = n10;
        int n22 = layout7.getLineBottom(n21);
        Layout layout8 = this;
        int n23 = n10;
        int n24 = n;
        int n25 = n14;
        Path path3 = path;
        layout8.addSelection(n23, n24, n20, n25, n22, path3);
        Layout layout9 = this;
        int n26 = n10;
        if (layout9.getParagraphDirection(n26) == -1) {
            Layout layout10 = this;
            int n27 = n10;
            float f2 = layout10.getLineLeft(n27);
            float f3 = n14;
            Layout layout11 = this;
            int n28 = n10;
            float f4 = layout11.getLineBottom(n28);
            Path.Direction direction = Path.Direction.CW;
            path.addRect(f2, f3, 0.0f, f4, direction);
        } else {
            Layout layout12 = this;
            int n29 = n10;
            float f5 = layout12.getLineRight(n29);
            float f6 = n14;
            Layout layout13 = this;
            int n30 = n10;
            float f7 = layout13.getLineBottom(n30);
            Path.Direction direction = Path.Direction.CW;
            Path path4 = path;
            float f8 = f;
            path4.addRect(f5, f6, f8, f7, direction);
        }
        int n31 = n10 + 1;
        while ((n4 = n31) < (n3 = n12)) {
            Layout layout14 = this;
            int n32 = n31;
            int n33 = layout14.getLineTop(n32);
            Layout layout15 = this;
            int n34 = n31++;
            int n35 = layout15.getLineBottom(n34);
            float f9 = n33;
            float f10 = n35;
            Path.Direction direction = Path.Direction.CW;
            Path path5 = path;
            float f11 = f;
            path5.addRect(0.0f, f9, f11, f10, direction);
        }
        Layout layout16 = this;
        int n36 = n12;
        n14 = layout16.getLineTop(n36);
        Layout layout17 = this;
        int n37 = n12;
        n16 = layout17.getLineBottom(n37);
        Layout layout18 = this;
        int n38 = n12;
        int n39 = layout18.getLineStart(n38);
        Layout layout19 = this;
        int n40 = n12;
        int n41 = n2;
        int n42 = n14;
        int n43 = n16;
        Path path6 = path;
        layout19.addSelection(n40, n39, n41, n42, n43, path6);
        Layout layout20 = this;
        int n44 = n12;
        if (layout20.getParagraphDirection(n44) == -1) {
            float f12 = n14;
            Layout layout21 = this;
            int n45 = n12;
            float f13 = layout21.getLineRight(n45);
            float f14 = n16;
            Path.Direction direction = Path.Direction.CW;
            Path path7 = path;
            float f15 = f;
            path7.addRect(f15, f12, f13, f14, direction);
            return;
        }
        float f16 = n14;
        Layout layout22 = this;
        int n46 = n12;
        float f17 = layout22.getLineLeft(n46);
        float f18 = n16;
        Path.Direction direction = Path.Direction.CW;
        path.addRect(0.0f, f16, f17, f18, direction);
    }

    public final float getSpacingAdd() {
        return this.mSpacingAdd;
    }

    public final float getSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public final CharSequence getText() {
        return this.mText;
    }

    public abstract int getTopPadding();

    public final int getWidth() {
        return this.mWidth;
    }

    public final void increaseWidthTo(int n) {
        int n2 = this.mWidth;
        if (n < n2) {
            throw new RuntimeException("attempted to reduce Layout width");
        }
        this.mWidth = n;
    }

    protected final boolean isSpanned() {
        return this.mSpannedText;
    }

    void replaceWith(CharSequence charSequence, TextPaint textPaint, int n, Alignment alignment, float f, float f2) {
        boolean bl;
        if (n < 0) {
            String string2 = "Layout: " + n + " < 0";
            throw new IllegalArgumentException(string2);
        }
        this.mText = charSequence;
        this.mPaint = textPaint;
        this.mWidth = n;
        this.mAlignment = alignment;
        this.mSpacingMult = f;
        this.mSpacingAdd = f2;
        this.mSpannedText = bl = charSequence instanceof Spanned;
    }

    public static final class Alignment
    extends Enum<Alignment> {
        private static final /* synthetic */ Alignment[] $VALUES;
        public static final /* enum */ Alignment ALIGN_CENTER;
        public static final /* enum */ Alignment ALIGN_NORMAL;
        public static final /* enum */ Alignment ALIGN_OPPOSITE;

        static {
            ALIGN_NORMAL = new Alignment();
            ALIGN_OPPOSITE = new Alignment();
            ALIGN_CENTER = new Alignment();
            Alignment alignment = ALIGN_NORMAL;
            Alignment alignment2 = ALIGN_OPPOSITE;
            Alignment alignment3 = ALIGN_CENTER;
            Alignment[] alignmentArray = new Alignment[]{alignment, alignment2, alignment3};
            $VALUES = alignmentArray;
        }

        public static Alignment valueOf(String string2) {
            return Enum.valueOf(Alignment.class, string2);
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }
    }

    static class SpannedEllipsizer
    extends Ellipsizer
    implements Spanned {
        private Spanned mSpanned;

        public SpannedEllipsizer(CharSequence charSequence) {
            super(charSequence);
            Spanned spanned;
            this.mSpanned = spanned = (Spanned)charSequence;
        }

        @Override
        public int getSpanEnd(Object object) {
            return this.mSpanned.getSpanEnd(object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return this.mSpanned.getSpanFlags(object);
        }

        @Override
        public int getSpanStart(Object object) {
            return this.mSpanned.getSpanStart(object);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return this.mSpanned.getSpans(n, n2, clazz);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return this.mSpanned.nextSpanTransition(n, n2, clazz);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            String string2 = new String(cArray);
            SpannableString spannableString = new SpannableString(string2);
            Spanned spanned = this.mSpanned;
            int n3 = n;
            int n4 = n2;
            TextUtils.copySpansFrom(spanned, n3, n4, Object.class, spannableString, 0);
            return spannableString;
        }
    }

    static class Ellipsizer
    implements CharSequence,
    GetChars {
        Layout mLayout;
        TextUtils.TruncateAt mMethod;
        CharSequence mText;
        int mWidth;

        public Ellipsizer(CharSequence charSequence) {
            this.mText = charSequence;
        }

        @Override
        public char charAt(int n) {
            char[] cArray = TextUtils.obtain(1);
            int n2 = n + 1;
            this.getChars(n, n2, cArray, 0);
            char c = cArray[0];
            TextUtils.recycle(cArray);
            return c;
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            int n4 = this.mLayout.getLineForOffset(n);
            int n5 = this.mLayout.getLineForOffset(n2);
            TextUtils.getChars(this.mText, n, n2, cArray, n3);
            int n6 = n4;
            while (n6 <= n5) {
                Layout layout2 = this.mLayout;
                int n7 = n;
                int n8 = n2;
                char[] cArray2 = cArray;
                int n9 = n3;
                layout2.ellipsize(n7, n8, n6, cArray2, n9);
                ++n6;
            }
            return;
        }

        @Override
        public int length() {
            return this.mText.length();
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            char[] cArray = new char[this.length()];
            int n = this.length();
            this.getChars(0, n, cArray, 0);
            return new String(cArray);
        }
    }

    public static class Directions {
        private short[] mDirections;

        Directions(short[] sArray) {
            this.mDirections = sArray;
        }
    }
}

