/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Editable;
import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;

public abstract class LoginFilter
implements InputFilter {
    private boolean mAppendInvalid;

    LoginFilter() {
        this.mAppendInvalid = false;
    }

    LoginFilter(boolean bl) {
        this.mAppendInvalid = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        this.onStart();
        for (int i = 0; i < n3; ++i) {
            char c = spanned.charAt(i);
            if (this.isAllowed(c)) continue;
            this.onInvalidCharacter(c);
        }
        SpannableStringBuilder spannableStringBuilder = null;
        int n5 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (this.isAllowed(c)) {
                ++n5;
                continue;
            }
            if (this.mAppendInvalid) {
                ++n5;
            } else {
                if (spannableStringBuilder == null) {
                    spannableStringBuilder = new SpannableStringBuilder(charSequence, n, n2);
                    n5 = i - n;
                }
                int n6 = n5 + 1;
                Editable editable = spannableStringBuilder.delete(n5, n6);
            }
            this.onInvalidCharacter(c);
        }
        int n7 = n4;
        while (true) {
            int n8;
            if (n7 >= (n8 = spanned.length())) {
                this.onStop();
                return spannableStringBuilder;
            }
            char c = spanned.charAt(n7);
            if (!this.isAllowed(c)) {
                this.onInvalidCharacter(c);
            }
            ++n7;
        }
    }

    public abstract boolean isAllowed(char var1);

    public void onInvalidCharacter(char c) {
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public static class PasswordFilterGMail
    extends LoginFilter {
        public PasswordFilterGMail() {
            super(false);
        }

        public PasswordFilterGMail(boolean bl) {
            super(bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAllowed(char c) {
            if (' ' <= c && c <= '\u007f') {
                return true;
            }
            if ('\u00a0' > c) return false;
            if (c > '\u00ff') return false;
            return true;
        }
    }

    public static class UsernameFilterGeneric
    extends LoginFilter {
        private static final String mAllowed = "@_-+.";

        public UsernameFilterGeneric() {
            super(false);
        }

        public UsernameFilterGeneric(boolean bl) {
            super(bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAllowed(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('A' <= c && c <= 'Z') {
                return true;
            }
            if (mAllowed.indexOf(c) == -1) return false;
            return true;
        }
    }

    public static class UsernameFilterGMail
    extends LoginFilter {
        public UsernameFilterGMail() {
            super(false);
        }

        public UsernameFilterGMail(boolean bl) {
            super(bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAllowed(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('A' <= c && c <= 'Z') {
                return true;
            }
            if ('.' == c) return false;
            return true;
        }
    }
}

