/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.util.ArrayUtils;

class PackedIntVector {
    private final int mColumns;
    private int mRowGapLength;
    private int mRowGapStart;
    private int mRows;
    private int[] mValueGap;
    private int[] mValues;

    public PackedIntVector(int n) {
        int n2;
        this.mColumns = n;
        this.mRows = 0;
        this.mRowGapStart = 0;
        this.mRowGapLength = n2 = this.mRows;
        this.mValues = null;
        int[] nArray = new int[n * 2];
        this.mValueGap = nArray;
    }

    private final void growBuffer() {
        int n;
        int n2 = this.mColumns;
        int n3 = ArrayUtils.idealIntArraySize((this.size() + 1) * n2) / n2;
        int[] nArray = new int[n3 * n2];
        int[] nArray2 = this.mValueGap;
        int n4 = this.mRowGapStart;
        int n5 = this.mRows;
        int n6 = this.mRowGapLength + n4;
        int n7 = n5 - n6;
        if (this.mValues != null) {
            int[] nArray3 = this.mValues;
            int n8 = n2 * n4;
            System.arraycopy(nArray3, 0, nArray, 0, n8);
            int[] nArray4 = this.mValues;
            int n9 = (this.mRows - n7) * n2;
            int n10 = (n3 - n7) * n2;
            int n11 = n7 * n2;
            System.arraycopy(nArray4, n9, nArray, n10, n11);
        }
        for (int i = 0; i < n2; ++i) {
            int n12;
            if (nArray2[i] < n4) continue;
            int n13 = nArray2[i];
            int n14 = this.mRows;
            int n15 = n3 - n14;
            nArray2[i] = n12 = n13 + n15;
            if (nArray2[i] >= n4) continue;
            nArray2[i] = n4;
        }
        int n16 = this.mRowGapLength;
        int n17 = this.mRows;
        int n18 = n3 - n17;
        this.mRowGapLength = n = n16 + n18;
        this.mRows = n3;
        this.mValues = nArray;
    }

    private final void moveRowGapTo(int n) {
        int n2 = this.mRowGapStart;
        if (n != n2) {
            return;
        }
        int n3 = this.mRowGapStart;
        if (n > n3) {
            int n4;
            int n5;
            int n6 = this.mRowGapLength + n;
            int n7 = this.mRowGapStart;
            int n8 = this.mRowGapLength;
            int n9 = n7 + n8;
            int n10 = n6 - n9;
            int n11 = this.mColumns;
            int[] nArray = this.mValueGap;
            int[] nArray2 = this.mValues;
            int n12 = this.mRowGapStart;
            int n13 = this.mRowGapLength;
            for (int i = n4 = n12 + n13; i < (n5 = n4 + n10); ++i) {
                int n14 = i - n4;
                int n15 = this.mRowGapStart;
                int n16 = n14 + n15;
                for (int j = 0; j < n11; ++j) {
                    int n17;
                    int n18 = i * n11 + j;
                    int n19 = nArray2[n18];
                    int n20 = nArray[j];
                    if (i >= n20) {
                        int n21 = j + n11;
                        int n22 = nArray[n21];
                        n19 += n22;
                    }
                    if (n16 >= (n17 = nArray[j])) {
                        int n23 = j + n11;
                        int n24 = nArray[n23];
                        n19 -= n24;
                    }
                    int n25 = n16 * n11 + j;
                    nArray2[n25] = n19;
                }
            }
        } else {
            int n26 = this.mRowGapStart - n;
            int n27 = this.mColumns;
            int[] nArray = this.mValueGap;
            int[] nArray3 = this.mValues;
            int n28 = this.mRowGapStart;
            int n29 = this.mRowGapLength;
            int n30 = n28 + n29;
            for (int i = n + n26 - 1; i >= n; i += -1) {
                int n31 = i - n + n30 - n26;
                for (int j = 0; j < n27; ++j) {
                    int n32;
                    int n33 = i * n27 + j;
                    int n34 = nArray3[n33];
                    int n35 = nArray[j];
                    if (i >= n35) {
                        int n36 = j + n27;
                        int n37 = nArray[n36];
                        n34 += n37;
                    }
                    if (n31 >= (n32 = nArray[j])) {
                        int n38 = j + n27;
                        int n39 = nArray[n38];
                        n34 -= n39;
                    }
                    int n40 = n31 * n27 + j;
                    nArray3[n40] = n34;
                }
            }
        }
        this.mRowGapStart = n;
    }

    private final void moveValueGapTo(int n, int n2) {
        int[] nArray = this.mValueGap;
        int[] nArray2 = this.mValues;
        int n3 = this.mColumns;
        int n4 = nArray[n];
        if (n2 != n4) {
            return;
        }
        int n5 = nArray[n];
        if (n2 > n5) {
            for (int i = nArray[n]; i < n2; ++i) {
                int n6;
                int n7 = i * n3 + n;
                int n8 = nArray2[n7];
                int n9 = n + n3;
                int n10 = nArray[n9];
                nArray2[n7] = n6 = n8 + n10;
            }
        } else {
            int n11;
            for (int i = n2; i < (n11 = nArray[n]); ++i) {
                int n12;
                int n13 = i * n3 + n;
                int n14 = nArray2[n13];
                int n15 = n + n3;
                int n16 = nArray[n15];
                nArray2[n13] = n12 = n14 - n16;
            }
        }
        nArray[n] = n2;
    }

    private void setValueInternal(int n, int n2, int n3) {
        int[] nArray;
        int n4;
        int n5 = this.mRowGapStart;
        if (n >= n5) {
            int n6 = this.mRowGapLength;
            n += n6;
        }
        if (n >= (n4 = (nArray = this.mValueGap)[n2])) {
            int n7 = this.mColumns + n2;
            int n8 = nArray[n7];
            n3 -= n8;
        }
        int[] nArray2 = this.mValues;
        int n9 = this.mColumns * n + n2;
        nArray2[n9] = n3;
    }

    public void adjustValuesBelow(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if ((n | n2) < 0 || n > (n6 = this.size()) || n2 >= (n5 = this.width())) {
            String string2 = n + ", " + n2;
            throw new IndexOutOfBoundsException(string2);
        }
        int n7 = this.mRowGapStart;
        if (n >= n7) {
            int n8 = this.mRowGapLength;
            n += n8;
        }
        this.moveValueGapTo(n2, n);
        int[] nArray = this.mValueGap;
        int n9 = this.mColumns + n2;
        nArray[n9] = n4 = nArray[n9] + n3;
    }

    public void deleteAt(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if ((n | n2) < 0 || (n6 = n + n2) > (n5 = this.size())) {
            String string2 = n + ", " + n2;
            throw new IndexOutOfBoundsException(string2);
        }
        int n7 = n + n2;
        this.moveRowGapTo(n7);
        this.mRowGapStart = n4 = this.mRowGapStart - n2;
        this.mRowGapLength = n3 = this.mRowGapLength + n2;
    }

    public int getValue(int n, int n2) {
        int n3;
        int n4 = this.mColumns;
        if ((n | n2) < 0 || n >= (n3 = this.size()) || n2 >= n4) {
            String string2 = n + ", " + n2;
            throw new IndexOutOfBoundsException(string2);
        }
        int n5 = this.mRowGapStart;
        if (n >= n5) {
            int n6 = this.mRowGapLength;
            n += n6;
        }
        int[] nArray = this.mValues;
        int n7 = n * n4 + n2;
        int n8 = nArray[n7];
        int[] nArray2 = this.mValueGap;
        int n9 = nArray2[n2];
        if (n >= n9) {
            int n10 = n2 + n4;
            int n11 = nArray2[n10];
            n8 += n11;
        }
        return n8;
    }

    public void insertAt(int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (n < 0 || n > (n6 = this.size())) {
            String string2 = "row " + n;
            throw new IndexOutOfBoundsException(string2);
        }
        if (nArray != null && (n5 = nArray.length) < (n4 = this.width())) {
            StringBuilder stringBuilder = new StringBuilder().append("value count ");
            int n7 = nArray.length;
            String string3 = stringBuilder.append(n7).toString();
            throw new IndexOutOfBoundsException(string3);
        }
        this.moveRowGapTo(n);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        this.mRowGapStart = n3 = this.mRowGapStart + 1;
        this.mRowGapLength = n2 = this.mRowGapLength - 1;
        if (nArray == null) {
            int n8 = this.mColumns - 1;
            while (true) {
                if (n8 < 0) {
                    return;
                }
                this.setValueInternal(n, n8, 0);
                n8 += -1;
            }
        }
        int n9 = this.mColumns - 1;
        while (n9 >= 0) {
            int n10 = nArray[n9];
            this.setValueInternal(n, n9, n10);
            n9 += -1;
        }
        return;
    }

    public void setValue(int n, int n2, int n3) {
        int[] nArray;
        int n4;
        int n5;
        int n6;
        if ((n | n2) < 0 || n >= (n6 = this.size()) || n2 >= (n5 = this.mColumns)) {
            String string2 = n + ", " + n2;
            throw new IndexOutOfBoundsException(string2);
        }
        int n7 = this.mRowGapStart;
        if (n >= n7) {
            int n8 = this.mRowGapLength;
            n += n8;
        }
        if (n >= (n4 = (nArray = this.mValueGap)[n2])) {
            int n9 = this.mColumns + n2;
            int n10 = nArray[n9];
            n3 -= n10;
        }
        int[] nArray2 = this.mValues;
        int n11 = this.mColumns * n + n2;
        nArray2[n11] = n3;
    }

    public int size() {
        int n = this.mRows;
        int n2 = this.mRowGapLength;
        return n - n2;
    }

    public int width() {
        return this.mColumns;
    }
}

