/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.util.ArrayUtils;
import java.io.PrintStream;

class PackedObjectVector<E> {
    private int mColumns;
    private int mRowGapLength;
    private int mRowGapStart;
    private int mRows;
    private Object[] mValues;

    public PackedObjectVector(int n) {
        int n2;
        int n3;
        this.mColumns = n;
        int n4 = ArrayUtils.idealIntArraySize(0);
        int n5 = this.mColumns;
        this.mRows = n3 = n4 / n5;
        this.mRowGapStart = 0;
        this.mRowGapLength = n2 = this.mRows;
        int n6 = this.mRows;
        int n7 = this.mColumns;
        Object[] objectArray = new Object[n6 * n7];
        this.mValues = objectArray;
    }

    private void growBuffer() {
        int n;
        int n2 = this.size() + 1;
        int n3 = ArrayUtils.idealIntArraySize(this.mColumns * n2);
        int n4 = this.mColumns;
        int n5 = n3 / n4;
        Object[] objectArray = new Object[this.mColumns * n5];
        int n6 = this.mRows;
        int n7 = this.mRowGapStart;
        int n8 = this.mRowGapLength;
        int n9 = n7 + n8;
        int n10 = n6 - n9;
        Object[] objectArray2 = this.mValues;
        int n11 = this.mColumns;
        int n12 = this.mRowGapStart;
        int n13 = n11 * n12;
        System.arraycopy(objectArray2, 0, objectArray, 0, n13);
        Object[] objectArray3 = this.mValues;
        int n14 = this.mRows - n10;
        int n15 = this.mColumns;
        int n16 = n14 * n15;
        int n17 = n5 - n10;
        int n18 = this.mColumns;
        int n19 = n17 * n18;
        int n20 = this.mColumns * n10;
        System.arraycopy(objectArray3, n16, objectArray, n19, n20);
        int n21 = this.mRowGapLength;
        int n22 = this.mRows;
        int n23 = n5 - n22;
        this.mRowGapLength = n = n21 + n23;
        this.mRows = n5;
        this.mValues = objectArray;
    }

    private void moveRowGapTo(int n) {
        int n2 = this.mRowGapStart;
        if (n != n2) {
            return;
        }
        int n3 = this.mRowGapStart;
        if (n > n3) {
            int n4;
            int n5;
            int n6;
            int n7 = this.mRowGapLength + n;
            int n8 = this.mRowGapStart;
            int n9 = this.mRowGapLength;
            int n10 = n8 + n9;
            int n11 = n7 - n10;
            int n12 = this.mRowGapStart;
            int n13 = this.mRowGapLength;
            for (int i = n12 + n13; i < (n6 = (n5 = this.mRowGapStart) + (n4 = this.mRowGapLength) + n11); ++i) {
                int n14;
                int n15 = this.mRowGapStart;
                int n16 = this.mRowGapLength;
                int n17 = n15 + n16;
                int n18 = i - n17;
                int n19 = this.mRowGapStart;
                int n20 = n18 + n19;
                for (int j = 0; j < (n14 = this.mColumns); ++j) {
                    Object[] objectArray = this.mValues;
                    int n21 = this.mColumns * i + j;
                    Object object = objectArray[n21];
                    Object[] objectArray2 = this.mValues;
                    int n22 = this.mColumns * n20 + j;
                    objectArray2[n22] = object;
                }
            }
        } else {
            int n23 = this.mRowGapStart - n;
            for (int i = n + n23 - 1; i >= n; i += -1) {
                int n24;
                int n25 = i - n;
                int n26 = this.mRowGapStart;
                int n27 = n25 + n26;
                int n28 = this.mRowGapLength;
                int n29 = n27 + n28 - n23;
                for (int j = 0; j < (n24 = this.mColumns); ++j) {
                    Object[] objectArray = this.mValues;
                    int n30 = this.mColumns * i + j;
                    Object object = objectArray[n30];
                    Object[] objectArray3 = this.mValues;
                    int n31 = this.mColumns * n29 + j;
                    objectArray3[n31] = object;
                }
            }
        }
        this.mRowGapStart = n;
    }

    public void deleteAt(int n, int n2) {
        int n3;
        int n4;
        int n5 = n + n2;
        this.moveRowGapTo(n5);
        this.mRowGapStart = n4 = this.mRowGapStart - n2;
        int n6 = this.mRowGapLength = (n3 = this.mRowGapLength + n2);
        int n7 = this.size() * 2;
        if (n6 <= n7) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump() {
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if (n >= (n3 = this.mRows)) {
                System.out.print("-----\n\n");
                return;
            }
            for (int i = 0; i < (n2 = this.mColumns); ++i) {
                int n4;
                int n5;
                int n6;
                Object[] objectArray = this.mValues;
                int n7 = this.mColumns * n + i;
                Object object = objectArray[n7];
                int n8 = this.mRowGapStart;
                if (n < n8 || n >= (n6 = (n5 = this.mRowGapStart) + (n4 = this.mRowGapLength))) {
                    PrintStream printStream = System.out;
                    String string2 = object + " ";
                    printStream.print(string2);
                    continue;
                }
                PrintStream printStream = System.out;
                String string3 = "(" + object + ") ";
                printStream.print(string3);
            }
            System.out.print(" << \n");
            ++n;
        }
    }

    public E getValue(int n, int n2) {
        int n3 = this.mRowGapStart;
        if (n >= n3) {
            int n4 = this.mRowGapLength;
            n += n4;
        }
        Object[] objectArray = this.mValues;
        int n5 = this.mColumns * n + n2;
        return (E)objectArray[n5];
    }

    public void insertAt(int n, E[] EArray) {
        int n2;
        int n3;
        this.moveRowGapTo(n);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        this.mRowGapStart = n3 = this.mRowGapStart + 1;
        this.mRowGapLength = n2 = this.mRowGapLength - 1;
        if (EArray == null) {
            int n4 = 0;
            while (true) {
                int n5;
                if (n4 >= (n5 = this.mColumns)) {
                    return;
                }
                this.setValue(n, n4, null);
                ++n4;
            }
        }
        int n6 = 0;
        int n7;
        while (n6 < (n7 = this.mColumns)) {
            E e = EArray[n6];
            this.setValue(n, n6, e);
            ++n6;
        }
        return;
    }

    public void setValue(int n, int n2, E e) {
        int n3 = this.mRowGapStart;
        if (n >= n3) {
            int n4 = this.mRowGapLength;
            n += n4;
        }
        Object[] objectArray = this.mValues;
        int n5 = this.mColumns * n + n2;
        objectArray[n5] = e;
    }

    public int size() {
        int n = this.mRows;
        int n2 = this.mRowGapLength;
        return n - n2;
    }

    public int width() {
        return this.mColumns;
    }
}

