/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;

public class Selection {
    public static final Object SELECTION_END;
    public static final Object SELECTION_START;

    static {
        SELECTION_START = new START();
        SELECTION_END = new END();
    }

    private Selection() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int chooseHorizontal(Layout layout2, int n, int n2, int n3) {
        int n4;
        int n5 = layout2.getLineForOffset(n2);
        if (n5 != (n4 = layout2.getLineForOffset(n3))) {
            float f = layout2.getPrimaryHorizontal(n2);
            float f2 = layout2.getPrimaryHorizontal(n3);
            if (n < 0) {
                if (!(f < f2)) return n3;
                return n2;
            }
            if (!(f > f2)) return n3;
            return n2;
        }
        int n6 = layout2.getLineForOffset(n2);
        if (layout2.getParagraphDirection(n6) == n) return Math.min(n2, n3);
        return Math.max(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean extendDown(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionEnd(spannable);
        int n3 = layout2.getLineForOffset(n2);
        if (n3 < (n = layout2.getLineCount() - 1)) {
            int n4;
            int n5;
            int n6;
            int n7 = layout2.getParagraphDirection(n3);
            if (n7 != (n6 = layout2.getParagraphDirection(n5 = n3 + 1))) {
                float f = layout2.getPrimaryHorizontal(n2);
                int n8 = n3 + 1;
                n4 = layout2.getOffsetForHorizontal(n8, f);
            } else {
                int n9 = n3 + 1;
                n4 = layout2.getLineStart(n9);
            }
            Selection.extendSelection(spannable, n4);
            return true;
        }
        int n10 = spannable.length();
        if (n2 == n10) return true;
        int n11 = spannable.length();
        Selection.extendSelection(spannable, n11);
        return true;
    }

    public static boolean extendLeft(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getOffsetToLeftOf(n);
        if (n2 != n) {
            Selection.extendSelection(spannable, n2);
        }
        return true;
    }

    public static boolean extendRight(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getOffsetToRightOf(n);
        if (n2 != n) {
            Selection.extendSelection(spannable, n2);
        }
        return true;
    }

    public static final void extendSelection(Spannable spannable, int n) {
        Object object = SELECTION_END;
        if (spannable.getSpanStart(object) != n) {
            return;
        }
        Object object2 = SELECTION_END;
        spannable.setSpan(object2, n, n, 34);
    }

    public static boolean extendToLeftEdge(Spannable spannable, Layout layout2) {
        int n = Selection.findEdge(spannable, layout2, -1);
        Selection.extendSelection(spannable, n);
        return true;
    }

    public static boolean extendToRightEdge(Spannable spannable, Layout layout2) {
        int n = Selection.findEdge(spannable, layout2, 1);
        Selection.extendSelection(spannable, n);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean extendUp(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getLineForOffset(n);
        if (n2 > 0) {
            int n3;
            int n4;
            int n5;
            int n6 = layout2.getParagraphDirection(n2);
            if (n6 != (n5 = layout2.getParagraphDirection(n4 = n2 - 1))) {
                float f = layout2.getPrimaryHorizontal(n);
                int n7 = n2 - 1;
                n3 = layout2.getOffsetForHorizontal(n7, f);
            } else {
                int n8 = n2 - 1;
                n3 = layout2.getLineStart(n8);
            }
            Selection.extendSelection(spannable, n3);
            return true;
        }
        if (n == 0) return true;
        Selection.extendSelection(spannable, 0);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findEdge(Spannable spannable, Layout layout2, int n) {
        int n2 = Selection.getSelectionEnd(spannable);
        int n3 = layout2.getLineForOffset(n2);
        int n4 = layout2.getParagraphDirection(n3);
        if (n * n4 < 0) {
            return layout2.getLineStart(n3);
        }
        int n5 = layout2.getLineEnd(n3);
        int n6 = layout2.getLineCount() - 1;
        if (n3 == n6) return n5 - 1;
        return n5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getSelectionEnd(CharSequence charSequence) {
        if (!(charSequence instanceof Spanned)) return -1;
        Spanned spanned = (Spanned)charSequence;
        Object object = SELECTION_END;
        return spanned.getSpanStart(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getSelectionStart(CharSequence charSequence) {
        if (!(charSequence instanceof Spanned)) return -1;
        Spanned spanned = (Spanned)charSequence;
        Object object = SELECTION_START;
        return spanned.getSpanStart(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean moveDown(Spannable spannable, Layout layout2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = Selection.getSelectionStart(spannable);
        if (n6 != (n5 = Selection.getSelectionEnd(spannable))) {
            int n7 = Math.min(n6, n5);
            int n8 = Math.max(n6, n5);
            Selection.setSelection(spannable, n8);
            if (n7 != 0) return true;
            int n9 = spannable.length();
            if (n8 == n9) return true;
            return false;
        }
        int n10 = layout2.getLineForOffset(n5);
        if (n10 >= (n4 = layout2.getLineCount() - 1)) {
            return false;
        }
        int n11 = layout2.getParagraphDirection(n10);
        if (n11 != (n3 = layout2.getParagraphDirection(n2 = n10 + 1))) {
            float f = layout2.getPrimaryHorizontal(n5);
            int n12 = n10 + 1;
            n = layout2.getOffsetForHorizontal(n12, f);
        } else {
            int n13 = n10 + 1;
            n = layout2.getLineStart(n13);
        }
        Selection.setSelection(spannable, n);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean moveLeft(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionStart(spannable);
        if (n2 != (n = Selection.getSelectionEnd(spannable))) {
            int n3 = Selection.chooseHorizontal(layout2, -1, n2, n);
            Selection.setSelection(spannable, n3);
            return true;
        }
        int n4 = layout2.getOffsetToLeftOf(n);
        if (n4 == n) return false;
        Selection.setSelection(spannable, n4);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean moveRight(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionStart(spannable);
        if (n2 != (n = Selection.getSelectionEnd(spannable))) {
            int n3 = Selection.chooseHorizontal(layout2, 1, n2, n);
            Selection.setSelection(spannable, n3);
            return true;
        }
        int n4 = layout2.getOffsetToRightOf(n);
        if (n4 == n) return false;
        Selection.setSelection(spannable, n4);
        return true;
    }

    public static boolean moveToLeftEdge(Spannable spannable, Layout layout2) {
        int n = Selection.findEdge(spannable, layout2, -1);
        Selection.setSelection(spannable, n);
        return true;
    }

    public static boolean moveToRightEdge(Spannable spannable, Layout layout2) {
        int n = Selection.findEdge(spannable, layout2, 1);
        Selection.setSelection(spannable, n);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean moveUp(Spannable spannable, Layout layout2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = Selection.getSelectionStart(spannable);
        if (n5 != (n4 = Selection.getSelectionEnd(spannable))) {
            int n6 = Math.min(n5, n4);
            int n7 = Math.max(n5, n4);
            Selection.setSelection(spannable, n6);
            if (n6 != 0) return true;
            int n8 = spannable.length();
            if (n7 == n8) return true;
            return false;
        }
        int n9 = layout2.getLineForOffset(n4);
        if (n9 <= 0) {
            return false;
        }
        int n10 = layout2.getParagraphDirection(n9);
        if (n10 != (n3 = layout2.getParagraphDirection(n2 = n9 - 1))) {
            float f = layout2.getPrimaryHorizontal(n4);
            int n11 = n9 - 1;
            n = layout2.getOffsetForHorizontal(n11, f);
        } else {
            int n12 = n9 - 1;
            n = layout2.getLineStart(n12);
        }
        Selection.setSelection(spannable, n);
        return true;
    }

    public static final void removeSelection(Spannable spannable) {
        Object object = SELECTION_START;
        spannable.removeSpan(object);
        Object object2 = SELECTION_END;
        spannable.removeSpan(object2);
    }

    public static final void selectAll(Spannable spannable) {
        int n = spannable.length();
        Selection.setSelection(spannable, 0, n);
    }

    public static final void setSelection(Spannable spannable, int n) {
        Selection.setSelection(spannable, n, n);
    }

    public static void setSelection(Spannable spannable, int n, int n2) {
        int n3 = Selection.getSelectionStart(spannable);
        int n4 = Selection.getSelectionEnd(spannable);
        if (n3 != n && n4 != n2) {
            return;
        }
        Object object = SELECTION_START;
        spannable.setSpan(object, n, n, 546);
        Object object2 = SELECTION_END;
        spannable.setSpan(object2, n2, n2, 34);
    }

    private static final class END
    implements NoCopySpan {
        private END() {
        }
    }

    private static final class START
    implements NoCopySpan {
        private START() {
        }
    }
}

