/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import com.android.internal.util.ArrayUtils;
import java.lang.reflect.Array;

public class SpannableStringBuilder
implements CharSequence,
GetChars,
Spannable,
Editable,
Appendable,
GraphicsOperations {
    private static final int END_MASK = 15;
    private static final int MARK = 1;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final int PARAGRAPH = 3;
    private static final int POINT = 2;
    private static final int START_MASK = 240;
    private static final int START_SHIFT = 4;
    private InputFilter[] mFilters;
    private int mGapLength;
    private int mGapStart;
    private int mSpanCount;
    private int[] mSpanEnds;
    private int[] mSpanFlags;
    private int[] mSpanStarts;
    private Object[] mSpans;
    private char[] mText;

    public SpannableStringBuilder() {
        this("");
    }

    public SpannableStringBuilder(CharSequence charSequence) {
        int n = charSequence.length();
        this(charSequence, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SpannableStringBuilder(CharSequence charSequence, int n, int n2) {
        int n3;
        InputFilter[] inputFilterArray = NO_FILTERS;
        this.mFilters = inputFilterArray;
        int n4 = n2 - n;
        int n5 = ArrayUtils.idealCharArraySize(n4 + 1);
        char[] cArray = new char[n5];
        this.mText = cArray;
        this.mGapStart = n4;
        this.mGapLength = n3 = n5 - n4;
        char[] cArray2 = this.mText;
        TextUtils.getChars(charSequence, n, n2, cArray2, 0);
        this.mSpanCount = 0;
        int n6 = ArrayUtils.idealIntArraySize(0);
        Object[] objectArray = new Object[n6];
        this.mSpans = objectArray;
        int[] nArray = new int[n6];
        this.mSpanStarts = nArray;
        int[] nArray2 = new int[n6];
        this.mSpanEnds = nArray2;
        int[] nArray3 = new int[n6];
        this.mSpanFlags = nArray3;
        if (!(charSequence instanceof Spanned)) {
            return;
        }
        Spanned spanned = (Spanned)charSequence;
        Object[] objectArray2 = spanned.getSpans(n, n2, Object.class);
        int n7 = 0;
        int n8;
        while (n7 < (n8 = objectArray2.length)) {
            if (!(objectArray2[n7] instanceof NoCopySpan)) {
                int n9;
                int n10;
                Object object = objectArray2[n7];
                int n11 = spanned.getSpanStart(object) - n;
                Object object2 = objectArray2[n7];
                int n12 = spanned.getSpanEnd(object2) - n;
                Object object3 = objectArray2[n7];
                int n13 = spanned.getSpanFlags(object3);
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n11 > (n10 = n2 - n)) {
                    n11 = n2 - n;
                }
                if (n12 < 0) {
                    n12 = 0;
                }
                if (n12 > (n9 = n2 - n)) {
                    n12 = n2 - n;
                }
                Object object4 = objectArray2[n7];
                this.setSpan(object4, n11, n12, n13);
            }
            ++n7;
        }
        return;
    }

    private int change(int n, int n2, CharSequence charSequence, int n3, int n4) {
        SpannableStringBuilder spannableStringBuilder = this;
        int n5 = n;
        int n6 = n2;
        CharSequence charSequence2 = charSequence;
        int n7 = n3;
        int n8 = n4;
        return spannableStringBuilder.change(true, n5, n6, charSequence2, n7, n8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int change(boolean bl, int n, int n2, CharSequence charSequence, int n3, int n4) {
        SpannableStringBuilder spannableStringBuilder = this;
        String string2 = "replace";
        int n5 = n;
        int n6 = n2;
        spannableStringBuilder.checkRange(string2, n5, n6);
        int n7 = n4 - n3;
        TextWatcher[] textWatcherArray = null;
        if (bl) {
            int n8 = n2 - n;
            int n9 = n4 - n3;
            SpannableStringBuilder spannableStringBuilder2 = this;
            int n10 = n;
            int n11 = n8;
            int n12 = n9;
            textWatcherArray = spannableStringBuilder2.sendTextWillChange(n10, n11, n12);
        }
        int n13 = this.mSpanCount - 1;
        while (true) {
            block25: {
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                int n26;
                block26: {
                    int n27;
                    int n28;
                    SpannableStringBuilder spannableStringBuilder3;
                    int n29;
                    int n30;
                    int n31;
                    int n32;
                    block27: {
                        int n33;
                        int n34;
                        int n35;
                        int n36;
                        block24: {
                            int n37;
                            int n38;
                            int n39;
                            if (n13 < 0) break block24;
                            if ((this.mSpanFlags[n13] & 0x33) != 51) break block25;
                            n26 = this.mSpanStarts[n13];
                            int n40 = n26;
                            int n41 = this.mGapStart;
                            int n42 = n41;
                            if (n40 > n42) {
                                int n43 = this.mGapLength;
                                n26 -= n43;
                            }
                            if ((n25 = this.mSpanEnds[n13]) > (n39 = this.mGapStart)) {
                                int n44 = this.mGapLength;
                                n25 -= n44;
                            }
                            n24 = n26;
                            n23 = n25;
                            n22 = this.length();
                            int n45 = n26;
                            int n46 = n;
                            if (n45 <= n46 || (n38 = n26) > (n37 = n2)) break block26;
                            n26 = n2;
                            break block27;
                        }
                        SpannableStringBuilder spannableStringBuilder4 = this;
                        int n47 = n2;
                        spannableStringBuilder4.moveGapTo(n47);
                        int n48 = n4 - n3;
                        int n49 = this.mGapLength;
                        int n50 = n2 - n;
                        int n51 = n49 + n50;
                        if (n48 >= n51) {
                            int n52 = this.mText.length;
                            int n53 = this.mGapLength;
                            int n54 = n52 - n53 + n4 - n3;
                            int n55 = n2 - n;
                            int n56 = n54 - n55;
                            SpannableStringBuilder spannableStringBuilder5 = this;
                            int n57 = n56;
                            spannableStringBuilder5.resizeFor(n57);
                        }
                        int n58 = this.mGapStart;
                        int n59 = n4 - n3;
                        int n60 = n2 - n;
                        int n61 = n59 - n60;
                        this.mGapStart = n36 = n58 + n61;
                        int n62 = this.mGapLength;
                        int n63 = n4 - n3;
                        int n64 = n2 - n;
                        int n65 = n63 - n64;
                        this.mGapLength = n35 = n62 - n65;
                        if (this.mGapLength < 1) {
                            new Exception("mGapLength < 1").printStackTrace();
                        }
                        char[] cArray = this.mText;
                        CharSequence charSequence2 = charSequence;
                        int n66 = n3;
                        int n67 = n4;
                        char[] cArray2 = cArray;
                        int n68 = n;
                        TextUtils.getChars(charSequence2, n66, n67, cArray2, n68);
                        if (charSequence instanceof Spanned) {
                            int n69;
                            Spanned spanned;
                            Spanned spanned2 = spanned = (Spanned)charSequence;
                            int n70 = n3;
                            int n71 = n4;
                            Class<Object> clazz = Object.class;
                            Object[] objectArray = spanned2.getSpans(n70, n71, clazz);
                            for (n13 = 0; n13 < (n69 = objectArray.length); ++n13) {
                                Object object;
                                Object object2;
                                SpannableStringBuilder spannableStringBuilder6;
                                int n72;
                                int n73;
                                Object object3 = objectArray[n13];
                                Spanned spanned3 = spanned;
                                Object object4 = object3;
                                int n74 = spanned3.getSpanStart(object4);
                                Object object5 = objectArray[n13];
                                Spanned spanned4 = spanned;
                                Object object6 = object5;
                                int n75 = spanned4.getSpanEnd(object6);
                                int n76 = n74;
                                int n77 = n3;
                                if (n76 < n77) {
                                    n74 = n3;
                                }
                                if ((n73 = n75) > (n72 = n4)) {
                                    n75 = n4;
                                }
                                if ((spannableStringBuilder6 = this).getSpanStart(object2 = (object = objectArray[n13])) >= 0) continue;
                                Object object7 = objectArray[n13];
                                int n78 = n74 - n3 + n;
                                int n79 = n75 - n3 + n;
                                Object object8 = objectArray[n13];
                                Spanned spanned5 = spanned;
                                Object object9 = object8;
                                int n80 = spanned5.getSpanFlags(object9);
                                this.setSpan(false, object7, n78, n79, n80);
                            }
                        }
                        if ((n34 = n4) > (n33 = n3) && n2 - n == 0) {
                            if (!bl) return n7;
                            int n81 = n2 - n;
                            int n82 = n4 - n3;
                            SpannableStringBuilder spannableStringBuilder7 = this;
                            TextWatcher[] textWatcherArray2 = textWatcherArray;
                            int n83 = n;
                            int n84 = n81;
                            int n85 = n82;
                            spannableStringBuilder7.sendTextChange(textWatcherArray2, n83, n84, n85);
                            SpannableStringBuilder spannableStringBuilder8 = this;
                            TextWatcher[] textWatcherArray3 = textWatcherArray;
                            spannableStringBuilder8.sendTextHasChanged(textWatcherArray3);
                            return n7;
                        }
                        break;
                    }
                    while ((n32 = ++n26) < (n31 = n22) && ((n30 = n26) <= (n29 = n2) || (spannableStringBuilder3 = this).charAt(n28 = (n27 = n26 - 1)) != '\n')) {
                    }
                }
                if ((n21 = n25) > (n20 = n) && (n19 = n25) <= (n18 = n2)) {
                    int n86;
                    int n87;
                    SpannableStringBuilder spannableStringBuilder9;
                    int n88;
                    int n89;
                    for (n25 = n2; n25 < n22 && ((n89 = n25) <= (n88 = n2) || (spannableStringBuilder9 = this).charAt(n87 = (n86 = n25 - 1)) != '\n'); ++n25) {
                    }
                }
                if ((n17 = n26) == (n16 = n24) || (n15 = n25) != (n14 = n23)) {
                    Object object = this.mSpans[n13];
                    int n90 = this.mSpanFlags[n13];
                    SpannableStringBuilder spannableStringBuilder10 = this;
                    Object object10 = object;
                    int n91 = n26;
                    int n92 = n25;
                    int n93 = n90;
                    spannableStringBuilder10.setSpan(object10, n91, n92, n93);
                }
            }
            n13 += -1;
        }
        int n94 = this.mGapStart;
        int n95 = this.mGapLength;
        int n96 = n94 + n95;
        int n97 = this.mText.length;
        boolean bl2 = n96 != n97;
        n13 = this.mSpanCount - 1;
        while (true) {
            int n98;
            int n99;
            int n100;
            int n101;
            int n102;
            int n103;
            int n104;
            int n105;
            int n106;
            int n107;
            int n108;
            int n109;
            int n110;
            if (n13 < 0) {
                if (!bl) return n7;
                int n111 = n2 - n;
                int n112 = n4 - n3;
                SpannableStringBuilder spannableStringBuilder11 = this;
                TextWatcher[] textWatcherArray4 = textWatcherArray;
                int n113 = n;
                int n114 = n111;
                int n115 = n112;
                spannableStringBuilder11.sendTextChange(textWatcherArray4, n113, n114, n115);
                SpannableStringBuilder spannableStringBuilder12 = this;
                TextWatcher[] textWatcherArray5 = textWatcherArray;
                spannableStringBuilder12.sendTextHasChanged(textWatcherArray5);
                return n7;
            }
            int n116 = this.mSpanStarts[n13];
            int n117 = n;
            if (n116 >= n117 && (n110 = this.mSpanStarts[n13]) < (n109 = (n108 = this.mGapStart) + (n107 = this.mGapLength))) {
                n106 = (this.mSpanFlags[n13] & 0xF0) >> 4;
                if (n106 == 2 || n106 == 3 && bl2) {
                    int n118;
                    int[] nArray = this.mSpanStarts;
                    int n119 = this.mGapStart;
                    int n120 = this.mGapLength;
                    nArray[n13] = n118 = n119 + n120;
                } else {
                    this.mSpanStarts[n13] = n;
                }
            }
            if ((n105 = this.mSpanEnds[n13]) >= (n104 = n) && (n103 = this.mSpanEnds[n13]) < (n102 = (n101 = this.mGapStart) + (n100 = this.mGapLength))) {
                n106 = this.mSpanFlags[n13] & 0xF;
                if (n106 == 2 || n106 == 3 && bl2) {
                    int n121;
                    int[] nArray = this.mSpanEnds;
                    int n122 = this.mGapStart;
                    int n123 = this.mGapLength;
                    nArray[n13] = n121 = n122 + n123;
                } else {
                    this.mSpanEnds[n13] = n;
                }
            }
            if ((n99 = this.mSpanEnds[n13]) < (n98 = this.mSpanStarts[n13])) {
                int n124;
                Object[] objectArray = this.mSpans;
                int n125 = n13 + 1;
                Object[] objectArray2 = this.mSpans;
                int n126 = this.mSpanCount;
                int n127 = n13 + 1;
                int n128 = n126 - n127;
                System.arraycopy(objectArray, n125, objectArray2, n13, n128);
                int[] nArray = this.mSpanStarts;
                int n129 = n13 + 1;
                int[] nArray2 = this.mSpanStarts;
                int n130 = this.mSpanCount;
                int n131 = n13 + 1;
                int n132 = n130 - n131;
                System.arraycopy(nArray, n129, nArray2, n13, n132);
                int[] nArray3 = this.mSpanEnds;
                int n133 = n13 + 1;
                int[] nArray4 = this.mSpanEnds;
                int n134 = this.mSpanCount;
                int n135 = n13 + 1;
                int n136 = n134 - n135;
                System.arraycopy(nArray3, n133, nArray4, n13, n136);
                int[] nArray5 = this.mSpanFlags;
                int n137 = n13 + 1;
                int[] nArray6 = this.mSpanFlags;
                int n138 = this.mSpanCount;
                int n139 = n13 + 1;
                int n140 = n138 - n139;
                System.arraycopy(nArray5, n137, nArray6, n13, n140);
                this.mSpanCount = n124 = this.mSpanCount - 1;
            }
            int n141 = n13 + -1;
        }
    }

    private void checkRange(String string2, int n, int n2) {
        if (n2 < n) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append(" ");
            String string3 = SpannableStringBuilder.region(n, n2);
            String string4 = stringBuilder.append(string3).append(" has end before start").toString();
            throw new IndexOutOfBoundsException(string4);
        }
        int n3 = this.length();
        if (n > n3 || n2 > n3) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append(" ");
            String string5 = SpannableStringBuilder.region(n, n2);
            String string6 = stringBuilder.append(string5).append(" ends beyond length ").append(n3).toString();
            throw new IndexOutOfBoundsException(string6);
        }
        if (n >= 0 && n2 >= 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(string2).append(" ");
        String string7 = SpannableStringBuilder.region(n, n2);
        String string8 = stringBuilder.append(string7).append(" starts before 0").toString();
        throw new IndexOutOfBoundsException(string8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isprint(char c) {
        if (c < ' ') return false;
        if (c > '~') return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveGapTo(int n) {
        int n2 = this.mGapStart;
        if (n != n2) {
            return;
        }
        int n3 = this.length();
        boolean bl = n != n3;
        int n4 = this.mGapStart;
        if (n < n4) {
            int n5 = this.mGapStart - n;
            char[] cArray = this.mText;
            char[] cArray2 = this.mText;
            int n6 = this.mGapStart;
            int n7 = this.mGapLength;
            int n8 = n6 + n7 - n5;
            System.arraycopy(cArray, n, cArray2, n8, n5);
        } else {
            int n9 = this.mGapStart;
            int n10 = n - n9;
            char[] cArray = this.mText;
            int n11 = this.mGapLength + n - n10;
            char[] cArray3 = this.mText;
            int n12 = this.mGapStart;
            System.arraycopy(cArray, n11, cArray3, n12, n10);
        }
        int n13 = 0;
        while (true) {
            int n14;
            int n15;
            int n16;
            int n17;
            if (n13 >= (n17 = this.mSpanCount)) {
                this.mGapStart = n;
                return;
            }
            int n18 = this.mSpanStarts[n13];
            int n19 = this.mSpanEnds[n13];
            int n20 = this.mGapStart;
            if (n18 > n20) {
                int n21 = this.mGapLength;
                int n22 = n18 - n21;
            }
            if (n18 > n) {
                int n23 = this.mGapLength;
                n18 += n23;
            } else if (n18 != n && ((n16 = (this.mSpanFlags[n13] & 0xF0) >> 4) == 2 || bl && n16 == 3)) {
                int n24 = this.mGapLength;
                n18 += n24;
            }
            if (n19 > (n15 = this.mGapStart)) {
                int n25 = this.mGapLength;
                int n26 = n19 - n25;
            }
            if (n19 > n) {
                int n27 = this.mGapLength;
                n19 += n27;
            } else if (n19 != n && ((n14 = this.mSpanFlags[n13] & 0xF) == 2 || bl && n14 == 3)) {
                int n28 = this.mGapLength;
                n19 += n28;
            }
            this.mSpanStarts[n13] = n18;
            this.mSpanEnds[n13] = n19;
            ++n13;
        }
    }

    private static String region(int n, int n2) {
        return "(" + n + " ... " + n2 + ")";
    }

    private void resizeFor(int n) {
        int n2;
        int n3;
        int n4 = ArrayUtils.idealCharArraySize(n + 1);
        char[] cArray = new char[n4];
        int n5 = this.mText.length;
        int n6 = this.mGapStart;
        int n7 = this.mGapLength;
        int n8 = n6 + n7;
        int n9 = n5 - n8;
        char[] cArray2 = this.mText;
        int n10 = this.mGapStart;
        System.arraycopy(cArray2, 0, cArray, 0, n10);
        char[] cArray3 = this.mText;
        int n11 = this.mText.length - n9;
        int n12 = n4 - n9;
        System.arraycopy(cArray3, n11, cArray, n12, n9);
        for (int i = 0; i < (n3 = this.mSpanCount); ++i) {
            int n13;
            int n14;
            int n15;
            int n16 = this.mSpanStarts[i];
            int n17 = this.mGapStart;
            if (n16 > n17) {
                int n18;
                int[] nArray = this.mSpanStarts;
                int n19 = nArray[i];
                int n20 = this.mText.length;
                int n21 = n4 - n20;
                nArray[i] = n18 = n19 + n21;
            }
            if ((n15 = this.mSpanEnds[i]) <= (n14 = this.mGapStart)) continue;
            int[] nArray = this.mSpanEnds;
            int n22 = nArray[i];
            int n23 = this.mText.length;
            int n24 = n4 - n23;
            nArray[i] = n13 = n22 + n24;
        }
        int n25 = this.mText.length;
        this.mText = cArray;
        int n26 = this.mGapLength;
        int n27 = this.mText.length - n25;
        this.mGapLength = n2 = n26 + n27;
        if (this.mGapLength >= 1) {
            return;
        }
        new Exception("mGapLength < 1").printStackTrace();
    }

    private void sendSpanAdded(Object object, int n, int n2) {
        SpanWatcher[] spanWatcherArray = this.getSpans(n, n2, SpanWatcher.class);
        int n3 = spanWatcherArray.length;
        int n4 = 0;
        while (n4 < n3) {
            spanWatcherArray[n4].onSpanAdded(this, object, n, n2);
            ++n4;
        }
        return;
    }

    private void sendSpanChanged(Object object, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n2, n4);
        SpanWatcher[] spanWatcherArray = this.getSpans(n5, n6, SpanWatcher.class);
        int n7 = spanWatcherArray.length;
        int n8 = 0;
        while (n8 < n7) {
            SpanWatcher spanWatcher = spanWatcherArray[n8];
            SpannableStringBuilder spannableStringBuilder = this;
            Object object2 = object;
            int n9 = n;
            int n10 = n2;
            int n11 = n3;
            int n12 = n4;
            spanWatcher.onSpanChanged(spannableStringBuilder, object2, n9, n10, n11, n12);
            ++n8;
        }
        return;
    }

    private void sendSpanRemoved(Object object, int n, int n2) {
        SpanWatcher[] spanWatcherArray = this.getSpans(n, n2, SpanWatcher.class);
        int n3 = spanWatcherArray.length;
        int n4 = 0;
        while (n4 < n3) {
            spanWatcherArray[n4].onSpanRemoved(this, object, n, n2);
            ++n4;
        }
        return;
    }

    private void sendTextChange(TextWatcher[] textWatcherArray, int n, int n2, int n3) {
        int n4 = textWatcherArray.length;
        int n5 = 0;
        while (n5 < n4) {
            textWatcherArray[n5].onTextChanged(this, n, n2, n3);
            ++n5;
        }
        return;
    }

    private void sendTextHasChanged(TextWatcher[] textWatcherArray) {
        int n = textWatcherArray.length;
        int n2 = 0;
        while (n2 < n) {
            textWatcherArray[n2].afterTextChanged(this);
            ++n2;
        }
        return;
    }

    private TextWatcher[] sendTextWillChange(int n, int n2, int n3) {
        int n4 = n + n2;
        TextWatcher[] textWatcherArray = this.getSpans(n, n4, TextWatcher.class);
        int n5 = textWatcherArray.length;
        for (int i = 0; i < n5; ++i) {
            textWatcherArray[i].beforeTextChanged(this, n, n2, n3);
        }
        return textWatcherArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSpan(boolean bl, Object object, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        SpannableStringBuilder spannableStringBuilder;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        SpannableStringBuilder spannableStringBuilder2;
        int n15;
        int n16;
        int n17;
        int n18 = n;
        int n19 = n2;
        SpannableStringBuilder spannableStringBuilder3 = this;
        String string2 = "setSpan";
        int n20 = n;
        int n21 = n2;
        spannableStringBuilder3.checkRange(string2, n20, n21);
        if ((n3 & 0xF0) == 48 && n != 0 && (n17 = n) != (n16 = (n15 = this.length())) && (spannableStringBuilder2 = this).charAt(n14 = (n13 = n - 1)) != '\n') {
            throw new RuntimeException("PARAGRAPH span must start at paragraph boundary");
        }
        if ((n3 & 0xF) == 3 && n2 != 0 && (n12 = n2) != (n11 = (n10 = this.length())) && (spannableStringBuilder = this).charAt(n9 = (n8 = n2 - 1)) != '\n') {
            throw new RuntimeException("PARAGRAPH span must end at paragraph boundary");
        }
        int n22 = n;
        int n23 = this.mGapStart;
        int n24 = n23;
        if (n22 > n24) {
            int n25 = this.mGapLength;
            n += n25;
        } else {
            int n26;
            int n27;
            int n28;
            int n29;
            int n30 = n;
            int n31 = this.mGapStart;
            int n32 = n31;
            if (n30 != n32 && ((n29 = (n3 & 0xF0) >> 4) == 2 || n29 == 3 && (n28 = n) != (n27 = (n26 = this.length())))) {
                int n33 = this.mGapLength;
                n += n33;
            }
        }
        if ((n7 = n2) > (n6 = (n5 = this.mGapStart))) {
            int n34 = this.mGapLength;
            n2 += n34;
        } else {
            int n35;
            int n36;
            int n37;
            int n38;
            int n39 = n2;
            int n40 = this.mGapStart;
            int n41 = n40;
            if (n39 != n41 && ((n38 = n3 & 0xF) == 2 || n38 == 3 && (n37 = n2) != (n36 = (n35 = this.length())))) {
                int n42 = this.mGapLength;
                n2 += n42;
            }
        }
        int n43 = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        for (int i = 0; i < n43; ++i) {
            int n44;
            Object object2 = objectArray[i];
            Object object3 = object;
            if (object2 != object3) continue;
            int n45 = this.mSpanStarts[i];
            int n46 = this.mSpanEnds[i];
            int n47 = this.mGapStart;
            if (n45 > n47) {
                int n48 = this.mGapLength;
                n45 -= n48;
            }
            if (n46 > (n44 = this.mGapStart)) {
                int n49 = this.mGapLength;
                n46 -= n49;
            }
            this.mSpanStarts[i] = n;
            this.mSpanEnds[i] = n2;
            this.mSpanFlags[i] = n3;
            if (!bl) {
                return;
            }
            SpannableStringBuilder spannableStringBuilder4 = this;
            Object object4 = object;
            spannableStringBuilder4.sendSpanChanged(object4, n45, n46, n18, n19);
            return;
        }
        int n50 = this.mSpanCount + 1;
        int n51 = this.mSpans.length;
        if (n50 >= n51) {
            int n52 = ArrayUtils.idealIntArraySize(this.mSpanCount + 1);
            Object[] objectArray2 = new Object[n52];
            int[] nArray = new int[n52];
            int[] nArray2 = new int[n52];
            int[] nArray3 = new int[n52];
            Object[] objectArray3 = this.mSpans;
            int n53 = this.mSpanCount;
            Object[] objectArray4 = objectArray3;
            int n54 = 0;
            Object[] objectArray5 = objectArray2;
            int n55 = 0;
            int n56 = n53;
            System.arraycopy(objectArray4, n54, objectArray5, n55, n56);
            int[] nArray4 = this.mSpanStarts;
            int n57 = this.mSpanCount;
            int[] nArray5 = nArray4;
            int n58 = 0;
            int[] nArray6 = nArray;
            int n59 = 0;
            int n60 = n57;
            System.arraycopy(nArray5, n58, nArray6, n59, n60);
            int[] nArray7 = this.mSpanEnds;
            int n61 = this.mSpanCount;
            int[] nArray8 = nArray7;
            int n62 = 0;
            int[] nArray9 = nArray2;
            int n63 = 0;
            int n64 = n61;
            System.arraycopy(nArray8, n62, nArray9, n63, n64);
            int[] nArray10 = this.mSpanFlags;
            int n65 = this.mSpanCount;
            int[] nArray11 = nArray10;
            int n66 = 0;
            int[] nArray12 = nArray3;
            int n67 = 0;
            int n68 = n65;
            System.arraycopy(nArray11, n66, nArray12, n67, n68);
            Object[] objectArray6 = objectArray2;
            this.mSpans = objectArray6;
            int[] nArray13 = nArray;
            this.mSpanStarts = nArray13;
            int[] nArray14 = nArray2;
            this.mSpanEnds = nArray14;
            int[] nArray15 = nArray3;
            this.mSpanFlags = nArray15;
        }
        Object[] objectArray7 = this.mSpans;
        int n69 = this.mSpanCount;
        objectArray7[n69] = object;
        int[] nArray = this.mSpanStarts;
        int n70 = this.mSpanCount;
        nArray[n70] = n;
        int[] nArray16 = this.mSpanEnds;
        int n71 = this.mSpanCount;
        nArray16[n71] = n2;
        int[] nArray17 = this.mSpanFlags;
        int n72 = this.mSpanCount;
        nArray17[n72] = n3;
        this.mSpanCount = n4 = this.mSpanCount + 1;
        if (!bl) {
            return;
        }
        SpannableStringBuilder spannableStringBuilder5 = this;
        Object object5 = object;
        int n73 = n18;
        int n74 = n19;
        spannableStringBuilder5.sendSpanAdded(object5, n73, n74);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpannableStringBuilder valueOf(CharSequence charSequence) {
        if (!(charSequence instanceof SpannableStringBuilder)) return new SpannableStringBuilder(charSequence);
        return (SpannableStringBuilder)charSequence;
    }

    @Override
    public SpannableStringBuilder append(char c) {
        String string2 = String.valueOf(c);
        return this.append(string2);
    }

    @Override
    public SpannableStringBuilder append(CharSequence charSequence) {
        int n = this.length();
        int n2 = charSequence.length();
        SpannableStringBuilder spannableStringBuilder = this;
        int n3 = n;
        CharSequence charSequence2 = charSequence;
        return spannableStringBuilder.replace(n, n3, charSequence2, 0, n2);
    }

    @Override
    public SpannableStringBuilder append(CharSequence charSequence, int n, int n2) {
        int n3 = this.length();
        SpannableStringBuilder spannableStringBuilder = this;
        int n4 = n3;
        CharSequence charSequence2 = charSequence;
        int n5 = n;
        int n6 = n2;
        return spannableStringBuilder.replace(n3, n4, charSequence2, n5, n6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public char charAt(int n) {
        int n2 = this.length();
        if (n < 0) {
            String string2 = "charAt: " + n + " < 0";
            throw new IndexOutOfBoundsException(string2);
        }
        if (n >= n2) {
            String string3 = "charAt: " + n + " >= length " + n2;
            throw new IndexOutOfBoundsException(string3);
        }
        int n3 = this.mGapStart;
        if (n < n3) return this.mText[n];
        char[] cArray = this.mText;
        int n4 = this.mGapLength + n;
        return cArray[n4];
    }

    @Override
    public void clear() {
        int n = this.length();
        SpannableStringBuilder spannableStringBuilder = this;
        int n2 = 0;
        int n3 = 0;
        Editable editable = spannableStringBuilder.replace(0, n, "", n2, n3);
    }

    @Override
    public void clearSpans() {
        int n = this.mSpanCount - 1;
        while (n >= 0) {
            int n2;
            Object object = this.mSpans[n];
            int n3 = this.mSpanStarts[n];
            int n4 = this.mSpanEnds[n];
            int n5 = this.mGapStart;
            if (n3 > n5) {
                int n6 = this.mGapLength;
                n3 -= n6;
            }
            if (n4 > (n2 = this.mGapStart)) {
                int n7 = this.mGapLength;
                n4 -= n7;
            }
            this.mSpanCount = n;
            this.mSpans[n] = null;
            this.sendSpanRemoved(object, n3, n4);
            n += -1;
        }
        return;
    }

    @Override
    public SpannableStringBuilder delete(int n, int n2) {
        SpannableStringBuilder spannableStringBuilder = this;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        Editable editable = spannableStringBuilder.replace(n3, n4, "", 0, n5);
        int n6 = this.mGapLength;
        int n7 = this.length() * 2;
        if (n6 > n7) {
            int n8 = this.length();
            this.resizeFor(n8);
        }
        return editable;
    }

    @Override
    public void drawText(Canvas canvas, int n, int n2, float f, float f2, Paint paint) {
        this.checkRange("drawText", n, n2);
        int n3 = this.mGapStart;
        if (n2 <= n3) {
            char[] cArray = this.mText;
            int n4 = n2 - n;
            Canvas canvas2 = canvas;
            int n5 = n;
            float f3 = f;
            float f4 = f2;
            Paint paint2 = paint;
            canvas2.drawText(cArray, n5, n4, f3, f4, paint2);
            return;
        }
        int n6 = this.mGapStart;
        if (n >= n6) {
            char[] cArray = this.mText;
            int n7 = this.mGapLength;
            int n8 = n + n7;
            int n9 = n2 - n;
            Canvas canvas3 = canvas;
            float f5 = f;
            float f6 = f2;
            Paint paint3 = paint;
            canvas3.drawText(cArray, n8, n9, f5, f6, paint3);
            return;
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        this.getChars(n, n2, cArray, 0);
        int n10 = n2 - n;
        Canvas canvas4 = canvas;
        float f7 = f;
        float f8 = f2;
        Paint paint4 = paint;
        canvas4.drawText(cArray, 0, n10, f7, f8, paint4);
        TextUtils.recycle(cArray);
    }

    @Override
    public void getChars(int n, int n2, char[] cArray, int n3) {
        this.checkRange("getChars", n, n2);
        int n4 = this.mGapStart;
        if (n2 <= n4) {
            char[] cArray2 = this.mText;
            int n5 = n2 - n;
            System.arraycopy(cArray2, n, cArray, n3, n5);
            return;
        }
        int n6 = this.mGapStart;
        if (n >= n6) {
            char[] cArray3 = this.mText;
            int n7 = this.mGapLength + n;
            int n8 = n2 - n;
            System.arraycopy(cArray3, n7, cArray, n3, n8);
            return;
        }
        char[] cArray4 = this.mText;
        int n9 = this.mGapStart - n;
        System.arraycopy(cArray4, n, cArray, n3, n9);
        char[] cArray5 = this.mText;
        int n10 = this.mGapStart;
        int n11 = this.mGapLength;
        int n12 = n10 + n11;
        int n13 = this.mGapStart - n + n3;
        int n14 = this.mGapStart;
        int n15 = n2 - n14;
        System.arraycopy(cArray5, n12, cArray, n13, n15);
    }

    @Override
    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSpanEnd(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (objectArray[n2] == object) {
                int n3 = this.mSpanEnds[n2];
                int n4 = this.mGapStart;
                if (n3 <= n4) return n3;
                int n5 = this.mGapLength;
                n3 -= n5;
                return n3;
            }
            n2 += -1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSpanFlags(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (objectArray[n2] == object) {
                return this.mSpanFlags[n2];
            }
            n2 += -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSpanStart(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (objectArray[n2] == object) {
                int n3 = this.mSpanStarts[n2];
                int n4 = this.mGapStart;
                if (n3 <= n4) return n3;
                int n5 = this.mGapLength;
                n3 -= n5;
                return n3;
            }
            n2 += -1;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public <T> T[] getSpans(int var1_1, int var2_2, Class<T> var3_3) {
        block17: {
            block16: {
                var4_4 = this.mSpanCount;
                var5_5 = this.mSpans;
                var6_6 = this.mSpanStarts;
                var7_7 = this.mSpanEnds;
                var8_8 = this.mSpanFlags;
                var9_9 = this.mGapStart;
                var10_10 = this.mGapLength;
                var11_11 = null;
                var12_12 = 0;
                var13_13 = null;
                var14_14 = 0;
                block0: while ((var15_15 = ++var12_12) < (var16_16 = var4_4)) {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    block11: {
                                        block9: {
                                            var17_17 = var6_6[var12_12];
                                            var18_18 = var7_7[var12_12];
                                            var19_19 = var17_17;
                                            var20_20 = var9_9;
                                            if (var19_19 > var20_20) {
                                                var17_17 -= var10_10;
                                            }
                                            if ((var21_21 = var18_18) > (var22_22 = var9_9)) {
                                                var18_18 -= var10_10;
                                            }
                                            if ((var23_23 = var17_17) > (var24_24 = var2_2)) {
                                                var25_25 = var14_14;
lbl23:
                                                // 8 sources

                                                while (true) {
                                                    var14_14 = var25_25;
                                                    continue block0;
                                                    break;
                                                }
                                            }
                                            var26_26 = var18_18;
                                            var27_27 = var1_1;
                                            if (var26_26 >= var27_27) break block9;
                                            var25_25 = var14_14;
                                            ** GOTO lbl23
                                        }
                                        var28_28 = var17_17;
                                        var29_29 = var18_18;
                                        if (var28_28 == var29_29 || (var30_30 = var1_1) == (var31_31 = var2_2)) break block10;
                                        var32_32 = var17_17;
                                        var33_33 = var2_2;
                                        if (var32_32 == var33_33) break block11;
                                        var25_25 = var14_14;
                                        ** GOTO lbl23
                                    }
                                    var34_34 = var18_18;
                                    var35_35 = var1_1;
                                    if (var34_34 == var35_35) break block10;
                                    var25_25 = var14_14;
                                    ** GOTO lbl23
                                }
                                if (var3_3 == null || (var37_37 = var3_3).isInstance(var38_38 = (var36_36 = var5_5[var12_12]))) break block12;
                                var25_25 = var14_14;
                                ** GOTO lbl23
                            }
                            if (var14_14 != 0) break block13;
                            var39_39 = var5_5[var12_12];
                            var25_25 = var14_14 + 1;
                            var13_13 = var39_39;
                            ** GOTO lbl23
                        }
                        var40_40 = var14_14;
                        var41_41 = 1;
                        if (var40_40 == var41_41) {
                            var42_42 = var4_4 - var12_12 + 1;
                            var43_43 = var3_3;
                            var44_44 = var42_42;
                            var11_11 = (Object[])Array.newInstance(var43_43, var44_44);
                            var11_11[0] = var13_13;
                        }
                        if ((var45_45 = var8_8[var12_12] & 0xFF0000) == 0) break block14;
                        var46_46 = 0;
                        while (true) {
                            block15: {
                                if (var46_46 < var14_14 && var45_45 <= (var50_50 = (var48_48 = this).getSpanFlags(var49_49 = (var47_47 = var11_11[var46_46])) & 0xFF0000)) break block15;
                                var51_51 = var46_46 + 1;
                                var52_52 = var14_14 - var46_46;
                                var53_53 = var11_11;
                                var54_54 = var46_46;
                                var55_55 = var11_11;
                                var56_56 = var51_51;
                                var57_57 = var52_52;
                                System.arraycopy(var53_53, var54_54, var55_55, var56_56, var57_57);
                                var11_11[var46_46] = var58_58 = var5_5[var12_12];
                                var25_25 = var14_14 + 1;
                                ** GOTO lbl23
                            }
                            ++var46_46;
                        }
                    }
                    var25_25 = var14_14 + 1;
                    var11_11[var14_14] = var59_59 = var5_5[var12_12];
                    ** continue;
                }
                if (var14_14 == 0) {
                    var60_60 /* !! */  = ArrayUtils.emptyArray(var3_3);
lbl89:
                    // 4 sources

                    return var60_60 /* !! */ ;
                }
                var61_61 = var14_14;
                var62_62 = true;
                if (var61_61 != var62_62) break block16;
                var63_63 = var3_3;
                var64_64 = 1;
                var65_65 = (Object[])Array.newInstance(var63_63, var64_64);
                var65_65[0] = var13_13;
                var60_60 /* !! */  = var65_65;
                ** GOTO lbl89
            }
            var67_67 = var14_14;
            var66_66 = var11_11.length;
            var68_68 = var66_66;
            if (var67_67 == var68_68) break block17;
            var60_60 /* !! */  = var11_11;
            ** GOTO lbl89
        }
        var69_69 = var3_3;
        var70_70 = var14_14;
        var71_71 = (Object[])Array.newInstance(var69_69, var70_70);
        var72_72 = var11_11;
        var73_73 = 0;
        var74_74 = var71_71;
        var75_75 = 0;
        var76_76 = var14_14;
        System.arraycopy(var72_72, var73_73, var74_74, var75_75, var76_76);
        var60_60 /* !! */  = var71_71;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getTextWidths(int n, int n2, float[] fArray, Paint paint) {
        this.checkRange("getTextWidths", n, n2);
        int n3 = this.mGapStart;
        if (n2 <= n3) {
            char[] cArray = this.mText;
            int n4 = n2 - n;
            return paint.getTextWidths(cArray, n, n4, fArray);
        }
        int n5 = this.mGapStart;
        if (n >= n5) {
            char[] cArray = this.mText;
            int n6 = this.mGapLength + n;
            int n7 = n2 - n;
            return paint.getTextWidths(cArray, n6, n7, fArray);
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        this.getChars(n, n2, cArray, 0);
        int n8 = n2 - n;
        int n9 = paint.getTextWidths(cArray, 0, n8, fArray);
        TextUtils.recycle(cArray);
        return n9;
    }

    @Override
    public SpannableStringBuilder insert(int n, CharSequence charSequence) {
        int n2 = charSequence.length();
        SpannableStringBuilder spannableStringBuilder = this;
        int n3 = n;
        int n4 = n;
        CharSequence charSequence2 = charSequence;
        return spannableStringBuilder.replace(n3, n4, charSequence2, 0, n2);
    }

    @Override
    public SpannableStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        SpannableStringBuilder spannableStringBuilder = this;
        int n4 = n;
        int n5 = n;
        CharSequence charSequence2 = charSequence;
        int n6 = n2;
        int n7 = n3;
        return spannableStringBuilder.replace(n4, n5, charSequence2, n6, n7);
    }

    @Override
    public int length() {
        int n = this.mText.length;
        int n2 = this.mGapLength;
        return n - n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float measureText(int n, int n2, Paint paint) {
        this.checkRange("measureText", n, n2);
        int n3 = this.mGapStart;
        if (n2 <= n3) {
            char[] cArray = this.mText;
            int n4 = n2 - n;
            return paint.measureText(cArray, n, n4);
        }
        int n5 = this.mGapStart;
        if (n >= n5) {
            char[] cArray = this.mText;
            int n6 = this.mGapLength + n;
            int n7 = n2 - n;
            return paint.measureText(cArray, n6, n7);
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        this.getChars(n, n2, cArray, 0);
        int n8 = n2 - n;
        float f = paint.measureText(cArray, 0, n8);
        TextUtils.recycle(cArray);
        return f;
    }

    @Override
    public int nextSpanTransition(int n, int n2, Class clazz) {
        int n3 = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanStarts;
        int[] nArray2 = this.mSpanEnds;
        int n4 = this.mGapStart;
        int n5 = this.mGapLength;
        if (clazz == null) {
            clazz = Object.class;
        }
        for (int i = 0; i < n3; ++i) {
            Object object;
            Object object2;
            int n6 = nArray[i];
            int n7 = nArray2[i];
            if (n6 > n4) {
                n6 -= n5;
            }
            if (n7 > n4) {
                n7 -= n5;
            }
            if (n6 > n && n6 < n2 && clazz.isInstance(object2 = objectArray[i])) {
                n2 = n6;
            }
            if (n7 <= n || n7 >= n2 || !clazz.isInstance(object = objectArray[i])) continue;
            n2 = n7;
        }
        return n2;
    }

    @Override
    public void removeSpan(Object object) {
        int n = this.mSpanCount - 1;
        while (n >= 0) {
            if (this.mSpans[n] == object) {
                int n2;
                int n3;
                int n4 = this.mSpanStarts[n];
                int n5 = this.mSpanEnds[n];
                int n6 = this.mGapStart;
                if (n4 > n6) {
                    int n7 = this.mGapLength;
                    n4 -= n7;
                }
                if (n5 > (n3 = this.mGapStart)) {
                    int n8 = this.mGapLength;
                    n5 -= n8;
                }
                int n9 = this.mSpanCount;
                int n10 = n + 1;
                int n11 = n9 - n10;
                Object[] objectArray = this.mSpans;
                int n12 = n + 1;
                Object[] objectArray2 = this.mSpans;
                System.arraycopy(objectArray, n12, objectArray2, n, n11);
                int[] nArray = this.mSpanStarts;
                int n13 = n + 1;
                int[] nArray2 = this.mSpanStarts;
                System.arraycopy(nArray, n13, nArray2, n, n11);
                int[] nArray3 = this.mSpanEnds;
                int n14 = n + 1;
                int[] nArray4 = this.mSpanEnds;
                System.arraycopy(nArray3, n14, nArray4, n, n11);
                int[] nArray5 = this.mSpanFlags;
                int n15 = n + 1;
                int[] nArray6 = this.mSpanFlags;
                System.arraycopy(nArray5, n15, nArray6, n, n11);
                this.mSpanCount = n2 = this.mSpanCount - 1;
                Object[] objectArray3 = this.mSpans;
                int n16 = this.mSpanCount;
                objectArray3[n16] = null;
                this.sendSpanRemoved(object, n4, n5);
                return;
            }
            n += -1;
        }
        return;
    }

    @Override
    public SpannableStringBuilder replace(int n, int n2, CharSequence charSequence) {
        int n3 = charSequence.length();
        SpannableStringBuilder spannableStringBuilder = this;
        int n4 = n;
        int n5 = n2;
        CharSequence charSequence2 = charSequence;
        return spannableStringBuilder.replace(n4, n5, charSequence2, 0, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SpannableStringBuilder replace(int n, int n2, CharSequence charSequence, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19 = this.mFilters.length;
        int n20 = 0;
        while ((n18 = ++n20) < (n17 = n19)) {
            InputFilter inputFilter = this.mFilters[n20];
            CharSequence charSequence2 = charSequence;
            int n21 = n3;
            int n22 = n4;
            SpannableStringBuilder spannableStringBuilder = this;
            int n23 = n;
            int n24 = n2;
            CharSequence charSequence3 = inputFilter.filter(charSequence2, n21, n22, spannableStringBuilder, n23, n24);
            if (charSequence3 == null) continue;
            charSequence = charSequence3;
            n3 = 0;
            n4 = charSequence3.length();
        }
        int n25 = n2;
        int n26 = n;
        if (n25 != n26 && (n16 = n3) != (n15 = n4)) {
            return this;
        }
        int n27 = n2;
        int n28 = n;
        if (n27 == n28 || (n14 = n3) != (n13 = n4)) {
            int n29 = this.change(n, n2, charSequence, n3, n4);
            return this;
        }
        int n30 = Selection.getSelectionStart(this);
        int n31 = Selection.getSelectionEnd(this);
        SpannableStringBuilder spannableStringBuilder = this;
        String string2 = "replace";
        int n32 = n;
        int n33 = n2;
        spannableStringBuilder.checkRange(string2, n32, n33);
        SpannableStringBuilder spannableStringBuilder2 = this;
        int n34 = n2;
        spannableStringBuilder2.moveGapTo(n34);
        int n35 = n2 - n;
        int n36 = n4 - n3;
        SpannableStringBuilder spannableStringBuilder3 = this;
        int n37 = n;
        int n38 = n35;
        int n39 = n36;
        TextWatcher[] textWatcherArray = spannableStringBuilder3.sendTextWillChange(n37, n38, n39);
        int n40 = n2 - n;
        if (this.mGapLength < 2) {
            int n41 = this.length() + 1;
            SpannableStringBuilder spannableStringBuilder4 = this;
            int n42 = n41;
            spannableStringBuilder4.resizeFor(n42);
        }
        n20 = this.mSpanCount - 1;
        while (n20 >= 0) {
            int n43;
            int n44;
            int n45 = this.mSpanStarts[n20];
            int n46 = this.mGapStart;
            if (n45 != n46) {
                int n47;
                int[] nArray = this.mSpanStarts;
                nArray[n20] = n47 = nArray[n20] + 1;
            }
            if ((n44 = this.mSpanEnds[n20]) != (n43 = this.mGapStart)) {
                int n48;
                int[] nArray = this.mSpanEnds;
                nArray[n20] = n48 = nArray[n20] + 1;
            }
            int n49 = n20 + -1;
        }
        char[] cArray = this.mText;
        int n50 = this.mGapStart;
        cArray[n50] = 32;
        this.mGapStart = n12 = this.mGapStart + 1;
        this.mGapLength = n11 = this.mGapLength - 1;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        int n51 = n2 + 1 - n;
        int n52 = n + 1;
        int n53 = n + 1;
        SpannableStringBuilder spannableStringBuilder5 = this;
        CharSequence charSequence4 = charSequence;
        int n54 = n3;
        int n55 = n4;
        int n56 = spannableStringBuilder5.change(false, n52, n53, charSequence4, n54, n55);
        int n57 = n + 1;
        SpannableStringBuilder spannableStringBuilder6 = this;
        int n58 = n;
        int n59 = spannableStringBuilder6.change(false, n58, n57, "", 0, 0);
        int n60 = n + n56;
        int n61 = n + n56 + n51 - 1;
        int n62 = this.change(false, n60, n61, "", 0, 0);
        int n63 = n30;
        int n64 = n;
        if (n63 > n64 && (n10 = n30) < (n9 = n2)) {
            long l = n30 - n;
            long l2 = (long)n56 * l;
            long l3 = n2 - n;
            int n65 = (int)(l2 / l3) + n;
            Object object = Selection.SELECTION_START;
            SpannableStringBuilder spannableStringBuilder7 = this;
            int n66 = n65;
            spannableStringBuilder7.setSpan(false, object, n65, n66, 34);
        } else {
            int n67 = n30;
        }
        if ((n8 = n31) > (n7 = n) && (n6 = n31) < (n5 = n2)) {
            long l = n31 - n;
            long l4 = (long)n56 * l;
            long l5 = n2 - n;
            int n68 = (int)(l4 / l5) + n;
            Object object = Selection.SELECTION_END;
            SpannableStringBuilder spannableStringBuilder8 = this;
            int n69 = n68;
            spannableStringBuilder8.setSpan(false, object, n68, n69, 34);
        }
        SpannableStringBuilder spannableStringBuilder9 = this;
        TextWatcher[] textWatcherArray2 = textWatcherArray;
        int n70 = n;
        int n71 = n40;
        int n72 = n56;
        spannableStringBuilder9.sendTextChange(textWatcherArray2, n70, n71, n72);
        SpannableStringBuilder spannableStringBuilder10 = this;
        TextWatcher[] textWatcherArray3 = textWatcherArray;
        spannableStringBuilder10.sendTextHasChanged(textWatcherArray3);
        return this;
    }

    @Override
    public void setFilters(InputFilter[] inputFilterArray) {
        if (inputFilterArray == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = inputFilterArray;
    }

    @Override
    public void setSpan(Object object, int n, int n2, int n3) {
        SpannableStringBuilder spannableStringBuilder = this;
        Object object2 = object;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        spannableStringBuilder.setSpan(true, object2, n4, n5, n6);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return new SpannableStringBuilder(this, n, n2);
    }

    @Override
    public String toString() {
        int n = this.length();
        char[] cArray = new char[n];
        this.getChars(0, n, cArray, 0);
        return new String(cArray);
    }
}

