/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.emoji.EmojiFactory;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.text.AlteredCharSequence;
import android.text.AndroidCharacter;
import android.text.Layout;
import android.text.Spanned;
import android.text.Styled;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

public class StaticLayout
extends Layout {
    private static final int COLUMNS_ELLIPSIZE = 5;
    private static final int COLUMNS_NORMAL = 3;
    private static final int DESCENT = 2;
    private static final int DIR = 0;
    private static final int DIR_MASK = -1073741824;
    private static final int DIR_SHIFT = 30;
    private static final int ELLIPSIS_COUNT = 4;
    private static final int ELLIPSIS_START = 3;
    private static final char FIRST_CJK = '\u2e80';
    private static final char FIRST_RIGHT_TO_LEFT = '\u0590';
    private static final int START = 0;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int TAB = 0;
    private static final int TAB_MASK = 0x20000000;
    private static final int TOP = 1;
    private int mBottomPadding;
    private byte[] mChdirs;
    private char[] mChs;
    private int mColumns;
    private int mEllipsizedWidth;
    private Paint.FontMetricsInt mFontMetricsInt;
    private int mLineCount;
    private Layout.Directions[] mLineDirections;
    private int[] mLines;
    private int mTopPadding;
    private float[] mWidths;

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl) {
        StaticLayout staticLayout = this;
        CharSequence charSequence2 = charSequence;
        int n4 = n;
        int n5 = n2;
        TextPaint textPaint2 = textPaint;
        int n6 = n3;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        boolean bl2 = bl;
        staticLayout(charSequence2, n4, n5, textPaint2, n6, alignment2, f3, f4, bl2, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4) {
        Paint.FontMetricsInt fontMetricsInt;
        CharSequence charSequence2;
        if (truncateAt == null) {
            charSequence2 = charSequence;
        } else if (charSequence instanceof Spanned) {
            Layout.SpannedEllipsizer spannedEllipsizer;
            Layout.SpannedEllipsizer spannedEllipsizer2 = spannedEllipsizer;
            CharSequence charSequence3 = charSequence;
            spannedEllipsizer2(charSequence3);
            charSequence2 = spannedEllipsizer;
        } else {
            Layout.Ellipsizer ellipsizer;
            Layout.Ellipsizer ellipsizer2 = ellipsizer;
            CharSequence charSequence4 = charSequence;
            ellipsizer2(charSequence4);
            charSequence2 = ellipsizer;
        }
        StaticLayout staticLayout = this;
        TextPaint textPaint2 = textPaint;
        int n5 = n3;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        super(charSequence2, textPaint2, n5, alignment2, f3, f4);
        this.mFontMetricsInt = fontMetricsInt = new Paint.FontMetricsInt();
        if (truncateAt != null) {
            int n6;
            int n7;
            TextUtils.TruncateAt truncateAt2;
            int n8;
            Layout.Ellipsizer ellipsizer = (Layout.Ellipsizer)this.getText();
            StaticLayout staticLayout2 = this;
            ellipsizer.mLayout = staticLayout2;
            ellipsizer.mWidth = n8 = n4;
            ellipsizer.mMethod = truncateAt2 = truncateAt;
            this.mEllipsizedWidth = n7 = n4;
            this.mColumns = n6 = 5;
        } else {
            int n9;
            int n10;
            this.mColumns = n10 = 3;
            this.mEllipsizedWidth = n9 = n3;
        }
        int[] nArray = new int[ArrayUtils.idealIntArraySize(this.mColumns * 2)];
        this.mLines = nArray;
        Layout.Directions[] directionsArray = new Layout.Directions[ArrayUtils.idealIntArraySize(this.mColumns * 2)];
        this.mLineDirections = directionsArray;
        boolean bl2 = truncateAt != null;
        float f5 = n4;
        StaticLayout staticLayout3 = this;
        CharSequence charSequence5 = charSequence;
        int n11 = n;
        int n12 = n2;
        TextPaint textPaint3 = textPaint;
        int n13 = n3;
        Layout.Alignment alignment3 = alignment;
        float f6 = f;
        float f7 = f2;
        boolean bl3 = bl;
        boolean bl4 = bl;
        TextUtils.TruncateAt truncateAt3 = truncateAt;
        staticLayout3.generate(charSequence5, n11, n12, textPaint3, n13, alignment3, f6, f7, bl3, bl4, bl2, f5, truncateAt3);
        Object var42_42 = null;
        this.mChdirs = var42_42;
        Object var43_43 = null;
        this.mChs = var43_43;
        Object var44_44 = null;
        this.mWidths = var44_44;
        Object var45_45 = null;
        this.mFontMetricsInt = var45_45;
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        int n2 = charSequence.length();
        StaticLayout staticLayout = this;
        CharSequence charSequence2 = charSequence;
        TextPaint textPaint2 = textPaint;
        int n3 = n;
        Layout.Alignment alignment2 = alignment;
        float f3 = f;
        float f4 = f2;
        boolean bl2 = bl;
        staticLayout(charSequence2, 0, n2, textPaint2, n3, alignment2, f3, f4, bl2);
    }

    StaticLayout(boolean bl) {
        Paint.FontMetricsInt fontMetricsInt;
        StaticLayout staticLayout = this;
        TextPaint textPaint = null;
        Layout.Alignment alignment = null;
        float f = 0.0f;
        super(null, textPaint, 0, alignment, 0.0f, f);
        this.mFontMetricsInt = fontMetricsInt = new Paint.FontMetricsInt();
        this.mColumns = 5;
        int[] nArray = new int[ArrayUtils.idealIntArraySize(this.mColumns * 2)];
        this.mLines = nArray;
        Layout.Directions[] directionsArray = new Layout.Directions[ArrayUtils.idealIntArraySize(this.mColumns * 2)];
        this.mLineDirections = directionsArray;
    }

    /*
     * Unable to fully structure code
     */
    static int bidi(int var0, char[] var1_1, byte[] var2_2, int var3_3, boolean var4_4) {
        block38: {
            block37: {
                block39: {
                    block42: {
                        block36: {
                            block41: {
                                AndroidCharacter.getDirectionalities(var1_1, var2_2, var3_3);
                                if (var0 == 1 || var0 == -1) ** GOTO lbl12
                                if (var0 < 0) break block41;
                                var0 = 1;
lbl5:
                                // 2 sources

                                while (true) {
                                    var5_5 = 0;
lbl7:
                                    // 2 sources

                                    while (true) {
                                        if (var5_5 < var3_3) {
                                            var6_6 = var2_2[var5_5];
                                            if (var6_6 != null) break block36;
                                            var0 = 1;
                                        }
lbl12:
                                        // 5 sources

                                        while (var0 == 1) {
                                            var7_7 = 0;
lbl14:
                                            // 2 sources

                                            while (true) {
                                                block4: for (var8_8 = 0; var8_8 < var3_3; ++var8_8) {
                                                    if (var2_2[var8_8] == 6) {
                                                        if (var8_8 != 0) break block37;
                                                        var2_2[var8_8] = var7_7;
                                                    }
lbl19:
                                                    // 4 sources

                                                }
                                                break block38;
                                                break;
                                            }
                                        }
                                        break block39;
                                        break;
                                    }
                                    break;
                                }
                            }
                            var0 = -1;
                            ** while (true)
                        }
                        if (var6_6 != 1) break block42;
                        var0 = -1;
                        ** GOTO lbl12
                    }
                    ++var5_5;
                    ** while (true)
                }
                var7_7 = 1;
                ** while (true)
            }
            var9_9 = var8_8 - 1;
            var2_2[var8_8] = var10_10 = var2_2[var9_9];
            ** while (true)
        }
        var11_11 = var7_7;
        block6: for (var12_12 = 0; var12_12 < var3_3; ++var12_12) {
            var13_13 = var2_2[var12_12];
            if (var13_13 == null || var13_13 == 1 || var13_13 == 2) {
                var14_14 = var13_13;
lbl46:
                // 3 sources

                continue block6;
            }
            if (var13_13 != 3 || var11_11 != 2) ** GOTO lbl46
            var2_2[var12_12] = 6;
            ** continue;
        }
        for (var15_15 = 0; var15_15 < var3_3; ++var15_15) {
            if (var2_2[var15_15] != 2) continue;
            var2_2[var15_15] = 1;
        }
        block9: for (var16_16 = 1; var16_16 < (var17_17 = var3_3 - 1); ++var16_16) {
            var18_18 = var2_2[var16_16];
            var19_19 = var16_16 - 1;
            var20_20 = var2_2[var19_19];
            var21_21 = var16_16 + 1;
            var12_12 = var2_2[var21_21];
            if (var18_18 == 4) {
                if (var20_20 == 3 && var12_12 == 3) {
                    var2_2[var16_16] = 3;
                }
lbl64:
                // 6 sources

                continue block9;
            }
            if (var18_18 != 7) ** GOTO lbl64
            if (var20_20 == 3 && var12_12 == 3) {
                var2_2[var16_16] = 3;
            }
            if (var20_20 != 6 || var12_12 != 6) ** GOTO lbl64
            var2_2[var16_16] = 6;
            ** continue;
        }
        var22_22 = false;
        block11: for (var23_23 = 0; var23_23 < var3_3; ++var23_23) {
            block43: {
                var24_24 = var2_2[var23_23];
                if (var24_24 == 3) {
                    var22_22 = true;
lbl77:
                    // 3 sources

                    continue block11;
                }
                if (var24_24 != 5 || !var22_22) break block43;
                var2_2[var23_23] = 3;
                ** GOTO lbl77
            }
            var22_22 = false;
            ** continue;
        }
        var25_25 = false;
        block13: for (var26_26 = var3_3 - 1; var26_26 >= 0; var26_26 += -1) {
            block44: {
                block45: {
                    var27_27 = var2_2[var26_26];
                    if (var27_27 == 3) {
                        var25_25 = true;
lbl90:
                        // 5 sources

                        continue block13;
                    }
                    if (var27_27 != 5) break block44;
                    if (!var25_25) break block45;
                    var2_2[var26_26] = 3;
                    ** GOTO lbl90
                }
                var2_2[var26_26] = 13;
                ** GOTO lbl90
            }
            var25_25 = false;
            if (var27_27 != 4 && var27_27 != 7 && var27_27 != 10 && var27_27 != 11) ** GOTO lbl90
            var2_2[var26_26] = 13;
            ** continue;
        }
        var28_28 = var7_7;
        for (var29_29 = 0; var29_29 < var3_3; ++var29_29) {
            var30_30 = var2_2[var29_29];
            if (var30_30 == var7_7 || var30_30 == null || var30_30 == 1) {
                var28_28 = var30_30;
            }
            if (var30_30 != 3) continue;
            var2_2[var29_29] = var28_28;
        }
        var31_31 = var7_7;
        var32_32 = 0;
        block16: while (var32_32 < var3_3) {
            block40: {
                block46: {
                    var33_33 = var2_2[var32_32];
                    if (var33_33 == null || var33_33 == 1) {
                        var34_34 = var33_33;
                        var35_35 = var32_32;
lbl119:
                        // 3 sources

                        while (true) {
                            var32_32 = var35_35 + 1;
                            continue block16;
                            break;
                        }
                    }
                    if (var33_33 != 3 && var33_33 != 6) break block46;
                    var35_35 = var32_32;
                    ** GOTO lbl119
                }
                var36_36 = var7_7;
                var37_37 = var32_32 + 1;
                block18: while (true) {
                    block47: {
                        if (var37_37 >= var3_3 || (var36_36 = var2_2[var37_37]) == null || var36_36 == 1) lbl-1000:
                        // 3 sources

                        {
                            block19: while (var32_32 < var37_37) {
                                if (var36_36 == var31_31) break block18;
                                var2_2[var32_32] = var31_31;
lbl133:
                                // 2 sources

                                while (true) {
                                    var38_38 = var32_32 + 1;
                                    continue block19;
                                    break;
                                }
                            }
                            break block40;
                        }
                        if (var36_36 != 3 && var36_36 != 6) break block47;
                        var36_36 = 1;
                        ** GOTO lbl-1000
                    }
                    ++var37_37;
                }
                var2_2[var32_32] = var7_7;
                ** continue;
            }
            var35_35 = var37_37 - 1;
            ** continue;
        }
        for (var39_39 = 0; var39_39 < var3_3; ++var39_39) {
            var40_40 = var1_1[var39_39];
            if (var40_40 != '\t' && (var40_40 < '\ud800' || var40_40 > '\udfff')) continue;
            var2_2[var39_39] = var7_7;
        }
        return var0;
    }

    /*
     * Unable to fully structure code
     */
    private void calculateEllipsis(int var1_1, int var2_2, float[] var3_3, int var4_4, int var5_5, float var6_6, TextUtils.TruncateAt var7_7, int var8_8, float var9_9, TextPaint var10_10) {
        block9: {
            var11_11 = var2_2 - var1_1;
            if (var9_9 <= var6_6) {
                var12_12 = this.mLines;
                var13_13 = this.mColumns * var8_8 + 3;
                var12_12[var13_13] = 0;
                var14_14 = this.mLines;
                var15_15 = this.mColumns * var8_8 + 4;
                var14_14[var15_15] = 0;
                return;
            }
            var16_16 = var10_10;
            var17_17 = "\u2026";
            var18_18 = var16_16.measureText(var17_17);
            var20_20 = var7_7;
            var19_19 = TextUtils.TruncateAt.START;
            var21_21 = var19_19;
            if (var20_20 == var21_21) {
                var22_22 = 0.0f;
                var23_24 = var11_11;
                while (true) {
                    if (var23_24 < 0 || (var25_27 = var3_3[var24_26 = var23_24 - 1 + var1_1 - var4_4 + var5_5]) + var22_22 + var18_18 > var6_6) {
                        var26_30 = 0;
                        var27_31 = var23_24;
lbl23:
                        // 3 sources

                        while (true) {
                            var28_32 = this.mLines;
                            var29_33 = this.mColumns * var8_8 + 3;
                            var28_32[var29_33] = var26_30;
                            var30_34 = this.mLines;
                            var31_35 = this.mColumns * var8_8 + 4;
                            var30_34[var31_35] = var27_31;
                            return;
                        }
                    }
                    var22_22 += var25_27;
                    var23_24 += -1;
                }
            }
            var33_37 = var7_7;
            var32_36 = TextUtils.TruncateAt.END;
            var34_38 = var32_36;
            if (var33_37 != var34_38 && (var36_40 = var7_7) != (var37_41 = (var35_39 = TextUtils.TruncateAt.MARQUEE))) break block9;
            var22_23 = 0.0f;
            var23_25 = 0;
            while (true) {
                block10: {
                    if (var23_25 < var11_11 && !((var25_28 = var3_3[var38_42 = var23_25 + var1_1 - var4_4 + var5_5]) + var22_23 + var18_18 > var6_6)) break block10;
                    var26_30 = var23_25;
                    var27_31 = var11_11 - var23_25;
                    ** GOTO lbl23
                }
                var22_23 += var25_28;
                ++var23_25;
            }
        }
        var39_43 = 0.0f;
        var40_44 = 0.0f;
        var41_45 = var11_11;
        var42_46 = (var6_6 - var18_18) / 2.0f;
        var43_47 = var11_11;
        block3: while (true) {
            if (var43_47 < 0 || (var25_29 = var3_3[var44_48 = var43_47 - 1 + var1_1 - var4_4 + var5_5]) + var40_44 > var42_46) {
                var45_49 = var6_6 - var18_18 - var40_44;
                var46_50 = 0;
lbl59:
                // 2 sources

                while (true) {
                    if (var46_50 < var43_47 && !((var25_29 = var3_3[var47_51 = var46_50 + var1_1 - var4_4 + var5_5]) + var39_43 > var45_49)) break block3;
                    var26_30 = var46_50;
                    var27_31 = var43_47 - var46_50;
                    ** continue;
                    break;
                }
            }
            var40_44 += var25_29;
            var43_47 += -1;
        }
        var39_43 += var25_29;
        ++var46_50;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getFit(TextPaint textPaint, TextPaint textPaint2, CharSequence charSequence, int n, int n2, float f) {
        int n3 = n2 + 1;
        int n4 = n - 1;
        while (n3 - n4 > 1) {
            TextPaint textPaint3 = textPaint;
            TextPaint textPaint4 = textPaint2;
            CharSequence charSequence2 = charSequence;
            int n5 = n;
            int n6 = (n3 + n4) / 2;
            Object[] objectArray = null;
            if (StaticLayout.measureText(textPaint3, textPaint4, charSequence2, n5, n6, null, true, objectArray) > f) {
                n3 = n6;
                continue;
            }
            n4 = n6;
        }
        if (n4 >= n) return n4;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIdeographic(char c, boolean bl) {
        if (c >= '\u2e80' && c <= '\u2fff') {
            return true;
        }
        if (c == '\u3000') {
            return true;
        }
        if (c >= '\u3040' && c <= '\u309f') {
            if (bl) return true;
            switch (c) {
                default: {
                    return true;
                }
                case '\u3041': 
                case '\u3043': 
                case '\u3045': 
                case '\u3047': 
                case '\u3049': 
                case '\u3063': 
                case '\u3083': 
                case '\u3085': 
                case '\u3087': 
                case '\u308e': 
                case '\u3095': 
                case '\u3096': 
                case '\u309b': 
                case '\u309c': 
                case '\u309d': 
                case '\u309e': 
            }
            return false;
        }
        if (c >= '\u30a0' && c <= '\u30ff') {
            if (bl) return true;
            switch (c) {
                default: {
                    return true;
                }
                case '\u30a0': 
                case '\u30a1': 
                case '\u30a3': 
                case '\u30a5': 
                case '\u30a7': 
                case '\u30a9': 
                case '\u30c3': 
                case '\u30e3': 
                case '\u30e5': 
                case '\u30e7': 
                case '\u30ee': 
                case '\u30f5': 
                case '\u30f6': 
                case '\u30fb': 
                case '\u30fc': 
                case '\u30fd': 
                case '\u30fe': 
            }
            return false;
        }
        if (c >= '\u3400' && c <= '\u4db5') {
            return true;
        }
        if (c >= '\u4e00' && c <= '\u9fbb') {
            return true;
        }
        if (c >= '\uf900' && c <= '\ufad9') {
            return true;
        }
        if (c >= '\ua000' && c <= '\ua48f') {
            return true;
        }
        if (c >= '\ua490' && c <= '\ua4cf') {
            return true;
        }
        if (c >= '\ufe62' && c <= '\ufe66') {
            return true;
        }
        if (c < '\uff10') return false;
        if (c > '\uff19') return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int out(CharSequence var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, float var9_9, float var10_10, LineHeightSpan[] var11_11, int[] var12_12, Paint.FontMetricsInt var13_13, boolean var14_14, boolean var15_15, int var16_16, byte[] var17_17, int var18_18, boolean var19_19, boolean var20_20, boolean var21_21, boolean var22_22, float[] var23_23, int var24_24, int var25_25, TextUtils.TruncateAt var26_26, float var27_27, float var28_28, TextPaint var29_29) {
        block24: {
            block26: {
                block23: {
                    block25: {
                        var30_30 = this.mLineCount;
                        var31_31 = this.mColumns;
                        var32_32 = var30_30 * var31_31;
                        var33_33 = this.mColumns + var32_32 + 1;
                        var36_36 = var33_33;
                        var34_34 = this.mLines;
                        var35_35 = var34_34.length;
                        var37_37 = var35_35;
                        if (var36_36 >= var37_37) {
                            var38_38 = ArrayUtils.idealIntArraySize(var33_33 + 1);
                            var39_39 = new int[var38_38];
                            var40_40 = var34_34.length;
                            var41_41 = var34_34;
                            var42_42 = 0;
                            var43_43 = var39_39;
                            var44_44 = 0;
                            var45_45 = var40_40;
                            System.arraycopy(var41_41, var42_42, var43_43, var44_44, var45_45);
                            var46_46 = var39_39;
                            this.mLines = var46_46;
                            var34_34 = var39_39;
                            var47_47 = new Layout.Directions[var38_38];
                            var48_48 = this.mLineDirections;
                            var49_49 = this.mLineDirections.length;
                            var50_50 = var48_48;
                            var51_51 = 0;
                            var52_52 = var47_47;
                            var53_53 = 0;
                            var54_54 = var49_49;
                            System.arraycopy(var50_50, var51_51, var52_52, var53_53, var54_54);
                            var55_55 = var47_47;
                            this.mLineDirections = var55_55;
                        }
                        if (var11_11 != null) {
                            var13_13.ascent = var56_56 = var4_4;
                            var13_13.descent = var57_57 = var5_5;
                            var13_13.top = var58_58 = var6_6;
                            var13_13.bottom = var59_59 = var7_7;
                            var60_60 = 0;
                            block0: while ((var62_62 = ++var60_60) < (var63_63 = (var61_61 = var11_11.length))) {
                                if (var11_11[var60_60] instanceof LineHeightSpan.WithDensity) {
                                    var64_64 = (LineHeightSpan.WithDensity)var11_11[var60_60];
                                    var65_65 = var12_12[var60_60];
                                    var66_66 = var1_1;
                                    var67_67 = var2_2;
                                    var68_68 = var3_3;
                                    var69_69 = var8_8;
                                    var70_70 = var13_13;
                                    var71_71 = var29_29;
                                    var64_64.chooseHeight(var66_66, var67_67, var68_68, var65_65, var69_69, var70_70, var71_71);
lbl50:
                                    // 2 sources

                                    continue block0;
                                }
                                var72_72 = var11_11[var60_60];
                                var73_73 = var12_12[var60_60];
                                var74_74 = var1_1;
                                var75_75 = var2_2;
                                var76_76 = var3_3;
                                var77_77 = var8_8;
                                var78_78 = var13_13;
                                var72_72.chooseHeight(var74_74, var75_75, var76_76, var73_73, var77_77, var78_78);
                                ** continue;
                            }
                            var4_4 = var13_13.ascent;
                            var5_5 = var13_13.descent;
                            var6_6 = var13_13.top;
                            var7_7 = var13_13.bottom;
                        }
                        if (var30_30 == 0) {
                            if (var22_22) {
                                this.mTopPadding = var79_79 = var6_6 - var4_4;
                            }
                            if (var21_21) {
                                var4_4 = var6_6;
                            }
                        }
                        if (var20_20) {
                            if (var22_22) {
                                this.mBottomPadding = var80_80 = var7_7 - var5_5;
                            }
                            if (var21_21) {
                                var5_5 = var7_7;
                            }
                        }
                        if (!var15_15) break block25;
                        var81_81 = var5_5 - var4_4;
                        var82_82 = var9_9 - 1.0f;
                        var83_83 = var81_81 * var82_82 + var10_10;
                        if (var83_83 >= 0.0) {
                            var85_84 = (int)(0.5 + var83_83);
lbl81:
                            // 3 sources

                            while (true) {
                                var86_85 = var32_32 + 0;
                                var34_34[var86_85] = var2_2;
                                var87_86 = var32_32 + 1;
                                var34_34[var87_86] = var8_8;
                                var88_87 = var32_32 + 2;
                                var34_34[var88_87] = var89_88 = var5_5 + var85_84;
                                var90_89 = var5_5 - var4_4 + var85_84;
                                var91_90 = var8_8 + var90_89;
                                var92_91 = this.mColumns + var32_32 + 0;
                                var34_34[var92_91] = var3_3;
                                var93_92 = this.mColumns + var32_32 + 1;
                                var34_34[var93_92] = var91_90;
                                if (var14_14) {
                                    var94_93 = var32_32 + 0;
                                    var34_34[var94_93] = var95_94 = var34_34[var94_93] | 0x20000000;
                                }
                                var96_95 = var32_32 + 0;
                                var97_96 = var34_34[var96_95];
                                var98_97 = var18_18 << 30;
                                var34_34[var96_95] = var99_98 = var97_96 | var98_97;
                                var100_99 = 0;
                                var101_100 = 0;
                                if (!var19_19) {
                                    var102_101 = var2_2;
                                    while ((var103_102 = ++var102_101) < (var104_103 = var3_3)) {
                                        var105_104 = var102_101 - var16_16;
                                        var106_105 = var17_17[var105_104];
                                        var107_106 = var100_99;
                                        if (var106_105 != var107_106) {
                                            ++var101_100;
                                            var108_107 = var102_101 - var16_16;
                                            var100_99 = var17_17[var108_107];
                                        }
                                    }
                                }
                                break block23;
                                break;
                            }
                        }
                        var85_84 = -((int)(-var83_83 + 0.5));
                        ** GOTO lbl81
                    }
                    var85_84 = 0;
                    ** while (true)
                }
                if (var101_100 == 0) {
                    var109_108 = StaticLayout.DIRS_ALL_LEFT_TO_RIGHT;
lbl123:
                    // 3 sources

                    while (true) {
                        this.mLineDirections[var30_30] = var109_108;
                        if (var26_26 != null && ((var111_110 = var26_26) != (var112_111 = (var110_109 = TextUtils.TruncateAt.MARQUEE)) || var30_30 != 0)) {
                            var113_112 = this;
                            var114_113 = var2_2;
                            var115_114 = var3_3;
                            var116_115 = var23_23;
                            var117_116 = var24_24;
                            var118_117 = var25_25;
                            var119_118 = var27_27;
                            var120_119 = var26_26;
                            var121_120 = var28_28;
                            var122_121 = var29_29;
                            var113_112.calculateEllipsis(var114_113, var115_114, var116_115, var117_116, var118_117, var119_118, var120_119, var30_30, var121_120, var122_121);
                        }
                        this.mLineCount = var123_122 = this.mLineCount + 1;
                        return var91_90;
                    }
                }
                var124_123 = var101_100 + 1;
                var100_99 = 0;
                var125_124 = var2_2;
                var102_101 = var2_2;
                var126_125 = 0;
                block5: while ((var127_126 = var102_101) < (var128_127 = var3_3)) {
                    var129_128 = var102_101 - var16_16;
                    var130_129 = var17_17[var129_128];
                    var131_130 = var100_99;
                    if (var130_129 != var131_130) {
                        var132_131 = var126_125 + 1;
                        var124_123[var126_125] = var133_132 = (short)(var102_101 - var125_124);
                        var134_133 = var102_101 - var16_16;
                        var135_134 = var17_17[var134_133];
                        var125_124 = var102_101;
lbl154:
                        // 2 sources

                        while (true) {
                            var136_135 = var102_101 + 1;
                            var126_125 = var132_131;
                            continue block5;
                            break;
                        }
                    }
                    break block24;
                }
                var124_123[var126_125] = var137_136 = (short)(var3_3 - var125_124);
                var138_137 = var126_125;
                var138_137 = 1;
                if (var138_137 != var138_137 || var124_123[0] != null) break block26;
                var109_108 = StaticLayout.DIRS_ALL_RIGHT_TO_LEFT;
                var140_138 = var126_125;
                ** GOTO lbl123
            }
            var141_139 = var109_108;
            var142_140 = var124_123;
            var141_139((short[])var142_140);
            var143_141 = var126_125;
            ** while (true)
        }
        var132_131 = var126_125;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    void generate(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3, TextUtils.TruncateAt truncateAt) {
        int n4;
        int n5;
        CharSequence charSequence2;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        this.mLineCount = n10 = 0;
        int n11 = 0;
        boolean bl4 = f != 1.0f || f2 != 0.0f;
        Paint.FontMetricsInt fontMetricsInt = this.mFontMetricsInt;
        int[] nArray = null;
        CharSequence charSequence3 = charSequence;
        char c = '\n';
        int n12 = n;
        int n13 = n2;
        int n14 = TextUtils.indexOf(charSequence3, c, n12, n13);
        int n15 = n14 >= 0 ? n14 - n : n2 - n;
        boolean bl5 = true;
        if (this.mChdirs == null) {
            byte[] byArray = new byte[ArrayUtils.idealByteArraySize(n15 + 1)];
            this.mChdirs = byArray;
            char[] cArray = new char[ArrayUtils.idealCharArraySize(n15 + 1)];
            this.mChs = cArray;
            float[] fArray = new float[ArrayUtils.idealIntArraySize((n15 + 1) * 2)];
            this.mWidths = fArray;
        }
        byte[] byArray = this.mChdirs;
        char[] cArray = this.mChs;
        float[] fArray = this.mWidths;
        AlteredCharSequence alteredCharSequence = null;
        Spanned spanned = null;
        if (charSequence instanceof Spanned) {
            spanned = (Spanned)charSequence;
        }
        int n16 = 1;
        int n17 = n;
        block0: while ((n9 = n17) <= (n8 = n2)) {
            CharSequence charSequence4;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            Object object;
            if (bl5) {
                bl5 = false;
            } else {
                CharSequence charSequence5 = charSequence;
                char c2 = '\n';
                int n26 = n17;
                int n27 = n2;
                n14 = TextUtils.indexOf(charSequence5, c2, n26, n27);
            }
            n14 = n14 < 0 ? n2 : ++n14;
            int n28 = 1;
            int n29 = n3;
            int n30 = n3;
            LineHeightSpan[] lineHeightSpanArray = null;
            if (spanned != null) {
                int n31;
                int n32;
                Spanned spanned2 = spanned;
                int n33 = n17;
                int n34 = n14;
                Class<LeadingMarginSpan> clazz = LeadingMarginSpan.class;
                object = spanned2.getSpans(n33, n34, clazz);
                for (n32 = 0; n32 < (n31 = ((LeadingMarginSpan[])object).length); ++n32) {
                    LeadingMarginSpan leadingMarginSpan = object[n32];
                    int n35 = object[n32].getLeadingMargin(true);
                    n29 -= n35;
                    int n36 = object[n32].getLeadingMargin(false);
                    n30 -= n36;
                    if (!(leadingMarginSpan instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    n28 = ((LeadingMarginSpan.LeadingMarginSpan2)leadingMarginSpan).getLeadingMarginLineCount();
                }
                Spanned spanned3 = spanned;
                int n37 = n17;
                int n38 = n14;
                Class<LineHeightSpan> clazz2 = LineHeightSpan.class;
                lineHeightSpanArray = spanned3.getSpans(n37, n38, clazz2);
                if (lineHeightSpanArray.length != 0) {
                    int n39;
                    int n40;
                    int n41;
                    if (nArray == null || (n41 = nArray.length) < (n40 = lineHeightSpanArray.length)) {
                        nArray = new int[ArrayUtils.idealIntArraySize(lineHeightSpanArray.length)];
                    }
                    for (n32 = 0; n32 < (n39 = lineHeightSpanArray.length); ++n32) {
                        int n42;
                        LineHeightSpan lineHeightSpan = lineHeightSpanArray[n32];
                        int n43 = spanned.getSpanStart(lineHeightSpan);
                        int n44 = n43;
                        if (n44 < (n42 = n17)) {
                            int n45;
                            StaticLayout staticLayout = this;
                            int n46 = n43;
                            int n47 = staticLayout.getLineForOffset(n46);
                            StaticLayout staticLayout2 = this;
                            int n48 = n47;
                            nArray[n32] = n45 = staticLayout2.getLineTop(n48);
                            continue;
                        }
                        nArray[n32] = n11;
                    }
                }
            }
            if ((n25 = n14 - n17) > (n24 = byArray.length)) {
                byte[] byArray2;
                this.mChdirs = byArray2 = (byArray = new byte[ArrayUtils.idealByteArraySize(n14 - n17)]);
            }
            if ((n23 = n14 - n17) > (n22 = cArray.length)) {
                char[] cArray2;
                this.mChs = cArray2 = (cArray = new char[ArrayUtils.idealCharArraySize(n14 - n17)]);
            }
            if ((n21 = (n14 - n17) * 2) > (n20 = fArray.length)) {
                float[] fArray2;
                this.mWidths = fArray2 = (fArray = new float[ArrayUtils.idealIntArraySize((n14 - n17) * 2)]);
            }
            CharSequence charSequence6 = charSequence;
            int n49 = n17;
            int n50 = n14;
            char[] cArray3 = cArray;
            int n51 = 0;
            TextUtils.getChars(charSequence6, n49, n50, cArray3, n51);
            int n52 = n14 - n17;
            boolean bl6 = true;
            boolean bl7 = false;
            int n53 = n16;
            int n54 = 0;
            while ((n19 = ++n54) < (n18 = n52)) {
                if (cArray[n54] < '\u0590') continue;
                bl6 = false;
                break;
            }
            if (charSequence instanceof Spanned) {
                int n55;
                int n56;
                int n57;
                Object object2 = object = (Spanned)charSequence;
                int n58 = n17;
                int n59 = n14;
                Class<ReplacementSpan> clazz = ReplacementSpan.class;
                ReplacementSpan[] replacementSpanArray = object2.getSpans(n58, n59, clazz);
                int n60 = 0;
                while ((n57 = ++n60) < (n56 = (n55 = replacementSpanArray.length))) {
                    int n61;
                    int n62;
                    ReplacementSpan replacementSpan = replacementSpanArray[n60];
                    Object object3 = object;
                    ReplacementSpan replacementSpan2 = replacementSpan;
                    int n63 = object3.getSpanStart(replacementSpan2);
                    ReplacementSpan replacementSpan3 = replacementSpanArray[n60];
                    Object object4 = object;
                    ReplacementSpan replacementSpan4 = replacementSpan3;
                    int n64 = object4.getSpanEnd(replacementSpan4);
                    int n65 = n63;
                    while ((n62 = ++n65) < (n61 = n64)) {
                        int n66 = n65 - n17;
                        cArray[n66] = 65532;
                    }
                }
            }
            if (!bl6) {
                int n67;
                int n68;
                int n69 = n53;
                char[] cArray4 = cArray;
                byte[] byArray3 = byArray;
                int n70 = n52;
                boolean bl8 = false;
                n53 = StaticLayout.bidi(n69, cArray4, byArray3, n70, bl8);
                n54 = 0;
                while ((n68 = ++n54) < (n67 = n52)) {
                    int n71;
                    int n72;
                    if (byArray[n54] != 1) continue;
                    int n73 = n54;
                    while ((n72 = ++n73) < (n71 = n52) && byArray[n73] == 1) {
                    }
                    char[] cArray5 = cArray;
                    int n74 = n54;
                    int n75 = n73 - n54;
                    int n76 = n75;
                    if (AndroidCharacter.mirror(cArray5, n74, n76)) {
                        bl7 = true;
                    }
                    n54 = n73 - 1;
                }
            }
            if (bl7) {
                if (alteredCharSequence == null) {
                    CharSequence charSequence7 = charSequence;
                    char[] cArray6 = cArray;
                    int n77 = n17;
                    int n78 = n14;
                    alteredCharSequence = AlteredCharSequence.make(charSequence7, cArray6, n77, n78);
                } else {
                    AlteredCharSequence alteredCharSequence2 = alteredCharSequence;
                    char[] cArray7 = cArray;
                    int n79 = n17;
                    int n80 = n14;
                    alteredCharSequence2.update(cArray7, n79, n80);
                }
                charSequence4 = alteredCharSequence;
            } else {
                charSequence4 = charSequence;
            }
            int n81 = n29;
            float f4 = 0.0f;
            int n82 = n17;
            int n83 = n17;
            float f5 = f4;
            int n84 = 0;
            int n85 = 0;
            int n86 = 0;
            int n87 = 0;
            int n88 = n17;
            float f6 = f4;
            int n89 = 0;
            int n90 = 0;
            int n91 = 0;
            int n92 = 0;
            boolean bl9 = false;
            int n93 = n17;
            while (true) {
                int n94;
                int n95;
                int n96;
                int n97;
                int n98;
                int n99;
                int n100;
                int n101;
                int n102;
                int n103;
                if ((n103 = n93) < (n102 = n14)) {
                    if (spanned == null) {
                        n101 = n14;
                    } else {
                        Spanned spanned4 = spanned;
                        int n104 = n93;
                        int n105 = n14;
                        Class<MetricAffectingSpan> clazz = MetricAffectingSpan.class;
                        n101 = spanned4.nextSpanTransition(n104, n105, clazz);
                    }
                    if (spanned == null) {
                        TextPaint textPaint2 = textPaint;
                        CharSequence charSequence8 = charSequence4;
                        int n106 = n93;
                        int n107 = n101;
                        float[] fArray3 = fArray;
                        int n108 = textPaint2.getTextWidths(charSequence8, n106, n107, fArray3);
                        int n109 = n14 - n17;
                        int n110 = n93 - n17;
                        int n111 = n109 + n110;
                        int n112 = n101 - n93;
                        System.arraycopy(fArray, 0, fArray, n111, n112);
                        TextPaint textPaint3 = textPaint;
                        Paint.FontMetricsInt fontMetricsInt2 = fontMetricsInt;
                        int n113 = textPaint3.getFontMetricsInt(fontMetricsInt2);
                    } else {
                        this.mWorkPaint.baselineShift = 0;
                        TextPaint textPaint4 = this.mWorkPaint;
                        int n114 = Styled.getTextWidths(textPaint, textPaint4, spanned, n93, n101, fArray, fontMetricsInt);
                        int n115 = n14 - n17;
                        int n116 = n93 - n17;
                        int n117 = n115 + n116;
                        int n118 = n101 - n93;
                        System.arraycopy(fArray, 0, fArray, n117, n118);
                        if (this.mWorkPaint.baselineShift < 0) {
                            int n119;
                            int n120;
                            int n121 = fontMetricsInt.ascent;
                            int n122 = this.mWorkPaint.baselineShift;
                            fontMetricsInt.ascent = n120 = n121 + n122;
                            int n123 = fontMetricsInt.top;
                            int n124 = this.mWorkPaint.baselineShift;
                            fontMetricsInt.top = n119 = n123 + n124;
                        } else {
                            int n125;
                            int n126;
                            int n127 = fontMetricsInt.descent;
                            int n128 = this.mWorkPaint.baselineShift;
                            fontMetricsInt.descent = n126 = n127 + n128;
                            int n129 = fontMetricsInt.bottom;
                            int n130 = this.mWorkPaint.baselineShift;
                            fontMetricsInt.bottom = n125 = n129 + n130;
                        }
                    }
                    n100 = fontMetricsInt.top;
                    n99 = fontMetricsInt.bottom;
                    n98 = fontMetricsInt.ascent;
                    n97 = fontMetricsInt.descent;
                    n96 = n93;
                } else {
                    int n131 = n14;
                    int n132 = n82;
                    if (n131 != n132) {
                        int n133;
                        int n134;
                        if (!(n91 | n92 | n90 | n89)) {
                            TextPaint textPaint5 = textPaint;
                            Paint.FontMetricsInt fontMetricsInt3 = fontMetricsInt;
                            int n135 = textPaint5.getFontMetricsInt(fontMetricsInt3);
                            n91 = fontMetricsInt.top;
                            n92 = fontMetricsInt.bottom;
                            n89 = fontMetricsInt.ascent;
                            n90 = fontMetricsInt.descent;
                        }
                        boolean bl10 = (n134 = n14) != (n133 = n2);
                        int n136 = n14 - n17;
                        StaticLayout staticLayout = this;
                        CharSequence charSequence9 = charSequence;
                        int n137 = n82;
                        int n138 = n14;
                        int n139 = n89;
                        int n140 = n90;
                        int n141 = n91;
                        int n142 = n92;
                        int n143 = n11;
                        float f7 = f;
                        float f8 = f2;
                        LineHeightSpan[] lineHeightSpanArray2 = lineHeightSpanArray;
                        int[] nArray2 = nArray;
                        Paint.FontMetricsInt fontMetricsInt4 = fontMetricsInt;
                        boolean bl11 = bl9;
                        boolean bl12 = bl4;
                        int n144 = n17;
                        byte[] byArray4 = byArray;
                        int n145 = n53;
                        boolean bl13 = bl6;
                        boolean bl14 = bl;
                        boolean bl15 = bl2;
                        float[] fArray4 = fArray;
                        int n146 = n17;
                        TextUtils.TruncateAt truncateAt2 = truncateAt;
                        float f9 = f3;
                        TextPaint textPaint6 = textPaint;
                        n11 = staticLayout.out(charSequence9, n137, n138, n139, n140, n141, n142, n143, f7, f8, lineHeightSpanArray2, nArray2, fontMetricsInt4, bl11, bl12, n144, byArray4, n145, bl13, bl10, bl14, bl15, fArray4, n146, n136, truncateAt2, f9, f4, textPaint6);
                    }
                    int n147 = n14;
                    int n148 = n14;
                    int n149 = n2;
                    if (n148 != n149) break block0;
                    n17 = n14;
                    continue block0;
                }
                while ((n95 = ++n96) < (n94 = n101)) {
                    boolean bl16;
                    float f10;
                    char c3;
                    block64: {
                        block66: {
                            int n150;
                            int n151;
                            int n152;
                            int n153;
                            int n154;
                            char c4;
                            char c5;
                            block65: {
                                int n155 = n96 - n17;
                                c3 = cArray[n155];
                                float f11 = f4;
                                char c6 = c3;
                                char c7 = '\n';
                                if (c6 == c7) break block64;
                                char c8 = c3;
                                char c9 = '\t';
                                if (c8 != c9) break block65;
                                CharSequence charSequence10 = charSequence4;
                                int n156 = n17;
                                int n157 = n14;
                                float f12 = f4;
                                Object[] objectArray = null;
                                f4 = Layout.nextTab(charSequence10, n156, n157, f12, objectArray);
                                bl9 = true;
                                break block64;
                            }
                            char c10 = c3;
                            char c11 = '\ud800';
                            if (c10 < c11 || (c5 = c3) > (c4 = '\udfff') || n96 + 1 >= n101) break block66;
                            char[] cArray8 = cArray;
                            int n158 = n96 - n17;
                            int n159 = n158;
                            int n160 = Character.codePointAt(cArray8, n159);
                            int n161 = n160;
                            if (n161 >= (n154 = (n153 = MIN_EMOJI)) && (n152 = n160) <= (n151 = (n150 = MAX_EMOJI))) {
                                EmojiFactory emojiFactory = EMOJI_FACTORY;
                                int n162 = n160;
                                Bitmap bitmap = emojiFactory.getBitmapFromAndroidPua(n162);
                                if (bitmap != null) {
                                    TextPaint textPaint7 = spanned == null ? textPaint : this.mWorkPaint;
                                    float f13 = bitmap.getWidth();
                                    float f14 = -textPaint7.ascent();
                                    float f15 = f13 * f14;
                                    float f16 = bitmap.getHeight();
                                    float f17 = f15 / f16;
                                    f4 += f17;
                                    bl9 = true;
                                    ++n96;
                                    break block64;
                                } else {
                                    int n163 = n96 - n17;
                                    int n164 = n14 - n17;
                                    int n165 = n163 + n164;
                                    float f18 = fArray[n165];
                                    f4 += f18;
                                }
                                break block64;
                            } else {
                                int n166 = n96 - n17;
                                int n167 = n14 - n17;
                                int n168 = n166 + n167;
                                float f19 = fArray[n168];
                                f4 += f19;
                            }
                            break block64;
                        }
                        int n169 = n96 - n17;
                        int n170 = n14 - n17;
                        int n171 = n169 + n170;
                        float f20 = fArray[n171];
                        f4 += f20;
                    }
                    if (f4 <= (f10 = (float)n81)) {
                        int n172;
                        int n173;
                        int n174;
                        int n175;
                        int n176;
                        int n177;
                        int n178;
                        boolean bl17;
                        char c12;
                        char c13;
                        char c14;
                        int n179;
                        char c15;
                        char c16;
                        char c17;
                        char c18;
                        int n180;
                        int n181;
                        char c19;
                        char c20;
                        char c21;
                        char c22;
                        char c23;
                        char c24;
                        char c25;
                        char c26;
                        char c27;
                        char c28;
                        char c29;
                        char c30;
                        int n182;
                        int n183;
                        int n184;
                        int n185;
                        int n186;
                        int n187;
                        float f21 = f4;
                        n88 = n96 + 1;
                        int n188 = n100;
                        int n189 = n91;
                        if (n188 < n189) {
                            n91 = n100;
                        }
                        if ((n187 = n98) < (n186 = n89)) {
                            n89 = n98;
                        }
                        if ((n185 = n97) > (n184 = n90)) {
                            n90 = n97;
                        }
                        if ((n183 = n99) > (n182 = n92)) {
                            n92 = n99;
                        }
                        if ((c30 = c3) != (c29 = ' ') && (c28 = c3) != (c27 = '\t') && ((c26 = c3) != (c25 = '.') && (c24 = c3) != (c23 = ',') && (c22 = c3) != (c21 = ':') && (c20 = c3) != (c19 = ';') || n96 - 1 >= n82 && Character.isDigit(cArray[n181 = n96 - 1 - n17]) || n96 + 1 < n101 && Character.isDigit(cArray[n180 = n96 + 1 - n17])) && ((c18 = c3) != (c17 = '/') && (c16 = c3) != (c15 = '-') || n96 + 1 < n101 && Character.isDigit(cArray[n179 = n96 + 1 - n17])) && ((c14 = c3) < (c13 = '\u2e80') || !StaticLayout.isIdeographic(c12 = c3, bl17 = true) || n96 + 1 >= n101 || !StaticLayout.isIdeographic(cArray[n178 = n96 + 1 - n17], false))) continue;
                        float f22 = f4;
                        n83 = n96 + 1;
                        int n190 = n91;
                        int n191 = n86;
                        if (n190 < n191) {
                            n86 = n91;
                        }
                        if ((n177 = n89) < (n176 = n84)) {
                            n84 = n89;
                        }
                        if ((n175 = n90) > (n174 = n85)) {
                            n85 = n90;
                        }
                        if ((n173 = n92) <= (n172 = n87)) continue;
                        n87 = n92;
                        continue;
                    }
                    if (bl3) {
                        int n192;
                        int n193;
                        int n194;
                        int n195;
                        int n196;
                        int n197;
                        if (n83 != n82) {
                            int n198;
                            while (n83 < n101 && cArray[n198 = n83 - n17] == ' ') {
                                ++n83;
                            }
                            int n199 = n83;
                            int n200 = n2;
                            bl16 = n199 != n200;
                            int n201 = n14 - n17;
                            StaticLayout staticLayout = this;
                            CharSequence charSequence11 = charSequence;
                            float f23 = f;
                            float f24 = f2;
                            Paint.FontMetricsInt fontMetricsInt5 = fontMetricsInt;
                            boolean bl18 = bl;
                            boolean bl19 = bl2;
                            float[] fArray5 = fArray;
                            int n202 = n17;
                            TextUtils.TruncateAt truncateAt3 = truncateAt;
                            float f25 = f3;
                            TextPaint textPaint8 = textPaint;
                            n11 = staticLayout.out(charSequence11, n82, n83, n84, n85, n86, n87, n11, f23, f24, lineHeightSpanArray, nArray, fontMetricsInt5, bl9, bl4, n17, byArray, n53, bl6, bl16, bl18, bl19, fArray5, n202, n201, truncateAt3, f25, f5, textPaint8);
                            n82 = n83;
                            continue;
                        }
                        float f26 = f4;
                        n88 = n96 + 1;
                        int n203 = n100;
                        int n204 = n91;
                        if (n203 < n204) {
                            n91 = n100;
                        }
                        if ((n197 = n98) < (n196 = n89)) {
                            n89 = n98;
                        }
                        if ((n195 = n97) > (n194 = n90)) {
                            n90 = n97;
                        }
                        if ((n193 = n99) <= (n192 = n92)) continue;
                        n92 = n99;
                        continue;
                    }
                    if (n83 != n82) {
                        int n205;
                        while (n83 < n101 && cArray[n205 = n83 - n17] == ' ') {
                            ++n83;
                        }
                        int n206 = n83;
                        int n207 = n2;
                        bl16 = n206 != n207;
                        int n208 = n14 - n17;
                        StaticLayout staticLayout = this;
                        CharSequence charSequence12 = charSequence;
                        float f27 = f;
                        float f28 = f2;
                        Paint.FontMetricsInt fontMetricsInt6 = fontMetricsInt;
                        boolean bl20 = bl;
                        boolean bl21 = bl2;
                        float[] fArray6 = fArray;
                        int n209 = n17;
                        TextUtils.TruncateAt truncateAt4 = truncateAt;
                        float f29 = f3;
                        TextPaint textPaint9 = textPaint;
                        n11 = staticLayout.out(charSequence12, n82, n83, n84, n85, n86, n87, n11, f27, f28, lineHeightSpanArray, nArray, fontMetricsInt6, bl9, bl4, n17, byArray, n53, bl6, bl16, bl20, bl21, fArray6, n209, n208, truncateAt4, f29, f5, textPaint9);
                        n82 = n83;
                    } else {
                        int n210 = n88;
                        int n211 = n82;
                        if (n210 != n211) {
                            int n212 = n88;
                            int n213 = n2;
                            boolean bl22 = n212 != n213;
                            int n214 = n14 - n17;
                            StaticLayout staticLayout = this;
                            CharSequence charSequence13 = charSequence;
                            int n215 = n82;
                            int n216 = n11;
                            float f30 = f;
                            float f31 = f2;
                            LineHeightSpan[] lineHeightSpanArray3 = lineHeightSpanArray;
                            int[] nArray3 = nArray;
                            Paint.FontMetricsInt fontMetricsInt7 = fontMetricsInt;
                            boolean bl23 = bl9;
                            boolean bl24 = bl4;
                            int n217 = n17;
                            byte[] byArray5 = byArray;
                            int n218 = n53;
                            boolean bl25 = bl6;
                            boolean bl26 = bl;
                            boolean bl27 = bl2;
                            float[] fArray7 = fArray;
                            int n219 = n17;
                            TextUtils.TruncateAt truncateAt5 = truncateAt;
                            float f32 = f3;
                            TextPaint textPaint10 = textPaint;
                            n11 = staticLayout.out(charSequence13, n215, n88, n89, n90, n91, n92, n216, f30, f31, lineHeightSpanArray3, nArray3, fontMetricsInt7, bl23, bl24, n217, byArray5, n218, bl25, bl22, bl26, bl27, fArray7, n219, n214, truncateAt5, f32, f6, textPaint10);
                            n82 = n88;
                        } else {
                            TextPaint textPaint11 = this.mWorkPaint;
                            int n220 = n82 + 1;
                            TextPaint textPaint12 = textPaint;
                            CharSequence charSequence14 = charSequence;
                            int n221 = n82;
                            Paint.FontMetricsInt fontMetricsInt8 = fontMetricsInt;
                            boolean bl28 = bl9;
                            float f33 = StaticLayout.measureText(textPaint12, textPaint11, charSequence14, n221, n220, fontMetricsInt8, bl28, null);
                            int n222 = n82 + 1;
                            int n223 = fontMetricsInt.ascent;
                            int n224 = fontMetricsInt.descent;
                            int n225 = fontMetricsInt.top;
                            int n226 = fontMetricsInt.bottom;
                            int n227 = n82 + 1;
                            int n228 = n2;
                            boolean bl29 = n227 != n228;
                            int n229 = n14 - n17;
                            int n230 = n82 - n17;
                            float f34 = fArray[n230];
                            StaticLayout staticLayout = this;
                            CharSequence charSequence15 = charSequence;
                            int n231 = n82++;
                            int n232 = n11;
                            float f35 = f;
                            float f36 = f2;
                            LineHeightSpan[] lineHeightSpanArray4 = lineHeightSpanArray;
                            int[] nArray4 = nArray;
                            Paint.FontMetricsInt fontMetricsInt9 = fontMetricsInt;
                            boolean bl30 = bl9;
                            boolean bl31 = bl4;
                            int n233 = n17;
                            byte[] byArray6 = byArray;
                            int n234 = n53;
                            boolean bl32 = bl6;
                            boolean bl33 = bl;
                            boolean bl34 = bl2;
                            float[] fArray8 = fArray;
                            int n235 = n17;
                            TextUtils.TruncateAt truncateAt6 = truncateAt;
                            float f37 = f3;
                            TextPaint textPaint13 = textPaint;
                            n11 = staticLayout.out(charSequence15, n231, n222, n223, n224, n225, n226, n232, f35, f36, lineHeightSpanArray4, nArray4, fontMetricsInt9, bl30, bl31, n233, byArray6, n234, bl32, bl29, bl33, bl34, fArray8, n235, n229, truncateAt6, f37, f34, textPaint13);
                        }
                    }
                    if (n82 < n93) {
                        n101 = n82;
                        n96 = n82;
                    } else {
                        n96 = n82 - 1;
                    }
                    n88 = n82;
                    n83 = n82;
                    f4 = 0.0f;
                    n91 = n92 = 0;
                    n90 = n92;
                    n89 = n92;
                    n86 = n87 = 0;
                    n85 = n87;
                    n84 = n87;
                    if ((n28 += -1) > 0) continue;
                    n81 = n30;
                }
                n93 = n101;
            }
        }
        if ((n7 = n2) != (n6 = n) && (charSequence2 = charSequence).charAt(n5 = (n4 = n2 - 1)) != '\n') {
            return;
        }
        TextPaint textPaint14 = textPaint;
        Paint.FontMetricsInt fontMetricsInt10 = fontMetricsInt;
        int n236 = textPaint14.getFontMetricsInt(fontMetricsInt10);
        int n237 = fontMetricsInt.ascent;
        int n238 = fontMetricsInt.descent;
        int n239 = fontMetricsInt.top;
        int n240 = fontMetricsInt.bottom;
        StaticLayout staticLayout = this;
        CharSequence charSequence16 = charSequence;
        int n241 = n2;
        int n242 = n2;
        int n243 = n11;
        float f38 = f;
        float f39 = f2;
        Paint.FontMetricsInt fontMetricsInt11 = fontMetricsInt;
        boolean bl35 = bl4;
        int n244 = n2;
        byte[] byArray7 = byArray;
        boolean bl36 = bl;
        boolean bl37 = bl2;
        float[] fArray9 = fArray;
        int n245 = n;
        TextUtils.TruncateAt truncateAt7 = truncateAt;
        float f40 = f3;
        TextPaint textPaint15 = textPaint;
        int n246 = staticLayout.out(charSequence16, n241, n242, n237, n238, n239, n240, n243, f38, f39, null, null, fontMetricsInt11, false, bl35, n244, byArray7, n16, true, true, bl36, bl37, fArray9, n245, 0, truncateAt7, f40, 0.0f, textPaint15);
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getEllipsisCount(int n) {
        if (this.mColumns < 5) {
            return 0;
        }
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 4;
        return nArray[n2];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getEllipsisStart(int n) {
        if (this.mColumns < 5) {
            return 0;
        }
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 3;
        return nArray[n2];
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getLineContainsTab(int n) {
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 0;
        if ((nArray[n2] & 0x20000000) == 0) return false;
        return true;
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    @Override
    public int getLineDescent(int n) {
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 2;
        return nArray[n2];
    }

    @Override
    public final Layout.Directions getLineDirections(int n) {
        return this.mLineDirections[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getLineForVertical(int n) {
        int n2 = this.mLineCount;
        int n3 = -1;
        int[] nArray = this.mLines;
        while (n2 - n3 > 1) {
            int n4 = n2 + n3 >> 1;
            int n5 = this.mColumns * n4 + 1;
            if (nArray[n5] > n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 >= 0) return n3;
        return 0;
    }

    @Override
    public int getLineStart(int n) {
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 0;
        return nArray[n2] & 0x1FFFFFFF;
    }

    @Override
    public int getLineTop(int n) {
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 1;
        return nArray[n2];
    }

    @Override
    public int getParagraphDirection(int n) {
        int[] nArray = this.mLines;
        int n2 = this.mColumns * n + 0;
        return nArray[n2] >> 30;
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }
}

