/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.AndroidCharacter;
import android.text.Annotation;
import android.text.Editable;
import android.text.GetChars;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.Styled;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.Printer;
import com.android.internal.util.ArrayUtils;
import java.util.Iterator;
import java.util.regex.Pattern;

public class TextUtils {
    public static final int ABSOLUTE_SIZE_SPAN = 16;
    public static final int ALIGNMENT_SPAN = 1;
    public static final int ANNOTATION = 18;
    public static final int BACKGROUND_COLOR_SPAN = 12;
    public static final int BULLET_SPAN = 8;
    public static final int CAP_MODE_CHARACTERS = 4096;
    public static final int CAP_MODE_SENTENCES = 16384;
    public static final int CAP_MODE_WORDS = 8192;
    public static final Parcelable.Creator<CharSequence> CHAR_SEQUENCE_CREATOR;
    private static String[] EMPTY_STRING_ARRAY;
    public static final int FOREGROUND_COLOR_SPAN = 2;
    public static final int LEADING_MARGIN_SPAN = 10;
    public static final int QUOTE_SPAN = 9;
    public static final int RELATIVE_SIZE_SPAN = 3;
    public static final int SCALE_X_SPAN = 4;
    public static final int STRIKETHROUGH_SPAN = 5;
    public static final int STYLE_SPAN = 7;
    public static final int SUBSCRIPT_SPAN = 15;
    public static final int SUPERSCRIPT_SPAN = 14;
    public static final int TEXT_APPEARANCE_SPAN = 17;
    public static final int TYPEFACE_SPAN = 13;
    public static final int UNDERLINE_SPAN = 6;
    public static final int URL_SPAN = 11;
    private static String sEllipsis;
    private static Object sLock;
    private static char[] sTemp;

    static {
        EMPTY_STRING_ARRAY = new String[0];
        CHAR_SEQUENCE_CREATOR = new Parcelable.Creator<CharSequence>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public CharSequence createFromParcel(Parcel parcel) {
                void var2_3;
                if (parcel.readInt() == 1) {
                    String string2 = parcel.readString();
                    return var2_3;
                }
                String string3 = parcel.readString();
                SpannableString spannableString = new SpannableString(string3);
                block21: while (true) {
                    int n;
                    if ((n = parcel.readInt()) == 0) {
                        SpannableString spannableString2 = spannableString;
                        return var2_3;
                    }
                    switch (n) {
                        default: {
                            String string4 = "bogus span encoding " + n;
                            throw new RuntimeException(string4);
                        }
                        case 1: {
                            AlignmentSpan.Standard standard = new AlignmentSpan.Standard(parcel);
                            TextUtils.readSpan(parcel, spannableString, standard);
                            continue block21;
                        }
                        case 2: {
                            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, foregroundColorSpan);
                            continue block21;
                        }
                        case 3: {
                            RelativeSizeSpan relativeSizeSpan = new RelativeSizeSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, relativeSizeSpan);
                            continue block21;
                        }
                        case 4: {
                            ScaleXSpan scaleXSpan = new ScaleXSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, scaleXSpan);
                            continue block21;
                        }
                        case 5: {
                            StrikethroughSpan strikethroughSpan = new StrikethroughSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, strikethroughSpan);
                            continue block21;
                        }
                        case 6: {
                            UnderlineSpan underlineSpan = new UnderlineSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, underlineSpan);
                            continue block21;
                        }
                        case 7: {
                            StyleSpan styleSpan = new StyleSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, styleSpan);
                            continue block21;
                        }
                        case 8: {
                            BulletSpan bulletSpan = new BulletSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, bulletSpan);
                            continue block21;
                        }
                        case 9: {
                            QuoteSpan quoteSpan = new QuoteSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, quoteSpan);
                            continue block21;
                        }
                        case 10: {
                            LeadingMarginSpan.Standard standard = new LeadingMarginSpan.Standard(parcel);
                            TextUtils.readSpan(parcel, spannableString, standard);
                            continue block21;
                        }
                        case 11: {
                            URLSpan uRLSpan = new URLSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, uRLSpan);
                            continue block21;
                        }
                        case 12: {
                            BackgroundColorSpan backgroundColorSpan = new BackgroundColorSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, backgroundColorSpan);
                            continue block21;
                        }
                        case 13: {
                            TypefaceSpan typefaceSpan = new TypefaceSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, typefaceSpan);
                            continue block21;
                        }
                        case 14: {
                            SuperscriptSpan superscriptSpan = new SuperscriptSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, superscriptSpan);
                            continue block21;
                        }
                        case 15: {
                            SubscriptSpan subscriptSpan = new SubscriptSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, subscriptSpan);
                            continue block21;
                        }
                        case 16: {
                            AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, absoluteSizeSpan);
                            continue block21;
                        }
                        case 17: {
                            TextAppearanceSpan textAppearanceSpan = new TextAppearanceSpan(parcel);
                            TextUtils.readSpan(parcel, spannableString, textAppearanceSpan);
                            continue block21;
                        }
                        case 18: 
                    }
                    Annotation annotation = new Annotation(parcel);
                    TextUtils.readSpan(parcel, spannableString, annotation);
                }
            }

            public CharSequence[] newArray(int n) {
                return new CharSequence[n];
            }
        };
        sEllipsis = null;
        sLock = new Object();
        sTemp = null;
    }

    private TextUtils() {
    }

    private static String blank(CharSequence charSequence, int n, int n2) {
        int n3 = charSequence.length();
        char[] cArray = TextUtils.obtain(n3);
        if (n != 0) {
            TextUtils.getChars(charSequence, 0, n, cArray, 0);
        }
        if (n2 != n3) {
            TextUtils.getChars(charSequence, n2, n3, cArray, n2);
        }
        if (n != n2) {
            cArray[n] = 8230;
            for (int i = n + 1; i < n2; ++i) {
                cArray[i] = 65279;
            }
        }
        String string2 = new String(cArray, 0, n3);
        TextUtils.recycle(cArray);
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence commaEllipsize(CharSequence charSequence, TextPaint textPaint, float f, String string2, String string3) {
        float[] fArray;
        int n = charSequence.length();
        char[] cArray = new char[n];
        CharSequence charSequence2 = charSequence;
        int n2 = 0;
        int n3 = n;
        char[] cArray2 = cArray;
        int n4 = 0;
        TextUtils.getChars(charSequence2, n2, n3, cArray2, n4);
        int n5 = 0;
        int n6 = 0;
        while (0 < n) {
            int n7 = cArray[0] == ',' ? n6 + 1 : n6;
            int n8 = 0 + 1;
            n6 = n7;
        }
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            TextPaint textPaint2 = new TextPaint();
            fArray = new float[n * 2];
            n5 = 0;
            while (n5 < n) {
                int n9 = spanned.nextSpanTransition(n5, n, MetricAffectingSpan.class);
                int n10 = Styled.getTextWidths(textPaint, textPaint2, spanned, n5, n9, fArray, null);
                int n11 = n + n5;
                int n12 = n9 - n5;
                System.arraycopy(fArray, 0, fArray, n11, n12);
                n5 = n9;
            }
            System.arraycopy(fArray, n, fArray, 0, n);
        } else {
            fArray = new float[n];
            TextPaint textPaint3 = textPaint;
            CharSequence charSequence3 = charSequence;
            int n13 = 0;
            int n14 = n;
            float[] fArray2 = fArray;
            int n15 = textPaint3.getTextWidths(charSequence3, n13, n14, fArray2);
        }
        int n16 = n6 + 1;
        int n17 = 0;
        int n18 = 0;
        int n19 = n16;
        int n20 = 0;
        int n21 = 0;
        String string4 = "";
        while (true) {
            String string5;
            int n22;
            int n23;
            int n24;
            block10: {
                block9: {
                    SpannableStringBuilder spannableStringBuilder;
                    block8: {
                        float f2;
                        String string6;
                        TextPaint textPaint4;
                        float f3;
                        String string7;
                        if (n18 >= n) break block8;
                        float f4 = n21;
                        float f5 = fArray[n18];
                        n24 = (int)(f4 + f5);
                        if (cArray[n18] != ',') break block9;
                        int n25 = n17 + 1;
                        int n26 = n6 - n25 + 1;
                        int n27 = n26;
                        int n28 = 1;
                        if (n27 == n28) {
                            StringBuilder stringBuilder = new StringBuilder().append(" ");
                            String string8 = string2;
                            string7 = stringBuilder.append(string8).toString();
                        } else {
                            StringBuilder stringBuilder = new StringBuilder().append(" ");
                            Object[] objectArray = new Object[1];
                            Integer n29 = n26;
                            objectArray[0] = n29;
                            String string9 = string3;
                            Object[] objectArray2 = objectArray;
                            String string10 = String.format(string9, objectArray2);
                            string7 = stringBuilder.append(string10).toString();
                        }
                        if (!((f3 = (textPaint4 = textPaint).measureText(string6 = string7)) + (f2 = (float)n24) <= f)) break block9;
                        int n30 = n18 + 1;
                        n23 = n26;
                        String string11 = string7;
                        n22 = n30;
                        string5 = string11;
                        break block10;
                    }
                    if ((float)n21 <= f) {
                        return charSequence;
                    }
                    SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
                    String string12 = string4;
                    spannableStringBuilder2(string12);
                    SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder;
                    int n31 = 0;
                    CharSequence charSequence4 = charSequence;
                    int n32 = 0;
                    int n33 = n20;
                    Editable editable = spannableStringBuilder3.insert(n31, charSequence4, n32, n33);
                    return spannableStringBuilder;
                }
                string5 = string4;
                n22 = n20;
                n23 = n19;
            }
            ++n18;
            string4 = string5;
            n19 = n23;
            n20 = n22;
            n21 = n24;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CharSequence concat(CharSequence ... charSequenceArray) {
        int n;
        int n2;
        StringBuilder stringBuilder;
        void var1_2;
        if (charSequenceArray.length == 0) {
            return var1_2;
        }
        if (charSequenceArray.length == 1) {
            CharSequence charSequence = charSequenceArray[0];
            return var1_2;
        }
        boolean bl = false;
        int n3 = 0;
        while (true) {
            block11: {
                int n4;
                block10: {
                    int n5;
                    if (n3 >= (n5 = charSequenceArray.length)) break block10;
                    if (!(charSequenceArray[n3] instanceof Spanned)) break block11;
                    bl = true;
                }
                stringBuilder = new StringBuilder();
                for (n2 = 0; n2 < (n4 = charSequenceArray.length); ++n2) {
                    CharSequence charSequence = charSequenceArray[n2];
                    StringBuilder stringBuilder2 = stringBuilder.append(charSequence);
                }
                break;
            }
            ++n3;
        }
        if (!bl) {
            String string2 = stringBuilder.toString();
            return var1_2;
        }
        SpannableString spannableString = new SpannableString(stringBuilder);
        int n6 = 0;
        n2 = 0;
        while (n2 < (n = charSequenceArray.length)) {
            int n7 = charSequenceArray[n2].length();
            if (charSequenceArray[n2] instanceof Spanned) {
                TextUtils.copySpansFrom((Spanned)charSequenceArray[n2], 0, n7, Object.class, spannableString, n6);
            }
            n6 += n7;
            int n8 = n2 + 1;
        }
        SpannedString spannedString = new SpannedString(spannableString);
        return var1_2;
    }

    public static void copySpansFrom(Spanned spanned, int n, int n2, Class clazz, Spannable spannable, int n3) {
        if (clazz == null) {
            clazz = Object.class;
        }
        Object[] objectArray = spanned.getSpans(n, n2, clazz);
        int n4 = 0;
        int n5;
        while (n4 < (n5 = objectArray.length)) {
            Object object = objectArray[n4];
            int n6 = spanned.getSpanStart(object);
            Object object2 = objectArray[n4];
            int n7 = spanned.getSpanEnd(object2);
            Object object3 = objectArray[n4];
            int n8 = spanned.getSpanFlags(object3);
            if (n6 < n) {
                n6 = n;
            }
            if (n7 > n2) {
                n7 = n2;
            }
            Object object4 = objectArray[n4];
            int n9 = n6 - n + n3;
            int n10 = n7 - n + n3;
            spannable.setSpan(object4, n9, n10, n8);
            ++n4;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean delimitedStringContains(String string2, char c, String string3) {
        int n;
        if (TextUtils.isEmpty(string2)) return false;
        if (TextUtils.isEmpty(string3)) {
            return false;
        }
        int n2 = -1;
        int n3 = string2.length();
        while ((n2 = string2.indexOf(string3, n = n2 + 1)) != -1) {
            int n4;
            if (n2 > 0 && string2.charAt(n4 = n2 - 1) == c) continue;
            int n5 = string3.length();
            int n6 = n2 + n5;
            if (n6 != n3) {
                return true;
            }
            if (string2.charAt(n6) != c) return true;
        }
        return false;
    }

    public static void dumpSpans(CharSequence charSequence, Printer printer, String string2) {
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            int n = charSequence.length();
            Object[] objectArray = spanned.getSpans(0, n, Object.class);
            int n2 = 0;
            while (true) {
                int n3;
                if (n2 >= (n3 = objectArray.length)) {
                    return;
                }
                Object object = objectArray[n2];
                StringBuilder stringBuilder = new StringBuilder().append(string2);
                int n4 = spanned.getSpanStart(object);
                int n5 = spanned.getSpanEnd(object);
                CharSequence charSequence2 = charSequence.subSequence(n4, n5);
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence2).append(": ");
                String string3 = Integer.toHexString(System.identityHashCode(object));
                StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" ");
                String string4 = object.getClass().getCanonicalName();
                StringBuilder stringBuilder4 = stringBuilder3.append(string4).append(" (");
                int n6 = spanned.getSpanStart(object);
                StringBuilder stringBuilder5 = stringBuilder4.append(n6).append("-");
                int n7 = spanned.getSpanEnd(object);
                StringBuilder stringBuilder6 = stringBuilder5.append(n7).append(") fl=#");
                int n8 = spanned.getSpanFlags(object);
                String string5 = stringBuilder6.append(n8).toString();
                printer.println(string5);
                ++n2;
            }
        }
        String string6 = string2 + charSequence + ": (no spans)";
        printer.println(string6);
    }

    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt) {
        CharSequence charSequence2 = charSequence;
        TextPaint textPaint2 = textPaint;
        float f2 = f;
        TruncateAt truncateAt2 = truncateAt;
        return TextUtils.ellipsize(charSequence2, textPaint2, f2, truncateAt2, false, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt, boolean bl, EllipsizeCallback ellipsizeCallback) {
        SpannableStringBuilder spannableStringBuilder;
        float f2;
        Spanned spanned;
        float[] fArray;
        int n;
        block36: {
            SpannableStringBuilder spannableStringBuilder2;
            int n2;
            block35: {
                SpannableStringBuilder spannableStringBuilder3;
                block34: {
                    if (sEllipsis == null) {
                        sEllipsis = Resources.getSystem().getString(17039537);
                    }
                    n = charSequence.length();
                    if (!(charSequence instanceof Spanned)) {
                        TextPaint textPaint2 = textPaint;
                        CharSequence charSequence2 = charSequence;
                        int n3 = 0;
                        int n4 = n;
                        if (textPaint2.measureText(charSequence2, n3, n4) <= f) {
                            if (ellipsizeCallback == null) return charSequence;
                            EllipsizeCallback ellipsizeCallback2 = ellipsizeCallback;
                            int n5 = 0;
                            int n6 = 0;
                            ellipsizeCallback2.ellipsized(n5, n6);
                            return charSequence;
                        }
                        TextPaint textPaint3 = textPaint;
                        String string2 = sEllipsis;
                        String string3 = string2;
                        float f3 = textPaint3.measureText(string3);
                        if (f3 > f) {
                            if (ellipsizeCallback != null) {
                                EllipsizeCallback ellipsizeCallback3 = ellipsizeCallback;
                                int n7 = 0;
                                int n8 = n;
                                ellipsizeCallback3.ellipsized(n7, n8);
                            }
                            if (!bl) {
                                return "";
                            }
                            char[] cArray = TextUtils.obtain(n);
                            int n9 = 0;
                            while (true) {
                                if (n9 >= n) {
                                    String string4;
                                    String string5 = string4;
                                    char[] cArray2 = cArray;
                                    int n10 = 0;
                                    int n11 = n;
                                    string5(cArray2, n10, n11);
                                    TextUtils.recycle(cArray);
                                    return string4;
                                }
                                cArray[n9] = 65279;
                                ++n9;
                            }
                        }
                        TruncateAt truncateAt2 = truncateAt;
                        TruncateAt truncateAt3 = TruncateAt.START;
                        TruncateAt truncateAt4 = truncateAt3;
                        if (truncateAt2 == truncateAt4) {
                            float f4 = f - f3;
                            TextPaint textPaint4 = textPaint;
                            CharSequence charSequence3 = charSequence;
                            int n12 = textPaint4.breakText(charSequence3, 0, n, false, f4, null);
                            if (ellipsizeCallback != null) {
                                int n13 = n - n12;
                                EllipsizeCallback ellipsizeCallback4 = ellipsizeCallback;
                                int n14 = 0;
                                int n15 = n13;
                                ellipsizeCallback4.ellipsized(n14, n15);
                            }
                            if (bl) {
                                int n16 = n - n12;
                                CharSequence charSequence4 = charSequence;
                                int n17 = 0;
                                int n18 = n16;
                                return TextUtils.blank(charSequence4, n17, n18);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            String string6 = sEllipsis;
                            StringBuilder stringBuilder2 = stringBuilder.append(string6);
                            String string7 = ((Object)charSequence).toString();
                            int n19 = n - n12;
                            String string8 = string7;
                            int n20 = n19;
                            int n21 = n;
                            String string9 = string8.substring(n20, n21);
                            StringBuilder stringBuilder3 = stringBuilder2;
                            String string10 = string9;
                            return stringBuilder3.append(string10).toString();
                        }
                        TruncateAt truncateAt5 = truncateAt;
                        TruncateAt truncateAt6 = TruncateAt.END;
                        TruncateAt truncateAt7 = truncateAt6;
                        if (truncateAt5 == truncateAt7) {
                            float f5 = f - f3;
                            TextPaint textPaint5 = textPaint;
                            CharSequence charSequence5 = charSequence;
                            int n22 = textPaint5.breakText(charSequence5, 0, n, true, f5, null);
                            if (ellipsizeCallback != null) {
                                EllipsizeCallback ellipsizeCallback5 = ellipsizeCallback;
                                int n23 = n22;
                                int n24 = n;
                                ellipsizeCallback5.ellipsized(n23, n24);
                            }
                            if (bl) {
                                CharSequence charSequence6 = charSequence;
                                int n25 = n22;
                                int n26 = n;
                                return TextUtils.blank(charSequence6, n25, n26);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            String string11 = ((Object)charSequence).toString();
                            int n27 = 0;
                            int n28 = n22;
                            String string12 = string11.substring(n27, n28);
                            StringBuilder stringBuilder4 = stringBuilder;
                            String string13 = string12;
                            StringBuilder stringBuilder5 = stringBuilder4.append(string13);
                            String string14 = sEllipsis;
                            return stringBuilder5.append(string14).toString();
                        }
                        float f6 = (f - f3) / 2.0f;
                        TextPaint textPaint6 = textPaint;
                        CharSequence charSequence7 = charSequence;
                        int n29 = textPaint6.breakText(charSequence7, 0, n, false, f6, null);
                        int n30 = n - n29;
                        TextPaint textPaint7 = textPaint;
                        CharSequence charSequence8 = charSequence;
                        int n31 = n30;
                        int n32 = n;
                        float f7 = textPaint7.measureText(charSequence8, n31, n32);
                        int n33 = n - n29;
                        float f8 = f - f3 - f7;
                        TextPaint textPaint8 = textPaint;
                        CharSequence charSequence9 = charSequence;
                        int n34 = textPaint8.breakText(charSequence9, 0, n33, true, f8, null);
                        if (ellipsizeCallback != null) {
                            int n35 = n - n29;
                            EllipsizeCallback ellipsizeCallback6 = ellipsizeCallback;
                            int n36 = n34;
                            int n37 = n35;
                            ellipsizeCallback6.ellipsized(n36, n37);
                        }
                        if (bl) {
                            int n38 = n - n29;
                            return TextUtils.blank(charSequence, n34, n38);
                        }
                        String string15 = ((Object)charSequence).toString();
                        StringBuilder stringBuilder = new StringBuilder();
                        String string16 = string15;
                        int n39 = 0;
                        int n40 = n34;
                        String string17 = string16.substring(n39, n40);
                        StringBuilder stringBuilder6 = stringBuilder;
                        String string18 = string17;
                        StringBuilder stringBuilder7 = stringBuilder6.append(string18);
                        String string19 = sEllipsis;
                        StringBuilder stringBuilder8 = stringBuilder7.append(string19);
                        int n41 = n - n29;
                        String string20 = string15;
                        int n42 = n41;
                        int n43 = n;
                        String string21 = string20.substring(n42, n43);
                        StringBuilder stringBuilder9 = stringBuilder8;
                        String string22 = string21;
                        return stringBuilder9.append(string22).toString();
                    }
                    fArray = new float[n * 2];
                    TextPaint textPaint9 = new TextPaint();
                    spanned = (Spanned)charSequence;
                    int n44 = 0;
                    while (n44 < n) {
                        int n45 = spanned.nextSpanTransition(n44, n, MetricAffectingSpan.class);
                        int n46 = Styled.getTextWidths(textPaint, textPaint9, spanned, n44, n45, fArray, null);
                        int n47 = n + n44;
                        int n48 = n45 - n44;
                        System.arraycopy(fArray, 0, fArray, n47, n48);
                        n44 = n45;
                    }
                    float f9 = 0.0f;
                    n2 = 0;
                    while (n2 < n) {
                        int n49 = n + n2;
                        float f10 = fArray[n49];
                        f9 += f10;
                        int n50 = n2 + 1;
                    }
                    if (f9 <= f) {
                        if (ellipsizeCallback == null) return charSequence;
                        EllipsizeCallback ellipsizeCallback7 = ellipsizeCallback;
                        int n51 = 0;
                        int n52 = 0;
                        ellipsizeCallback7.ellipsized(n51, n52);
                        return charSequence;
                    }
                    TextPaint textPaint10 = textPaint;
                    String string23 = sEllipsis;
                    String string24 = string23;
                    f2 = textPaint10.measureText(string24);
                    if (f2 > f) {
                        if (ellipsizeCallback != null) {
                            EllipsizeCallback ellipsizeCallback8 = ellipsizeCallback;
                            int n53 = 0;
                            int n54 = n;
                            ellipsizeCallback8.ellipsized(n53, n54);
                        }
                        if (!bl) {
                            return "";
                        }
                        char[] cArray = TextUtils.obtain(n);
                        n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                SpannableString spannableString;
                                String string25;
                                String string26 = string25;
                                char[] cArray3 = cArray;
                                int n55 = 0;
                                int n56 = n;
                                string26(cArray3, n55, n56);
                                SpannableString spannableString2 = spannableString;
                                String string27 = string25;
                                spannableString2(string27);
                                TextUtils.recycle(cArray);
                                Spanned spanned2 = spanned;
                                int n57 = n;
                                TextUtils.copySpansFrom(spanned2, 0, n57, Object.class, spannableString, 0);
                                return spannableString;
                            }
                            cArray[n2] = 65279;
                            int n58 = n2 + 1;
                        }
                    }
                    TruncateAt truncateAt8 = truncateAt;
                    TruncateAt truncateAt9 = TruncateAt.START;
                    TruncateAt truncateAt10 = truncateAt9;
                    if (truncateAt8 == truncateAt10) break block34;
                    TruncateAt truncateAt11 = truncateAt;
                    TruncateAt truncateAt12 = TruncateAt.END;
                    TruncateAt truncateAt13 = truncateAt12;
                    if (truncateAt11 == truncateAt13) break block35;
                    break block36;
                }
                float f11 = 0.0f;
                n2 = n;
                while (true) {
                    int n59;
                    float f12;
                    if (n2 < 0 || (f12 = fArray[n59 = n + n2 - 1]) + f11 + f2 > f) {
                        SpannableString spannableString;
                        if (ellipsizeCallback != null) {
                            EllipsizeCallback ellipsizeCallback9 = ellipsizeCallback;
                            int n60 = 0;
                            int n61 = n2;
                            ellipsizeCallback9.ellipsized(n60, n61);
                        }
                        if (!bl) break;
                        CharSequence charSequence10 = charSequence;
                        int n62 = 0;
                        int n63 = n2;
                        String string28 = TextUtils.blank(charSequence10, n62, n63);
                        SpannableString spannableString3 = spannableString;
                        String string29 = string28;
                        spannableString3(string29);
                        Spanned spanned3 = spanned;
                        int n64 = n;
                        TextUtils.copySpansFrom(spanned3, 0, n64, Object.class, spannableString, 0);
                        return spannableString;
                    }
                    f11 += f12;
                    n2 += -1;
                }
                String string30 = sEllipsis;
                SpannableStringBuilder spannableStringBuilder4 = spannableStringBuilder3 = new SpannableStringBuilder(string30);
                int n65 = 1;
                CharSequence charSequence11 = charSequence;
                int n66 = n2;
                int n67 = n;
                Editable editable = spannableStringBuilder4.insert(n65, charSequence11, n66, n67);
                return spannableStringBuilder3;
            }
            float f13 = 0.0f;
            n2 = 0;
            while (true) {
                int n68;
                float f14;
                if (n2 >= n || (f14 = fArray[n68 = n + n2]) + f13 + f2 > f) {
                    SpannableString spannableString;
                    if (ellipsizeCallback != null) {
                        EllipsizeCallback ellipsizeCallback10 = ellipsizeCallback;
                        int n69 = n2;
                        int n70 = n;
                        ellipsizeCallback10.ellipsized(n69, n70);
                    }
                    if (!bl) break;
                    CharSequence charSequence12 = charSequence;
                    int n71 = n2;
                    int n72 = n;
                    String string31 = TextUtils.blank(charSequence12, n71, n72);
                    SpannableString spannableString4 = spannableString;
                    String string32 = string31;
                    spannableString4(string32);
                    Spanned spanned4 = spanned;
                    int n73 = n;
                    TextUtils.copySpansFrom(spanned4, 0, n73, Object.class, spannableString, 0);
                    return spannableString;
                }
                f13 += f14;
                ++n2;
            }
            String string33 = sEllipsis;
            SpannableStringBuilder spannableStringBuilder5 = spannableStringBuilder2 = new SpannableStringBuilder(string33);
            int n74 = 0;
            CharSequence charSequence13 = charSequence;
            int n75 = 0;
            int n76 = n2;
            Editable editable = spannableStringBuilder5.insert(n74, charSequence13, n75, n76);
            return spannableStringBuilder2;
        }
        int n77 = 0;
        float f15 = 0.0f;
        int n78 = n;
        float f16 = (f - f2) / 2.0f;
        int n79 = n;
        while (true) {
            int n80;
            float f17;
            if (n79 < 0 || (f17 = fArray[n80 = n + n79 - 1]) + f15 > f16) break;
            f15 += f17;
            n79 += -1;
        }
        f2 = f - f2 - f15;
        int n81 = 0;
        int n82 = n77;
        while (true) {
            int n83;
            int n84;
            int n85;
            if ((n85 = ++n81) >= (n84 = n79) || (n77 = fArray[n83 = n + n81]) + truncateAt > f2) {
                SpannableString spannableString;
                if (ellipsizeCallback != null) {
                    EllipsizeCallback ellipsizeCallback11 = ellipsizeCallback;
                    int n86 = n81;
                    int n87 = n79;
                    ellipsizeCallback11.ellipsized(n86, n87);
                }
                if (!bl) break;
                CharSequence charSequence14 = charSequence;
                int n88 = n81;
                int n89 = n79;
                String string34 = TextUtils.blank(charSequence14, n88, n89);
                SpannableString spannableString5 = spannableString;
                String string35 = string34;
                spannableString5(string35);
                Spanned spanned5 = spanned;
                int n90 = n;
                TextUtils.copySpansFrom(spanned5, 0, n90, Object.class, spannableString, 0);
                return spannableString;
            }
            reference var3_12 = truncateAt + n77;
        }
        String string36 = sEllipsis;
        SpannableStringBuilder spannableStringBuilder6 = spannableStringBuilder;
        String string37 = string36;
        spannableStringBuilder6(string37);
        SpannableStringBuilder spannableStringBuilder7 = spannableStringBuilder;
        int n91 = 0;
        CharSequence charSequence15 = charSequence;
        int n92 = 0;
        int n93 = n81;
        Editable editable = spannableStringBuilder7.insert(n91, charSequence15, n92, n93);
        int n94 = spannableStringBuilder.length();
        SpannableStringBuilder spannableStringBuilder8 = spannableStringBuilder;
        int n95 = n94;
        CharSequence charSequence16 = charSequence;
        int n96 = n79;
        int n97 = n;
        Editable editable2 = spannableStringBuilder8.insert(n95, charSequence16, n96, n97);
        return spannableStringBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null) return false;
        if (charSequence2 == null) return false;
        int n2 = charSequence.length();
        if (n2 == (n = charSequence2.length())) return false;
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return charSequence.equals(charSequence2);
        }
        int n3 = 0;
        while (n3 < n2) {
            char c;
            char c2 = charSequence.charAt(n3);
            if (c2 != (c = charSequence2.charAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static CharSequence expandTemplate(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (charSequenceArray.length > 9) {
            throw new IllegalArgumentException("max of 9 values are supported");
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence);
        int n = 0;
        while (true) {
            block8: {
                int n2;
                block9: {
                    try {
                        int n3;
                        while (n < (n3 = spannableStringBuilder.length())) {
                            if (spannableStringBuilder.charAt(n) != '^') break block8;
                            int n4 = n + 1;
                            char c = spannableStringBuilder.charAt(n4);
                            if (c == '^') {
                                int n5 = n + 1;
                                int n6 = n + 2;
                                Editable editable = spannableStringBuilder.delete(n5, n6);
                                ++n;
                                continue;
                            }
                            if (!Character.isDigit(c)) break block8;
                            n2 = Character.getNumericValue(c) - 1;
                            if (n2 < 0) {
                                StringBuilder stringBuilder = new StringBuilder().append("template requests value ^");
                                int n7 = n2 + 1;
                                String string2 = stringBuilder.append(n7).toString();
                                throw new IllegalArgumentException(string2);
                            }
                            break block9;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    return spannableStringBuilder;
                }
                int n8 = charSequenceArray.length;
                if (n2 >= n8) {
                    StringBuilder stringBuilder = new StringBuilder().append("template requests value ^");
                    int n9 = n2 + 1;
                    StringBuilder stringBuilder2 = stringBuilder.append(n9).append("; only ");
                    int n10 = charSequenceArray.length;
                    String string3 = stringBuilder2.append(n10).append(" provided").toString();
                    throw new IllegalArgumentException(string3);
                }
                int n11 = n + 2;
                CharSequence charSequence2 = charSequenceArray[n2];
                Editable editable = spannableStringBuilder.replace(n, n11, charSequence2);
                int n12 = charSequenceArray[n2].length();
                n += n12;
                continue;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int getCapsMode(CharSequence var0, int var1_1, int var2_2) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (var1_1 < 0) {
                            var3_3 = 0;
lbl3:
                            // 8 sources

                            return var3_3;
                        }
                        var4_4 = 0;
                        if ((var2_2 & 4096) != 0) {
                            var4_4 |= 4096;
                        }
                        if ((var2_2 & 24576) != 0) break block9;
                        var3_3 = var4_4;
                        ** GOTO lbl3
                    }
                    var5_5 = var1_1;
                    while (true) {
                        if (var5_5 <= 0 || (var7_7 = var0.charAt(var6_6 = var5_5 - 1)) != '\"' && var7_7 != '\'' && Character.getType(var7_7) != 21) {
                            for (var8_8 = var5_5; var8_8 > 0 && ((var7_7 = var0.charAt(var9_9 = var8_8 - 1)) == ' ' || var7_7 == '\t'); var8_8 += -1) {
                            }
                            break;
                        }
                        var5_5 += -1;
                    }
                    if (var8_8 != 0 && var0.charAt(var10_10 = var8_8 - 1) != '\n') break block10;
                    var3_3 = var4_4 | 8192;
                    ** GOTO lbl3
                }
                if ((var2_2 & 16384) != 0) break block11;
                if (var5_5 != var8_8) {
                    var4_4 |= 8192;
                }
                var3_3 = var4_4;
                ** GOTO lbl3
            }
            if (var5_5 == var8_8) ** GOTO lbl34
            var3_3 = var4_4;
            ** GOTO lbl3
lbl-1000:
            // 1 sources

            {
                var8_8 += -1;
lbl34:
                // 2 sources

                ** while (var8_8 > 0 && ((var7_7 = var0.charAt((int)(var11_11 = var8_8 - 1))) == '\"' || var7_7 == '\'' || Character.getType((char)var7_7) == 22))
            }
lbl35:
            // 1 sources

            if (var8_8 <= 0 || (var7_7 = var0.charAt(var12_12 = var8_8 - 1)) != '.' && var7_7 != '?' && var7_7 != '!') break block12;
            if (var7_7 != '.') ** GOTO lbl46
            var13_13 = var8_8 - 2;
            while (true) {
                block15: {
                    block13: {
                        block14: {
                            if (var13_13 < 0) break block13;
                            var7_7 = var0.charAt(var13_13);
                            if (var7_7 != '.') break block14;
                            var3_3 = var4_4;
                            ** GOTO lbl3
                        }
                        if (Character.isLetter(var7_7)) break block15;
                    }
                    var3_3 = var4_4 | 16384;
                    ** GOTO lbl3
                }
                var13_13 += -1;
            }
        }
        var3_3 = var4_4;
        ** while (true)
    }

    public static void getChars(CharSequence charSequence, int n, int n2, char[] cArray, int n3) {
        Class<? extends Object> clazz = charSequence.getClass();
        if (clazz == String.class) {
            ((String)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        if (clazz == StringBuffer.class) {
            ((StringBuffer)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        if (clazz == StringBuilder.class) {
            ((StringBuilder)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        if (charSequence instanceof GetChars) {
            ((GetChars)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        int n4 = n3;
        for (int i = n; i < n2; ++i) {
            char c;
            int n5 = n4 + 1;
            cArray[n4] = c = charSequence.charAt(i);
            n4 = n5;
        }
        int n6 = n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getOffsetAfter(CharSequence charSequence, int n) {
        int n2;
        int n3;
        char c;
        int n4 = charSequence.length();
        if (n != n4) {
            return n4;
        }
        int n5 = n4 - 1;
        if (n != n5) {
            return n4;
        }
        char c2 = charSequence.charAt(n);
        n = c2 >= '\ud800' && c2 <= '\udbff' ? ((c = charSequence.charAt(n3 = n + 1)) >= '\udc00' && c <= '\udfff' ? (n += 2) : ++n) : ++n;
        if (!(charSequence instanceof Spanned)) return n;
        ReplacementSpan[] replacementSpanArray = ((Spanned)charSequence).getSpans(n, n, ReplacementSpan.class);
        int n6 = 0;
        while (n6 < (n2 = replacementSpanArray.length)) {
            Spanned spanned = (Spanned)charSequence;
            ReplacementSpan replacementSpan = replacementSpanArray[n6];
            int n7 = spanned.getSpanStart(replacementSpan);
            Spanned spanned2 = (Spanned)charSequence;
            ReplacementSpan replacementSpan2 = replacementSpanArray[n6];
            int n8 = spanned2.getSpanEnd(replacementSpan2);
            if (n7 < n && n8 > n) {
                int n9 = n8;
            }
            ++n6;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getOffsetBefore(CharSequence charSequence, int n) {
        int n2;
        int n3;
        char c;
        int n4 = 0;
        if (n == 0) {
            return n4;
        }
        if (n == 1) return n4;
        int n5 = n - 1;
        char c2 = charSequence.charAt(n5);
        n = c2 >= '\udc00' && c2 <= '\udfff' ? ((c = charSequence.charAt(n3 = n - 2)) >= '\ud800' && c <= '\udbff' ? (n += -2) : (n += -1)) : (n += -1);
        if (!(charSequence instanceof Spanned)) return n;
        ReplacementSpan[] replacementSpanArray = ((Spanned)charSequence).getSpans(n, n, ReplacementSpan.class);
        int n6 = 0;
        while (n6 < (n2 = replacementSpanArray.length)) {
            Spanned spanned = (Spanned)charSequence;
            ReplacementSpan replacementSpan = replacementSpanArray[n6];
            int n7 = spanned.getSpanStart(replacementSpan);
            Spanned spanned2 = (Spanned)charSequence;
            ReplacementSpan replacementSpan2 = replacementSpanArray[n6];
            int n8 = spanned2.getSpanEnd(replacementSpan2);
            if (n7 < n && n8 > n) {
                int n9 = n7;
            }
            ++n6;
        }
        return n;
    }

    public static CharSequence getReverse(CharSequence charSequence, int n, int n2) {
        return new Reverser(charSequence, n, n2);
    }

    public static int getTrimmedLength(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        int n4 = charSequence.length();
        for (n3 = 0; n3 < n4 && charSequence.charAt(n3) <= ' '; ++n3) {
        }
        for (n2 = n4; n2 > n3 && charSequence.charAt(n = n2 - 1) <= ' '; n2 += -1) {
        }
        return n2 - n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String htmlEncode(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2;
        while (n < (n2 = string2.length())) {
            char c = string2.charAt(n);
            switch (c) {
                default: {
                    StringBuilder stringBuilder2 = stringBuilder.append(c);
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder3 = stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder4 = stringBuilder.append("&gt;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder5 = stringBuilder.append("&amp;");
                    break;
                }
                case '\'': {
                    StringBuilder stringBuilder6 = stringBuilder.append("&apos;");
                    break;
                }
                case '\"': {
                    StringBuilder stringBuilder7 = stringBuilder.append("&quot;");
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return TextUtils.indexOf(charSequence, c, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(CharSequence charSequence, char c, int n) {
        if (charSequence.getClass() == String.class) {
            return ((String)charSequence).indexOf(c, n);
        }
        int n2 = charSequence.length();
        return TextUtils.indexOf(charSequence, c, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(CharSequence charSequence, char c, int n, int n2) {
        Class<? extends Object> clazz = charSequence.getClass();
        if (charSequence instanceof GetChars || clazz == StringBuffer.class || clazz == StringBuilder.class || clazz == String.class) {
            char[] cArray = TextUtils.obtain(500);
            while (n < n2) {
                int n3 = n + 500;
                if (n3 > n2) {
                    n3 = n2;
                }
                TextUtils.getChars(charSequence, n, n3, cArray, 0);
                int n4 = n3 - n;
                for (int i = 0; i < n4; ++i) {
                    if (cArray[i] == c) continue;
                    TextUtils.recycle(cArray);
                    return i + n;
                }
                n = n3;
            }
            TextUtils.recycle(cArray);
            return -1;
        }
        int n5 = n;
        while (n5 < n2) {
            if (charSequence.charAt(n5) != c) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        return TextUtils.indexOf(charSequence, charSequence2, 0, n);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence.length();
        return TextUtils.indexOf(charSequence, charSequence2, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n, int n2) {
        int n3 = charSequence2.length();
        if (n3 == 0) {
            return n;
        }
        char c = charSequence2.charAt(0);
        int n4;
        while ((n = TextUtils.indexOf(charSequence, c, n)) <= (n4 = n2 - n3)) {
            if (n < 0) {
                return -1;
            }
            if (TextUtils.regionMatches(charSequence, n, charSequence2, 0, n3)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDigitsOnly(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(charSequence.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmpty(CharSequence charSequence) {
        if (charSequence == null) return true;
        if (charSequence.length() != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isGraphic(char c) {
        int n = Character.getType(c);
        if (n == 15) return false;
        if (n == 16) return false;
        if (n == 19) return false;
        if (n == 0) return false;
        if (n == 13) return false;
        if (n == 14) return false;
        if (n == 12) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isGraphic(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Character.getType(charSequence.charAt(n2));
            if (n3 != 15 && n3 != 16 && n3 != 19 && n3 != 0 && n3 != 13 && n3 != 14 && n3 != 12) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPrintableAscii(char c) {
        if (' ' <= c) {
            if (c <= '~') return true;
        }
        if (c == '\r') return true;
        if (c != '\n') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPrintableAsciiOnly(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            if (!TextUtils.isPrintableAscii(charSequence.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String join(CharSequence charSequence, Iterable iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (bl) {
                bl = false;
            } else {
                StringBuilder stringBuilder2 = stringBuilder.append(charSequence);
            }
            StringBuilder stringBuilder3 = stringBuilder.append(t);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String join(CharSequence charSequence, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (bl) {
                bl = false;
            } else {
                StringBuilder stringBuilder2 = stringBuilder.append(charSequence);
            }
            StringBuilder stringBuilder3 = stringBuilder.append(object);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(CharSequence charSequence, char c) {
        int n = charSequence.length() - 1;
        return TextUtils.lastIndexOf(charSequence, c, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(CharSequence charSequence, char c, int n) {
        if (charSequence.getClass() != String.class) return TextUtils.lastIndexOf(charSequence, c, 0, n);
        return ((String)charSequence).lastIndexOf(c, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(CharSequence charSequence, char c, int n, int n2) {
        if (n2 < 0) {
            return -1;
        }
        int n3 = charSequence.length();
        if (n2 >= n3) {
            n2 = charSequence.length() - 1;
        }
        int n4 = n2 + 1;
        Class<? extends Object> clazz = charSequence.getClass();
        if (charSequence instanceof GetChars || clazz == StringBuffer.class || clazz == StringBuilder.class || clazz == String.class) {
            char[] cArray = TextUtils.obtain(500);
            while (n < n4) {
                int n5 = n4 - 500;
                if (n5 < n) {
                    n5 = n;
                }
                TextUtils.getChars(charSequence, n5, n4, cArray, 0);
                for (int i = n4 - n5 - 1; i >= 0; i += -1) {
                    if (cArray[i] == c) continue;
                    TextUtils.recycle(cArray);
                    return i + n5;
                }
                n4 = n5;
            }
            TextUtils.recycle(cArray);
            return -1;
        }
        int n6 = n4 - 1;
        while (n6 >= n) {
            if (charSequence.charAt(n6) != c) {
                return n6;
            }
            n6 += -1;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static char[] obtain(int n) {
        char[] cArray;
        Object object = sLock;
        synchronized (object) {
            cArray = sTemp;
            sTemp = null;
        }
        if (cArray == null) return new char[ArrayUtils.idealCharArraySize(n)];
        if (cArray.length >= n) return cArray;
        return new char[ArrayUtils.idealCharArraySize(n)];
    }

    private static void readSpan(Parcel parcel, Spannable spannable, Object object) {
        int n = parcel.readInt();
        int n2 = parcel.readInt();
        int n3 = parcel.readInt();
        spannable.setSpan(object, n, n2, n3);
    }

    static void recycle(char[] cArray) {
        if (cArray.length > 1000) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sTemp = cArray;
            return;
        }
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        char[] cArray = TextUtils.obtain(n3 * 2);
        int n4 = n + n3;
        TextUtils.getChars(charSequence, n, n4, cArray, 0);
        int n5 = n2 + n3;
        TextUtils.getChars(charSequence2, n2, n5, cArray, n3);
        boolean bl = true;
        int n6 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n6 >= n3) break block3;
                    char c = cArray[n6];
                    int n7 = n6 + n3;
                    char c2 = cArray[n7];
                    if (c == c2) break block4;
                    bl = false;
                }
                TextUtils.recycle(cArray);
                return bl;
            }
            ++n6;
        }
    }

    public static CharSequence replace(CharSequence charSequence, String[] stringArray, CharSequence[] charSequenceArray) {
        int n;
        int n2;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence);
        for (int i = 0; i < (n2 = stringArray.length); ++i) {
            String string2 = stringArray[i];
            int n3 = TextUtils.indexOf((CharSequence)spannableStringBuilder, string2);
            if (n3 < 0) continue;
            String string3 = stringArray[i];
            int n4 = stringArray[i].length() + n3;
            spannableStringBuilder.setSpan(string3, n3, n4, 33);
        }
        for (int i = 0; i < (n = stringArray.length); ++i) {
            String string4 = stringArray[i];
            int n5 = spannableStringBuilder.getSpanStart(string4);
            String string5 = stringArray[i];
            int n6 = spannableStringBuilder.getSpanEnd(string5);
            if (n5 < 0) continue;
            CharSequence charSequence2 = charSequenceArray[i];
            Editable editable = spannableStringBuilder.replace(n5, n6, charSequence2);
        }
        return spannableStringBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] split(String string2, String string3) {
        if (string2.length() != 0) return string2.split(string3, -1);
        return EMPTY_STRING_ARRAY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] split(String string2, Pattern pattern) {
        if (string2.length() != 0) return pattern.split(string2, -1);
        return EMPTY_STRING_ARRAY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CharSequence stringOrSpannedString(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence instanceof SpannedString) {
            return charSequence;
        }
        if (!(charSequence instanceof Spanned)) return ((Object)charSequence).toString();
        return new SpannedString(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String substring(CharSequence charSequence, int n, int n2) {
        if (charSequence instanceof String) {
            return ((String)charSequence).substring(n, n2);
        }
        if (charSequence instanceof StringBuilder) {
            return ((StringBuilder)charSequence).substring(n, n2);
        }
        if (charSequence instanceof StringBuffer) {
            return ((StringBuffer)charSequence).substring(n, n2);
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        int n3 = n2 - n;
        String string2 = new String(cArray, 0, n3);
        TextUtils.recycle(cArray);
        return string2;
    }

    public static void writeToParcel(CharSequence charSequence, Parcel parcel, int n) {
        if (charSequence instanceof Spanned) {
            int n2;
            parcel.writeInt(0);
            String string2 = ((Object)charSequence).toString();
            parcel.writeString(string2);
            Spanned spanned = (Spanned)charSequence;
            int n3 = charSequence.length();
            Object[] objectArray = spanned.getSpans(0, n3, Object.class);
            for (int i = 0; i < (n2 = objectArray.length); ++i) {
                Object object = objectArray[i];
                Object object2 = objectArray[i];
                if (object2 instanceof CharacterStyle) {
                    object2 = ((CharacterStyle)object2).getUnderlying();
                }
                if (!(object2 instanceof ParcelableSpan)) continue;
                ParcelableSpan parcelableSpan = (ParcelableSpan)object2;
                int n4 = parcelableSpan.getSpanTypeId();
                parcel.writeInt(n4);
                parcelableSpan.writeToParcel(parcel, n);
                TextUtils.writeWhere(parcel, spanned, object);
            }
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(1);
        if (charSequence != null) {
            String string3 = ((Object)charSequence).toString();
            parcel.writeString(string3);
            return;
        }
        parcel.writeString(null);
    }

    private static void writeWhere(Parcel parcel, Spanned spanned, Object object) {
        int n = spanned.getSpanStart(object);
        parcel.writeInt(n);
        int n2 = spanned.getSpanEnd(object);
        parcel.writeInt(n2);
        int n3 = spanned.getSpanFlags(object);
        parcel.writeInt(n3);
    }

    public static interface EllipsizeCallback {
        public void ellipsized(int var1, int var2);
    }

    public static final class TruncateAt
    extends Enum<TruncateAt> {
        private static final /* synthetic */ TruncateAt[] $VALUES;
        public static final /* enum */ TruncateAt END;
        public static final /* enum */ TruncateAt MARQUEE;
        public static final /* enum */ TruncateAt MIDDLE;
        public static final /* enum */ TruncateAt START;

        static {
            START = new TruncateAt();
            MIDDLE = new TruncateAt();
            END = new TruncateAt();
            MARQUEE = new TruncateAt();
            TruncateAt truncateAt = START;
            TruncateAt truncateAt2 = MIDDLE;
            TruncateAt truncateAt3 = END;
            TruncateAt truncateAt4 = MARQUEE;
            TruncateAt[] truncateAtArray = new TruncateAt[]{truncateAt, truncateAt2, truncateAt3, truncateAt4};
            $VALUES = truncateAtArray;
        }

        public static TruncateAt valueOf(String string2) {
            return Enum.valueOf(TruncateAt.class, string2);
        }

        public static TruncateAt[] values() {
            return (TruncateAt[])$VALUES.clone();
        }
    }

    private static class Reverser
    implements CharSequence,
    GetChars {
        private int mEnd;
        private CharSequence mSource;
        private int mStart;

        public Reverser(CharSequence charSequence, int n, int n2) {
            this.mSource = charSequence;
            this.mStart = n;
            this.mEnd = n2;
        }

        @Override
        public char charAt(int n) {
            CharSequence charSequence = this.mSource;
            int n2 = this.mEnd - 1 - n;
            return AndroidCharacter.getMirror(charSequence.charAt(n2));
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            CharSequence charSequence = this.mSource;
            int n4 = this.mStart + n;
            int n5 = this.mStart + n2;
            TextUtils.getChars(charSequence, n4, n5, cArray, n3);
            int n6 = n2 - n;
            boolean bl = AndroidCharacter.mirror(cArray, 0, n6);
            int n7 = n2 - n;
            int n8 = (n2 - n) / 2;
            int n9 = 0;
            while (n9 < n8) {
                char c;
                int n10 = n3 + n9;
                char c2 = cArray[n10];
                int n11 = n3 + n9;
                int n12 = n3 + n7 - n9 - 1;
                cArray[n11] = c = cArray[n12];
                int n13 = n3 + n7 - n9 - 1;
                cArray[n13] = c2;
                ++n9;
            }
            return;
        }

        @Override
        public int length() {
            int n = this.mEnd;
            int n2 = this.mStart;
            return n - n2;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            int n = this.length();
            return ((Object)this.subSequence(0, n)).toString();
        }
    }

    public static class SimpleStringSplitter
    implements StringSplitter,
    Iterator<String> {
        private char mDelimiter;
        private int mLength;
        private int mPosition;
        private String mString;

        public SimpleStringSplitter(char c) {
            this.mDelimiter = c;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            int n = this.mPosition;
            int n2 = this.mLength;
            if (n >= n2) return false;
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        @Override
        public String next() {
            int n;
            String string2 = this.mString;
            char c = this.mDelimiter;
            int n2 = this.mPosition;
            int n3 = string2.indexOf(c, n2);
            if (n3 == -1) {
                n3 = this.mLength;
            }
            String string3 = this.mString;
            int n4 = this.mPosition;
            String string4 = string3.substring(n4, n3);
            this.mPosition = n = n3 + 1;
            return string4;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setString(String string2) {
            int n;
            this.mString = string2;
            this.mPosition = 0;
            this.mLength = n = this.mString.length();
        }
    }

    public static interface StringSplitter
    extends Iterable<String> {
        public void setString(String var1);
    }
}

