/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.provider.Settings;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.format.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormat {
    public static final char AM_PM = 'a';
    public static final char CAPITAL_AM_PM = 'A';
    public static final char DATE = 'd';
    public static final char DAY = 'E';
    public static final char HOUR = 'h';
    public static final char HOUR_OF_DAY = 'k';
    public static final char MINUTE = 'm';
    public static final char MONTH = 'M';
    public static final char QUOTE = '\'';
    public static final char SECONDS = 's';
    public static final char TIME_ZONE = 'z';
    public static final char YEAR = 'y';
    private static boolean sIs24Hour;
    private static Locale sIs24HourLocale;
    private static final Object sLocaleLock;

    static {
        sLocaleLock = new Object();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int appendQuotedText(SpannableStringBuilder spannableStringBuilder, int n, int n2) {
        int n3;
        if (n + 1 < n2 && spannableStringBuilder.charAt(n3 = n + 1) == '\'') {
            int n4 = n + 1;
            Editable editable = spannableStringBuilder.delete(n, n4);
            return 1;
        }
        int n5 = 0;
        int n6 = n + 1;
        Editable editable = spannableStringBuilder.delete(n, n6);
        n2 += -1;
        while (n < n2) {
            if (spannableStringBuilder.charAt(n) == '\'') {
                int n7;
                if (n + 1 < n2 && spannableStringBuilder.charAt(n7 = n + 1) == '\'') {
                    int n8 = n + 1;
                    Editable editable2 = spannableStringBuilder.delete(n, n8);
                    int n9 = n2 + -1;
                    ++n5;
                    ++n;
                    continue;
                }
                int n10 = n + 1;
                Editable editable3 = spannableStringBuilder.delete(n, n10);
                return n5;
            }
            ++n;
            ++n5;
        }
        return n5;
    }

    public static final CharSequence format(CharSequence charSequence, long l) {
        Date date = new Date(l);
        return DateFormat.format(charSequence, date);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final CharSequence format(CharSequence charSequence, Calendar calendar) {
        void var14_15;
        int n;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence);
        int n2 = charSequence.length();
        for (int i = 0; i < n2; i += n) {
            String string2;
            int n3;
            n = 1;
            char c = spannableStringBuilder.charAt(i);
            if (c == '\'') {
                n = DateFormat.appendQuotedText(spannableStringBuilder, i, n2);
                n2 = spannableStringBuilder.length();
                continue;
            }
            while (i + n < n2 && spannableStringBuilder.charAt(n3 = i + n) != c) {
                int n4 = n + 1;
            }
            switch (c) {
                default: {
                    string2 = null;
                    break;
                }
                case 'a': {
                    string2 = DateUtils.getAMPMString(calendar.get(9));
                    break;
                }
                case 'A': {
                    string2 = DateUtils.getAMPMString(calendar.get(9));
                    break;
                }
                case 'd': {
                    string2 = DateFormat.zeroPad(calendar.get(5), n);
                    break;
                }
                case 'E': {
                    int n5 = calendar.get(7);
                    int n6 = n < 4 ? 20 : 10;
                    string2 = DateUtils.getDayOfWeekString(n5, n6);
                    break;
                }
                case 'h': {
                    int n5 = calendar.get(10);
                    if (n5 == 0) {
                        n5 = 12;
                    }
                    string2 = DateFormat.zeroPad(n5, n);
                    break;
                }
                case 'k': {
                    string2 = DateFormat.zeroPad(calendar.get(11), n);
                    break;
                }
                case 'm': {
                    string2 = DateFormat.zeroPad(calendar.get(12), n);
                    break;
                }
                case 'M': {
                    string2 = DateFormat.getMonthString(calendar, n);
                    break;
                }
                case 's': {
                    string2 = DateFormat.zeroPad(calendar.get(13), n);
                    break;
                }
                case 'z': {
                    string2 = DateFormat.getTimeZoneString(calendar, n);
                    break;
                }
                case 'y': {
                    string2 = DateFormat.getYearString(calendar, n);
                }
            }
            if (string2 == null) continue;
            int n7 = i + n;
            Editable editable = spannableStringBuilder.replace(i, n7, string2);
            n = string2.length();
            n2 = spannableStringBuilder.length();
        }
        if (charSequence instanceof Spanned) {
            SpannedString spannedString = new SpannedString(spannableStringBuilder);
            return var14_15;
        }
        String string3 = spannableStringBuilder.toString();
        return var14_15;
    }

    public static final CharSequence format(CharSequence charSequence, Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return DateFormat.format(charSequence, gregorianCalendar);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String formatZoneOffset(int n, int n2) {
        int n3 = n / 1000;
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 < 0) {
            StringBuilder stringBuilder2 = stringBuilder.insert(0, "-");
            n3 = -n3;
        } else {
            StringBuilder stringBuilder3 = stringBuilder.insert(0, "+");
        }
        int n4 = n3 / 3600;
        int n5 = n3 % 3600 / 60;
        String string2 = DateFormat.zeroPad(n4, 2);
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        String string3 = DateFormat.zeroPad(n5, 2);
        StringBuilder stringBuilder5 = stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static final java.text.DateFormat getDateFormat(Context context) {
        String string2 = Settings.System.getString(context.getContentResolver(), "date_format");
        return DateFormat.getDateFormatForSetting(context, string2);
    }

    public static java.text.DateFormat getDateFormatForSetting(Context context, String string2) {
        String string3 = DateFormat.getDateFormatStringForSetting(context, string2);
        return new SimpleDateFormat(string3);
    }

    public static final char[] getDateFormatOrder(Context context) {
        char[] cArray = new char[]{'d', 'M', 'y'};
        String string2 = DateFormat.getDateFormatString(context);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (char c : string2.toCharArray()) {
            if (!bl && c == 'd') {
                bl = true;
                cArray[n] = 100;
                ++n;
            }
            if (!bl2 && c == 'M') {
                bl2 = true;
                cArray[n] = 77;
                ++n;
            }
            if (bl3 || c != 'y') continue;
            bl3 = true;
            cArray[n] = 121;
            int n2 = n + 1;
        }
        return cArray;
    }

    private static String getDateFormatString(Context context) {
        String string2 = Settings.System.getString(context.getContentResolver(), "date_format");
        return DateFormat.getDateFormatStringForSetting(context, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDateFormatStringForSetting(Context context, String string2) {
        if (string2 == null) return context.getString(17039475);
        int n = string2.indexOf(77);
        int n2 = string2.indexOf(100);
        int n3 = string2.indexOf(121);
        if (n < 0) return context.getString(17039475);
        if (n2 < 0) return context.getString(17039475);
        if (n3 < 0) return context.getString(17039475);
        String string3 = context.getString(17039476);
        if (n3 < n && n3 < n2) {
            if (n < n2) {
                Object[] objectArray = new Object[]{"yyyy", "MM", "dd"};
                String string4 = String.format(string3, objectArray);
                return string4;
            }
            Object[] objectArray = new Object[]{"yyyy", "dd", "MM"};
            return String.format(string3, objectArray);
        }
        if (n < n2) {
            if (n2 < n3) {
                Object[] objectArray = new Object[]{"MM", "dd", "yyyy"};
                return String.format(string3, objectArray);
            }
            Object[] objectArray = new Object[]{"MM", "yyyy", "dd"};
            return String.format(string3, objectArray);
        }
        if (n < n3) {
            Object[] objectArray = new Object[]{"dd", "MM", "yyyy"};
            return String.format(string3, objectArray);
        }
        Object[] objectArray = new Object[]{"dd", "yyyy", "MM"};
        return String.format(string3, objectArray);
    }

    public static final java.text.DateFormat getLongDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(1);
    }

    public static final java.text.DateFormat getMediumDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getMonthString(Calendar calendar, int n) {
        int n2 = calendar.get(2);
        if (n >= 4) {
            return DateUtils.getMonthString(n2, 10);
        }
        if (n != 3) return DateFormat.zeroPad(n2 + 1, n);
        return DateUtils.getMonthString(n2, 20);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final java.text.DateFormat getTimeFormat(Context context) {
        int n = DateFormat.is24HourFormat(context) ? 17039473 : 17039472;
        String string2 = context.getString(n);
        return new SimpleDateFormat(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getTimeZoneString(Calendar calendar, int n) {
        boolean bl;
        TimeZone timeZone = calendar.getTimeZone();
        if (n < 2) {
            int n2 = calendar.get(16);
            int n3 = calendar.get(15);
            return DateFormat.formatZoneOffset(n2 + n3, n);
        }
        if (calendar.get(16) != 0) {
            bl = true;
            return timeZone.getDisplayName(bl, 0);
        }
        bl = false;
        return timeZone.getDisplayName(bl, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getYearString(Calendar calendar, int n) {
        int n2 = calendar.get(1);
        if (n > 2) return String.valueOf(n2);
        return DateFormat.zeroPad(n2 % 100, 2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean is24HourFormat(Context context) {
        String string2;
        block8: {
            Locale locale;
            block10: {
                block9: {
                    string2 = Settings.System.getString(context.getContentResolver(), "time_12_24");
                    if (string2 != null) break block8;
                    locale = context.getResources().getConfiguration().locale;
                    Object object = sLocaleLock;
                    // MONITORENTER : object
                    if (sIs24HourLocale != null && sIs24HourLocale.equals(locale)) {
                        boolean bl = sIs24Hour;
                        // MONITOREXIT : object
                        return (boolean)((Object)bl);
                    }
                    // MONITOREXIT : object
                    {
                        catch (Throwable throwable) {}
                        throw throwable;
                    }
                    java.text.DateFormat dateFormat = java.text.DateFormat.getTimeInstance(1, locale);
                    if (!(dateFormat instanceof SimpleDateFormat)) break block9;
                    string2 = ((SimpleDateFormat)dateFormat).toPattern().indexOf(72) >= 0 ? "24" : "12";
                    break block10;
                }
                string2 = "12";
            }
            Object object = sLocaleLock;
            // MONITORENTER : object
            sIs24HourLocale = locale;
            Object var7_7 = !string2.equals("12") ? null : null;
            sIs24Hour = var7_7;
            // MONITOREXIT : object
        }
        boolean bl = string2 != null && !string2.equals("12");
        return (boolean)((Object)bl);
    }

    private static final String zeroPad(int n, int n2) {
        String string2 = String.valueOf(n);
        if (string2.length() < n2) {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = 48;
            }
            int n3 = string2.length();
            int n4 = string2.length();
            int n5 = n2 - n4;
            string2.getChars(0, n3, cArray, n5);
            string2 = new String(cArray);
        }
        return string2;
    }
}

