/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.format.DateFormat;
import android.text.format.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final String ABBREV_MONTH_FORMAT = "%b";
    public static final String ABBREV_WEEKDAY_FORMAT = "%a";
    public static final long DAY_IN_MILLIS = 86400000L;
    private static final String FAST_FORMAT_HMMSS = "%1$d:%2$02d:%3$02d";
    private static final String FAST_FORMAT_MMSS = "%1$02d:%2$02d";
    public static final int FORMAT_12HOUR = 64;
    public static final int FORMAT_24HOUR = 128;
    public static final int FORMAT_ABBREV_ALL = 524288;
    public static final int FORMAT_ABBREV_MONTH = 65536;
    public static final int FORMAT_ABBREV_RELATIVE = 262144;
    public static final int FORMAT_ABBREV_TIME = 16384;
    public static final int FORMAT_ABBREV_WEEKDAY = 32768;
    public static final int FORMAT_CAP_AMPM = 256;
    public static final int FORMAT_CAP_MIDNIGHT = 4096;
    public static final int FORMAT_CAP_NOON = 1024;
    public static final int FORMAT_CAP_NOON_MIDNIGHT = 5120;
    public static final int FORMAT_NO_MIDNIGHT = 2048;
    public static final int FORMAT_NO_MONTH_DAY = 32;
    public static final int FORMAT_NO_NOON = 512;
    public static final int FORMAT_NO_NOON_MIDNIGHT = 2560;
    public static final int FORMAT_NO_YEAR = 8;
    public static final int FORMAT_NUMERIC_DATE = 131072;
    public static final int FORMAT_SHOW_DATE = 16;
    public static final int FORMAT_SHOW_TIME = 1;
    public static final int FORMAT_SHOW_WEEKDAY = 2;
    public static final int FORMAT_SHOW_YEAR = 4;
    @Deprecated
    public static final int FORMAT_UTC = 8192;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final String HOUR_MINUTE_24 = "%H:%M";
    public static final int LENGTH_LONG = 10;
    public static final int LENGTH_MEDIUM = 20;
    public static final int LENGTH_SHORT = 30;
    public static final int LENGTH_SHORTER = 40;
    public static final int LENGTH_SHORTEST = 50;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final String MONTH_DAY_FORMAT = "%-d";
    public static final String MONTH_FORMAT = "%B";
    public static final String NUMERIC_MONTH_FORMAT = "%m";
    public static final long SECOND_IN_MILLIS = 1000L;
    private static final char TIME_PADDING = '0';
    private static final char TIME_SEPARATOR = ':';
    public static final String WEEKDAY_FORMAT = "%A";
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final String YEAR_FORMAT = "%Y";
    public static final String YEAR_FORMAT_TWO_DIGITS = "%g";
    public static final long YEAR_IN_MILLIS = 31449600000L;
    private static final int[] sAmPm;
    private static final int[] sDaysLong;
    private static final int[] sDaysMedium;
    private static final int[] sDaysShort;
    private static final int[] sDaysShortest;
    private static String sElapsedFormatHMMSS;
    private static String sElapsedFormatMMSS;
    private static Configuration sLastConfig;
    private static final Object sLock;
    private static final int[] sMonthsLong;
    private static final int[] sMonthsMedium;
    private static final int[] sMonthsShortest;
    private static final int[] sMonthsStandaloneLong;
    private static Time sNowTime;
    private static java.text.DateFormat sStatusTimeFormat;
    private static Time sThenTime;
    public static final int[] sameMonthTable;
    public static final int[] sameYearTable;

    static {
        sLock = new Object();
        sDaysLong = new int[]{17039436, 17039437, 17039438, 17039439, 17039440, 17039441, 17039442};
        sDaysMedium = new int[]{17039443, 17039444, 17039445, 17039446, 17039447, 17039448, 17039449};
        sDaysShort = new int[]{17039450, 17039451, 17039452, 17039453, 17039454, 17039455, 17039456};
        sDaysShortest = new int[]{17039457, 17039458, 17039459, 17039460, 17039461, 17039462, 17039463};
        sMonthsStandaloneLong = new int[]{17039388, 17039389, 17039390, 17039391, 17039392, 17039393, 17039394, 17039395, 17039396, 17039397, 17039398, 17039399};
        sMonthsLong = new int[]{17039400, 17039401, 17039402, 17039403, 17039404, 17039405, 17039406, 17039407, 17039408, 17039409, 17039410, 17039411};
        sMonthsMedium = new int[]{17039412, 17039413, 17039414, 17039415, 17039416, 17039417, 17039418, 17039419, 17039420, 17039421, 17039422, 17039423};
        sMonthsShortest = new int[]{0x1040040, 0x1040041, 17039426, 17039427, 0x1040044, 17039429, 17039430, 17039431, 17039432, 17039433, 17039434, 17039435};
        sAmPm = new int[]{17039464, 17039465};
        sameYearTable = new int[]{17039505, 17039506, 17039518, 17039520, 17039507, 17039509, 17039511, 17039513, 17039491, 17039492, 17039493, 17039494, 17039496, 17039497, 17039498, 17039495};
        sameMonthTable = new int[]{17039516, 17039517, 17039519, 17039515, 17039508, 17039510, 17039512, 17039514, 17039491, 17039492, 17039493, 17039494, 17039496, 17039497, 17039498, 17039495};
    }

    public static void assign(Calendar calendar, Calendar calendar2) {
        calendar.clear();
        long l = calendar2.getTimeInMillis();
        calendar.setTimeInMillis(l);
    }

    public static String formatDateRange(Context context, long l, long l2, int n) {
        StringBuilder stringBuilder = new StringBuilder(50);
        Locale locale = Locale.getDefault();
        Formatter formatter = new Formatter(stringBuilder, locale);
        Context context2 = context;
        long l3 = l;
        long l4 = l2;
        int n2 = n;
        return DateUtils.formatDateRange(context2, formatter, l3, l4, n2).toString();
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long l, long l2, int n) {
        Context context2 = context;
        Formatter formatter2 = formatter;
        long l3 = l;
        long l4 = l2;
        int n2 = n;
        return DateUtils.formatDateRange(context2, formatter2, l3, l4, n2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Formatter formatDateRange(Context object, Formatter formatter, long l, long l2, int n, String string2) {
        String string3;
        String string4;
        Formatter formatter2;
        Object object2;
        String string5;
        block108: {
            String string6;
            boolean bl;
            block116: {
                int n2;
                int n3;
                String string7;
                String string8;
                String string9;
                String string10;
                int n4;
                int n5;
                String string11;
                boolean bl2;
                String string12;
                String string13;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                Time time;
                Time time2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String string14;
                block105: {
                    block115: {
                        block114: {
                            boolean bl6;
                            boolean bl7;
                            block113: {
                                String string15;
                                String string16;
                                block109: {
                                    String string17;
                                    String string18;
                                    block104: {
                                        int n12;
                                        int n13;
                                        String string19;
                                        boolean bl8;
                                        boolean bl9;
                                        block103: {
                                            block111: {
                                                boolean bl10;
                                                boolean bl11;
                                                boolean bl12;
                                                block112: {
                                                    int n14;
                                                    int n15;
                                                    int n16;
                                                    block110: {
                                                        boolean bl13;
                                                        int n17;
                                                        int n18;
                                                        int n19;
                                                        int n20;
                                                        int n21;
                                                        int n22;
                                                        int n23;
                                                        Resources resources = Resources.getSystem();
                                                        boolean bl14 = (n & 1) != 0;
                                                        bl = (n & 2) != 0;
                                                        bl7 = (n & 4) != 0;
                                                        bl6 = (n & 8) != 0;
                                                        string14 = (n & 0x2000) != 0 ? null : null;
                                                        bl12 = (0x88000 & n) != 0;
                                                        Object var15_14 = (0x90000 & n) != 0 ? null : null;
                                                        bl5 = (n & 0x20) != 0;
                                                        bl4 = (0x20000 & n) != 0;
                                                        bl3 = l == l2;
                                                        if (bl14 != null) {
                                                            Time time3;
                                                            Time time4 = time3;
                                                            boolean bl15 = bl14;
                                                            time4((String)bl15);
                                                            time2 = time3;
                                                        } else {
                                                            time2 = string14 != null ? new Time("UTC") : new Time();
                                                        }
                                                        Time time5 = time2;
                                                        long l3 = l;
                                                        time5.set(l3);
                                                        if (bl3) {
                                                            Time time6 = time2;
                                                            n23 = 0;
                                                            time = time6;
                                                        } else {
                                                            Time time7;
                                                            if (bl14 != null) {
                                                                Time time8;
                                                                Time time9 = time8;
                                                                boolean bl16 = bl14;
                                                                time9((String)bl16);
                                                                time7 = time8;
                                                            } else if (string14 != null) {
                                                                Time time10 = time7;
                                                                String string20 = "UTC";
                                                                time10(string20);
                                                            } else {
                                                                time7 = new Time();
                                                            }
                                                            Time time11 = time7;
                                                            long l4 = l2;
                                                            time11.set(l4);
                                                            long l5 = time2.gmtoff;
                                                            long l6 = l;
                                                            long l7 = l5;
                                                            n16 = Time.getJulianDay(l6, l7);
                                                            long l8 = time7.gmtoff;
                                                            long l9 = l2;
                                                            long l10 = l8;
                                                            n23 = Time.getJulianDay(l9, l10) - n16;
                                                            time = time7;
                                                        }
                                                        if (!(bl3 || ((n22 = (n21 = time.hour) | (n20 = time.minute)) | (n19 = time.second)) != 0 || string2 != false && (n18 = n23) > (n17 = 1))) {
                                                            int n24;
                                                            time.monthDay = n24 = time.monthDay - 1;
                                                            Time time12 = time;
                                                            boolean bl17 = true;
                                                            long l11 = time12.normalize(bl17);
                                                        }
                                                        n11 = time2.monthDay;
                                                        n10 = time2.month;
                                                        n9 = time2.year;
                                                        n8 = time.monthDay;
                                                        n7 = time.month;
                                                        n6 = time.year;
                                                        String string21 = "";
                                                        String string22 = "";
                                                        if (bl) {
                                                            String string23 = bl12 ? ABBREV_WEEKDAY_FORMAT : WEEKDAY_FORMAT;
                                                            Time time13 = time2;
                                                            String string24 = string23;
                                                            string21 = time13.format(string24);
                                                            if (bl3) {
                                                                string22 = string21;
                                                            } else {
                                                                Time time14 = time;
                                                                String string25 = string23;
                                                                string22 = time14.format(string25);
                                                            }
                                                            string13 = string22;
                                                            string5 = string21;
                                                        } else {
                                                            string13 = string22;
                                                            string5 = string21;
                                                        }
                                                        string16 = "";
                                                        string15 = "";
                                                        if (string2 == false) break block109;
                                                        string14 = "";
                                                        if ((n & 0x80) != 0) {
                                                            string16 = null;
                                                        } else {
                                                            boolean bl18 = false;
                                                        }
                                                        boolean bl19 = (n & 0x40) != 0;
                                                        if (string16 != null) {
                                                            bl13 = true;
                                                        } else if (bl19) {
                                                            boolean bl20 = false;
                                                        } else {
                                                            bl13 = DateFormat.is24HourFormat((Context)object);
                                                        }
                                                        if (!bl13) break block110;
                                                        boolean bl21 = bl;
                                                        int n25 = 17039469;
                                                        string17 = string18 = bl21.getString(n25);
                                                        break block104;
                                                    }
                                                    n16 = (0x84000 & n) != 0 ? 1 : 0;
                                                    boolean bl22 = (n & 0x100) != 0;
                                                    bl9 = (n & 0x200) != 0;
                                                    l2 = (n & 0x400) != 0 ? (long)1 : (long)0;
                                                    bl11 = (n & 0x800) != 0;
                                                    bl10 = (n & 0x1000) != 0;
                                                    bl8 = time2.minute == 0 && time2.second == 0;
                                                    bl12 = time.minute == 0 && time.second == 0;
                                                    if (n16 != 0 && bl8) {
                                                        if (bl22) {
                                                            boolean bl23 = bl;
                                                            int n26 = 17040041;
                                                            string19 = bl23.getString(n26);
                                                        } else {
                                                            boolean bl24 = bl;
                                                            int n27 = 17040040;
                                                            string19 = bl24.getString(n27);
                                                        }
                                                    } else if (bl22) {
                                                        boolean bl25 = bl;
                                                        int n28 = 17039471;
                                                        string19 = bl25.getString(n28);
                                                    } else {
                                                        boolean bl26 = bl;
                                                        int n29 = 17039470;
                                                        string19 = bl26.getString(n29);
                                                    }
                                                    if (bl3) break block111;
                                                    if (n16 != 0 && bl12) {
                                                        if (bl22) {
                                                            boolean bl27 = bl;
                                                            int n30 = 17040041;
                                                            string18 = bl27.getString(n30);
                                                        } else {
                                                            boolean bl28 = bl;
                                                            int n31 = 17040040;
                                                            string18 = bl28.getString(n31);
                                                        }
                                                    } else if (bl22) {
                                                        boolean bl29 = bl;
                                                        int n32 = 17039471;
                                                        string18 = bl29.getString(n32);
                                                    } else {
                                                        boolean bl30 = bl;
                                                        int n33 = 17039470;
                                                        string18 = bl30.getString(n33);
                                                    }
                                                    if ((n15 = time.hour) != (n14 = 12) || !bl12 || bl9) break block112;
                                                    if (l2 != null) {
                                                        boolean bl31 = bl;
                                                        int n34 = 17040092;
                                                        string18 = bl31.getString(n34);
                                                        break block103;
                                                    } else {
                                                        boolean bl32 = bl;
                                                        int n35 = 17040091;
                                                        string18 = bl32.getString(n35);
                                                    }
                                                    break block103;
                                                }
                                                if (time.hour == 0 && bl12 && !bl11) {
                                                    if (bl10) {
                                                        boolean bl33 = bl;
                                                        int n36 = 17040094;
                                                        string18 = bl33.getString(n36);
                                                        break block103;
                                                    } else {
                                                        boolean bl34 = bl;
                                                        int n37 = 17040093;
                                                        string18 = bl34.getString(n37);
                                                    }
                                                }
                                                break block103;
                                            }
                                            string18 = string14;
                                        }
                                        if ((n13 = time2.hour) == (n12 = 12) && bl8 && !bl9) {
                                            if (l2 != null) {
                                                boolean bl35 = bl;
                                                int n38 = 17040092;
                                                string17 = bl35.getString(n38);
                                            } else {
                                                boolean bl36 = bl;
                                                int n39 = 17040091;
                                                string17 = bl36.getString(n39);
                                            }
                                        } else {
                                            string17 = string19;
                                        }
                                    }
                                    Time time15 = time2;
                                    String string26 = string17;
                                    string15 = time15.format(string26);
                                    if (bl3) {
                                        object = string15;
                                    } else {
                                        Time time16 = time;
                                        String string27 = string18;
                                        String string28 = time16.format(string27);
                                    }
                                    object2 = object;
                                    string12 = string15;
                                    break block113;
                                }
                                object2 = string15;
                                string12 = string16;
                            }
                            if (bl7) {
                                bl2 = bl7;
                            } else if (bl6) {
                                bl2 = false;
                            } else {
                                int n40 = n9;
                                int n41 = n6;
                                if (n40 != n41) {
                                    bl2 = true;
                                } else {
                                    Time time17 = new Time();
                                    time17.setToNow();
                                    int n42 = time17.year;
                                    int n43 = n9;
                                    int n44 = n42;
                                    boolean bl37 = n43 != n44;
                                    bl2 = bl37;
                                }
                            }
                            if (!bl4) break block114;
                            boolean bl38 = bl;
                            int n45 = 17039474;
                            string11 = bl38.getString(n45);
                            break block105;
                        }
                        if (!bl2) break block115;
                        if (bl4 != null) {
                            if (bl5) {
                                boolean bl39 = bl;
                                int n46 = 17039488;
                                string11 = bl39.getString(n46);
                                break block105;
                            } else {
                                boolean bl40 = bl;
                                int n47 = 17039482;
                                string11 = bl40.getString(n47);
                            }
                            break block105;
                        } else if (bl5) {
                            boolean bl41 = bl;
                            int n48 = 17039485;
                            string11 = bl41.getString(n48);
                            break block105;
                        } else {
                            boolean bl42 = bl;
                            int n49 = 17039477;
                            string11 = bl42.getString(n49);
                        }
                        break block105;
                    }
                    if (bl4 != null) {
                        if (bl5) {
                            boolean bl43 = bl;
                            int n50 = 17039487;
                            string11 = bl43.getString(n50);
                        } else {
                            boolean bl44 = bl;
                            int n51 = 17039486;
                            string11 = bl44.getString(n51);
                        }
                    } else if (bl5) {
                        boolean bl45 = bl;
                        int n52 = 17039484;
                        string11 = bl45.getString(n52);
                    } else {
                        boolean bl46 = bl;
                        int n53 = 17039483;
                        string11 = bl46.getString(n53);
                    }
                }
                if (bl) {
                    if (string2 != false) {
                        boolean bl47 = bl;
                        int n54 = 17039499;
                        string6 = bl47.getString(n54);
                    } else {
                        boolean bl48 = bl;
                        int n55 = 17039500;
                        string6 = bl48.getString(n55);
                    }
                } else if (string2 != false) {
                    boolean bl49 = bl;
                    int n56 = 17039501;
                    string6 = bl49.getString(n56);
                } else {
                    boolean bl50 = bl;
                    int n57 = 17039490;
                    string6 = bl50.getString(n57);
                }
                if (bl5 && (n5 = n10) != (n4 = n7)) {
                    Object[] objectArray = new Object[1];
                    Time time18 = time2;
                    String string29 = string11;
                    String string30 = time18.format(string29);
                    objectArray[0] = string30;
                    Formatter formatter3 = formatter;
                    String string31 = "%s";
                    Object[] objectArray2 = objectArray;
                    formatter2 = formatter3.format(string31, objectArray2);
                    String string32 = string6;
                    return formatter2;
                }
                int n58 = n9;
                int n59 = n6;
                if (n58 != n59 || bl5) {
                    Time time19 = time2;
                    String string33 = string11;
                    String string34 = time19.format(string33);
                    Time time20 = time;
                    String string35 = string11;
                    String string36 = time20.format(string35);
                    Object[] objectArray = new Object[]{string5, string34, string12, string13, string36, object2};
                    Formatter formatter4 = formatter;
                    String string37 = string6;
                    Object[] objectArray3 = objectArray;
                    formatter2 = formatter4.format(string37, objectArray3);
                    String string38 = string6;
                    return formatter2;
                }
                if (bl4) {
                    string10 = NUMERIC_MONTH_FORMAT;
                } else if (bl4 != null) {
                    boolean bl51 = bl;
                    int n60 = 17039521;
                    string10 = bl51.getString(n60);
                } else {
                    string10 = MONTH_FORMAT;
                }
                Time time21 = time2;
                String string39 = string10;
                string14 = time21.format(string39);
                Time time22 = time2;
                String string40 = MONTH_DAY_FORMAT;
                String string41 = time22.format(string40);
                Time time23 = time2;
                String string42 = YEAR_FORMAT;
                String string43 = time23.format(string42);
                if (bl3) {
                    string9 = null;
                } else {
                    Time time24 = time;
                    String string44 = string10;
                    string9 = time24.format(string44);
                }
                if (bl3) {
                    string8 = null;
                } else {
                    Time time25 = time;
                    String string45 = MONTH_DAY_FORMAT;
                    string8 = time25.format(string45);
                }
                if (bl3) {
                    string7 = null;
                } else {
                    Time time26 = time;
                    String string46 = YEAR_FORMAT;
                    string7 = time26.format(string46);
                }
                if ((n3 = n10) != (n2 = n7)) {
                    int n61 = 0;
                    if (bl) {
                        n61 = 1;
                    }
                    if (bl2) {
                        n61 += 2;
                    }
                    if (string2 != false) {
                        n61 += 4;
                    }
                    if (string41 != false) {
                        n61 += 8;
                    }
                    int n62 = sameYearTable[n61];
                    boolean bl52 = bl;
                    int n63 = n62;
                    String string47 = bl52.getString(n63);
                    Object[] objectArray = new Object[]{string5, string14, string41, string43, string12, string13, string9, string8, string7, object2};
                    Formatter formatter5 = formatter;
                    String string48 = string47;
                    Object[] objectArray4 = objectArray;
                    formatter2 = formatter5.format(string48, objectArray4);
                    String string49 = string47;
                    return formatter2;
                }
                int n64 = n11;
                int n65 = n8;
                if (n64 != n65) {
                    int n66 = 0;
                    if (bl) {
                        n66 = 1;
                    }
                    if (bl2) {
                        n66 += 2;
                    }
                    if (string2 != false) {
                        n66 += 4;
                    }
                    if (string41 != false) {
                        n66 += 8;
                    }
                    int n67 = sameMonthTable[n66];
                    boolean bl53 = bl;
                    int n68 = n67;
                    String string50 = bl53.getString(n68);
                    Object[] objectArray = new Object[]{string5, string14, string41, string43, string12, string13, string9, string8, string7, object2};
                    Formatter formatter6 = formatter;
                    String string51 = string50;
                    Object[] objectArray5 = objectArray;
                    formatter2 = formatter6.format(string51, objectArray5);
                    String string52 = string50;
                    return formatter2;
                }
                Object var232_225 = (n & 0x10) != 0 ? null : null;
                string7 = string2 == false && var232_225 == null && !bl ? null : var232_225;
                String string53 = "";
                if (string2 != false) {
                    if (bl3) {
                        object2 = string12;
                    } else {
                        boolean bl54 = bl;
                        int n69 = 17039489;
                        String string54 = bl54.getString(n69);
                        Object[] objectArray = new Object[]{string12, object2};
                        String string55 = string54;
                        Object[] objectArray6 = objectArray;
                        object2 = String.format(string55, objectArray6);
                    }
                } else {
                    object2 = string53;
                }
                string6 = "";
                string4 = "";
                if (string7 == null) break block116;
                Time time27 = time2;
                String string56 = string11;
                string4 = time27.format(string56);
                if (bl) {
                    if (string2 != false) {
                        boolean bl55 = bl;
                        int n70 = 17039502;
                        string3 = bl55.getString(n70);
                        break block108;
                    } else {
                        boolean bl56 = bl;
                        int n71 = 17039503;
                        string3 = bl56.getString(n71);
                    }
                    break block108;
                } else {
                    if (string2 == false) {
                        Object[] objectArray = new Object[]{string4};
                        Formatter formatter7 = formatter;
                        String string57 = "%s";
                        Object[] objectArray7 = objectArray;
                        formatter2 = formatter7.format(string57, objectArray7);
                        String string58 = string6;
                        return formatter2;
                    }
                    boolean bl57 = bl;
                    int n72 = 17039481;
                    string3 = bl57.getString(n72);
                }
                break block108;
            }
            if (bl) {
                if (string2 == false) {
                    Object[] objectArray = new Object[]{string5};
                    Formatter formatter8 = formatter;
                    String string59 = "%s";
                    Object[] objectArray8 = objectArray;
                    formatter2 = formatter8.format(string59, objectArray8);
                    String string60 = string6;
                    return formatter2;
                }
                boolean bl58 = bl;
                int n73 = 17039504;
                string3 = bl58.getString(n73);
            } else {
                if (string2 != false) {
                    Object[] objectArray = new Object[]{object2};
                    Formatter formatter9 = formatter;
                    String string61 = "%s";
                    Object[] objectArray9 = objectArray;
                    formatter2 = formatter9.format(string61, objectArray9);
                    String string62 = string6;
                    return formatter2;
                }
                string3 = string6;
            }
        }
        Object[] objectArray = new Object[]{object2, string5, string4};
        formatter2 = formatter.format(string3, objectArray);
        String string63 = string3;
        return formatter2;
    }

    public static String formatDateTime(Context context, long l, int n) {
        Context context2 = context;
        long l2 = l;
        long l3 = l;
        int n2 = n;
        return DateUtils.formatDateRange(context2, l2, l3, n2);
    }

    public static String formatElapsedTime(long l) {
        return DateUtils.formatElapsedTime(null, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatElapsedTime(StringBuilder stringBuilder, long l) {
        DateUtils.initFormatStrings();
        long l2 = 0L;
        long l3 = 0L;
        if (l >= 3600L) {
            l2 = l / 3600L;
            long l4 = 3600L * l2;
            l -= l4;
        }
        if (l >= 60L) {
            l3 = l / 60L;
            long l5 = 60L * l3;
            l -= l5;
        }
        long l6 = l;
        if (l2 > 0L) {
            String string2 = sElapsedFormatHMMSS;
            return DateUtils.formatElapsedTime(stringBuilder, string2, l2, l3, l6);
        }
        String string3 = sElapsedFormatMMSS;
        StringBuilder stringBuilder2 = stringBuilder;
        long l7 = l3;
        long l8 = l6;
        return DateUtils.formatElapsedTime(stringBuilder2, string3, l7, l8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String formatElapsedTime(StringBuilder stringBuilder, String string2, long l, long l2) {
        if (!FAST_FORMAT_MMSS.equals(string2)) {
            Object[] objectArray = new Object[2];
            Long l3 = l;
            objectArray[0] = l3;
            Long l4 = l2;
            objectArray[1] = l4;
            return String.format(string2, objectArray);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2 == null) {
            stringBuilder2 = new StringBuilder(8);
        } else {
            stringBuilder2.setLength(0);
        }
        if (l < 10L) {
            StringBuilder stringBuilder3 = stringBuilder2.append('0');
        } else {
            char c = DateUtils.toDigitChar(l / 10L);
            StringBuilder stringBuilder4 = stringBuilder2.append(c);
        }
        char c = DateUtils.toDigitChar(l % 10L);
        StringBuilder stringBuilder5 = stringBuilder2.append(c);
        StringBuilder stringBuilder6 = stringBuilder2.append(':');
        if (l2 < 10L) {
            StringBuilder stringBuilder7 = stringBuilder2.append('0');
        } else {
            char c2 = DateUtils.toDigitChar(l2 / 10L);
            StringBuilder stringBuilder8 = stringBuilder2.append(c2);
        }
        char c3 = DateUtils.toDigitChar(l2 % 10L);
        StringBuilder stringBuilder9 = stringBuilder2.append(c3);
        return stringBuilder2.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String formatElapsedTime(StringBuilder stringBuilder, String string2, long l, long l2, long l3) {
        if (!FAST_FORMAT_HMMSS.equals(string2)) {
            Object[] objectArray = new Object[3];
            Long l4 = l;
            objectArray[0] = l4;
            Long l5 = l2;
            objectArray[1] = l5;
            Long l6 = l3;
            objectArray[2] = l6;
            return String.format(string2, objectArray);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2 == null) {
            stringBuilder2 = new StringBuilder(8);
        } else {
            stringBuilder2.setLength(0);
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(l);
        StringBuilder stringBuilder4 = stringBuilder2.append(':');
        if (l2 < 10L) {
            StringBuilder stringBuilder5 = stringBuilder2.append('0');
        } else {
            char c = DateUtils.toDigitChar(l2 / 10L);
            StringBuilder stringBuilder6 = stringBuilder2.append(c);
        }
        char c = DateUtils.toDigitChar(l2 % 10L);
        StringBuilder stringBuilder7 = stringBuilder2.append(c);
        StringBuilder stringBuilder8 = stringBuilder2.append(':');
        if (l3 < 10L) {
            StringBuilder stringBuilder9 = stringBuilder2.append('0');
        } else {
            char c2 = DateUtils.toDigitChar(l3 / 10L);
            StringBuilder stringBuilder10 = stringBuilder2.append(c2);
        }
        char c3 = DateUtils.toDigitChar(l3 % 10L);
        StringBuilder stringBuilder11 = stringBuilder2.append(c3);
        return stringBuilder2.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CharSequence formatSameDayTime(long l, long l2, int n, int n2) {
        java.text.DateFormat dateFormat;
        int n3;
        int n4;
        int n5;
        int n6;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        Date date = gregorianCalendar.getTime();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(l2);
        int n7 = gregorianCalendar.get(1);
        int n8 = gregorianCalendar2.get(1);
        if (n7 != n8 && (n6 = gregorianCalendar.get(2)) != (n5 = gregorianCalendar2.get(2)) && (n4 = gregorianCalendar.get(5)) != (n3 = gregorianCalendar2.get(5))) {
            dateFormat = java.text.DateFormat.getTimeInstance(n2);
            return dateFormat.format(date);
        }
        dateFormat = java.text.DateFormat.getDateInstance(n);
        return dateFormat.format(date);
    }

    public static String getAMPMString(int n) {
        Resources resources = Resources.getSystem();
        int[] nArray = sAmPm;
        int n2 = n - 0;
        int n3 = nArray[n2];
        return resources.getString(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getDayOfWeekString(int n, int n2) {
        int[] nArray;
        switch (n2) {
            default: {
                nArray = sDaysMedium;
                break;
            }
            case 10: {
                nArray = sDaysLong;
                break;
            }
            case 20: {
                nArray = sDaysMedium;
                break;
            }
            case 30: {
                nArray = sDaysShort;
                break;
            }
            case 40: {
                nArray = sDaysShort;
                break;
            }
            case 50: {
                nArray = sDaysShortest;
            }
        }
        Resources resources = Resources.getSystem();
        int n3 = n - 1;
        int n4 = nArray[n3];
        return resources.getString(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getMonthString(int n, int n2) {
        int[] nArray;
        switch (n2) {
            default: {
                nArray = sMonthsMedium;
                break;
            }
            case 10: {
                nArray = sMonthsLong;
                break;
            }
            case 20: {
                nArray = sMonthsMedium;
                break;
            }
            case 30: {
                nArray = sMonthsMedium;
                break;
            }
            case 40: {
                nArray = sMonthsMedium;
                break;
            }
            case 50: {
                nArray = sMonthsShortest;
            }
        }
        Resources resources = Resources.getSystem();
        int n3 = n - 0;
        int n4 = nArray[n3];
        return resources.getString(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence getRelativeDateTimeString(Context context, long l, long l2, long l3, int n) {
        Resources resources = Resources.getSystem();
        long l4 = System.currentTimeMillis();
        long l5 = Math.abs(l4 - l);
        if (l3 > 604800000L) {
            l3 = 604800000L;
        } else if (l3 < 86400000L) {
            l3 = 86400000L;
        }
        Context context2 = context;
        long l6 = l;
        long l7 = l;
        String string2 = DateUtils.formatDateRange(context2, l6, l7, 1);
        if (l5 < l3) {
            long l8 = l;
            long l9 = l4;
            long l10 = l2;
            int n2 = n;
            CharSequence charSequence = DateUtils.getRelativeTimeSpanString(l8, l9, l10, n2);
            Object[] objectArray = new Object[]{charSequence, string2};
            return resources.getString(17040090, objectArray);
        }
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString(context, l, false);
        Object[] objectArray = new Object[]{charSequence, string2};
        return resources.getString(17039480, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String getRelativeDayString(Resources resources, long l, long l2) {
        Time time = new Time();
        time.set(l);
        Time time2 = new Time();
        time2.set(l2);
        long l3 = time.gmtoff;
        int n = Time.getJulianDay(l, l3);
        long l4 = time2.gmtoff;
        int n2 = Math.abs(Time.getJulianDay(l2, l4) - n);
        n = l2 > l ? 1 : 0;
        if (n2 == 1) {
            if (n == 0) return resources.getString(17039468);
            return resources.getString(17039466);
        }
        if (n2 == 0) {
            return resources.getString(17039467);
        }
        int n3 = n != 0 ? 17760260 : 17760264;
        String string2 = resources.getQuantityString(n3, n2);
        Object[] objectArray = new Object[1];
        Integer n4 = n2;
        objectArray[0] = n4;
        return String.format(string2, objectArray);
    }

    public static CharSequence getRelativeTimeSpanString(long l) {
        long l2 = System.currentTimeMillis();
        return DateUtils.getRelativeTimeSpanString(l, l2, 60000L);
    }

    public static CharSequence getRelativeTimeSpanString(long l, long l2, long l3) {
        long l4 = l;
        long l5 = l2;
        long l6 = l3;
        return DateUtils.getRelativeTimeSpanString(l4, l5, l6, 65556);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence getRelativeTimeSpanString(long l, long l2, long l3, int n) {
        block5: {
            int n2;
            long l4;
            Resources resources;
            block2: {
                long l5;
                boolean bl;
                block4: {
                    block3: {
                        block1: {
                            resources = Resources.getSystem();
                            bl = (0xC0000 & n) != 0;
                            n = l2 >= l ? 1 : 0;
                            l5 = Math.abs(l2 - l);
                            if (l5 >= 60000L || l3 >= 60000L) break block1;
                            l4 = l5 / 1000L;
                            n2 = n != 0 ? (bl ? 17760265 : 0x10F0000) : (bl ? 17760269 : 17760261);
                            break block2;
                        }
                        if (l5 >= 3600000L || l3 >= 3600000L) break block3;
                        l4 = l5 / 60000L;
                        n2 = n != 0 ? (bl ? 17760266 : 0x10F0001) : (bl ? 17760270 : 17760262);
                        break block2;
                    }
                    if (l5 >= 86400000L || l3 >= 86400000L) break block4;
                    l4 = l5 / 3600000L;
                    n2 = n != 0 ? (bl ? 17760267 : 17760258) : (bl ? 0x10F000F : 17760263);
                    break block2;
                }
                if (l5 < 604800000L && l3 < 604800000L) {
                    l4 = l5 / 86400000L;
                    n2 = n != 0 ? (bl ? 17760268 : 17760260) : (bl ? 0x10F0010 : 17760264);
                }
                break block5;
            }
            int n3 = (int)l4;
            String string2 = resources.getQuantityString(n2, n3);
            Object[] objectArray = new Object[1];
            Long l6 = l4;
            objectArray[0] = l6;
            return String.format(string2, objectArray);
        }
        long l7 = l;
        long l8 = l;
        int n4 = n;
        return DateUtils.formatDateRange(null, l7, l8, n4);
    }

    public static CharSequence getRelativeTimeSpanString(Context context, long l) {
        return DateUtils.getRelativeTimeSpanString(context, l, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence getRelativeTimeSpanString(Context context, long l, boolean bl) {
        int n;
        String string2;
        int n2;
        int n3;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (sNowTime == null) {
            sNowTime = new Time();
            sThenTime = new Time();
        }
        sNowTime.set(l2);
        sThenTime.set(l);
        if (l3 < 86400000L && (n3 = DateUtils.sNowTime.weekDay) != (n2 = DateUtils.sThenTime.weekDay)) {
            Context context2 = context;
            long l4 = l;
            long l5 = l;
            string2 = DateUtils.formatDateRange(context2, l4, l5, 1);
            n = 17040076;
        } else {
            int n4 = DateUtils.sNowTime.year;
            int n5 = DateUtils.sThenTime.year;
            if (n4 != n5) {
                Context context3 = context;
                long l6 = l;
                long l7 = l;
                string2 = DateUtils.formatDateRange(context3, l6, l7, 131092);
                n = 17040075;
            } else {
                Context context4 = context;
                long l8 = l;
                long l9 = l;
                string2 = DateUtils.formatDateRange(context4, l8, l9, 65552);
                n = 17040075;
            }
        }
        if (!bl) return string2;
        Resources resources = context.getResources();
        Object[] objectArray = new Object[]{string2};
        return resources.getString(n, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getStandaloneMonthString(int n, int n2) {
        int[] nArray;
        switch (n2) {
            default: {
                nArray = sMonthsMedium;
                break;
            }
            case 10: {
                nArray = sMonthsStandaloneLong;
                break;
            }
            case 20: {
                nArray = sMonthsMedium;
                break;
            }
            case 30: {
                nArray = sMonthsMedium;
                break;
            }
            case 40: {
                nArray = sMonthsMedium;
                break;
            }
            case 50: {
                nArray = sMonthsShortest;
            }
        }
        Resources resources = Resources.getSystem();
        int n3 = n - 0;
        int n4 = nArray[n3];
        return resources.getString(n4);
    }

    private static void initFormatStrings() {
        Object object = sLock;
        synchronized (object) {
            Resources resources = Resources.getSystem();
            Configuration configuration = resources.getConfiguration();
            if (sLastConfig == null || !sLastConfig.equals(configuration)) {
                sLastConfig = configuration;
                sStatusTimeFormat = java.text.DateFormat.getTimeInstance(3);
                sElapsedFormatMMSS = resources.getString(17040095);
                sElapsedFormatHMMSS = resources.getString(17040096);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isToday(long l) {
        Time time = new Time();
        time.set(l);
        int n = time.year;
        int n2 = time.month;
        int n3 = time.monthDay;
        long l2 = System.currentTimeMillis();
        time.set(l2);
        int n4 = time.year;
        if (n == n4) return false;
        int n5 = time.month;
        if (n2 == n5) return false;
        int n6 = time.monthDay;
        if (n3 == n6) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUTC(String string2) {
        if (string2.length() == 16 && string2.charAt(15) == 'Z') {
            return true;
        }
        if (string2.length() != 9) return false;
        if (string2.charAt(8) != 'Z') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Calendar newCalendar(boolean bl) {
        if (!bl) return Calendar.getInstance();
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public static final CharSequence timeString(long l) {
        DateUtils.initFormatStrings();
        java.text.DateFormat dateFormat = sStatusTimeFormat;
        Long l2 = l;
        return dateFormat.format(l2);
    }

    private static char toDigitChar(long l) {
        return (char)(48L + l);
    }

    public static String writeDateTime(Calendar calendar) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        long l = calendar.getTimeInMillis();
        gregorianCalendar.setTimeInMillis(l);
        return DateUtils.writeDateTime((Calendar)gregorianCalendar, true);
    }

    public static String writeDateTime(Calendar calendar, StringBuilder stringBuilder) {
        int n = calendar.get(1);
        char c = (char)(n % 10 + 48);
        stringBuilder.setCharAt(3, c);
        int n2 = n / 10;
        char c2 = (char)(n2 % 10 + 48);
        stringBuilder.setCharAt(2, c2);
        int n3 = n2 / 10;
        char c3 = (char)(n3 % 10 + 48);
        stringBuilder.setCharAt(1, c3);
        char c4 = (char)(n3 / 10 % 10 + 48);
        stringBuilder.setCharAt(0, c4);
        int n4 = calendar.get(2) + 1;
        char c5 = (char)(n4 % 10 + 48);
        stringBuilder.setCharAt(5, c5);
        char c6 = (char)(n4 / 10 % 10 + 48);
        stringBuilder.setCharAt(4, c6);
        int n5 = calendar.get(5);
        char c7 = (char)(n5 % 10 + 48);
        stringBuilder.setCharAt(7, c7);
        char c8 = (char)(n5 / 10 % 10 + 48);
        stringBuilder.setCharAt(6, c8);
        stringBuilder.setCharAt(8, 'T');
        int n6 = calendar.get(11);
        char c9 = (char)(n6 % 10 + 48);
        stringBuilder.setCharAt(10, c9);
        char c10 = (char)(n6 / 10 % 10 + 48);
        stringBuilder.setCharAt(9, c10);
        int n7 = calendar.get(12);
        char c11 = (char)(n7 % 10 + 48);
        stringBuilder.setCharAt(12, c11);
        char c12 = (char)(n7 / 10 % 10 + 48);
        stringBuilder.setCharAt(11, c12);
        int n8 = calendar.get(13);
        char c13 = (char)(n8 % 10 + 48);
        stringBuilder.setCharAt(14, c13);
        char c14 = (char)(n8 / 10 % 10 + 48);
        stringBuilder.setCharAt(13, c14);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String writeDateTime(Calendar calendar, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.ensureCapacity(16);
        if (bl) {
            stringBuilder.setLength(16);
            stringBuilder.setCharAt(15, 'Z');
            return DateUtils.writeDateTime(calendar, stringBuilder);
        }
        stringBuilder.setLength(15);
        return DateUtils.writeDateTime(calendar, stringBuilder);
    }
}

