/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.res.Resources;
import java.util.Locale;
import java.util.TimeZone;

public class Time {
    private static final int[] DAYS_PER_MONTH;
    public static final int EPOCH_JULIAN_DAY = 2440588;
    public static final int FRIDAY = 5;
    public static final int HOUR = 3;
    public static final int MINUTE = 2;
    public static final int MONDAY = 1;
    public static final int MONTH = 5;
    public static final int MONTH_DAY = 4;
    public static final int SATURDAY = 6;
    public static final int SECOND = 1;
    public static final int SUNDAY = 0;
    public static final int THURSDAY = 4;
    public static final String TIMEZONE_UTC = "UTC";
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int WEEK_DAY = 7;
    public static final int WEEK_NUM = 9;
    public static final int YEAR = 6;
    public static final int YEAR_DAY = 8;
    private static final String Y_M_D = "%Y-%m-%d";
    private static final String Y_M_D_T_H_M_S_000 = "%Y-%m-%dT%H:%M:%S.000";
    private static final String Y_M_D_T_H_M_S_000_Z = "%Y-%m-%dT%H:%M:%S.000Z";
    private static String sAm;
    private static String sDateCommand;
    private static String sDateOnlyFormat;
    private static String sDateTimeFormat;
    private static Locale sLocale;
    private static String[] sLongMonths;
    private static String[] sLongStandaloneMonths;
    private static String[] sLongWeekdays;
    private static String sPm;
    private static String[] sShortMonths;
    private static String[] sShortWeekdays;
    private static final int[] sThursdayOffset;
    private static String sTimeOnlyFormat;
    public boolean allDay;
    public long gmtoff;
    public int hour;
    public int isDst;
    public int minute;
    public int month;
    public int monthDay;
    public int second;
    public String timezone;
    public int weekDay;
    public int year;
    public int yearDay;

    static {
        sDateCommand = "%a %b %e %H:%M:%S %Z %Y";
        DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        sThursdayOffset = new int[]{-3, 3, 2, 1, 0, -1, -2};
    }

    public Time() {
        String string2 = TimeZone.getDefault().getID();
        this(string2);
    }

    public Time(Time time) {
        this.set(time);
    }

    public Time(String string2) {
        if (string2 == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = string2;
        this.year = 1970;
        this.monthDay = 1;
        this.isDst = -1;
    }

    public static native int compare(Time var0, Time var1);

    private native String format1(String var1);

    public static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    public static int getJulianDay(long l, long l2) {
        long l3 = l2 * 1000L;
        return (int)((l + l3) / 86400000L) + 2440588;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEpoch(Time time) {
        if (Time.getJulianDay(time.toMillis(true), 0L) != 2440588) return false;
        return true;
    }

    private native boolean nativeParse(String var1);

    private native boolean nativeParse3339(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean after(Time time) {
        if (Time.compare(this, time) <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean before(Time time) {
        if (Time.compare(this, time) >= 0) return false;
        return true;
    }

    public void clear(String string2) {
        if (string2 == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = string2;
        this.allDay = false;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = 0;
        this.month = 0;
        this.year = 0;
        this.weekDay = 0;
        this.yearDay = 0;
        this.gmtoff = 0L;
        this.isDst = -1;
    }

    public String format(String string2) {
        synchronized (Time.class) {
            Locale locale;
            Locale locale2 = Locale.getDefault();
            if (sLocale == null || locale2 == null || !locale2.equals(locale = sLocale)) {
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                String string12;
                String string13;
                String string14;
                String string15;
                String string16;
                String string17;
                String string18;
                String string19;
                String string20;
                String string21;
                String string22;
                String string23;
                String string24;
                String string25;
                String string26;
                String string27;
                String string28;
                String string29;
                String string30;
                String string31;
                String string32;
                String string33;
                String string34;
                String string35;
                String string36;
                String string37;
                String string38;
                String string39;
                String string40;
                String string41;
                String string42;
                String string43;
                String string44;
                String string45;
                String string46;
                String string47;
                Resources resources = Resources.getSystem();
                String string48 = resources.getString(17039412);
                String[] stringArray = new String[]{string48, string47 = resources.getString(17039413), string46 = resources.getString(17039414), string45 = resources.getString(17039415), string44 = resources.getString(17039416), string43 = resources.getString(17039417), string42 = resources.getString(17039418), string41 = resources.getString(17039419), string40 = resources.getString(17039420), string39 = resources.getString(17039421), string38 = resources.getString(17039422), string37 = resources.getString(17039423)};
                sShortMonths = stringArray;
                String string49 = resources.getString(17039400);
                String[] stringArray2 = new String[]{string49, string36 = resources.getString(17039401), string35 = resources.getString(17039402), string34 = resources.getString(17039403), string33 = resources.getString(17039404), string32 = resources.getString(17039405), string31 = resources.getString(17039406), string30 = resources.getString(17039407), string29 = resources.getString(17039408), string28 = resources.getString(17039409), string27 = resources.getString(17039410), string26 = resources.getString(17039411)};
                sLongMonths = stringArray2;
                String string50 = resources.getString(17039388);
                String[] stringArray3 = new String[]{string50, string25 = resources.getString(17039389), string24 = resources.getString(17039390), string23 = resources.getString(17039391), string22 = resources.getString(17039392), string21 = resources.getString(17039393), string20 = resources.getString(17039394), string19 = resources.getString(17039395), string18 = resources.getString(17039396), string17 = resources.getString(17039397), string16 = resources.getString(17039398), string15 = resources.getString(17039399)};
                sLongStandaloneMonths = stringArray3;
                String string51 = resources.getString(17039443);
                String[] stringArray4 = new String[]{string51, string14 = resources.getString(17039444), string13 = resources.getString(17039445), string12 = resources.getString(17039446), string11 = resources.getString(17039447), string10 = resources.getString(17039448), string9 = resources.getString(17039449)};
                sShortWeekdays = stringArray4;
                String string52 = resources.getString(17039436);
                String[] stringArray5 = new String[]{string52, string8 = resources.getString(17039437), string7 = resources.getString(17039438), string6 = resources.getString(17039439), string5 = resources.getString(17039440), string4 = resources.getString(17039441), string3 = resources.getString(17039442)};
                sLongWeekdays = stringArray5;
                sTimeOnlyFormat = resources.getString(17039478);
                sDateOnlyFormat = resources.getString(17039477);
                sDateTimeFormat = resources.getString(17039479);
                sAm = resources.getString(17039464);
                sPm = resources.getString(17039465);
                sLocale = locale2;
            }
            String string53 = this.format1(string2);
            return string53;
        }
    }

    public native String format2445();

    /*
     * Enabled aggressive block sorting
     */
    public String format3339(boolean bl) {
        if (bl) {
            return this.format(Y_M_D);
        }
        String string2 = this.timezone;
        if (TIMEZONE_UTC.equals(string2)) {
            return this.format(Y_M_D_T_H_M_S_000_Z);
        }
        String string3 = this.format(Y_M_D_T_H_M_S_000);
        String string4 = this.gmtoff < 0L ? "-" : "+";
        int n = (int)Math.abs(this.gmtoff);
        int n2 = n % 3600 / 60;
        int n3 = n / 3600;
        Object[] objectArray = new Object[4];
        objectArray[0] = string3;
        objectArray[1] = string4;
        Integer n4 = n3;
        objectArray[2] = n4;
        Integer n5 = n2;
        objectArray[3] = n5;
        return String.format("%s%s%02d:%02d", objectArray);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public int getActualMaximum(int n) {
        int n2 = 59;
        int n3 = 0;
        block10: do {
            switch (n3 == 0 ? n : n3) {
                default: {
                    String string2 = "bad field=" + n;
                    throw new RuntimeException(string2);
                }
                case 3: {
                    n2 = 23;
                    n3 = 1;
                    continue block10;
                }
                case 4: {
                    int[] nArray = DAYS_PER_MONTH;
                    int n4 = this.month;
                    int n5 = nArray[n4];
                    if (n5 != 28) {
                        n2 = n5;
                        n3 = 1;
                        continue block10;
                    }
                    int n6 = this.year;
                    if (n6 % 4 == 0 && (n6 % 100 != 0 || n6 % 400 == 0)) {
                        n2 = 29;
                        n3 = 1;
                        continue block10;
                    }
                    n2 = 28;
                    n3 = 1;
                    continue block10;
                }
                case 5: {
                    n2 = 11;
                    n3 = 1;
                    continue block10;
                }
                case 6: {
                    n2 = 2037;
                    n3 = 1;
                    continue block10;
                }
                case 7: {
                    n2 = 6;
                    n3 = 1;
                    continue block10;
                }
                case 8: {
                    int n7 = this.year;
                    n2 = n7 % 4 == 0 && (n7 % 100 != 0 || n7 % 400 == 0) ? 365 : 364;
                }
                case 1: 
                case 2: {
                    return n2;
                }
                case 9: 
            }
            throw new RuntimeException("WEEK_NUM not implemented");
        } while (true);
        throw new RuntimeException("WEEK_NUM not implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getWeekNumber() {
        int n;
        int n2 = this.yearDay;
        int[] nArray = sThursdayOffset;
        int n3 = this.weekDay;
        int n4 = nArray[n3];
        int n5 = n2 + n4;
        if (n5 >= 0 && n5 <= 364) {
            return n5 / 7 + 1;
        }
        Time time = new Time(this);
        int n6 = time.monthDay;
        int[] nArray2 = sThursdayOffset;
        int n7 = this.weekDay;
        int n8 = nArray2[n7];
        time.monthDay = n = n6 + n8;
        long l = time.normalize(true);
        return time.yearDay / 7 + 1;
    }

    public native long normalize(boolean var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse(String string2) {
        if (!this.nativeParse(string2)) return false;
        this.timezone = TIMEZONE_UTC;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse3339(String string2) {
        if (!this.nativeParse3339(string2)) return false;
        this.timezone = TIMEZONE_UTC;
        return true;
    }

    public void set(int n, int n2, int n3) {
        this.allDay = true;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = n;
        this.month = n2;
        this.year = n3;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.allDay = false;
        this.second = n;
        this.minute = n2;
        this.hour = n3;
        this.monthDay = n4;
        this.month = n5;
        this.year = n6;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public native void set(long var1);

    public void set(Time time) {
        long l;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        String string2;
        this.timezone = string2 = time.timezone;
        this.allDay = bl = time.allDay;
        this.second = n9 = time.second;
        this.minute = n8 = time.minute;
        this.hour = n7 = time.hour;
        this.monthDay = n6 = time.monthDay;
        this.month = n5 = time.month;
        this.year = n4 = time.year;
        this.weekDay = n3 = time.weekDay;
        this.yearDay = n2 = time.yearDay;
        this.isDst = n = time.isDst;
        this.gmtoff = l = time.gmtoff;
    }

    public long setJulianDay(int n) {
        int n2;
        long l = (long)(n - 2440588) * 86400000L;
        this.set(l);
        long l2 = this.gmtoff;
        int n3 = Time.getJulianDay(l, l2);
        int n4 = n - n3;
        this.monthDay = n2 = this.monthDay + n4;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        return this.normalize(true);
    }

    public native void setToNow();

    public native void switchTimezone(String var1);

    public native long toMillis(boolean var1);

    public native String toString();
}

