/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class ArrowKeyMovementMethod
implements MovementMethod {
    private static final Object LAST_TAP_DOWN = new Object();
    private static ArrowKeyMovementMethod sInstance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean down(TextView textView, Spannable spannable) {
        boolean bl = this.isCap(spannable);
        boolean bl2 = this.isAlt(spannable);
        Layout layout2 = textView.getLayout();
        if (bl) {
            if (!bl2) return Selection.extendDown(spannable, layout2);
            int n = spannable.length();
            Selection.extendSelection(spannable, n);
            return true;
        }
        if (!bl2) return Selection.moveDown(spannable, layout2);
        int n = spannable.length();
        Selection.setSelection(spannable, n);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean executeDown(TextView textView, Spannable spannable, int n) {
        boolean bl = false;
        switch (n) {
            case 19: {
                boolean bl2 = this.up(textView, spannable);
                bl = false | bl2;
                break;
            }
            case 20: {
                boolean bl3 = this.down(textView, spannable);
                bl = false | bl3;
                break;
            }
            case 21: {
                boolean bl4 = this.left(textView, spannable);
                bl = false | bl4;
                break;
            }
            case 22: {
                boolean bl5 = this.right(textView, spannable);
                bl = false | bl5;
                break;
            }
            case 23: {
                if (MetaKeyKeyListener.getMetaState(spannable, 65536) == 0 || !textView.showContextMenu()) break;
                bl = true;
                break;
            }
        }
        if (bl) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
            MetaKeyKeyListener.resetLockedMeta(spannable);
        }
        return bl;
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ArrowKeyMovementMethod();
        }
        return sInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAlt(Spannable spannable) {
        if (MetaKeyKeyListener.getMetaState(spannable, 2) != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCap(Spannable spannable) {
        if (MetaKeyKeyListener.getMetaState(spannable, 1) == 1) return true;
        if (MetaKeyKeyListener.getMetaState(spannable, 65536) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean left(TextView textView, Spannable spannable) {
        boolean bl = this.isCap(spannable);
        boolean bl2 = this.isAlt(spannable);
        Layout layout2 = textView.getLayout();
        if (bl) {
            if (!bl2) return Selection.extendLeft(spannable, layout2);
            return Selection.extendToLeftEdge(spannable, layout2);
        }
        if (!bl2) return Selection.moveLeft(spannable, layout2);
        return Selection.moveToLeftEdge(spannable, layout2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean right(TextView textView, Spannable spannable) {
        boolean bl = this.isCap(spannable);
        boolean bl2 = this.isAlt(spannable);
        Layout layout2 = textView.getLayout();
        if (bl) {
            if (!bl2) return Selection.extendRight(spannable, layout2);
            return Selection.extendToRightEdge(spannable, layout2);
        }
        if (!bl2) return Selection.moveRight(spannable, layout2);
        return Selection.moveToRightEdge(spannable, layout2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean up(TextView textView, Spannable spannable) {
        boolean bl = this.isCap(spannable);
        boolean bl2 = this.isAlt(spannable);
        Layout layout2 = textView.getLayout();
        if (bl) {
            if (!bl2) return Selection.extendUp(spannable, layout2);
            Selection.extendSelection(spannable, 0);
            return true;
        }
        if (!bl2) return Selection.moveUp(spannable, layout2);
        Selection.setSelection(spannable, 0);
        return true;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return true;
    }

    @Override
    public void initialize(TextView textView, Spannable spannable) {
        Selection.setSelection(spannable, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
        if (!this.executeDown(textView, spannable, n)) return false;
        MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
        MetaKeyKeyListener.resetLockedMeta(spannable);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyOther(TextView textView, Spannable spannable, KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 0) return false;
        if (keyEvent.getAction() != 2) return false;
        int n2 = keyEvent.getRepeatCount();
        boolean bl = false;
        while ((n2 += -1) > 0) {
            boolean bl2 = this.executeDown(textView, spannable, n);
            bl |= bl2;
        }
        return bl;
    }

    @Override
    public boolean onKeyUp(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public void onTakeFocus(TextView textView, Spannable spannable, int n) {
        if ((n & 0x82) != 0) {
            if (textView.getLayout() != null) {
                return;
            }
            int n2 = spannable.length();
            Selection.setSelection(spannable, n2);
            return;
        }
        int n3 = spannable.length();
        Selection.setSelection(spannable, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        int n = -1;
        int n2 = -1;
        if (motionEvent.getAction() == 1) {
            n = Touch.getInitialScrollX(textView, spannable);
            n2 = Touch.getInitialScrollY(textView, spannable);
        }
        boolean bl = Touch.onTouchEvent(textView, spannable, motionEvent);
        if (!textView.isFocused()) return bl;
        if (textView.didTouchFocusSelect()) return bl;
        if (motionEvent.getAction() != 0) {
            int n3;
            int n4;
            if (motionEvent.getAction() == 2) {
                if (!this.isCap(spannable)) return bl;
                if (!bl) return bl;
                textView.cancelLongPress();
                int n5 = (int)motionEvent.getX();
                int n6 = (int)motionEvent.getY();
                int n7 = textView.getOffset(n5, n6);
                Selection.extendSelection(spannable, n7);
                return true;
            }
            if (motionEvent.getAction() != 1) return bl;
            if (n2 >= 0 && n2 == (n4 = textView.getScrollY()) || n >= 0 && n != (n3 = textView.getScrollX())) {
                boolean bl2 = textView.moveCursorToVisibleOffset();
                return true;
            }
        } else {
            if (!this.isCap(spannable)) return bl;
            int n8 = (int)motionEvent.getX();
            int n9 = (int)motionEvent.getY();
            int n10 = textView.getOffset(n8, n9);
            Object object = LAST_TAP_DOWN;
            spannable.setSpan(object, n10, n10, 34);
            textView.getParent().requestDisallowInterceptTouchEvent(true);
            return bl;
        }
        int n11 = (int)motionEvent.getX();
        int n12 = (int)motionEvent.getY();
        int n13 = textView.getOffset(n11, n12);
        if (this.isCap(spannable)) {
            Object object = LAST_TAP_DOWN;
            spannable.removeSpan(object);
            Selection.extendSelection(spannable, n13);
        } else {
            Selection.setSelection(spannable, n13);
        }
        MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
        MetaKeyKeyListener.resetLockedMeta(spannable);
        return true;
    }

    @Override
    public boolean onTrackballEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        return false;
    }
}

