/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.view.KeyEvent;
import android.view.View;

public abstract class MetaKeyKeyListener {
    private static final Object ALT;
    private static final Object CAP;
    private static final int LOCKED = 0x4000011;
    private static final int LOCKED_SHIFT = 8;
    public static final int META_ALT_LOCKED = 512;
    private static final long META_ALT_MASK = 0x20202000202L;
    public static final int META_ALT_ON = 2;
    private static final long META_ALT_PRESSED = 0x200000000L;
    private static final long META_ALT_RELEASED = 0x20000000000L;
    private static final long META_ALT_USED = 0x2000000L;
    public static final int META_CAP_LOCKED = 256;
    private static final long META_CAP_PRESSED = 0x100000000L;
    private static final long META_CAP_RELEASED = 0x10000000000L;
    private static final long META_CAP_USED = 0x1000000L;
    public static final int META_SELECTING = 65536;
    private static final long META_SHIFT_MASK = 0x10101000101L;
    public static final int META_SHIFT_ON = 1;
    public static final int META_SYM_LOCKED = 1024;
    private static final long META_SYM_MASK = 0x40404000404L;
    public static final int META_SYM_ON = 4;
    private static final long META_SYM_PRESSED = 0x400000000L;
    private static final long META_SYM_RELEASED = 0x40000000000L;
    private static final long META_SYM_USED = 0x4000000L;
    private static final int PRESSED = 0x1000011;
    private static final int PRESSED_SHIFT = 32;
    private static final int RELEASED = 0x2000011;
    private static final int RELEASED_SHIFT = 40;
    private static final Object SELECTING;
    private static final Object SYM;
    private static final int USED = 0x3000011;
    private static final int USED_SHIFT = 24;

    static {
        CAP = new NoCopySpan.Concrete();
        ALT = new NoCopySpan.Concrete();
        SYM = new NoCopySpan.Concrete();
        SELECTING = new NoCopySpan.Concrete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long adjust(long l, int n, long l2) {
        if (((long)n << 32 & l) != 0L) {
            long l3 = (l2 ^ 0xFFFFL) & l;
            long l4 = n;
            long l5 = l3 | l4;
            long l6 = (long)n << 24;
            return l5 | l6;
        }
        if (((long)n << 40 & l) == 0L) return l;
        return (l2 ^ 0xFFFFL) & l;
    }

    private static void adjust(Spannable spannable, Object object) {
        int n = spannable.getSpanFlags(object);
        if (n == 0x1000011) {
            spannable.setSpan(object, 0, 0, 0x3000011);
            return;
        }
        if (n != 0x2000011) {
            return;
        }
        spannable.removeSpan(object);
    }

    public static long adjustMetaAfterKeypress(long l) {
        return MetaKeyKeyListener.adjust(MetaKeyKeyListener.adjust(MetaKeyKeyListener.adjust(l, 1, 0x10101000101L), 2, 0x20202000202L), 4, 0x40404000404L);
    }

    public static void adjustMetaAfterKeypress(Spannable spannable) {
        Object object = CAP;
        MetaKeyKeyListener.adjust(spannable, object);
        Object object2 = ALT;
        MetaKeyKeyListener.adjust(spannable, object2);
        Object object3 = SYM;
        MetaKeyKeyListener.adjust(spannable, object3);
    }

    public static void clearMetaKeyState(Editable editable, int n) {
        if ((n & 1) != 0) {
            Object object = CAP;
            editable.removeSpan(object);
        }
        if ((n & 2) != 0) {
            Object object = ALT;
            editable.removeSpan(object);
        }
        if ((n & 4) != 0) {
            Object object = SYM;
            editable.removeSpan(object);
        }
        if ((0x10000 & n) == 0) {
            return;
        }
        Object object = SELECTING;
        editable.removeSpan(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getActive(long l, int n, int n2, int n3) {
        if (((long)(n << 8) & l) != 0L) {
            return n3;
        }
        if (((long)n & l) == 0L) return 0;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getActive(CharSequence charSequence, Object object, int n, int n2) {
        if (!(charSequence instanceof Spanned)) {
            return 0;
        }
        int n3 = ((Spanned)charSequence).getSpanFlags(object);
        if (n3 == 0x4000011) {
            return n2;
        }
        if (n3 == 0) return 0;
        return n;
    }

    public static final int getMetaState(long l) {
        int n = MetaKeyKeyListener.getActive(l, 1, 1, 256);
        int n2 = MetaKeyKeyListener.getActive(l, 2, 2, 512);
        int n3 = n | n2;
        int n4 = MetaKeyKeyListener.getActive(l, 4, 4, 1024);
        return n3 | n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getMetaState(long l, int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                return MetaKeyKeyListener.getActive(l, n, 1, 2);
            }
            case 2: {
                return MetaKeyKeyListener.getActive(l, n, 1, 2);
            }
            case 4: 
        }
        return MetaKeyKeyListener.getActive(l, n, 1, 2);
    }

    public static final int getMetaState(CharSequence charSequence) {
        Object object = CAP;
        int n = MetaKeyKeyListener.getActive(charSequence, object, 1, 256);
        Object object2 = ALT;
        int n2 = MetaKeyKeyListener.getActive(charSequence, object2, 2, 512);
        int n3 = n | n2;
        Object object3 = SYM;
        int n4 = MetaKeyKeyListener.getActive(charSequence, object3, 4, 1024);
        int n5 = n3 | n4;
        Object object4 = SELECTING;
        int n6 = MetaKeyKeyListener.getActive(charSequence, object4, 65536, 65536);
        return n5 | n6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getMetaState(CharSequence charSequence, int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                Object object = CAP;
                return MetaKeyKeyListener.getActive(charSequence, object, 1, 2);
            }
            case 2: {
                Object object = ALT;
                return MetaKeyKeyListener.getActive(charSequence, object, 1, 2);
            }
            case 4: {
                Object object = SYM;
                return MetaKeyKeyListener.getActive(charSequence, object, 1, 2);
            }
            case 65536: 
        }
        Object object = SELECTING;
        return MetaKeyKeyListener.getActive(charSequence, object, 1, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long handleKeyDown(long l, int n, KeyEvent keyEvent) {
        if (n == 59) return MetaKeyKeyListener.press(l, 1, 0x10101000101L);
        if (n == 60) {
            return MetaKeyKeyListener.press(l, 1, 0x10101000101L);
        }
        if (n == 57) return MetaKeyKeyListener.press(l, 2, 0x20202000202L);
        if (n == 58) return MetaKeyKeyListener.press(l, 2, 0x20202000202L);
        if (n == 78) {
            return MetaKeyKeyListener.press(l, 2, 0x20202000202L);
        }
        if (n != 63) return l;
        return MetaKeyKeyListener.press(l, 4, 0x40404000404L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long handleKeyUp(long l, int n, KeyEvent keyEvent) {
        if (n == 59) return MetaKeyKeyListener.release(l, 1, 0x10101000101L);
        if (n == 60) {
            return MetaKeyKeyListener.release(l, 1, 0x10101000101L);
        }
        if (n == 57) return MetaKeyKeyListener.release(l, 2, 0x20202000202L);
        if (n == 58) return MetaKeyKeyListener.release(l, 2, 0x20202000202L);
        if (n == 78) {
            return MetaKeyKeyListener.release(l, 2, 0x20202000202L);
        }
        if (n != 63) return l;
        return MetaKeyKeyListener.release(l, 4, 0x40404000404L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMetaTracker(CharSequence charSequence, Object object) {
        Object object2 = CAP;
        if (object == object2) return true;
        Object object3 = ALT;
        if (object == object3) return true;
        Object object4 = SYM;
        if (object == object4) return true;
        Object object5 = SELECTING;
        if (object != object5) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSelectingMetaTracker(CharSequence charSequence, Object object) {
        Object object2 = SELECTING;
        if (object != object2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long press(long l, int n, long l2) {
        if (((long)n << 32 & l) != 0L) {
            return l;
        }
        if (((long)n << 40 & l) != 0L) {
            long l3 = (l2 ^ 0xFFFFL) & l;
            long l4 = n;
            long l5 = l3 | l4;
            long l6 = (long)n << 8;
            return l5 | l6;
        }
        if (((long)n << 24 & l) != 0L) return l;
        if (((long)n << 8 & l) != 0L) {
            long l7 = l2 ^ 0xFFFFL;
            l &= l7;
            return l;
        }
        long l8 = (long)n | l;
        long l9 = (long)n << 32;
        return l8 | l9;
    }

    private void press(Editable editable, Object object) {
        int n = editable.getSpanFlags(object);
        if (n == 0x1000011) {
            return;
        }
        if (n == 0x2000011) {
            editable.setSpan(object, 0, 0, 0x4000011);
            return;
        }
        if (n == 0x3000011) {
            return;
        }
        if (n == 0x4000011) {
            editable.removeSpan(object);
            return;
        }
        editable.setSpan(object, 0, 0, 0x1000011);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long release(long l, int n, long l2) {
        if (((long)n << 24 & l) != 0L) {
            long l3 = 0xFFFFL ^ l2;
            l &= l3;
            return l;
        }
        if (((long)n << 32 & l) == 0L) return l;
        long l4 = (long)n | l;
        long l5 = (long)n << 40;
        return l4 | l5;
    }

    private void release(Editable editable, Object object) {
        int n = editable.getSpanFlags(object);
        if (n == 0x3000011) {
            editable.removeSpan(object);
            return;
        }
        if (n != 0x1000011) {
            return;
        }
        editable.setSpan(object, 0, 0, 0x2000011);
    }

    private static long resetLock(long l, int n, long l2) {
        if (((long)n << 8 & l) != 0L) {
            long l3 = 0xFFFFL ^ l2;
            l &= l3;
        }
        return l;
    }

    private static void resetLock(Spannable spannable, Object object) {
        if (spannable.getSpanFlags(object) != 0x4000011) {
            return;
        }
        spannable.removeSpan(object);
    }

    public static long resetLockedMeta(long l) {
        return MetaKeyKeyListener.resetLock(MetaKeyKeyListener.resetLock(MetaKeyKeyListener.resetLock(l, 1, 0x10101000101L), 2, 0x20202000202L), 4, 0x40404000404L);
    }

    protected static void resetLockedMeta(Spannable spannable) {
        Object object = CAP;
        MetaKeyKeyListener.resetLock(spannable, object);
        Object object2 = ALT;
        MetaKeyKeyListener.resetLock(spannable, object2);
        Object object3 = SYM;
        MetaKeyKeyListener.resetLock(spannable, object3);
        Object object4 = SELECTING;
        MetaKeyKeyListener.resetLock(spannable, object4);
    }

    public static void resetMetaState(Spannable spannable) {
        Object object = CAP;
        spannable.removeSpan(object);
        Object object2 = ALT;
        spannable.removeSpan(object2);
        Object object3 = SYM;
        spannable.removeSpan(object3);
        Object object4 = SELECTING;
        spannable.removeSpan(object4);
    }

    public static void startSelecting(View view, Spannable spannable) {
        Object object = SELECTING;
        spannable.setSpan(object, 0, 0, 0x1000011);
    }

    public static void stopSelecting(View view, Spannable spannable) {
        Object object = SELECTING;
        spannable.removeSpan(object);
    }

    public long clearMetaKeyState(long l, int n) {
        if ((n & 1) != 0) {
            l = MetaKeyKeyListener.resetLock(l, 1, 0x10101000101L);
        }
        if ((n & 2) != 0) {
            l = MetaKeyKeyListener.resetLock(l, 2, 0x20202000202L);
        }
        if ((n & 4) != 0) {
            l = MetaKeyKeyListener.resetLock(l, 4, 0x40404000404L);
        }
        return l;
    }

    public void clearMetaKeyState(View view, Editable editable, int n) {
        MetaKeyKeyListener.clearMetaKeyState(editable, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        if (n == 59 || n == 60) {
            Object object = CAP;
            this.press(editable, object);
            return true;
        }
        if (n == 57 || n == 58 || n == 78) {
            Object object = ALT;
            this.press(editable, object);
            return true;
        }
        if (n != 63) return false;
        Object object = SYM;
        this.press(editable, object);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
        if (n == 59 || n == 60) {
            Object object = CAP;
            this.release(editable, object);
            return true;
        }
        if (n == 57 || n == 58 || n == 78) {
            Object object = ALT;
            this.release(editable, object);
            return true;
        }
        if (n != 63) return false;
        Object object = SYM;
        this.release(editable, object);
        return true;
    }
}

