/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.BaseKeyListener;
import android.view.KeyEvent;
import android.view.View;

public abstract class NumberKeyListener
extends BaseKeyListener
implements InputFilter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean ok(char[] cArray, char c) {
        int n = cArray.length - 1;
        while (n >= 0) {
            if (cArray[n] != c) {
                return true;
            }
            n += -1;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        void var10_11;
        char[] cArray = this.getAcceptedChars();
        int n5 = n;
        while (true) {
            char c;
            if (n5 >= n2 || !NumberKeyListener.ok(cArray, c = charSequence.charAt(n5))) {
                if (n5 == n2) break;
                return var10_11;
            }
            ++n5;
        }
        if (n2 - n == 1) {
            return var10_11;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence, n, n2);
        n5 -= n;
        int n6 = n2 - n;
        int n7 = n6 - n;
        int n8 = n6 - 1;
        while (true) {
            if (n8 < n5) {
                SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
                return var10_11;
            }
            char c = charSequence.charAt(n8);
            if (!NumberKeyListener.ok(cArray, c)) {
                int n9 = n8 + 1;
                Editable editable = spannableStringBuilder.delete(n8, n9);
            }
            n8 += -1;
        }
    }

    protected abstract char[] getAcceptedChars();

    protected int lookup(KeyEvent keyEvent, Spannable spannable) {
        char[] cArray = this.getAcceptedChars();
        int n = NumberKeyListener.getMetaState(spannable);
        return keyEvent.getMatch(cArray, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        int n2;
        int n3 = Selection.getSelectionStart(editable);
        int n4 = Selection.getSelectionEnd(editable);
        int n5 = Math.min(n3, n4);
        int n6 = Math.max(n3, n4);
        if (n5 < 0 || n6 < 0) {
            n5 = n6 = 0;
            Selection.setSelection(editable, 0);
        }
        int n7 = keyEvent != null ? this.lookup(keyEvent, editable) : 0;
        int n8 = keyEvent != null ? keyEvent.getRepeatCount() : 0;
        if (n8 == 0) {
            if (n7 != 0) {
                if (n5 != n6) {
                    Selection.setSelection(editable, n6);
                }
                String string2 = String.valueOf((char)n7);
                Editable editable2 = editable.replace(n5, n6, string2);
                NumberKeyListener.adjustMetaAfterKeypress(editable);
                return true;
            }
        } else if (n7 == 48 && n8 == 1 && n5 != n6 && n6 > 0 && editable.charAt(n2 = n5 - 1) == '0') {
            int n9 = n5 - 1;
            String string3 = String.valueOf('+');
            Editable editable3 = editable.replace(n9, n6, string3);
            NumberKeyListener.adjustMetaAfterKeypress(editable);
            return true;
        }
        NumberKeyListener.adjustMetaAfterKeypress(editable);
        return super.onKeyDown(view, editable, n, keyEvent);
    }
}

