/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.GetChars;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TextKeyListener;
import android.text.method.TransformationMethod;
import android.text.style.UpdateLayout;
import android.view.View;
import java.lang.ref.WeakReference;

public class PasswordTransformationMethod
implements TransformationMethod,
TextWatcher {
    private static char DOT = (char)8226;
    private static PasswordTransformationMethod sInstance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PasswordTransformationMethod getInstance() {
        if (sInstance == null) return sInstance = new PasswordTransformationMethod();
        return sInstance;
    }

    private static void removeVisibleSpans(Spannable spannable) {
        int n = spannable.length();
        Visible[] visibleArray = spannable.getSpans(0, n, Visible.class);
        int n2 = 0;
        int n3;
        while (n2 < (n3 = visibleArray.length)) {
            Visible visible = visibleArray[n2];
            spannable.removeSpan(visible);
            ++n2;
        }
        return;
    }

    @Override
    public void afterTextChanged(Editable editable) {
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    @Override
    public CharSequence getTransformation(CharSequence charSequence, View view) {
        if (charSequence instanceof Spannable) {
            int n;
            Spannable spannable = (Spannable)charSequence;
            int n2 = spannable.length();
            ViewReference[] viewReferenceArray = spannable.getSpans(0, n2, ViewReference.class);
            for (int i = 0; i < (n = viewReferenceArray.length); ++i) {
                ViewReference viewReference = viewReferenceArray[i];
                spannable.removeSpan(viewReference);
            }
            PasswordTransformationMethod.removeVisibleSpans(spannable);
            ViewReference viewReference = new ViewReference(view);
            spannable.setSpan(viewReference, 0, 0, 34);
        }
        return new PasswordCharSequence(charSequence);
    }

    @Override
    public void onFocusChanged(View view, CharSequence charSequence, boolean bl, int n, Rect rect) {
        if (bl) {
            return;
        }
        if (!(charSequence instanceof Spannable)) {
            return;
        }
        PasswordTransformationMethod.removeVisibleSpans((Spannable)charSequence);
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        Context context;
        int n4;
        if (!(charSequence instanceof Spannable)) {
            return;
        }
        Spannable spannable = (Spannable)charSequence;
        int n5 = charSequence.length();
        ViewReference[] viewReferenceArray = spannable.getSpans(0, n5, ViewReference.class);
        if (viewReferenceArray.length == 0) {
            return;
        }
        View view = null;
        for (int i = 0; view == null && i < (n4 = viewReferenceArray.length); ++i) {
            view = (View)viewReferenceArray[i].get();
        }
        if (view == null) {
            return;
        }
        TextKeyListener textKeyListener = TextKeyListener.getInstance();
        if ((textKeyListener.getPrefs(context = view.getContext()) & 8) == 0) {
            return;
        }
        if (n3 <= 0) {
            return;
        }
        PasswordTransformationMethod.removeVisibleSpans(spannable);
        if (n3 != 1) {
            return;
        }
        Visible visible = new Visible(spannable, this);
        int n6 = n + n3;
        spannable.setSpan(visible, n, n6, 33);
    }

    private static class ViewReference
    extends WeakReference<View>
    implements NoCopySpan {
        public ViewReference(View view) {
            super(view);
        }
    }

    private static class Visible
    extends Handler
    implements UpdateLayout,
    Runnable {
        private Spannable mText;
        private PasswordTransformationMethod mTransformer;

        public Visible(Spannable spannable, PasswordTransformationMethod passwordTransformationMethod) {
            this.mText = spannable;
            this.mTransformer = passwordTransformationMethod;
            long l = SystemClock.uptimeMillis() + 1500L;
            boolean bl = this.postAtTime(this, l);
        }

        @Override
        public void run() {
            this.mText.removeSpan(this);
        }
    }

    private static class PasswordCharSequence
    implements CharSequence,
    GetChars {
        private CharSequence mSource;

        public PasswordCharSequence(CharSequence charSequence) {
            this.mSource = charSequence;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public char charAt(int n) {
            int n2;
            if (!(this.mSource instanceof Spanned)) return DOT;
            Spanned spanned = (Spanned)this.mSource;
            Object object = TextKeyListener.ACTIVE;
            int n3 = spanned.getSpanStart(object);
            Object object2 = TextKeyListener.ACTIVE;
            int n4 = spanned.getSpanEnd(object2);
            if (n >= n3 && n < n4) {
                return this.mSource.charAt(n);
            }
            int n5 = spanned.length();
            Visible[] visibleArray = spanned.getSpans(0, n5, Visible.class);
            int n6 = 0;
            while (n6 < (n2 = visibleArray.length)) {
                PasswordTransformationMethod passwordTransformationMethod = visibleArray[n6].mTransformer;
                if (spanned.getSpanStart(passwordTransformationMethod) >= 0) {
                    Visible visible = visibleArray[n6];
                    int n7 = spanned.getSpanStart(visible);
                    Visible visible2 = visibleArray[n6];
                    n4 = spanned.getSpanEnd(visible2);
                    if (n >= n7 && n < n4) {
                        return this.mSource.charAt(n);
                    }
                }
                ++n6;
            }
            return DOT;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            Visible[] visibleArray;
            CharSequence charSequence = this.mSource;
            int n4 = n;
            int n5 = n2;
            char[] cArray2 = cArray;
            int n6 = n3;
            TextUtils.getChars(charSequence, n4, n5, cArray2, n6);
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            int[] nArray = null;
            int[] nArray2 = null;
            if (this.mSource instanceof Spanned) {
                Spanned spanned = (Spanned)this.mSource;
                Object object = TextKeyListener.ACTIVE;
                n7 = spanned.getSpanStart(object);
                Object object2 = TextKeyListener.ACTIVE;
                n8 = spanned.getSpanEnd(object2);
                int n10 = spanned.length();
                Spanned spanned2 = spanned;
                int n11 = 0;
                int n12 = n10;
                Class<Visible> clazz = Visible.class;
                visibleArray = spanned2.getSpans(n11, n12, clazz);
                n9 = visibleArray.length;
                nArray = new int[n9];
                nArray2 = new int[n9];
                for (int i = 0; i < n9; ++i) {
                    int n13;
                    int n14;
                    PasswordTransformationMethod passwordTransformationMethod = visibleArray[i].mTransformer;
                    if (spanned.getSpanStart(passwordTransformationMethod) < 0) continue;
                    Visible visible = visibleArray[i];
                    nArray[i] = n14 = spanned.getSpanStart(visible);
                    Visible visible2 = visibleArray[i];
                    nArray2[i] = n13 = spanned.getSpanEnd(visible2);
                }
            }
            int n15 = n;
            int n16;
            int n17;
            block1: while ((n17 = ++n15) < (n16 = n2)) {
                if (n15 >= n7 && n15 < n8) continue;
                visibleArray = null;
                int n18 = 0;
                while (true) {
                    void var35_35;
                    void var34_34;
                    if (n18 >= n9 || n15 >= (var34_34 = nArray[n18]) && n15 < (var35_35 = nArray2[n18])) {
                        if (visibleArray == null) {
                            char c;
                            int n19 = n15 - n + n3;
                            cArray[n19] = c = DOT;
                        }
                        continue block1;
                    }
                    ++n18;
                }
                break;
            }
            return;
        }

        @Override
        public int length() {
            return this.mSource.length();
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            int n = this.length();
            return ((Object)this.subSequence(0, n)).toString();
        }
    }
}

