/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.text.Editable;
import android.text.GetChars;
import android.text.Spannable;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.view.View;

public abstract class ReplacementTransformationMethod
implements TransformationMethod {
    protected abstract char[] getOriginal();

    protected abstract char[] getReplacement();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getTransformation(CharSequence charSequence, View view) {
        void var9_10;
        char[] cArray;
        char[] cArray2;
        block8: {
            cArray2 = this.getOriginal();
            cArray = this.getReplacement();
            if (charSequence instanceof Editable) break block8;
            boolean bl = true;
            int n = cArray2.length;
            int n2 = 0;
            while (true) {
                block10: {
                    block9: {
                        if (n2 >= n) break block9;
                        char c = cArray2[n2];
                        if (TextUtils.indexOf(charSequence, c) < 0) break block10;
                        bl = false;
                    }
                    if (!bl) break;
                    CharSequence charSequence2 = charSequence;
                    return var9_10;
                }
                ++n2;
            }
            if (!(charSequence instanceof Spannable)) {
                if (charSequence instanceof Spanned) {
                    Spanned spanned = (Spanned)charSequence;
                    SpannedReplacementCharSequence spannedReplacementCharSequence = new SpannedReplacementCharSequence(spanned, cArray2, cArray);
                    SpannedString spannedString = new SpannedString(spannedReplacementCharSequence);
                    return var9_10;
                }
                String string2 = new ReplacementCharSequence(charSequence, cArray2, cArray).toString();
                return var9_10;
            }
        }
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            SpannedReplacementCharSequence spannedReplacementCharSequence = new SpannedReplacementCharSequence(spanned, cArray2, cArray);
            return var9_10;
        }
        ReplacementCharSequence replacementCharSequence = new ReplacementCharSequence(charSequence, cArray2, cArray);
        return var9_10;
    }

    @Override
    public void onFocusChanged(View view, CharSequence charSequence, boolean bl, int n, Rect rect) {
    }

    private static class SpannedReplacementCharSequence
    extends ReplacementCharSequence
    implements Spanned {
        private Spanned mSpanned;

        public SpannedReplacementCharSequence(Spanned spanned, char[] cArray, char[] cArray2) {
            super(spanned, cArray, cArray2);
            this.mSpanned = spanned;
        }

        @Override
        public int getSpanEnd(Object object) {
            return this.mSpanned.getSpanEnd(object);
        }

        @Override
        public int getSpanFlags(Object object) {
            return this.mSpanned.getSpanFlags(object);
        }

        @Override
        public int getSpanStart(Object object) {
            return this.mSpanned.getSpanStart(object);
        }

        @Override
        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            return this.mSpanned.getSpans(n, n2, clazz);
        }

        @Override
        public int nextSpanTransition(int n, int n2, Class clazz) {
            return this.mSpanned.nextSpanTransition(n, n2, clazz);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new SpannedString(this).subSequence(n, n2);
        }
    }

    private static class ReplacementCharSequence
    implements CharSequence,
    GetChars {
        private char[] mOriginal;
        private char[] mReplacement;
        private CharSequence mSource;

        public ReplacementCharSequence(CharSequence charSequence, char[] cArray, char[] cArray2) {
            this.mSource = charSequence;
            this.mOriginal = cArray;
            this.mReplacement = cArray2;
        }

        @Override
        public char charAt(int n) {
            char c = this.mSource.charAt(n);
            int n2 = this.mOriginal.length;
            for (int i = 0; i < n2; ++i) {
                char c2 = this.mOriginal[i];
                if (c == c2) continue;
                c = this.mReplacement[i];
            }
            return c;
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            TextUtils.getChars(this.mSource, n, n2, cArray, n3);
            int n4 = n2 - n + n3;
            int n5 = this.mOriginal.length;
            int n6 = n3;
            while (n6 < n4) {
                char c = cArray[n6];
                for (int i = 0; i < n5; ++i) {
                    char c2;
                    char c3 = this.mOriginal[i];
                    if (c == c3) continue;
                    cArray[n6] = c2 = this.mReplacement[i];
                }
                ++n6;
            }
            return;
        }

        @Override
        public int length() {
            return this.mSource.length();
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            char[] cArray = new char[this.length()];
            int n = this.length();
            this.getChars(0, n, cArray, 0);
            return new String(cArray);
        }
    }
}

