/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class ScrollingMovementMethod
implements MovementMethod {
    private static ScrollingMovementMethod sInstance;

    /*
     * Enabled aggressive block sorting
     */
    private boolean executeDown(TextView textView, Spannable spannable, int n) {
        boolean bl = false;
        switch (n) {
            case 21: {
                boolean bl2 = this.left(textView, spannable);
                return false | bl2;
            }
            case 22: {
                boolean bl3 = this.right(textView, spannable);
                return false | bl3;
            }
            case 19: {
                boolean bl4 = this.up(textView, spannable);
                return false | bl4;
            }
            case 20: {
                boolean bl5 = this.down(textView, spannable);
                return false | bl5;
            }
        }
        return bl;
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ScrollingMovementMethod();
        }
        return sInstance;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean down(TextView textView, Spannable spannable) {
        int n;
        int n2;
        int n3;
        Layout layout2 = textView.getLayout();
        int n4 = textView.getTotalPaddingTop();
        int n5 = textView.getTotalPaddingBottom();
        int n6 = n4 + n5;
        int n7 = textView.getScrollY();
        int n8 = n7 + (n3 = textView.getHeight()) - n6;
        int n9 = layout2.getLineForVertical(n8);
        int n10 = n9 + 1;
        int n11 = layout2.getLineTop(n10);
        if (n11 < (n2 = n8 + 1)) {
            ++n9;
        }
        if (n9 > (n = layout2.getLineCount() - 1)) return false;
        int n12 = textView.getScrollX();
        int n13 = n9 + 1;
        int n14 = layout2.getLineTop(n13);
        int n15 = textView.getHeight() - n6;
        int n16 = n14 - n15;
        textView.scrollTo(n12, n16);
        int n17 = textView.getScrollX();
        int n18 = textView.getScrollY();
        Touch.scrollTo(textView, layout2, n17, n18);
        return true;
    }

    @Override
    public void initialize(TextView textView, Spannable spannable) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean left(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        int n = textView.getScrollY();
        int n2 = textView.getScrollX();
        int n3 = Math.round(layout2.getPaint().getFontSpacing());
        int n4 = textView.getTotalPaddingTop();
        int n5 = textView.getTotalPaddingBottom();
        int n6 = n4 + n5;
        int n7 = layout2.getLineForVertical(n);
        int n8 = textView.getHeight() + n - n6;
        int n9 = layout2.getLineForVertical(n8);
        int n10 = Integer.MAX_VALUE;
        for (int i = n7; i <= n9; ++i) {
            float f = n10;
            float f2 = layout2.getLineLeft(i);
            n10 = (int)Math.min(f, f2);
        }
        if (n2 <= n10) return false;
        int n11 = Math.max(n2 - n3, n10);
        int n12 = textView.getScrollY();
        textView.scrollTo(n11, n12);
        return true;
    }

    @Override
    public boolean onKeyDown(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
        return this.executeDown(textView, spannable, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyOther(TextView textView, Spannable spannable, KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 0) return false;
        if (keyEvent.getAction() != 2) return false;
        int n2 = keyEvent.getRepeatCount();
        boolean bl = true;
        boolean bl2 = false;
        while ((n2 += -1) > 0) {
            if (bl && this.executeDown(textView, spannable, n)) {
                bl2 = true;
                MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
                MetaKeyKeyListener.resetLockedMeta(spannable);
            }
            bl = false;
        }
        return bl2;
    }

    @Override
    public boolean onKeyUp(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public void onTakeFocus(TextView textView, Spannable spannable, int n) {
        Layout layout2 = textView.getLayout();
        if (layout2 != null && (n & 2) != 0) {
            int n2 = textView.getScrollX();
            int n3 = layout2.getLineTop(0);
            textView.scrollTo(n2, n3);
        }
        if (layout2 == null) {
            return;
        }
        if ((n & 1) == 0) {
            return;
        }
        int n4 = textView.getTotalPaddingTop();
        int n5 = textView.getTotalPaddingBottom();
        int n6 = n4 + n5;
        int n7 = layout2.getLineCount() - 1;
        int n8 = textView.getScrollX();
        int n9 = n7 + 1;
        int n10 = layout2.getLineTop(n9);
        int n11 = textView.getHeight() - n6;
        int n12 = n10 - n11;
        textView.scrollTo(n8, n12);
    }

    @Override
    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        return Touch.onTouchEvent(textView, spannable, motionEvent);
    }

    @Override
    public boolean onTrackballEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean right(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        int n = textView.getScrollY();
        int n2 = textView.getScrollX();
        int n3 = Math.round(layout2.getPaint().getFontSpacing());
        int n4 = textView.getTotalPaddingTop();
        int n5 = textView.getTotalPaddingBottom();
        int n6 = n4 + n5;
        int n7 = layout2.getLineForVertical(n);
        int n8 = textView.getHeight() + n - n6;
        int n9 = layout2.getLineForVertical(n8);
        int n10 = 0;
        for (int i = n7; i <= n9; ++i) {
            float f = n10;
            float f2 = layout2.getLineRight(i);
            n10 = (int)Math.max(f, f2);
        }
        int n11 = textView.getTotalPaddingLeft();
        int n12 = textView.getTotalPaddingRight();
        int n13 = n11 + n12;
        int n14 = textView.getWidth() - n13;
        int n15 = n10 - n14;
        if (n2 >= n15) return false;
        int n16 = n2 + n3;
        int n17 = textView.getWidth() - n13;
        int n18 = n10 - n17;
        int n19 = Math.min(n16, n18);
        int n20 = textView.getScrollY();
        textView.scrollTo(n19, n20);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean up(TextView textView, Spannable spannable) {
        int n;
        int n2;
        Layout layout2 = textView.getLayout();
        int n3 = textView.getScrollY();
        if (n3 != (n2 = layout2.getLineTop(n = layout2.getLineForVertical(n3)))) {
            n += -1;
        }
        if (n < 0) return false;
        int n4 = textView.getScrollX();
        int n5 = layout2.getLineTop(n);
        Touch.scrollTo(textView, layout2, n4, n5);
        return true;
    }
}

