/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.BaseKeyListener;
import android.text.method.KeyListener;
import android.text.method.MultiTapKeyListener;
import android.text.method.QwertyKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import java.lang.ref.WeakReference;

public class TextKeyListener
extends BaseKeyListener
implements SpanWatcher {
    static final Object ACTIVE;
    static final int AUTO_CAP = 1;
    static final int AUTO_PERIOD = 4;
    static final int AUTO_TEXT = 2;
    static final Object CAPPED;
    static final Object INHIBIT_REPLACEMENT;
    static final Object LAST_TYPED;
    static final int SHOW_PASSWORD = 8;
    private static TextKeyListener[] sInstance;
    private Capitalize mAutoCap;
    private boolean mAutoText;
    private SettingsObserver mObserver;
    private int mPrefs;
    private boolean mPrefsInited;
    private WeakReference<ContentResolver> mResolver;

    static {
        sInstance = new TextKeyListener[Capitalize.values().length * 2];
        ACTIVE = new NoCopySpan.Concrete();
        CAPPED = new NoCopySpan.Concrete();
        INHIBIT_REPLACEMENT = new NoCopySpan.Concrete();
        LAST_TYPED = new NoCopySpan.Concrete();
    }

    public TextKeyListener(Capitalize capitalize, boolean bl) {
        this.mAutoCap = capitalize;
        this.mAutoText = bl;
    }

    static /* synthetic */ boolean access$102(TextKeyListener textKeyListener, boolean bl) {
        textKeyListener.mPrefsInited = bl;
        return bl;
    }

    public static void clear(Editable editable) {
        editable.clear();
        Object object = ACTIVE;
        editable.removeSpan(object);
        Object object2 = CAPPED;
        editable.removeSpan(object2);
        Object object3 = INHIBIT_REPLACEMENT;
        editable.removeSpan(object3);
        Object object4 = LAST_TYPED;
        editable.removeSpan(object4);
        int n = editable.length();
        QwertyKeyListener.Replaced[] replacedArray = editable.getSpans(0, n, QwertyKeyListener.Replaced.class);
        int n2 = replacedArray.length;
        int n3 = 0;
        while (n3 < n2) {
            QwertyKeyListener.Replaced replaced = replacedArray[n3];
            editable.removeSpan(replaced);
            ++n3;
        }
        return;
    }

    public static TextKeyListener getInstance() {
        Capitalize capitalize = Capitalize.NONE;
        return TextKeyListener.getInstance(false, capitalize);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static TextKeyListener getInstance(boolean bl, Capitalize capitalize) {
        int n;
        int n2 = capitalize.ordinal() * 2;
        int n3 = n2 + (n = bl ? 1 : 0);
        if (sInstance[n3] == null) {
            TextKeyListener textKeyListener;
            TextKeyListener[] textKeyListenerArray = sInstance;
            textKeyListenerArray[n3] = textKeyListener = new TextKeyListener(capitalize, bl);
        }
        return sInstance[n3];
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyListener getKeyListener(KeyEvent keyEvent) {
        void var5_6;
        int n = KeyCharacterMap.load(keyEvent.getKeyboardDevice()).getKeyboardType();
        if (n == 3) {
            boolean bl = this.mAutoText;
            Capitalize capitalize = this.mAutoCap;
            QwertyKeyListener qwertyKeyListener = QwertyKeyListener.getInstance(bl, capitalize);
            return var5_6;
        }
        if (n == 1) {
            boolean bl = this.mAutoText;
            Capitalize capitalize = this.mAutoCap;
            MultiTapKeyListener multiTapKeyListener = MultiTapKeyListener.getInstance(bl, capitalize);
            return var5_6;
        }
        NullKeyListener nullKeyListener = NullKeyListener.getInstance();
        return var5_6;
    }

    private void initPrefs(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        WeakReference<ContentResolver> weakReference = new WeakReference<ContentResolver>(contentResolver);
        this.mResolver = weakReference;
        if (this.mObserver == null) {
            SettingsObserver settingsObserver;
            this.mObserver = settingsObserver = new SettingsObserver();
            Uri uri = Settings.System.CONTENT_URI;
            SettingsObserver settingsObserver2 = this.mObserver;
            contentResolver.registerContentObserver(uri, true, settingsObserver2);
        }
        this.updatePrefs(contentResolver);
        this.mPrefsInited = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean shouldCap(Capitalize capitalize, CharSequence charSequence, int n) {
        Capitalize capitalize2 = Capitalize.NONE;
        if (capitalize == capitalize2) {
            return false;
        }
        Capitalize capitalize3 = Capitalize.CHARACTERS;
        if (capitalize == capitalize3) {
            return true;
        }
        Capitalize capitalize4 = Capitalize.WORDS;
        int n2 = capitalize == capitalize4 ? 8192 : 16384;
        if (TextUtils.getCapsMode(charSequence, n, n2) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePrefs(ContentResolver contentResolver) {
        int n;
        boolean bl = Settings.System.getInt(contentResolver, "auto_caps", 1) > 0;
        boolean bl2 = Settings.System.getInt(contentResolver, "auto_replace", 1) > 0;
        boolean bl3 = Settings.System.getInt(contentResolver, "auto_punctuate", 1) > 0;
        boolean bl4 = Settings.System.getInt(contentResolver, "show_password", 1) > 0;
        int n2 = bl ? 1 : 0;
        int n3 = bl2 ? 2 : 0;
        int n4 = n2 | n3;
        int n5 = bl3 ? 4 : 0;
        int n6 = n4 | n5;
        int n7 = bl4 ? 8 : 0;
        this.mPrefs = n = n6 | n7;
    }

    @Override
    public int getInputType() {
        Capitalize capitalize = this.mAutoCap;
        boolean bl = this.mAutoText;
        return TextKeyListener.makeTextContentType(capitalize, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getPrefs(Context context) {
        synchronized (this) {
            if (!this.mPrefsInited || this.mResolver.get() == null) {
                this.initPrefs(context);
            }
            return this.mPrefs;
        }
    }

    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        return this.getKeyListener(keyEvent).onKeyDown(view, editable, n, keyEvent);
    }

    @Override
    public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
        return this.getKeyListener(keyEvent).onKeyOther(view, editable, keyEvent);
    }

    @Override
    public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
        return this.getKeyListener(keyEvent).onKeyUp(view, editable, n, keyEvent);
    }

    @Override
    public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
    }

    @Override
    public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
        Object object2 = Selection.SELECTION_END;
        if (object != object2) {
            return;
        }
        Object object3 = ACTIVE;
        spannable.removeSpan(object3);
    }

    @Override
    public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
    }

    public void release() {
        if (this.mResolver == null) {
            return;
        }
        ContentResolver contentResolver = (ContentResolver)this.mResolver.get();
        if (contentResolver != null) {
            SettingsObserver settingsObserver = this.mObserver;
            contentResolver.unregisterContentObserver(settingsObserver);
            this.mResolver.clear();
        }
        this.mObserver = null;
        this.mResolver = null;
        this.mPrefsInited = false;
    }

    private class SettingsObserver
    extends ContentObserver {
        public SettingsObserver() {
            Handler handler = new Handler();
            super(handler);
        }

        @Override
        public void onChange(boolean bl) {
            if (TextKeyListener.this.mResolver != null) {
                ContentResolver contentResolver = (ContentResolver)TextKeyListener.this.mResolver.get();
                if (contentResolver == null) {
                    boolean bl2 = TextKeyListener.access$102(TextKeyListener.this, false);
                    return;
                }
                TextKeyListener.this.updatePrefs(contentResolver);
                return;
            }
            boolean bl3 = TextKeyListener.access$102(TextKeyListener.this, false);
        }
    }

    private static class NullKeyListener
    implements KeyListener {
        private static NullKeyListener sInstance;

        private NullKeyListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static NullKeyListener getInstance() {
            if (sInstance == null) return sInstance = new NullKeyListener();
            return sInstance;
        }

        @Override
        public void clearMetaKeyState(View view, Editable editable, int n) {
        }

        @Override
        public int getInputType() {
            return 0;
        }

        @Override
        public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
            return false;
        }
    }

    public static final class Capitalize
    extends Enum<Capitalize> {
        private static final /* synthetic */ Capitalize[] $VALUES;
        public static final /* enum */ Capitalize CHARACTERS;
        public static final /* enum */ Capitalize NONE;
        public static final /* enum */ Capitalize SENTENCES;
        public static final /* enum */ Capitalize WORDS;

        static {
            NONE = new Capitalize();
            SENTENCES = new Capitalize();
            WORDS = new Capitalize();
            CHARACTERS = new Capitalize();
            Capitalize capitalize = NONE;
            Capitalize capitalize2 = SENTENCES;
            Capitalize capitalize3 = WORDS;
            Capitalize capitalize4 = CHARACTERS;
            Capitalize[] capitalizeArray = new Capitalize[]{capitalize, capitalize2, capitalize3, capitalize4};
            $VALUES = capitalizeArray;
        }

        public static Capitalize valueOf(String string2) {
            return Enum.valueOf(Capitalize.class, string2);
        }

        public static Capitalize[] values() {
            return (Capitalize[])$VALUES.clone();
        }
    }
}

