/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.TextView;

public class Touch {
    private Touch() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getInitialScrollX(TextView textView, Spannable spannable) {
        int n = spannable.length();
        DragState[] dragStateArray = spannable.getSpans(0, n, DragState.class);
        if (dragStateArray.length <= 0) return -1;
        return dragStateArray[0].mScrollX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getInitialScrollY(TextView textView, Spannable spannable) {
        int n = spannable.length();
        DragState[] dragStateArray = spannable.getSpans(0, n, DragState.class);
        if (dragStateArray.length <= 0) return -1;
        return dragStateArray[0].mScrollY;
    }

    public static int getMaxScrollX(TextView textView, Layout layout2, int n) {
        int n2 = layout2.getLineForVertical(n);
        int n3 = textView.getHeight() + n;
        int n4 = textView.getTotalPaddingTop();
        int n5 = n3 - n4;
        int n6 = textView.getTotalPaddingBottom();
        int n7 = n5 - n6;
        int n8 = layout2.getLineForVertical(n7);
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        for (int i = n2; i <= n8; ++i) {
            float f = n9;
            float f2 = layout2.getLineLeft(i);
            n9 = (int)Math.min(f, f2);
            float f3 = n10;
            float f4 = layout2.getLineRight(i);
            n10 = (int)Math.max(f3, f4);
        }
        int n11 = n10 - n9;
        int n12 = textView.getWidth();
        int n13 = n11 - n12;
        int n14 = textView.getTotalPaddingLeft();
        int n15 = n13 - n14;
        int n16 = textView.getTotalPaddingRight();
        return n15 - n16;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        float f;
        float f2;
        float f3;
        float f4;
        boolean bl;
        DragState[] dragStateArray;
        switch (motionEvent.getActionMasked()) {
            default: {
                return false;
            }
            case 0: {
                int n = spannable.length();
                DragState[] dragStateArray2 = spannable.getSpans(0, n, DragState.class);
                int n2 = 0;
                while (true) {
                    int n3;
                    if (n2 >= (n3 = dragStateArray2.length)) {
                        float f5 = motionEvent.getX();
                        float f6 = motionEvent.getY();
                        int n4 = textView.getScrollX();
                        int n5 = textView.getScrollY();
                        DragState dragState = new DragState(f5, f6, n4, n5);
                        spannable.setSpan(dragState, 0, 0, 17);
                        return true;
                    }
                    DragState dragState = dragStateArray2[n2];
                    spannable.removeSpan(dragState);
                    ++n2;
                }
            }
            case 1: {
                int n;
                int n6 = spannable.length();
                DragState[] dragStateArray3 = spannable.getSpans(0, n6, DragState.class);
                motionEvent = null;
                while (motionEvent < (n = dragStateArray3.length)) {
                    DragState dragState = dragStateArray3[motionEvent];
                    spannable.removeSpan(dragState);
                    reference var18_18 = motionEvent + true;
                }
                if (dragStateArray3.length <= 0) return false;
                if (!dragStateArray3[0].mUsed) return false;
                return true;
            }
            case 2: {
                int n = spannable.length();
                dragStateArray = spannable.getSpans(0, n, DragState.class);
                if (dragStateArray.length <= 0) return false;
                if (!dragStateArray[0].mFarEnough) {
                    float f7;
                    float f8;
                    float f9;
                    float f10;
                    float f11;
                    float f12;
                    int n7 = ViewConfiguration.get(textView.getContext()).getScaledTouchSlop();
                    float f13 = motionEvent.getX();
                    float f14 = Math.abs(f13 - (f12 = dragStateArray[0].mX));
                    if (f14 >= (f11 = (float)n7) || (f10 = Math.abs((f9 = motionEvent.getY()) - (f8 = dragStateArray[0].mY))) >= (f7 = (float)n7)) {
                        dragStateArray[0].mFarEnough = true;
                    }
                }
                if (!dragStateArray[0].mFarEnough) return false;
                dragStateArray[0].mUsed = true;
                bl = MetaKeyKeyListener.getMetaState(spannable, 1) == 1 || MetaKeyKeyListener.getMetaState(spannable, 65536) != 0;
            }
        }
        if (bl) {
            float f15 = motionEvent.getX();
            float f16 = dragStateArray[0].mX;
            f4 = f15 - f16;
            float f17 = motionEvent.getY();
            float f18 = dragStateArray[0].mY;
            f3 = f17 - f18;
        } else {
            float f19 = dragStateArray[0].mX;
            float f20 = motionEvent.getX();
            f4 = f19 - f20;
            float f21 = dragStateArray[0].mY;
            float f22 = motionEvent.getY();
            f3 = f21 - f22;
        }
        DragState dragState = dragStateArray[0];
        dragState.mX = f2 = motionEvent.getX();
        DragState dragState2 = dragStateArray[0];
        dragState2.mY = f = motionEvent.getY();
        int n = textView.getScrollX();
        int n8 = (int)f4;
        int n9 = n + n8;
        int n10 = textView.getScrollY();
        int n11 = (int)f3 + n10;
        int n12 = textView.getTotalPaddingTop();
        int n13 = textView.getTotalPaddingBottom() + n12;
        Layout layout2 = textView.getLayout();
        int n14 = layout2.getHeight();
        int n15 = textView.getHeight() - n13;
        int n16 = n14 - n15;
        int n17 = Math.max(Math.min(n11, n16), 0);
        int n18 = textView.getScrollX();
        int n19 = textView.getScrollY();
        Touch.scrollTo(textView, layout2, n9, n17);
        int n20 = textView.getScrollX();
        if (n18 != n20) {
            int n21 = textView.getScrollY();
            if (n19 == n21) return true;
        }
        textView.cancelLongPress();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void scrollTo(TextView textView, Layout layout2, int n, int n2) {
        int n3 = textView.getTotalPaddingTop();
        int n4 = textView.getTotalPaddingBottom();
        int n5 = n3 + n4;
        int n6 = layout2.getLineForVertical(n2);
        int n7 = textView.getHeight() + n2 - n5;
        int n8 = layout2.getLineForVertical(n7);
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        Layout.Alignment alignment = null;
        for (int i = n6; i <= n8; ++i) {
            float f = n9;
            float f2 = layout2.getLineLeft(i);
            n9 = (int)Math.min(f, f2);
            float f3 = n10;
            float f4 = layout2.getLineRight(i);
            n10 = (int)Math.max(f3, f4);
            if (alignment != null) continue;
            alignment = layout2.getParagraphAlignment(i);
        }
        int n11 = textView.getTotalPaddingLeft();
        int n12 = textView.getTotalPaddingRight();
        int n13 = n11 + n12;
        int n14 = textView.getWidth();
        int n15 = 0;
        int n16 = n10 - n9;
        int n17 = n14 - n13;
        if (n16 < n17) {
            Layout.Alignment alignment2 = Layout.Alignment.ALIGN_CENTER;
            if (alignment == alignment2) {
                int n18 = n14 - n13;
                int n19 = n10 - n9;
                n15 = (n18 - n19) / 2;
            } else {
                Layout.Alignment alignment3 = Layout.Alignment.ALIGN_OPPOSITE;
                if (alignment == alignment3) {
                    int n20 = n14 - n13;
                    int n21 = n10 - n9;
                    n15 = n20 - n21;
                }
            }
        }
        int n22 = n14 - n13;
        int n23 = n10 - n22 - n15;
        int n24 = Math.min(n, n23);
        int n25 = n9 - n15;
        int n26 = Math.max(n24, n25);
        textView.scrollTo(n26, n2);
    }

    private static class DragState
    implements NoCopySpan {
        public boolean mFarEnough;
        public int mScrollX;
        public int mScrollY;
        public boolean mUsed;
        public float mX;
        public float mY;

        public DragState(float f, float f2, int n, int n2) {
            this.mX = f;
            this.mY = f2;
            this.mScrollX = n;
            this.mScrollY = n2;
        }
    }
}

