/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class AbsoluteSizeSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private boolean mDip;
    private final int mSize;

    public AbsoluteSizeSpan(int n) {
        this.mSize = n;
    }

    public AbsoluteSizeSpan(int n, boolean bl) {
        this.mSize = n;
        this.mDip = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public AbsoluteSizeSpan(Parcel parcel) {
        int n;
        this.mSize = n = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.mDip = bl;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean getDip() {
        return this.mDip;
    }

    public int getSize() {
        return this.mSize;
    }

    @Override
    public int getSpanTypeId() {
        return 16;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        if (this.mDip) {
            float f = this.mSize;
            float f2 = textPaint.density;
            float f3 = f * f2;
            textPaint.setTextSize(f3);
            return;
        }
        float f = this.mSize;
        textPaint.setTextSize(f);
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        if (this.mDip) {
            float f = this.mSize;
            float f2 = textPaint.density;
            float f3 = f * f2;
            textPaint.setTextSize(f3);
            return;
        }
        float f = this.mSize;
        textPaint.setTextSize(f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mSize;
        parcel.writeInt(n2);
        int n3 = this.mDip ? 1 : 0;
        parcel.writeInt(n3);
    }
}

