/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;

public class BulletSpan
implements LeadingMarginSpan,
ParcelableSpan {
    private static final int BULLET_RADIUS = 3;
    public static final int STANDARD_GAP_WIDTH = 2;
    private final int mColor;
    private final int mGapWidth;
    private final boolean mWantColor;

    public BulletSpan() {
        this.mGapWidth = 2;
        this.mWantColor = false;
        this.mColor = 0;
    }

    public BulletSpan(int n) {
        this.mGapWidth = n;
        this.mWantColor = false;
        this.mColor = 0;
    }

    public BulletSpan(int n, int n2) {
        this.mGapWidth = n;
        this.mWantColor = true;
        this.mColor = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BulletSpan(Parcel parcel) {
        int n;
        int n2;
        this.mGapWidth = n2 = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.mWantColor = bl;
        this.mColor = n = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout2) {
        if (((Spanned)charSequence).getSpanStart(this) != n6) {
            return;
        }
        Paint.Style style2 = paint.getStyle();
        int n8 = 0;
        if (this.mWantColor) {
            n8 = paint.getColor();
            int n9 = this.mColor;
            paint.setColor(n9);
        }
        Paint.Style style3 = Paint.Style.FILL;
        paint.setStyle(style3);
        float f = n2 * 3 + n;
        float f2 = (float)(n3 + n5) / 2.0f;
        canvas.drawCircle(f, f2, 3.0f, paint);
        if (this.mWantColor) {
            paint.setColor(n8);
        }
        paint.setStyle(style2);
    }

    @Override
    public int getLeadingMargin(boolean bl) {
        return this.mGapWidth + 6;
    }

    @Override
    public int getSpanTypeId() {
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mGapWidth;
        parcel.writeInt(n2);
        int n3 = this.mWantColor ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = this.mColor;
        parcel.writeInt(n4);
    }
}

