/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import com.android.internal.R;

public class TextAppearanceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final int mStyle;
    private final ColorStateList mTextColor;
    private final ColorStateList mTextColorLink;
    private final int mTextSize;
    private final String mTypeface;

    public TextAppearanceSpan(Context context, int n) {
        this(context, n, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TextAppearanceSpan(Context context, int n, int n2) {
        int n3;
        int n4;
        ColorStateList colorStateList;
        int[] nArray = R.styleable.TextAppearance;
        TypedArray typedArray = context.obtainStyledAttributes(n, nArray);
        ColorStateList colorStateList2 = typedArray.getColorStateList(3);
        this.mTextColorLink = colorStateList = typedArray.getColorStateList(6);
        this.mTextSize = n4 = typedArray.getDimensionPixelSize(0, -1);
        this.mStyle = n3 = typedArray.getInt(2, 0);
        switch (typedArray.getInt(1, 0)) {
            default: {
                this.mTypeface = null;
                break;
            }
            case 1: {
                this.mTypeface = "sans";
                break;
            }
            case 2: {
                this.mTypeface = "serif";
                break;
            }
            case 3: {
                this.mTypeface = "monospace";
            }
        }
        typedArray.recycle();
        if (n2 >= 0) {
            int[] nArray2 = R.styleable.Theme;
            TypedArray typedArray2 = context.obtainStyledAttributes(16973829, nArray2);
            colorStateList2 = typedArray2.getColorStateList(n2);
            typedArray2.recycle();
        }
        this.mTextColor = colorStateList2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TextAppearanceSpan(Parcel parcel) {
        ColorStateList colorStateList;
        int n;
        int n2;
        String string2;
        this.mTypeface = string2 = parcel.readString();
        this.mStyle = n2 = parcel.readInt();
        this.mTextSize = n = parcel.readInt();
        this.mTextColor = parcel.readInt() != 0 ? (colorStateList = ColorStateList.CREATOR.createFromParcel(parcel)) : null;
        if (parcel.readInt() != 0) {
            ColorStateList colorStateList2;
            this.mTextColorLink = colorStateList2 = ColorStateList.CREATOR.createFromParcel(parcel);
            return;
        }
        this.mTextColorLink = null;
    }

    public TextAppearanceSpan(String string2, int n, int n2, ColorStateList colorStateList, ColorStateList colorStateList2) {
        this.mTypeface = string2;
        this.mStyle = n;
        this.mTextSize = n2;
        this.mTextColor = colorStateList;
        this.mTextColorLink = colorStateList2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getFamily() {
        return this.mTypeface;
    }

    public ColorStateList getLinkTextColor() {
        return this.mTextColorLink;
    }

    @Override
    public int getSpanTypeId() {
        return 17;
    }

    public ColorStateList getTextColor() {
        return this.mTextColor;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public int getTextStyle() {
        return this.mStyle;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        int n;
        this.updateMeasureState(textPaint);
        if (this.mTextColor != null) {
            ColorStateList colorStateList = this.mTextColor;
            int[] nArray = textPaint.drawableState;
            int n2 = colorStateList.getColorForState(nArray, 0);
            textPaint.setColor(n2);
        }
        if (this.mTextColorLink == null) {
            return;
        }
        ColorStateList colorStateList = this.mTextColor;
        int[] nArray = textPaint.drawableState;
        textPaint.linkColor = n = colorStateList.getColorForState(nArray, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMeasureState(TextPaint textPaint) {
        if (this.mTypeface != null || this.mStyle != 0) {
            Typeface typeface;
            int n;
            int n2;
            int n3;
            int n4;
            Typeface typeface2 = textPaint.getTypeface();
            int n5 = 0;
            if (typeface2 != null) {
                n5 = typeface2.getStyle();
            }
            if (((n4 = (n3 = n5 | (n2 = this.mStyle)) & (n = ~(typeface = this.mTypeface != null ? Typeface.create(this.mTypeface, n3) : (typeface2 == null ? Typeface.defaultFromStyle(n3) : Typeface.create(typeface2, n3))).getStyle())) & 1) != 0) {
                textPaint.setFakeBoldText(true);
            }
            if ((n4 & 2) != 0) {
                textPaint.setTextSkewX(-0.25f);
            }
            Typeface typeface3 = textPaint.setTypeface(typeface);
        }
        if (this.mTextSize <= 0) {
            return;
        }
        float f = this.mTextSize;
        textPaint.setTextSize(f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.mTypeface;
        parcel.writeString(string2);
        int n2 = this.mStyle;
        parcel.writeInt(n2);
        int n3 = this.mTextSize;
        parcel.writeInt(n3);
        if (this.mTextColor != null) {
            parcel.writeInt(1);
            this.mTextColor.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        if (this.mTextColorLink != null) {
            parcel.writeInt(1);
            this.mTextColorLink.writeToParcel(parcel, n);
            return;
        }
        parcel.writeInt(0);
    }
}

