/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.LinkSpec;
import android.util.Patterns;
import android.webkit.WebView;
import android.widget.TextView;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Linkify {
    public static final int ALL = 15;
    public static final int EMAIL_ADDRESSES = 2;
    public static final int MAP_ADDRESSES = 8;
    public static final int PHONE_NUMBERS = 4;
    private static final int PHONE_NUMBER_MINIMUM_DIGITS = 5;
    public static final int WEB_URLS = 1;
    public static final MatchFilter sPhoneNumberMatchFilter;
    public static final TransformFilter sPhoneNumberTransformFilter;
    public static final MatchFilter sUrlMatchFilter;

    static {
        sUrlMatchFilter = new MatchFilter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final boolean acceptMatch(CharSequence charSequence, int n, int n2) {
                if (n == 0) {
                    return true;
                }
                int n3 = n - 1;
                if (charSequence.charAt(n3) != '@') return true;
                return false;
            }
        };
        sPhoneNumberMatchFilter = new MatchFilter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final boolean acceptMatch(CharSequence charSequence, int n, int n2) {
                int n3 = n;
                while (n3 < n2) {
                    if (Character.isDigit(charSequence.charAt(n3)) && 0 + 1 >= 5) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        };
        sPhoneNumberTransformFilter = new TransformFilter(){

            @Override
            public final String transformUrl(Matcher matcher, String string2) {
                return Patterns.digitsAndPlusOnly(matcher);
            }
        };
    }

    private static final void addLinkMovementMethod(TextView textView) {
        MovementMethod movementMethod = textView.getMovementMethod();
        if (movementMethod != null && movementMethod instanceof LinkMovementMethod) {
            return;
        }
        if (!textView.getLinksClickable()) {
            return;
        }
        MovementMethod movementMethod2 = LinkMovementMethod.getInstance();
        textView.setMovementMethod(movementMethod2);
    }

    public static final void addLinks(TextView textView, Pattern pattern, String string2) {
        Linkify.addLinks(textView, pattern, string2, null, null);
    }

    public static final void addLinks(TextView textView, Pattern pattern, String string2, MatchFilter matchFilter, TransformFilter transformFilter) {
        SpannableString spannableString = SpannableString.valueOf(textView.getText());
        if (!Linkify.addLinks(spannableString, pattern, string2, matchFilter, transformFilter)) {
            return;
        }
        textView.setText(spannableString);
        Linkify.addLinkMovementMethod(textView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean addLinks(Spannable spannable, int n) {
        if (n == 0) {
            return false;
        }
        int n2 = spannable.length();
        URLSpan[] uRLSpanArray = spannable.getSpans(0, n2, URLSpan.class);
        for (int i = uRLSpanArray.length - 1; i >= 0; i += -1) {
            URLSpan uRLSpan = uRLSpanArray[i];
            spannable.removeSpan(uRLSpan);
        }
        ArrayList<LinkSpec> arrayList = new ArrayList<LinkSpec>();
        if ((n & 1) != 0) {
            Pattern pattern = Patterns.WEB_URL;
            String[] stringArray = new String[]{"http://", "https://", "rtsp://"};
            MatchFilter matchFilter = sUrlMatchFilter;
            Spannable spannable2 = spannable;
            Linkify.gatherLinks(arrayList, spannable2, pattern, stringArray, matchFilter, null);
        }
        if ((n & 2) != 0) {
            Pattern pattern = Patterns.EMAIL_ADDRESS;
            String[] stringArray = new String[]{"mailto:"};
            Spannable spannable3 = spannable;
            MatchFilter matchFilter = null;
            Linkify.gatherLinks(arrayList, spannable3, pattern, stringArray, matchFilter, null);
        }
        if ((n & 4) != 0) {
            Pattern pattern = Patterns.PHONE;
            String[] stringArray = new String[]{"tel:"};
            MatchFilter matchFilter = sPhoneNumberMatchFilter;
            TransformFilter transformFilter = sPhoneNumberTransformFilter;
            Spannable spannable4 = spannable;
            Linkify.gatherLinks(arrayList, spannable4, pattern, stringArray, matchFilter, transformFilter);
        }
        if ((n & 8) != 0) {
            Linkify.gatherMapLinks(arrayList, spannable);
        }
        Linkify.pruneOverlaps(arrayList);
        if (arrayList.size() == 0) {
            return false;
        }
        Iterator<LinkSpec> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            LinkSpec linkSpec = iterator.next();
            String string2 = linkSpec.url;
            int n3 = linkSpec.start;
            int n4 = linkSpec.end;
            Linkify.applyLink(string2, n3, n4, spannable);
        }
        return true;
    }

    public static final boolean addLinks(Spannable spannable, Pattern pattern, String string2) {
        return Linkify.addLinks(spannable, pattern, string2, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean addLinks(Spannable spannable, Pattern pattern, String string2, MatchFilter matchFilter, TransformFilter transformFilter) {
        boolean bl = false;
        String string3 = string2 == null ? "" : string2.toLowerCase();
        Matcher matcher = pattern.matcher(spannable);
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end();
            boolean bl2 = true;
            if (matchFilter != null) {
                bl2 = matchFilter.acceptMatch(spannable, n, n2);
            }
            if (!bl2) continue;
            String string4 = matcher.group(0);
            String[] stringArray = new String[]{string3};
            Linkify.applyLink(Linkify.makeUrl(string4, stringArray, matcher, transformFilter), n, n2, spannable);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean addLinks(TextView textView, int n) {
        if (n == 0) {
            return false;
        }
        CharSequence charSequence = textView.getText();
        if (charSequence instanceof Spannable) {
            if (!Linkify.addLinks((Spannable)charSequence, n)) return false;
            Linkify.addLinkMovementMethod(textView);
            return true;
        }
        SpannableString spannableString = SpannableString.valueOf(charSequence);
        if (!Linkify.addLinks(spannableString, n)) return false;
        Linkify.addLinkMovementMethod(textView);
        textView.setText(spannableString);
        return true;
    }

    private static final void applyLink(String string2, int n, int n2, Spannable spannable) {
        URLSpan uRLSpan = new URLSpan(string2);
        spannable.setSpan(uRLSpan, n, n2, 33);
    }

    private static final void gatherLinks(ArrayList<LinkSpec> arrayList, Spannable spannable, Pattern pattern, String[] stringArray, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher matcher = pattern.matcher(spannable);
        while (matcher.find()) {
            String string2;
            int n = matcher.start();
            int n2 = matcher.end();
            if (matchFilter != null && !matchFilter.acceptMatch(spannable, n, n2)) continue;
            LinkSpec linkSpec = new LinkSpec();
            linkSpec.url = string2 = Linkify.makeUrl(matcher.group(0), stringArray, matcher, transformFilter);
            linkSpec.start = n;
            linkSpec.end = n2;
            boolean bl = arrayList.add(linkSpec);
        }
        return;
    }

    private static final void gatherMapLinks(ArrayList<LinkSpec> arrayList, Spannable spannable) {
        String string2 = spannable.toString();
        int n = 0;
        String string3;
        while ((string3 = WebView.findAddress(string2)) != null) {
            int n2;
            int n3;
            int n4 = string2.indexOf(string3);
            if (n4 < 0) {
                return;
            }
            LinkSpec linkSpec = new LinkSpec();
            int n5 = string3.length();
            int n6 = n4 + n5;
            linkSpec.start = n3 = n + n4;
            linkSpec.end = n2 = n + n6;
            string2 = string2.substring(n6);
            n += n6;
            try {
                String string4;
                String string5;
                String string6 = string5 = URLEncoder.encode(string3, "UTF-8");
                linkSpec.url = string4 = "geo:0,0?q=" + string6;
                boolean bl = arrayList.add(linkSpec);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        }
        return;
    }

    private static final String makeUrl(String string2, String[] stringArray, Matcher matcher, TransformFilter transformFilter) {
        if (transformFilter != null) {
            string2 = transformFilter.transformUrl(matcher, string2);
        }
        boolean bl = false;
        int n = 0;
        while (true) {
            block8: {
                block7: {
                    int n2;
                    if (n >= (n2 = stringArray.length)) break block7;
                    String string3 = string2;
                    String string4 = stringArray[n];
                    int n3 = 0;
                    int n4 = stringArray[n].length();
                    if (!string3.regionMatches(true, 0, string4, n3, n4)) break block8;
                    bl = true;
                    String string5 = string2;
                    int n5 = 0;
                    String string6 = stringArray[n];
                    int n6 = 0;
                    int n7 = stringArray[n].length();
                    if (!string5.regionMatches(false, n5, string6, n6, n7)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string7 = stringArray[n];
                        StringBuilder stringBuilder2 = stringBuilder.append(string7);
                        int n8 = stringArray[n].length();
                        String string8 = string2.substring(n8);
                        string2 = stringBuilder2.append(string8).toString();
                    }
                }
                if (!bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string9 = stringArray[0];
                    string2 = stringBuilder.append(string9).append(string2).toString();
                }
                return string2;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void pruneOverlaps(ArrayList<LinkSpec> arrayList) {
        Comparator<LinkSpec> comparator = new Comparator<LinkSpec>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final int compare(LinkSpec linkSpec, LinkSpec linkSpec2) {
                int n = linkSpec.start;
                int n2 = linkSpec2.start;
                if (n < n2) {
                    return -1;
                }
                int n3 = linkSpec.start;
                int n4 = linkSpec2.start;
                if (n3 > n4) {
                    return 1;
                }
                int n5 = linkSpec.end;
                int n6 = linkSpec2.end;
                if (n5 < n6) {
                    return 1;
                }
                int n7 = linkSpec.end;
                int n8 = linkSpec2.end;
                if (n7 <= n8) return 0;
                return -1;
            }

            @Override
            public final boolean equals(Object object) {
                return false;
            }
        };
        Collections.sort(arrayList, comparator);
        int n = arrayList.size();
        int n2 = 0;
        int n3;
        while (n2 < (n3 = n - 1)) {
            int n4;
            int n5;
            LinkSpec linkSpec = arrayList.get(n2);
            int n6 = n2 + 1;
            LinkSpec linkSpec2 = arrayList.get(n6);
            int n7 = -1;
            int n8 = linkSpec.start;
            int n9 = linkSpec2.start;
            if (n8 <= n9 && (n5 = linkSpec.end) > (n4 = linkSpec2.start)) {
                int n10 = linkSpec2.end;
                int n11 = linkSpec.end;
                if (n10 <= n11) {
                    n7 = n2 + 1;
                } else {
                    int n12 = linkSpec.end;
                    int n13 = linkSpec.start;
                    int n14 = n12 - n13;
                    int n15 = linkSpec2.end;
                    int n16 = linkSpec2.start;
                    int n17 = n15 - n16;
                    if (n14 > n17) {
                        n7 = n2 + 1;
                    } else {
                        int n18 = linkSpec.end;
                        int n19 = linkSpec.start;
                        int n20 = n18 - n19;
                        int n21 = linkSpec2.end;
                        int n22 = linkSpec2.start;
                        int n23 = n21 - n22;
                        if (n20 < n23) {
                            n7 = n2;
                        }
                    }
                }
                if (n7 != -1) {
                    LinkSpec linkSpec3 = arrayList.remove(n7);
                    n += -1;
                    continue;
                }
            }
            ++n2;
        }
        return;
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }
}

