/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

public class Rfc822Token {
    private String mAddress;
    private String mComment;
    private String mName;

    public Rfc822Token(String string2, String string3, String string4) {
        this.mName = string2;
        this.mAddress = string3;
        this.mComment = string4;
    }

    public static String quoteComment(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '(' || c == ')' || c == '\\') {
                StringBuilder stringBuilder2 = stringBuilder.append('\\');
            }
            StringBuilder stringBuilder3 = stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String quoteName(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\\' || c == '\"') {
                StringBuilder stringBuilder2 = stringBuilder.append('\\');
            }
            StringBuilder stringBuilder3 = stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String quoteNameIfNecessary(String string2) {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ' ' || c >= '0' && c <= '9')) {
                StringBuilder stringBuilder = new StringBuilder().append('\"');
                String string3 = Rfc822Token.quoteName(string2);
                return stringBuilder.append(string3).append('\"').toString();
            }
            ++n2;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean stringEquals(String string2, String string3) {
        if (string2 != null) return string2.equals(string3);
        if (string3 != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Rfc822Token)) {
            return false;
        }
        Rfc822Token rfc822Token = (Rfc822Token)object;
        String string2 = this.mName;
        String string3 = rfc822Token.mName;
        if (!Rfc822Token.stringEquals(string2, string3)) return false;
        String string4 = this.mAddress;
        String string5 = rfc822Token.mAddress;
        if (!Rfc822Token.stringEquals(string4, string5)) return false;
        String string6 = this.mComment;
        String string7 = rfc822Token.mComment;
        if (!Rfc822Token.stringEquals(string6, string7)) return false;
        return true;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getComment() {
        return this.mComment;
    }

    public String getName() {
        return this.mName;
    }

    public int hashCode() {
        int n = 17;
        if (this.mName != null) {
            int n2 = 17 * 31;
            n = this.mName.hashCode() + 527;
        }
        if (this.mAddress != null) {
            int n3 = n * 31;
            int n4 = this.mAddress.hashCode();
            n = n3 + n4;
        }
        if (this.mComment != null) {
            int n5 = n * 31;
            int n6 = this.mComment.hashCode();
            n = n5 + n6;
        }
        return n;
    }

    public void setAddress(String string2) {
        this.mAddress = string2;
    }

    public void setComment(String string2) {
        this.mComment = string2;
    }

    public void setName(String string2) {
        this.mName = string2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mName != null && this.mName.length() != 0) {
            String string2 = Rfc822Token.quoteNameIfNecessary(this.mName);
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            StringBuilder stringBuilder3 = stringBuilder.append(' ');
        }
        if (this.mComment != null && this.mComment.length() != 0) {
            StringBuilder stringBuilder4 = stringBuilder.append('(');
            String string3 = Rfc822Token.quoteComment(this.mComment);
            StringBuilder stringBuilder5 = stringBuilder.append(string3);
            StringBuilder stringBuilder6 = stringBuilder.append(") ");
        }
        if (this.mAddress != null && this.mAddress.length() != 0) {
            StringBuilder stringBuilder7 = stringBuilder.append('<');
            String string4 = this.mAddress;
            StringBuilder stringBuilder8 = stringBuilder.append(string4);
            StringBuilder stringBuilder9 = stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }
}

