/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final int BUFFER_SIZE = 2048;
    private static byte[] EMPTY = new byte[0];
    private final Base64.Coder coder;
    private boolean eof = false;
    private byte[] inputBuffer;
    private int outputEnd;
    private int outputStart;

    public Base64InputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Base64InputStream(InputStream inputStream, int n, boolean bl) {
        super(inputStream);
        byte[] byArray = new byte[2048];
        this.inputBuffer = byArray;
        if (bl) {
            Base64.Encoder encoder = new Base64.Encoder(n, null);
            this.coder = encoder;
        } else {
            Base64.Decoder decoder = new Base64.Decoder(n, null);
            this.coder = decoder;
        }
        Base64.Coder coder = this.coder;
        byte[] byArray2 = new byte[this.coder.maxOutputSize(2048)];
        coder.output = byArray2;
        this.outputStart = 0;
        this.outputEnd = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refill() throws IOException {
        int n;
        boolean bl;
        if (this.eof) {
            return;
        }
        InputStream inputStream = this.in;
        byte[] byArray = this.inputBuffer;
        int n2 = inputStream.read(byArray);
        if (n2 == -1) {
            this.eof = true;
            Base64.Coder coder = this.coder;
            byte[] byArray2 = EMPTY;
            bl = coder.process(byArray2, 0, 0, true);
        } else {
            Base64.Coder coder = this.coder;
            byte[] byArray3 = this.inputBuffer;
            bl = coder.process(byArray3, 0, n2, false);
        }
        if (!bl) {
            throw new IOException("bad base-64");
        }
        this.outputEnd = n = this.coder.op;
        this.outputStart = 0;
    }

    @Override
    public int available() {
        int n = this.outputEnd;
        int n2 = this.outputStart;
        return n - n2;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.inputBuffer = null;
    }

    @Override
    public void mark(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.outputStart;
        int n5 = this.outputEnd;
        if (n4 >= n5) {
            this.refill();
        }
        if ((n3 = this.outputStart) >= (n2 = this.outputEnd)) {
            return -1;
        }
        byte[] byArray = this.coder.output;
        int n6 = this.outputStart;
        this.outputStart = n = n6 + 1;
        return byArray[n6] & 0xFF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6 = this.outputStart;
        int n7 = this.outputEnd;
        if (n6 >= n7) {
            this.refill();
        }
        if ((n5 = this.outputStart) >= (n4 = this.outputEnd)) {
            return -1;
        }
        int n8 = this.outputEnd;
        int n9 = this.outputStart;
        int n10 = n8 - n9;
        int n11 = Math.min(n2, n10);
        byte[] byArray2 = this.coder.output;
        int n12 = this.outputStart;
        System.arraycopy(byArray2, n12, byArray, n, n11);
        this.outputStart = n3 = this.outputStart + n11;
        return n11;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long skip(long l) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.outputStart;
        int n5 = this.outputEnd;
        if (n4 >= n5) {
            this.refill();
        }
        if ((n3 = this.outputStart) >= (n2 = this.outputEnd)) {
            return 0L;
        }
        int n6 = this.outputEnd;
        int n7 = this.outputStart;
        long l2 = n6 - n7;
        long l3 = Math.min(l, l2);
        this.outputStart = n = (int)((long)this.outputStart + l3);
        return l3;
    }
}

