/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private static byte[] EMPTY = new byte[0];
    private int bpos = 0;
    private byte[] buffer = null;
    private final Base64.Coder coder;
    private final int flags;

    public Base64OutputStream(OutputStream outputStream, int n) {
        this(outputStream, n, true);
    }

    public Base64OutputStream(OutputStream outputStream, int n, boolean bl) {
        super(outputStream);
        this.flags = n;
        if (bl) {
            Base64.Encoder encoder = new Base64.Encoder(n, null);
            this.coder = encoder;
            return;
        }
        Base64.Decoder decoder = new Base64.Decoder(n, null);
        this.coder = decoder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] embiggen(byte[] byArray, int n) {
        if (byArray == null) return new byte[n];
        if (byArray.length >= n) return byArray;
        return new byte[n];
    }

    private void flushBuffer() throws IOException {
        if (this.bpos <= 0) {
            return;
        }
        byte[] byArray = this.buffer;
        int n = this.bpos;
        this.internalWrite(byArray, 0, n, false);
        this.bpos = 0;
    }

    private void internalWrite(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        Base64.Coder coder = this.coder;
        byte[] byArray2 = this.coder.output;
        int n3 = this.coder.maxOutputSize(n2);
        byte[] byArray3 = this.embiggen(byArray2, n3);
        coder.output = byArray3;
        if (!this.coder.process(byArray, n, n2, bl)) {
            throw new IOException("bad base-64");
        }
        OutputStream outputStream = this.out;
        byte[] byArray4 = this.coder.output;
        int n4 = this.coder.op;
        outputStream.write(byArray4, 0, n4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        IOException iOException;
        block8: {
            iOException = null;
            try {
                this.flushBuffer();
                byte[] byArray = EMPTY;
                this.internalWrite(byArray, 0, 0, true);
            }
            catch (IOException iOException2) {}
            try {
                if ((this.flags & 0x10) == 0) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
            }
            catch (IOException iOException3) {
                if (iOException == null) break block8;
                iOException = iOException3;
            }
        }
        if (iOException == null) {
            return;
        }
        throw iOException;
    }

    @Override
    public void write(int n) throws IOException {
        byte by;
        int n2;
        int n3;
        int n4;
        if (this.buffer == null) {
            byte[] byArray = new byte[1024];
            this.buffer = byArray;
        }
        if ((n4 = this.bpos) >= (n3 = this.buffer.length)) {
            byte[] byArray = this.buffer;
            int n5 = this.bpos;
            this.internalWrite(byArray, 0, n5, false);
            this.bpos = 0;
        }
        byte[] byArray = this.buffer;
        int n6 = this.bpos;
        this.bpos = n2 = n6 + 1;
        byArray[n6] = by = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        this.flushBuffer();
        this.internalWrite(byArray, n, n2, false);
    }
}

