/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Calendar;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.text.format.Time;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class CalendarUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = "CalendarUtils";

    public static SharedPreferences getSharedPreferences(Context context, String string2) {
        return context.getSharedPreferences(string2, 0);
    }

    public static void setSharedPreference(SharedPreferences sharedPreferences, String string2, String string3) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        SharedPreferences.Editor editor2 = editor.putString(string2, string3);
        editor.apply();
    }

    public static void setSharedPreference(SharedPreferences sharedPreferences, String string2, boolean bl) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        SharedPreferences.Editor editor2 = editor.putBoolean(string2, bl);
        editor.apply();
    }

    public static class TimeZoneUtils {
        public static final String KEY_HOME_TZ = "preferences_home_tz";
        public static final String KEY_HOME_TZ_ENABLED = "preferences_home_tz_enabled";
        private static final String[] TIMEZONE_INSTANCES_ARGS;
        private static final String[] TIMEZONE_TYPE_ARGS;
        private static Formatter mF;
        private static volatile boolean mFirstTZRequest;
        private static AsyncTZHandler mHandler;
        private static volatile String mHomeTZ;
        private static StringBuilder mSB;
        private static HashSet<Runnable> mTZCallbacks;
        private static volatile boolean mTZQueryInProgress;
        private static int mToken;
        private static volatile boolean mUseHomeTZ;
        private final String mPrefsName;

        static {
            String[] stringArray = new String[]{"timezoneType"};
            TIMEZONE_TYPE_ARGS = stringArray;
            String[] stringArray2 = new String[]{"timezoneInstances"};
            TIMEZONE_INSTANCES_ARGS = stringArray2;
            StringBuilder stringBuilder = mSB = new StringBuilder(50);
            Locale locale = Locale.getDefault();
            mF = new Formatter(stringBuilder, locale);
            mFirstTZRequest = true;
            mTZQueryInProgress = false;
            mUseHomeTZ = false;
            mHomeTZ = Time.getCurrentTimezone();
            mTZCallbacks = new HashSet();
            mToken = 1;
        }

        public TimeZoneUtils(String string2) {
            this.mPrefsName = string2;
        }

        static /* synthetic */ boolean access$102(boolean bl) {
            mUseHomeTZ = bl;
            return bl;
        }

        static /* synthetic */ String access$202(String string2) {
            mHomeTZ = string2;
            return string2;
        }

        static /* synthetic */ boolean access$402(boolean bl) {
            mTZQueryInProgress = bl;
            return bl;
        }

        public void forceDBRequery(Context context, Runnable runnable) {
            HashSet<Runnable> hashSet = mTZCallbacks;
            synchronized (hashSet) {
                if (mTZQueryInProgress) {
                    boolean bl = mTZCallbacks.add(runnable);
                    return;
                }
                mFirstTZRequest = true;
                String string2 = this.getTimeZone(context, runnable);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String formatDateRange(Context context, long l, long l2, int n) {
            String string2 = (n & 0x2000) != 0 ? "UTC" : this.getTimeZone(context, null);
            StringBuilder stringBuilder = mSB;
            synchronized (stringBuilder) {
                mSB.setLength(0);
                Formatter formatter = mF;
                Context context2 = context;
                long l3 = l;
                long l4 = l2;
                int n2 = n;
                return DateUtils.formatDateRange(context2, formatter, l3, l4, n2, string2).toString();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getTimeZone(Context context, Runnable runnable) {
            HashSet<Runnable> hashSet = mTZCallbacks;
            synchronized (hashSet) {
                if (mFirstTZRequest) {
                    mTZQueryInProgress = true;
                    mFirstTZRequest = false;
                    String string2 = this.mPrefsName;
                    SharedPreferences sharedPreferences = CalendarUtils.getSharedPreferences(context, string2);
                    mUseHomeTZ = sharedPreferences.getBoolean(KEY_HOME_TZ_ENABLED, false);
                    String string3 = Time.getCurrentTimezone();
                    mHomeTZ = sharedPreferences.getString(KEY_HOME_TZ, string3);
                    if (mHandler == null) {
                        ContentResolver contentResolver = context.getContentResolver();
                        mHandler = new AsyncTZHandler(contentResolver);
                    }
                    AsyncTZHandler asyncTZHandler = mHandler;
                    Uri uri = Calendar.CalendarCache.URI;
                    String[] stringArray = Calendar.CalendarCache.POJECTION;
                    Context context2 = context;
                    asyncTZHandler.startQuery(0, context2, uri, stringArray, null, null, null);
                }
                if (mTZQueryInProgress) {
                    boolean bl = mTZCallbacks.add(runnable);
                }
            }
            if (!mUseHomeTZ) return Time.getCurrentTimezone();
            return mHomeTZ;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void setTimeZone(Context context, String string2) {
            int n;
            AsyncTZHandler asyncTZHandler;
            if (TextUtils.isEmpty(string2)) {
                return;
            }
            boolean bl = false;
            HashSet<Runnable> hashSet = mTZCallbacks;
            // MONITORENTER : hashSet
            String string3 = "auto";
            String string4 = string2;
            if (string3.equals(string4)) {
                if (mUseHomeTZ) {
                    bl = true;
                }
                mUseHomeTZ = false;
            } else {
                String string5;
                String string6;
                if (!mUseHomeTZ || !TextUtils.equals(string6 = mHomeTZ, string5 = string2)) {
                    bl = true;
                }
                mUseHomeTZ = true;
                mHomeTZ = string2;
            }
            // MONITOREXIT : hashSet
            if (!bl) {
                return;
            }
            String string7 = this.mPrefsName;
            Context context2 = context;
            String string8 = string7;
            SharedPreferences sharedPreferences = CalendarUtils.getSharedPreferences(context2, string8);
            boolean bl2 = mUseHomeTZ;
            CalendarUtils.setSharedPreference(sharedPreferences, KEY_HOME_TZ_ENABLED, bl2);
            String string9 = mHomeTZ;
            CalendarUtils.setSharedPreference(sharedPreferences, KEY_HOME_TZ, string9);
            ContentValues contentValues = new ContentValues();
            if (mHandler != null) {
                AsyncTZHandler asyncTZHandler2 = mHandler;
                int n2 = mToken;
                asyncTZHandler2.cancelOperation(n2);
            }
            ContentResolver contentResolver = context.getContentResolver();
            AsyncTZHandler asyncTZHandler3 = asyncTZHandler;
            TimeZoneUtils timeZoneUtils = this;
            ContentResolver contentResolver2 = contentResolver;
            asyncTZHandler3(contentResolver2);
            mHandler = asyncTZHandler;
            mToken = n = mToken + 1;
            if (n == 0) {
                mToken = 1;
            }
            String string10 = "value";
            String string11 = mUseHomeTZ ? "home" : "auto";
            contentValues.put(string10, string11);
            AsyncTZHandler asyncTZHandler4 = mHandler;
            int n3 = mToken;
            Uri uri = Calendar.CalendarCache.URI;
            String[] stringArray = TIMEZONE_TYPE_ARGS;
            asyncTZHandler4.startUpdate(n3, null, uri, contentValues, "key=?", stringArray);
            if (!mUseHomeTZ) {
                return;
            }
            ContentValues contentValues2 = new ContentValues();
            String string12 = mHomeTZ;
            contentValues2.put("value", string12);
            AsyncTZHandler asyncTZHandler5 = mHandler;
            int n4 = mToken;
            Uri uri2 = Calendar.CalendarCache.URI;
            String[] stringArray2 = TIMEZONE_INSTANCES_ARGS;
            asyncTZHandler5.startUpdate(n4, null, uri2, contentValues2, "key=?", stringArray2);
        }

        private class AsyncTZHandler
        extends AsyncQueryHandler {
            public AsyncTZHandler(ContentResolver contentResolver) {
                super(contentResolver);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void onQueryComplete(int n, Object object, Cursor cursor) {
                HashSet hashSet = mTZCallbacks;
                synchronized (hashSet) {
                    boolean bl = false;
                    int n2 = cursor.getColumnIndexOrThrow("key");
                    int n3 = cursor.getColumnIndexOrThrow("value");
                    while (cursor.moveToNext()) {
                        String string2 = cursor.getString(n2);
                        String string3 = cursor.getString(n3);
                        if (TextUtils.equals(string2, "timezoneType")) {
                            boolean bl2;
                            boolean bl3 = !TextUtils.equals(string3, "auto");
                            if (bl3 == (bl2 = mUseHomeTZ)) continue;
                            bl = true;
                            boolean bl4 = TimeZoneUtils.access$102(bl3);
                            continue;
                        }
                        if (!TextUtils.equals(string2, "timezoneInstancesPrevious") || TextUtils.isEmpty(string3) || TextUtils.equals(mHomeTZ, string3)) continue;
                        bl = true;
                        String string4 = TimeZoneUtils.access$202(string3);
                    }
                    cursor.close();
                    if (bl) {
                        Context context = (Context)object;
                        String string5 = TimeZoneUtils.this.mPrefsName;
                        SharedPreferences sharedPreferences = CalendarUtils.getSharedPreferences(context, string5);
                        boolean bl5 = mUseHomeTZ;
                        CalendarUtils.setSharedPreference(sharedPreferences, TimeZoneUtils.KEY_HOME_TZ_ENABLED, bl5);
                        String string6 = mHomeTZ;
                        CalendarUtils.setSharedPreference(sharedPreferences, TimeZoneUtils.KEY_HOME_TZ, string6);
                    }
                    boolean bl6 = TimeZoneUtils.access$402(false);
                    Iterator iterator = mTZCallbacks.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            mTZCallbacks.clear();
                            return;
                        }
                        Runnable runnable = (Runnable)iterator.next();
                        if (runnable == null) continue;
                        runnable.run();
                    }
                }
            }
        }
    }
}

