/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Build;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public final class CharsetUtils {
    private static final String VENDOR_DOCOMO = "docomo";

    private CharsetUtils() {
    }

    public static Charset charsetForVendor(String string2) throws UnsupportedCharsetException, IllegalCharsetNameException {
        String string3 = CharsetUtils.getDefaultVendor();
        return CharsetUtils.charsetForVendor(string2, string3);
    }

    public static Charset charsetForVendor(String string2, String string3) throws UnsupportedCharsetException, IllegalCharsetNameException {
        return Charset.forName(CharsetUtils.nameForVendor(string2, string3));
    }

    private static String getDefaultVendor() {
        return Build.BRAND;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isShiftJis(String string2) {
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n != 4 && n != 9) {
            return false;
        }
        if (string2.equalsIgnoreCase("shift_jis")) return true;
        if (string2.equalsIgnoreCase("shift-jis")) return true;
        if (!string2.equalsIgnoreCase("sjis")) return false;
        return true;
    }

    public static String nameForDefaultVendor(String string2) {
        String string3 = CharsetUtils.getDefaultVendor();
        return CharsetUtils.nameForVendor(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String nameForVendor(String string2, String string3) {
        if (!string3.equalsIgnoreCase(VENDOR_DOCOMO)) return string2;
        if (!CharsetUtils.isShiftJis(string2)) return string2;
        return "docomo-shift_jis-2007";
    }
}

