/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;

public class EventLog {
    private static final String COMMENT_PATTERN = "^\\s*(#.*)?$";
    private static final String TAG = "EventLog";
    private static final String TAGS_FILE = "/system/etc/event-log-tags";
    private static final String TAG_PATTERN = "^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$";
    private static HashMap<String, Integer> sTagCodes = null;
    private static HashMap<Integer, String> sTagNames = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getTagCode(String string2) {
        EventLog.readTagsFile();
        Integer n = sTagCodes.get(string2);
        if (n == null) return -1;
        return n;
    }

    public static String getTagName(int n) {
        EventLog.readTagsFile();
        HashMap<Integer, String> hashMap = sTagNames;
        Integer n2 = n;
        return hashMap.get(n2);
    }

    public static native void readEvents(int[] var0, Collection<Event> var1) throws IOException;

    /*
     * Exception decompiling
     */
    private static void readTagsFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10, 9, 11 : 194->262)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static native int writeEvent(int var0, int var1);

    public static native int writeEvent(int var0, long var1);

    public static native int writeEvent(int var0, String var1);

    public static native int writeEvent(int var0, Object ... var1);

    public static final class Event {
        private static final int DATA_START = 24;
        private static final byte INT_TYPE = 0;
        private static final int LENGTH_OFFSET = 0;
        private static final byte LIST_TYPE = 3;
        private static final byte LONG_TYPE = 1;
        private static final int NANOSECONDS_OFFSET = 16;
        private static final int PAYLOAD_START = 20;
        private static final int PROCESS_OFFSET = 4;
        private static final int SECONDS_OFFSET = 12;
        private static final byte STRING_TYPE = 2;
        private static final int TAG_OFFSET = 20;
        private static final int THREAD_OFFSET = 8;
        private final ByteBuffer mBuffer;

        Event(byte[] byArray) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = this.mBuffer = (byteBuffer = ByteBuffer.wrap(byArray));
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            ByteBuffer byteBuffer3 = byteBuffer2.order(byteOrder);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object decodeObject() {
            void var3_4;
            byte by = this.mBuffer.get();
            switch (by) {
                default: {
                    String string2 = "Unknown entry type: " + by;
                    throw new IllegalArgumentException(string2);
                }
                case 0: {
                    Integer n = this.mBuffer.getInt();
                    return var3_4;
                }
                case 1: {
                    Long l = this.mBuffer.getLong();
                    return var3_4;
                }
                case 2: {
                    try {
                        int n = this.mBuffer.getInt();
                        int n2 = this.mBuffer.position();
                        ByteBuffer byteBuffer = this.mBuffer;
                        int n3 = n2 + n;
                        Buffer buffer = byteBuffer.position(n3);
                        byte[] byArray = this.mBuffer.array();
                        String string3 = new String(byArray, n2, n, "UTF-8");
                        return var3_4;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        int n = Log.wtf(EventLog.TAG, "UTF-8 is not supported", unsupportedEncodingException);
                        Object var3_7 = null;
                    }
                    return var3_4;
                }
                case 3: 
            }
            int n = this.mBuffer.get();
            if (n < 0) {
                n += 256;
            }
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                objectArray[i] = object = this.decodeObject();
            }
            Object[] objectArray2 = objectArray;
            return var3_4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getData() {
            synchronized (this) {
                try {
                    ByteBuffer byteBuffer = this.mBuffer;
                    int n = this.mBuffer.getShort(0) + 20;
                    Buffer buffer = byteBuffer.limit(n);
                    Buffer buffer2 = this.mBuffer.position(24);
                    Object object = this.decodeObject();
                    return object;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Illegal entry payload: tag=");
                    int n = this.getTag();
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.wtf(EventLog.TAG, string2, illegalArgumentException);
                    return null;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Truncated entry payload: tag=");
                    int n = this.getTag();
                    String string3 = stringBuilder.append(n).toString();
                    int n3 = Log.wtf(EventLog.TAG, string3, bufferUnderflowException);
                    return null;
                }
            }
        }

        public int getProcessId() {
            return this.mBuffer.getInt(4);
        }

        public int getTag() {
            return this.mBuffer.getInt(20);
        }

        public int getThreadId() {
            return this.mBuffer.getInt(8);
        }

        public long getTimeNanos() {
            long l = (long)this.mBuffer.getInt(12) * 1000000000L;
            long l2 = this.mBuffer.getInt(16);
            return l + l2;
        }
    }
}

