/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;

class FinitePool<T extends Poolable<T>>
implements Pool<T> {
    private final boolean mInfinite;
    private final int mLimit;
    private final PoolableManager<T> mManager;
    private int mPoolCount;
    private T mRoot;

    FinitePool(PoolableManager<T> poolableManager) {
        this.mManager = poolableManager;
        this.mLimit = 0;
        this.mInfinite = true;
    }

    FinitePool(PoolableManager<T> poolableManager, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The pool limit must be > 0");
        }
        this.mManager = poolableManager;
        this.mLimit = n;
        this.mInfinite = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public T acquire() {
        T t;
        if (this.mRoot != null) {
            int n;
            t = this.mRoot;
            Poolable poolable = (Poolable)t.getNextPoolable();
            this.mRoot = poolable;
            this.mPoolCount = n = this.mPoolCount - 1;
        } else {
            t = this.mManager.newInstance();
        }
        if (t != null) {
            t.setNextPoolable(null);
            this.mManager.onAcquired(t);
        }
        return t;
    }

    @Override
    public void release(T t) {
        int n;
        int n2;
        if (this.mInfinite || (n2 = this.mPoolCount) < (n = this.mLimit)) {
            int n3;
            this.mPoolCount = n3 = this.mPoolCount + 1;
            T t2 = this.mRoot;
            t.setNextPoolable(t2);
            this.mRoot = t;
        }
        this.mManager.onReleased(t);
    }
}

