/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import com.android.internal.util.ArrayUtils;

public class LongSparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private long[] mKeys;
    private int mSize;
    private Object[] mValues;

    public LongSparseArray() {
        this(10);
    }

    public LongSparseArray(int n) {
        int n2;
        int n3 = n2 = ArrayUtils.idealIntArraySize(n);
        this.mKeys = (long[])n3;
        Object[] objectArray = new Object[n2];
        this.mValues = objectArray;
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(long[] lArray, int n, int n2, long l) {
        int n3 = n + n2;
        int n4 = n - 1;
        while (n3 - n4 > 1) {
            int n5 = (n3 + n4) / 2;
            if (lArray[n5] < l) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        int n6 = n + n2;
        if (n3 != n6) {
            return ~(n + n2);
        }
        if (lArray[n3] != l) return ~n3;
        return n3;
    }

    private void checkIntegrity() {
        int n = 1;
        int n2;
        while (n < (n2 = this.mSize)) {
            long l = this.mKeys[n];
            long[] lArray = this.mKeys;
            int n3 = n - 1;
            long l2 = lArray[n3];
            if (l <= l2) {
                int n4;
                for (int i = 0; i < (n4 = this.mSize); ++i) {
                    StringBuilder stringBuilder = new StringBuilder().append(i).append(": ");
                    long l3 = this.mKeys[i];
                    StringBuilder stringBuilder2 = stringBuilder.append(l3).append(" -> ");
                    Object object = this.mValues[i];
                    String string2 = stringBuilder2.append(object).toString();
                    int n5 = Log.e("FAIL", string2);
                }
                throw new RuntimeException();
            }
            ++n;
        }
        return;
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        long[] lArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = DELETED;
            if (object == object2) continue;
            if (i != n2) {
                long l;
                lArray[n2] = l = lArray[i];
                objectArray[n2] = object;
            }
            ++n2;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    public void append(long l, E e) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long[] lArray;
        long l2;
        if (this.mSize != 0 && l <= (l2 = (lArray = this.mKeys)[n6 = this.mSize - 1])) {
            this.put(l, e);
            return;
        }
        if (this.mGarbage && (n5 = this.mSize) >= (n4 = this.mKeys.length)) {
            this.gc();
        }
        if ((n3 = this.mSize) >= (n2 = this.mKeys.length)) {
            int n7;
            int n8 = n7 = ArrayUtils.idealIntArraySize(n3 + 1);
            Object[] objectArray = new Object[n7];
            long[] lArray2 = this.mKeys;
            int n9 = this.mKeys.length;
            System.arraycopy(lArray2, 0, n8, 0, n9);
            Object[] objectArray2 = this.mValues;
            int n10 = this.mValues.length;
            System.arraycopy(objectArray2, 0, objectArray, 0, n10);
            this.mKeys = (long[])n8;
            this.mValues = objectArray;
        }
        this.mKeys[n3] = l;
        this.mValues[n3] = e;
        this.mSize = n = n3 + 1;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void delete(long l) {
        Object object;
        long[] lArray = this.mKeys;
        int n = this.mSize;
        int n2 = LongSparseArray.binarySearch(lArray, 0, n, l);
        if (n2 < 0) {
            return;
        }
        Object object2 = this.mValues[n2];
        Object object3 = DELETED;
        if (object2 == object3) {
            return;
        }
        Object[] objectArray = this.mValues;
        objectArray[n2] = object = DELETED;
        this.mGarbage = true;
    }

    public E get(long l) {
        return this.get(l, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public E get(long l, E e) {
        void var9_9;
        Object object;
        Object object2;
        long[] lArray = this.mKeys;
        int n = this.mSize;
        int n2 = LongSparseArray.binarySearch(lArray, 0, n, l);
        if (n2 < 0 || (object2 = this.mValues[n2]) == (object = DELETED)) {
            E e2 = e;
            return var9_9;
        }
        Object object3 = this.mValues[n2];
        return var9_9;
    }

    public long[] getKeys() {
        int n;
        int n2 = n = this.mKeys.length;
        System.arraycopy(this.mKeys, 0, n2, 0, n);
        return n2;
    }

    public int indexOfKey(long l) {
        if (this.mGarbage) {
            this.gc();
        }
        long[] lArray = this.mKeys;
        int n = this.mSize;
        return LongSparseArray.binarySearch(lArray, 0, n, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(E e) {
        int n;
        if (this.mGarbage) {
            this.gc();
        }
        int n2 = 0;
        while (n2 < (n = this.mSize)) {
            if (this.mValues[n2] == e) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public long keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public void put(long l, E e) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        Object object2;
        long[] lArray = this.mKeys;
        int n6 = this.mSize;
        int n7 = LongSparseArray.binarySearch(lArray, 0, n6, l);
        if (n7 >= 0) {
            this.mValues[n7] = e;
            return;
        }
        int n8 = this.mSize;
        if ((n7 ^= 0xFFFFFFFF) < n8 && (object2 = this.mValues[n7]) == (object = DELETED)) {
            this.mKeys[n7] = l;
            this.mValues[n7] = e;
            return;
        }
        if (this.mGarbage && (n5 = this.mSize) >= (n4 = this.mKeys.length)) {
            this.gc();
            long[] lArray2 = this.mKeys;
            int n9 = this.mSize;
            n7 = ~LongSparseArray.binarySearch(lArray2, 0, n9, l);
        }
        if ((n3 = this.mSize) >= (n2 = this.mKeys.length)) {
            int n10;
            int n11 = n10 = ArrayUtils.idealIntArraySize(this.mSize + 1);
            Object[] objectArray = new Object[n10];
            long[] lArray3 = this.mKeys;
            int n12 = this.mKeys.length;
            System.arraycopy(lArray3, 0, n11, 0, n12);
            Object[] objectArray2 = this.mValues;
            int n13 = this.mValues.length;
            System.arraycopy(objectArray2, 0, objectArray, 0, n13);
            this.mKeys = (long[])n11;
            this.mValues = objectArray;
        }
        if (this.mSize - n7 != 0) {
            long[] lArray4 = this.mKeys;
            long[] lArray5 = this.mKeys;
            int n14 = n7 + 1;
            int n15 = this.mSize - n7;
            System.arraycopy(lArray4, n7, lArray5, n14, n15);
            Object[] objectArray = this.mValues;
            Object[] objectArray3 = this.mValues;
            int n16 = n7 + 1;
            int n17 = this.mSize - n7;
            System.arraycopy(objectArray, n7, objectArray3, n16, n17);
        }
        this.mKeys[n7] = l;
        this.mValues[n7] = e;
        this.mSize = n = this.mSize + 1;
    }

    public void remove(long l) {
        this.delete(l);
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = e;
    }

    public void setValues(long[] lArray, E e) {
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            this.put(l, e);
            ++n2;
        }
        return;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n];
    }
}

