/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Random;

public final class MathUtils {
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float RAD_TO_DEG = 57.295784f;
    private static final Random sRandom = new Random();

    private MathUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float abs(float f) {
        if (!(f > 0.0f)) return -f;
        return f;
    }

    public static float acos(float f) {
        return (float)Math.acos(f);
    }

    public static float asin(float f) {
        return (float)Math.asin(f);
    }

    public static float atan(float f) {
        return (float)Math.atan(f);
    }

    public static float atan2(float f, float f2) {
        double d = f;
        double d2 = f2;
        return (float)Math.atan2(d, d2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float constrain(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (!(f > f3)) return f;
        return f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int constrain(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n <= n3) return n;
        return n3;
    }

    public static float degrees(float f) {
        return 57.295784f * f;
    }

    public static float dist(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float f7 = f5 * f5;
        float f8 = f6 * f6;
        return (float)Math.sqrt(f7 + f8);
    }

    public static float dist(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f4 - f;
        float f8 = f5 - f2;
        float f9 = f6 - f3;
        float f10 = f7 * f7;
        float f11 = f8 * f8;
        float f12 = f10 + f11;
        float f13 = f9 * f9;
        return (float)Math.sqrt(f12 + f13);
    }

    public static float exp(float f) {
        return (float)Math.exp(f);
    }

    public static float lerp(float f, float f2, float f3) {
        return (f2 - f) * f3 + f;
    }

    public static float log(float f) {
        return (float)Math.log(f);
    }

    public static float mag(float f, float f2) {
        float f3 = f * f;
        float f4 = f2 * f2;
        return (float)Math.sqrt(f3 + f4);
    }

    public static float mag(float f, float f2, float f3) {
        float f4 = f * f;
        float f5 = f2 * f2;
        float f6 = f4 + f5;
        float f7 = f3 * f3;
        return (float)Math.sqrt(f6 + f7);
    }

    public static float map(float f, float f2, float f3, float f4, float f5) {
        float f6 = f3 - f4;
        float f7 = f5 - f;
        float f8 = f2 - f;
        float f9 = f7 / f8;
        return f6 * f9 + f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float max(float f, float f2) {
        if (!(f > f2)) return f2;
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float max(float f, float f2, float f3) {
        if (f > f2) {
            if (!(f > f3)) return f3;
            return f;
        }
        if (!(f2 > f3)) return f3;
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float max(int n, int n2) {
        if (n <= n2) return n2;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float max(int n, int n2, int n3) {
        int n4;
        if (n > n2) {
            int n5;
            if (n > n3) {
                n5 = n;
                return n5;
            }
            n5 = n3;
            return n5;
        }
        if (n2 > n3) {
            n4 = n2;
            return n4;
        }
        n4 = n3;
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float min(float f, float f2) {
        if (!(f < f2)) return f2;
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float min(float f, float f2, float f3) {
        if (f < f2) {
            if (!(f < f3)) return f3;
            return f;
        }
        if (!(f2 < f3)) return f3;
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float min(int n, int n2) {
        if (n >= n2) return n2;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float min(int n, int n2, int n3) {
        int n4;
        if (n < n2) {
            int n5;
            if (n < n3) {
                n5 = n;
                return n5;
            }
            n5 = n3;
            return n5;
        }
        if (n2 < n3) {
            n4 = n2;
            return n4;
        }
        n4 = n3;
        return n4;
    }

    public static float norm(float f, float f2, float f3) {
        float f4 = f3 - f;
        float f5 = f2 - f;
        return f4 / f5;
    }

    public static float pow(float f, float f2) {
        double d = f;
        double d2 = f2;
        return (float)Math.pow(d, d2);
    }

    public static float radians(float f) {
        return (float)Math.PI / 180 * f;
    }

    public static float random(float f) {
        return sRandom.nextFloat() * f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float random(float f, float f2) {
        if (f >= f2) {
            return f;
        }
        float f3 = sRandom.nextFloat();
        float f4 = f2 - f;
        return f3 * f4 + f;
    }

    public static int random(int n) {
        float f = sRandom.nextFloat();
        float f2 = n;
        return (int)(f * f2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int random(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        float f = sRandom.nextFloat();
        float f2 = n2 - n;
        float f3 = f * f2;
        float f4 = n;
        return (int)(f3 + f4);
    }

    public static void randomSeed(long l) {
        sRandom.setSeed(l);
    }

    public static float sq(float f) {
        return f * f;
    }

    public static float tan(float f) {
        return (float)Math.tan(f);
    }
}

