/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Calendar;

public class MonthDisplayHelper {
    private Calendar mCalendar;
    private int mNumDaysInMonth;
    private int mNumDaysInPrevMonth;
    private int mOffset;
    private final int mWeekStartDay;

    public MonthDisplayHelper(int n, int n2) {
        this(n, n2, 1);
    }

    public MonthDisplayHelper(int n, int n2, int n3) {
        Calendar calendar;
        if (n3 < 1 || n3 > 7) {
            throw new IllegalArgumentException();
        }
        this.mWeekStartDay = n3;
        this.mCalendar = calendar = Calendar.getInstance();
        this.mCalendar.set(1, n);
        this.mCalendar.set(2, n2);
        this.mCalendar.set(5, 1);
        this.mCalendar.set(11, 0);
        this.mCalendar.set(12, 0);
        this.mCalendar.set(13, 0);
        long l = this.mCalendar.getTimeInMillis();
        this.recalculate();
    }

    private void recalculate() {
        int n;
        int n2;
        this.mNumDaysInMonth = n2 = this.mCalendar.getActualMaximum(5);
        this.mCalendar.add(2, -1);
        this.mNumDaysInPrevMonth = n = this.mCalendar.getActualMaximum(5);
        this.mCalendar.add(2, 1);
        int n3 = this.getFirstDayOfMonth();
        int n4 = this.mWeekStartDay;
        int n5 = n3 - n4;
        if (n5 < 0) {
            n5 += 7;
        }
        this.mOffset = n5;
    }

    public int getColumnOf(int n) {
        return (this.mOffset + n - 1) % 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDayAt(int n, int n2) {
        int n3;
        if (n == 0 && n2 < (n3 = this.mOffset)) {
            int n4 = this.mNumDaysInPrevMonth + n2;
            int n5 = this.mOffset;
            return n4 - n5 + 1;
        }
        int n6 = n * 7 + n2;
        int n7 = this.mOffset;
        int n8 = n6 - n7 + 1;
        int n9 = this.mNumDaysInMonth;
        if (n8 <= n9) return n8;
        int n10 = this.mNumDaysInMonth;
        return n8 - n10;
    }

    public int[] getDigitsForRow(int n) {
        if (n < 0 || n > 5) {
            String string2 = "row " + n + " out of range (0-5)";
            throw new IllegalArgumentException(string2);
        }
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            int n2;
            nArray[i] = n2 = this.getDayAt(n, i);
        }
        return nArray;
    }

    public int getFirstDayOfMonth() {
        return this.mCalendar.get(7);
    }

    public int getMonth() {
        return this.mCalendar.get(2);
    }

    public int getNumberOfDaysInMonth() {
        return this.mNumDaysInMonth;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getRowOf(int n) {
        return (this.mOffset + n - 1) / 7;
    }

    public int getWeekStartDay() {
        return this.mWeekStartDay;
    }

    public int getYear() {
        return this.mCalendar.get(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWithinCurrentMonth(int n, int n2) {
        int n3;
        if (n < 0) return false;
        if (n2 < 0) return false;
        if (n > 5) return false;
        if (n2 > 6) {
            return false;
        }
        if (n == 0 && n2 < (n3 = this.mOffset)) {
            return false;
        }
        int n4 = n * 7 + n2;
        int n5 = this.mOffset;
        int n6 = n4 - n5 + 1;
        int n7 = this.mNumDaysInMonth;
        if (n6 <= n7) return true;
        return false;
    }

    public void nextMonth() {
        this.mCalendar.add(2, 1);
        this.recalculate();
    }

    public void previousMonth() {
        this.mCalendar.add(2, -1);
        this.recalculate();
    }
}

