/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import com.android.internal.util.ArrayUtils;

public class SparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private int mSize;
    private Object[] mValues;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int n) {
        int n2 = ArrayUtils.idealIntArraySize(n);
        int[] nArray = new int[n2];
        this.mKeys = nArray;
        Object[] objectArray = new Object[n2];
        this.mValues = objectArray;
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n - 1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        int n7 = n + n2;
        if (n4 != n7) {
            return ~(n + n2);
        }
        if (nArray[n4] == n3) return ~n4;
        return n4;
    }

    private void checkIntegrity() {
        int n = 1;
        int n2;
        while (n < (n2 = this.mSize)) {
            int n3 = this.mKeys[n];
            int[] nArray = this.mKeys;
            int n4 = n - 1;
            int n5 = nArray[n4];
            if (n3 <= n5) {
                int n6;
                for (int i = 0; i < (n6 = this.mSize); ++i) {
                    StringBuilder stringBuilder = new StringBuilder().append(i).append(": ");
                    int n7 = this.mKeys[i];
                    StringBuilder stringBuilder2 = stringBuilder.append(n7).append(" -> ");
                    Object object = this.mValues[i];
                    String string2 = stringBuilder2.append(object).toString();
                    int n8 = Log.e("FAIL", string2);
                }
                throw new RuntimeException();
            }
            ++n;
        }
        return;
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = DELETED;
            if (object == object2) continue;
            if (i != n2) {
                int n3;
                nArray[n2] = n3 = nArray[i];
                objectArray[n2] = object;
            }
            ++n2;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    public void append(int n, E e) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int n8;
        if (this.mSize != 0 && n <= (n8 = (nArray = this.mKeys)[n7 = this.mSize - 1])) {
            this.put(n, e);
            return;
        }
        if (this.mGarbage && (n6 = this.mSize) >= (n5 = this.mKeys.length)) {
            this.gc();
        }
        if ((n4 = this.mSize) >= (n3 = this.mKeys.length)) {
            int n9 = ArrayUtils.idealIntArraySize(n4 + 1);
            int[] nArray2 = new int[n9];
            Object[] objectArray = new Object[n9];
            int[] nArray3 = this.mKeys;
            int n10 = this.mKeys.length;
            System.arraycopy(nArray3, 0, nArray2, 0, n10);
            Object[] objectArray2 = this.mValues;
            int n11 = this.mValues.length;
            System.arraycopy(objectArray2, 0, objectArray, 0, n11);
            this.mKeys = nArray2;
            this.mValues = objectArray;
        }
        this.mKeys[n4] = n;
        this.mValues[n4] = e;
        this.mSize = n2 = n4 + 1;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void delete(int n) {
        Object object;
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        int n3 = SparseArray.binarySearch(nArray, 0, n2, n);
        if (n3 < 0) {
            return;
        }
        Object object2 = this.mValues[n3];
        Object object3 = DELETED;
        if (object2 == object3) {
            return;
        }
        Object[] objectArray = this.mValues;
        objectArray[n3] = object = DELETED;
        this.mGarbage = true;
    }

    public E get(int n) {
        return this.get(n, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public E get(int n, E e) {
        void var8_9;
        Object object;
        Object object2;
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        int n3 = SparseArray.binarySearch(nArray, 0, n2, n);
        if (n3 < 0 || (object2 = this.mValues[n3]) == (object = DELETED)) {
            E e2 = e;
            return var8_9;
        }
        Object object3 = this.mValues[n3];
        return var8_9;
    }

    public int indexOfKey(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        return SparseArray.binarySearch(nArray, 0, n2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(E e) {
        int n;
        if (this.mGarbage) {
            this.gc();
        }
        int n2 = 0;
        while (n2 < (n = this.mSize)) {
            if (this.mValues[n2] == e) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public void put(int n, E e) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        Object object2;
        int[] nArray = this.mKeys;
        int n7 = this.mSize;
        int n8 = SparseArray.binarySearch(nArray, 0, n7, n);
        if (n8 >= 0) {
            this.mValues[n8] = e;
            return;
        }
        int n9 = this.mSize;
        if ((n8 ^= 0xFFFFFFFF) < n9 && (object2 = this.mValues[n8]) == (object = DELETED)) {
            this.mKeys[n8] = n;
            this.mValues[n8] = e;
            return;
        }
        if (this.mGarbage && (n6 = this.mSize) >= (n5 = this.mKeys.length)) {
            this.gc();
            int[] nArray2 = this.mKeys;
            int n10 = this.mSize;
            n8 = ~SparseArray.binarySearch(nArray2, 0, n10, n);
        }
        if ((n4 = this.mSize) >= (n3 = this.mKeys.length)) {
            int n11 = ArrayUtils.idealIntArraySize(this.mSize + 1);
            int[] nArray3 = new int[n11];
            Object[] objectArray = new Object[n11];
            int[] nArray4 = this.mKeys;
            int n12 = this.mKeys.length;
            System.arraycopy(nArray4, 0, nArray3, 0, n12);
            Object[] objectArray2 = this.mValues;
            int n13 = this.mValues.length;
            System.arraycopy(objectArray2, 0, objectArray, 0, n13);
            this.mKeys = nArray3;
            this.mValues = objectArray;
        }
        if (this.mSize - n8 != 0) {
            int[] nArray5 = this.mKeys;
            int[] nArray6 = this.mKeys;
            int n14 = n8 + 1;
            int n15 = this.mSize - n8;
            System.arraycopy(nArray5, n8, nArray6, n14, n15);
            Object[] objectArray = this.mValues;
            Object[] objectArray3 = this.mValues;
            int n16 = n8 + 1;
            int n17 = this.mSize - n8;
            System.arraycopy(objectArray, n8, objectArray3, n16, n17);
        }
        this.mKeys[n8] = n;
        this.mValues[n8] = e;
        this.mSize = n2 = this.mSize + 1;
    }

    public void remove(int n) {
        this.delete(n);
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = e;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n];
    }
}

