/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import com.android.internal.util.ArrayUtils;

public class SparseBooleanArray {
    private int[] mKeys;
    private int mSize;
    private boolean[] mValues;

    public SparseBooleanArray() {
        this(10);
    }

    public SparseBooleanArray(int n) {
        int n2 = ArrayUtils.idealIntArraySize(n);
        int[] nArray = new int[n2];
        this.mKeys = nArray;
        boolean[] blArray = new boolean[n2];
        this.mValues = blArray;
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n - 1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        int n7 = n + n2;
        if (n4 != n7) {
            return ~(n + n2);
        }
        if (nArray[n4] == n3) return ~n4;
        return n4;
    }

    private void checkIntegrity() {
        int n = 1;
        int n2;
        while (n < (n2 = this.mSize)) {
            int n3 = this.mKeys[n];
            int[] nArray = this.mKeys;
            int n4 = n - 1;
            int n5 = nArray[n4];
            if (n3 <= n5) {
                int n6;
                for (int i = 0; i < (n6 = this.mSize); ++i) {
                    StringBuilder stringBuilder = new StringBuilder().append(i).append(": ");
                    int n7 = this.mKeys[i];
                    StringBuilder stringBuilder2 = stringBuilder.append(n7).append(" -> ");
                    boolean bl = this.mValues[i];
                    String string2 = stringBuilder2.append(bl).toString();
                    int n8 = Log.e("FAIL", string2);
                }
                throw new RuntimeException();
            }
            ++n;
        }
        return;
    }

    public void append(int n, boolean bl) {
        int n2;
        int n3;
        int[] nArray;
        int n4;
        if (this.mSize != 0 && n <= (n4 = (nArray = this.mKeys)[n3 = this.mSize - 1])) {
            this.put(n, bl);
            return;
        }
        int n5 = this.mSize;
        int n6 = this.mKeys.length;
        if (n5 >= n6) {
            int n7 = ArrayUtils.idealIntArraySize(n5 + 1);
            int[] nArray2 = new int[n7];
            boolean[] blArray = new boolean[n7];
            int[] nArray3 = this.mKeys;
            int n8 = this.mKeys.length;
            System.arraycopy(nArray3, 0, nArray2, 0, n8);
            boolean[] blArray2 = this.mValues;
            int n9 = this.mValues.length;
            System.arraycopy(blArray2, 0, blArray, 0, n9);
            this.mKeys = nArray2;
            this.mValues = blArray;
        }
        this.mKeys[n5] = n;
        this.mValues[n5] = bl;
        this.mSize = n2 = n5 + 1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void delete(int n) {
        int n2;
        int[] nArray = this.mKeys;
        int n3 = this.mSize;
        int n4 = SparseBooleanArray.binarySearch(nArray, 0, n3, n);
        if (n4 < 0) {
            return;
        }
        int[] nArray2 = this.mKeys;
        int n5 = n4 + 1;
        int[] nArray3 = this.mKeys;
        int n6 = this.mSize;
        int n7 = n4 + 1;
        int n8 = n6 - n7;
        System.arraycopy(nArray2, n5, nArray3, n4, n8);
        boolean[] blArray = this.mValues;
        int n9 = n4 + 1;
        boolean[] blArray2 = this.mValues;
        int n10 = this.mSize;
        int n11 = n4 + 1;
        int n12 = n10 - n11;
        System.arraycopy(blArray, n9, blArray2, n4, n12);
        this.mSize = n2 = this.mSize - 1;
    }

    public boolean get(int n) {
        return this.get(n, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean get(int n, boolean bl) {
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        int n3 = SparseBooleanArray.binarySearch(nArray, 0, n2, n);
        if (n3 >= 0) return this.mValues[n3];
        return bl;
    }

    public int indexOfKey(int n) {
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        return SparseBooleanArray.binarySearch(nArray, 0, n2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(boolean bl) {
        int n;
        int n2 = 0;
        while (n2 < (n = this.mSize)) {
            if (this.mValues[n2] != bl) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(int n, boolean bl) {
        int n2;
        int[] nArray = this.mKeys;
        int n3 = this.mSize;
        int n4 = SparseBooleanArray.binarySearch(nArray, 0, n3, n);
        if (n4 >= 0) {
            this.mValues[n4] = bl;
            return;
        }
        n4 ^= 0xFFFFFFFF;
        int n5 = this.mSize;
        int n6 = this.mKeys.length;
        if (n5 >= n6) {
            int n7 = ArrayUtils.idealIntArraySize(this.mSize + 1);
            int[] nArray2 = new int[n7];
            boolean[] blArray = new boolean[n7];
            int[] nArray3 = this.mKeys;
            int n8 = this.mKeys.length;
            System.arraycopy(nArray3, 0, nArray2, 0, n8);
            boolean[] blArray2 = this.mValues;
            int n9 = this.mValues.length;
            System.arraycopy(blArray2, 0, blArray, 0, n9);
            this.mKeys = nArray2;
            this.mValues = blArray;
        }
        if (this.mSize - n4 != 0) {
            int[] nArray4 = this.mKeys;
            int[] nArray5 = this.mKeys;
            int n10 = n4 + 1;
            int n11 = this.mSize - n4;
            System.arraycopy(nArray4, n4, nArray5, n10, n11);
            boolean[] blArray = this.mValues;
            boolean[] blArray3 = this.mValues;
            int n12 = n4 + 1;
            int n13 = this.mSize - n4;
            System.arraycopy(blArray, n4, blArray3, n12, n13);
        }
        this.mKeys[n4] = n;
        this.mValues[n4] = bl;
        this.mSize = n2 = this.mSize + 1;
    }

    public int size() {
        return this.mSize;
    }

    public boolean valueAt(int n) {
        return this.mValues[n];
    }
}

