/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import com.android.internal.util.ArrayUtils;

public class SparseIntArray {
    private int[] mKeys;
    private int mSize;
    private int[] mValues;

    public SparseIntArray() {
        this(10);
    }

    public SparseIntArray(int n) {
        int n2 = ArrayUtils.idealIntArraySize(n);
        int[] nArray = new int[n2];
        this.mKeys = nArray;
        int[] nArray2 = new int[n2];
        this.mValues = nArray2;
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n - 1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        int n7 = n + n2;
        if (n4 != n7) {
            return ~(n + n2);
        }
        if (nArray[n4] == n3) return ~n4;
        return n4;
    }

    private void checkIntegrity() {
        int n = 1;
        int n2;
        while (n < (n2 = this.mSize)) {
            int n3 = this.mKeys[n];
            int[] nArray = this.mKeys;
            int n4 = n - 1;
            int n5 = nArray[n4];
            if (n3 <= n5) {
                int n6;
                for (int i = 0; i < (n6 = this.mSize); ++i) {
                    StringBuilder stringBuilder = new StringBuilder().append(i).append(": ");
                    int n7 = this.mKeys[i];
                    StringBuilder stringBuilder2 = stringBuilder.append(n7).append(" -> ");
                    int n8 = this.mValues[i];
                    String string2 = stringBuilder2.append(n8).toString();
                    int n9 = Log.e("FAIL", string2);
                }
                throw new RuntimeException();
            }
            ++n;
        }
        return;
    }

    public void append(int n, int n2) {
        int n3;
        int n4;
        int[] nArray;
        int n5;
        if (this.mSize != 0 && n <= (n5 = (nArray = this.mKeys)[n4 = this.mSize - 1])) {
            this.put(n, n2);
            return;
        }
        int n6 = this.mSize;
        int n7 = this.mKeys.length;
        if (n6 >= n7) {
            int n8 = ArrayUtils.idealIntArraySize(n6 + 1);
            int[] nArray2 = new int[n8];
            int[] nArray3 = new int[n8];
            int[] nArray4 = this.mKeys;
            int n9 = this.mKeys.length;
            System.arraycopy(nArray4, 0, nArray2, 0, n9);
            int[] nArray5 = this.mValues;
            int n10 = this.mValues.length;
            System.arraycopy(nArray5, 0, nArray3, 0, n10);
            this.mKeys = nArray2;
            this.mValues = nArray3;
        }
        this.mKeys[n6] = n;
        this.mValues[n6] = n2;
        this.mSize = n3 = n6 + 1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void delete(int n) {
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        int n3 = SparseIntArray.binarySearch(nArray, 0, n2, n);
        if (n3 < 0) {
            return;
        }
        this.removeAt(n3);
    }

    public int get(int n) {
        return this.get(n, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int get(int n, int n2) {
        int[] nArray = this.mKeys;
        int n3 = this.mSize;
        int n4 = SparseIntArray.binarySearch(nArray, 0, n3, n);
        if (n4 >= 0) return this.mValues[n4];
        return n2;
    }

    public int indexOfKey(int n) {
        int[] nArray = this.mKeys;
        int n2 = this.mSize;
        return SparseIntArray.binarySearch(nArray, 0, n2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(int n) {
        int n2;
        int n3 = 0;
        while (n3 < (n2 = this.mSize)) {
            if (this.mValues[n3] != n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(int n, int n2) {
        int n3;
        int[] nArray = this.mKeys;
        int n4 = this.mSize;
        int n5 = SparseIntArray.binarySearch(nArray, 0, n4, n);
        if (n5 >= 0) {
            this.mValues[n5] = n2;
            return;
        }
        n5 ^= 0xFFFFFFFF;
        int n6 = this.mSize;
        int n7 = this.mKeys.length;
        if (n6 >= n7) {
            int n8 = ArrayUtils.idealIntArraySize(this.mSize + 1);
            int[] nArray2 = new int[n8];
            int[] nArray3 = new int[n8];
            int[] nArray4 = this.mKeys;
            int n9 = this.mKeys.length;
            System.arraycopy(nArray4, 0, nArray2, 0, n9);
            int[] nArray5 = this.mValues;
            int n10 = this.mValues.length;
            System.arraycopy(nArray5, 0, nArray3, 0, n10);
            this.mKeys = nArray2;
            this.mValues = nArray3;
        }
        if (this.mSize - n5 != 0) {
            int[] nArray6 = this.mKeys;
            int[] nArray7 = this.mKeys;
            int n11 = n5 + 1;
            int n12 = this.mSize - n5;
            System.arraycopy(nArray6, n5, nArray7, n11, n12);
            int[] nArray8 = this.mValues;
            int[] nArray9 = this.mValues;
            int n13 = n5 + 1;
            int n14 = this.mSize - n5;
            System.arraycopy(nArray8, n5, nArray9, n13, n14);
        }
        this.mKeys[n5] = n;
        this.mValues[n5] = n2;
        this.mSize = n3 = this.mSize + 1;
    }

    public void removeAt(int n) {
        int n2;
        int[] nArray = this.mKeys;
        int n3 = n + 1;
        int[] nArray2 = this.mKeys;
        int n4 = this.mSize;
        int n5 = n + 1;
        int n6 = n4 - n5;
        System.arraycopy(nArray, n3, nArray2, n, n6);
        int[] nArray3 = this.mValues;
        int n7 = n + 1;
        int[] nArray4 = this.mValues;
        int n8 = this.mSize;
        int n9 = n + 1;
        int n10 = n8 - n9;
        System.arraycopy(nArray3, n7, nArray4, n, n10);
        this.mSize = n2 = this.mSize - 1;
    }

    public int size() {
        return this.mSize;
    }

    public int valueAt(int n) {
        return this.mValues[n];
    }
}

