/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.DisplayMetrics;
import java.io.PrintStream;

public class TypedValue {
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_UNIT_DIP = 1;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_NONE = 65535;
    private static final String[] DIMENSION_UNIT_STRS;
    private static final String[] FRACTION_UNIT_STRS;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FIRST_COLOR_INT = 28;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_FRACTION = 6;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_INT_COLOR_ARGB4 = 30;
    public static final int TYPE_INT_COLOR_ARGB8 = 28;
    public static final int TYPE_INT_COLOR_RGB4 = 31;
    public static final int TYPE_INT_COLOR_RGB8 = 29;
    public static final int TYPE_INT_DEC = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_LAST_COLOR_INT = 31;
    public static final int TYPE_LAST_INT = 31;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_STRING = 3;
    public int assetCookie;
    public int changingConfigurations = -1;
    public int data;
    public int density;
    public int resourceId;
    public CharSequence string;
    public int type;

    static {
        RADIX_MULTS = new float[]{998244352, 0x38000000, 0x34000000, 0x30000000};
        String[] stringArray = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
        DIMENSION_UNIT_STRS = stringArray;
        String[] stringArray2 = new String[]{"%", "%p"};
        FRACTION_UNIT_STRS = stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float applyDimension(int n, float f, DisplayMetrics displayMetrics) {
        switch (n) {
            default: {
                return 0.0f;
            }
            case 0: {
                return f;
            }
            case 1: {
                return displayMetrics.density * f;
            }
            case 2: {
                return displayMetrics.scaledDensity * f;
            }
            case 3: {
                return displayMetrics.xdpi * f * 0.013888889f;
            }
            case 4: {
                return displayMetrics.xdpi * f;
            }
            case 5: 
        }
        return displayMetrics.xdpi * f * 0.03937008f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String coerceToString(int n, int n2) {
        switch (n) {
            default: {
                if (n < 28 || n > 31) break;
                StringBuilder stringBuilder = new StringBuilder().append("#");
                String string2 = Integer.toHexString(n2);
                return stringBuilder.append(string2).toString();
            }
            case 0: {
                return null;
            }
            case 1: {
                return "@" + n2;
            }
            case 2: {
                return "?" + n2;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(n2));
            }
            case 5: {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = Float.toString(TypedValue.complexToFloat(n2));
                StringBuilder stringBuilder2 = stringBuilder.append(string3);
                String[] stringArray = DIMENSION_UNIT_STRS;
                int n3 = n2 >> 0 & 0xF;
                String string4 = stringArray[n3];
                return stringBuilder2.append(string4).toString();
            }
            case 6: {
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = Float.toString(TypedValue.complexToFloat(n2) * 100.0f);
                StringBuilder stringBuilder3 = stringBuilder.append(string5);
                String[] stringArray = FRACTION_UNIT_STRS;
                int n4 = n2 >> 0 & 0xF;
                String string6 = stringArray[n4];
                return stringBuilder3.append(string6).toString();
            }
            case 17: {
                StringBuilder stringBuilder = new StringBuilder().append("0x");
                String string7 = Integer.toHexString(n2);
                return stringBuilder.append(string7).toString();
            }
            case 18: {
                if (n2 == 0) return "false";
                return "true";
            }
        }
        if (n < 16) return null;
        if (n > 31) return null;
        return Integer.toString(n2);
    }

    public static float complexToDimension(int n, DisplayMetrics displayMetrics) {
        int n2 = n >> 0 & 0xF;
        float f = TypedValue.complexToFloat(n);
        return TypedValue.applyDimension(n2, f, displayMetrics);
    }

    public static float complexToDimensionNoisy(int n, DisplayMetrics displayMetrics) {
        float f = TypedValue.complexToDimension(n, displayMetrics);
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder().append("Dimension (0x");
        int n2 = n >> 8 & 0xFFFFFF;
        StringBuilder stringBuilder2 = stringBuilder.append(n2).append("*");
        float[] fArray = RADIX_MULTS;
        int n3 = n >> 4 & 3;
        float f2 = fArray[n3] / 0.00390625f;
        StringBuilder stringBuilder3 = stringBuilder2.append(f2).append(")");
        String[] stringArray = DIMENSION_UNIT_STRS;
        int n4 = n >> 0 & 0xF;
        String string2 = stringArray[n4];
        String string3 = stringBuilder3.append(string2).append(" = ").append(f).toString();
        printStream.println(string3);
        return f;
    }

    public static int complexToDimensionPixelOffset(int n, DisplayMetrics displayMetrics) {
        int n2 = n >> 0 & 0xF;
        float f = TypedValue.complexToFloat(n);
        return (int)TypedValue.applyDimension(n2, f, displayMetrics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int complexToDimensionPixelSize(int n, DisplayMetrics displayMetrics) {
        float f = TypedValue.complexToFloat(n);
        float f2 = TypedValue.applyDimension(n >> 0 & 0xF, f, displayMetrics);
        int n2 = (int)(0.5f + f2);
        if (n2 != 0) {
            return n2;
        }
        if (f == 0.0f) {
            return 0;
        }
        if (!(f > 0.0f)) return -1;
        return 1;
    }

    public static float complexToFloat(int n) {
        float f = n & 0xFFFFFF00;
        float[] fArray = RADIX_MULTS;
        int n2 = n >> 4 & 3;
        float f2 = fArray[n2];
        return f * f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float complexToFraction(int n, float f, float f2) {
        switch (n >> 0 & 0xF) {
            default: {
                return 0.0f;
            }
            case 0: {
                return TypedValue.complexToFloat(n) * f;
            }
            case 1: 
        }
        return TypedValue.complexToFloat(n) * f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CharSequence coerceToString() {
        int n = this.type;
        if (n == 3) {
            return this.string;
        }
        int n2 = this.data;
        return TypedValue.coerceToString(n, n2);
    }

    public float getDimension(DisplayMetrics displayMetrics) {
        return TypedValue.complexToDimension(this.data, displayMetrics);
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.data);
    }

    public float getFraction(float f, float f2) {
        return TypedValue.complexToFraction(this.data, f, f2);
    }

    public void setTo(TypedValue typedValue) {
        int n;
        int n2;
        int n3;
        int n4;
        CharSequence charSequence;
        int n5;
        this.type = n5 = typedValue.type;
        this.string = charSequence = typedValue.string;
        this.data = n4 = typedValue.data;
        this.assetCookie = n3 = typedValue.assetCookie;
        this.resourceId = n2 = typedValue.resourceId;
        this.density = n = typedValue.density;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("TypedValue{t=0x");
        String string2 = Integer.toHexString(this.type);
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        StringBuilder stringBuilder4 = stringBuilder.append("/d=0x");
        String string3 = Integer.toHexString(this.data);
        StringBuilder stringBuilder5 = stringBuilder4.append(string3);
        if (this.type == 3) {
            void var9_10;
            StringBuilder stringBuilder6 = stringBuilder.append(" \"");
            if (this.string != null) {
                CharSequence charSequence = this.string;
            } else {
                String string4 = "<null>";
            }
            StringBuilder stringBuilder7 = stringBuilder6.append((CharSequence)var9_10).append("\"");
        }
        if (this.assetCookie != 0) {
            StringBuilder stringBuilder8 = stringBuilder.append(" a=");
            int n = this.assetCookie;
            StringBuilder stringBuilder9 = stringBuilder8.append(n);
        }
        if (this.resourceId != 0) {
            StringBuilder stringBuilder10 = stringBuilder.append(" r=0x");
            String string5 = Integer.toHexString(this.resourceId);
            StringBuilder stringBuilder11 = stringBuilder10.append(string5);
        }
        StringBuilder stringBuilder12 = stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

