/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.AttributeSet;
import android.util.XmlPullAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.harmony.xml.ExpatPullParser;
import org.apache.harmony.xml.ExpatReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class Xml {
    public static String FEATURE_RELAXED = "http://xmlpull.org/v1/doc/features.html#relaxed";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttributeSet asAttributeSet(XmlPullParser xmlPullParser) {
        if (!(xmlPullParser instanceof AttributeSet)) return new XmlPullAttributes(xmlPullParser);
        return (AttributeSet)((Object)xmlPullParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encoding findEncodingByName(String string2) throws UnsupportedEncodingException {
        if (string2 == null) {
            return Encoding.UTF_8;
        }
        Encoding[] encodingArray = Encoding.values();
        int n = encodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Encoding encoding = encodingArray[n2];
            if (encoding.expatName.equalsIgnoreCase(string2)) {
                return encoding;
            }
            ++n2;
        }
        throw new UnsupportedEncodingException(string2);
    }

    public static XmlPullParser newPullParser() {
        ExpatPullParser expatPullParser = new ExpatPullParser();
        expatPullParser.setNamespaceProcessingEnabled(true);
        return expatPullParser;
    }

    public static XmlSerializer newSerializer() {
        try {
            XmlSerializer xmlSerializer = XmlSerializerFactory.instance.newSerializer();
            return xmlSerializer;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new AssertionError((Object)xmlPullParserException);
        }
    }

    public static void parse(InputStream inputStream, Encoding encoding, ContentHandler contentHandler) throws IOException, SAXException {
        try {
            ExpatReader expatReader = new ExpatReader();
            expatReader.setContentHandler(contentHandler);
            InputSource inputSource = new InputSource(inputStream);
            String string2 = encoding.expatName;
            inputSource.setEncoding(string2);
            expatReader.parse(inputSource);
            return;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void parse(Reader reader, ContentHandler contentHandler) throws IOException, SAXException {
        ExpatReader expatReader = new ExpatReader();
        expatReader.setContentHandler(contentHandler);
        InputSource inputSource = new InputSource(reader);
        expatReader.parse(inputSource);
    }

    public static void parse(String string2, ContentHandler contentHandler) throws SAXException {
        try {
            ExpatReader expatReader = new ExpatReader();
            expatReader.setContentHandler(contentHandler);
            StringReader stringReader = new StringReader(string2);
            InputSource inputSource = new InputSource(stringReader);
            expatReader.parse(inputSource);
            return;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static final class Encoding
    extends Enum<Encoding> {
        private static final /* synthetic */ Encoding[] $VALUES;
        public static final /* enum */ Encoding ISO_8859_1;
        public static final /* enum */ Encoding US_ASCII;
        public static final /* enum */ Encoding UTF_16;
        public static final /* enum */ Encoding UTF_8;
        final String expatName;

        static {
            US_ASCII = new Encoding("US-ASCII");
            UTF_8 = new Encoding("UTF-8");
            UTF_16 = new Encoding("UTF-16");
            ISO_8859_1 = new Encoding("ISO-8859-1");
            Encoding encoding = US_ASCII;
            Encoding encoding2 = UTF_8;
            Encoding encoding3 = UTF_16;
            Encoding encoding4 = ISO_8859_1;
            Encoding[] encodingArray = new Encoding[]{encoding, encoding2, encoding3, encoding4};
            $VALUES = encodingArray;
        }

        private Encoding(String string3) {
            this.expatName = string3;
        }

        public static Encoding valueOf(String string2) {
            return Enum.valueOf(Encoding.class, string2);
        }

        public static Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }
    }

    static class XmlSerializerFactory {
        static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
        static final XmlPullParserFactory instance;

        static {
            try {
                instance = XmlPullParserFactory.newInstance(TYPE, null);
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new AssertionError((Object)xmlPullParserException);
            }
        }

        XmlSerializerFactory() {
        }
    }
}

