/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.view.LayoutInflater;

public class ContextThemeWrapper
extends ContextWrapper {
    private Context mBase;
    private LayoutInflater mInflater;
    private Resources.Theme mTheme;
    private int mThemeResource;

    public ContextThemeWrapper() {
        super(null);
    }

    public ContextThemeWrapper(Context context, int n) {
        super(context);
        this.mBase = context;
        this.mThemeResource = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeTheme() {
        boolean bl = this.mTheme == null;
        if (bl) {
            Resources.Theme theme;
            this.mTheme = theme = this.getResources().newTheme();
            Resources.Theme theme2 = this.mBase.getTheme();
            if (theme2 != null) {
                this.mTheme.setTo(theme2);
            }
        }
        Resources.Theme theme = this.mTheme;
        int n = this.mThemeResource;
        this.onApplyThemeResource(theme, n, bl);
    }

    @Override
    protected void attachBaseContext(Context context) {
        super.attachBaseContext(context);
        this.mBase = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getSystemService(String string2) {
        LayoutInflater layoutInflater;
        if (!"layout_inflater".equals(string2)) return this.mBase.getSystemService(string2);
        if (this.mInflater != null) return this.mInflater;
        this.mInflater = layoutInflater = LayoutInflater.from(this.mBase).cloneInContext(this);
        return this.mInflater;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resources.Theme getTheme() {
        if (this.mTheme != null) {
            return this.mTheme;
        }
        if (this.mThemeResource == 0) {
            this.mThemeResource = 16973829;
        }
        this.initializeTheme();
        return this.mTheme;
    }

    protected void onApplyThemeResource(Resources.Theme theme, int n, boolean bl) {
        theme.applyStyle(n, true);
    }

    @Override
    public void setTheme(int n) {
        this.mThemeResource = n;
        this.initializeTheme();
    }
}

