/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.DisplayMetrics;

public class Display {
    public static final int DEFAULT_DISPLAY;
    private static boolean mInitialized;
    private static final Object mStaticInit;
    private float mDensity;
    private int mDisplay;
    private float mDpiX;
    private float mDpiY;
    private int mPixelFormat;
    private float mRefreshRate;

    static {
        mStaticInit = new Object();
        mInitialized = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Display(int n) {
        Object object = mStaticInit;
        synchronized (object) {
            if (!mInitialized) {
                Display.nativeClassInit();
                mInitialized = true;
            }
        }
        this.mDisplay = n;
        this.init(n);
    }

    public static Display createMetricsBasedDisplay(int n, DisplayMetrics displayMetrics) {
        return new CompatibleDisplay(n, displayMetrics);
    }

    static native int getDisplayCount();

    private native void init(int var1);

    private static native void nativeClassInit();

    public int getDisplayId() {
        return this.mDisplay;
    }

    public native int getHeight();

    public void getMetrics(DisplayMetrics displayMetrics) {
        float f;
        float f2;
        float f3;
        int n;
        float f4;
        int n2;
        int n3;
        displayMetrics.widthPixels = n3 = this.getWidth();
        displayMetrics.heightPixels = n2 = this.getHeight();
        displayMetrics.density = f4 = this.mDensity;
        displayMetrics.densityDpi = n = (int)(this.mDensity * 160.0f + 0.5f);
        displayMetrics.scaledDensity = f3 = displayMetrics.density;
        displayMetrics.xdpi = f2 = this.mDpiX;
        displayMetrics.ydpi = f = this.mDpiY;
    }

    @Deprecated
    public native int getOrientation();

    public int getPixelFormat() {
        return this.mPixelFormat;
    }

    public float getRefreshRate() {
        return this.mRefreshRate;
    }

    public int getRotation() {
        return this.getOrientation();
    }

    public native int getWidth();

    private static class CompatibleDisplay
    extends Display {
        private final DisplayMetrics mMetrics;

        private CompatibleDisplay(int n, DisplayMetrics displayMetrics) {
            super(n);
            this.mMetrics = displayMetrics;
        }

        @Override
        public int getHeight() {
            return this.mMetrics.heightPixels;
        }

        @Override
        public int getWidth() {
            return this.mMetrics.widthPixels;
        }
    }
}

