/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import java.util.ArrayList;

public class FocusFinder {
    private static ThreadLocal<FocusFinder> tlFocusFinder = new ThreadLocal<FocusFinder>(){

        @Override
        protected FocusFinder initialValue() {
            return new FocusFinder();
        }
    };
    Rect mBestCandidateRect;
    Rect mFocusedRect;
    Rect mOtherRect;

    private FocusFinder() {
        Rect rect;
        Rect rect2;
        Rect rect3;
        this.mFocusedRect = rect3 = new Rect();
        this.mOtherRect = rect2 = new Rect();
        this.mBestCandidateRect = rect = new Rect();
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n) {
        ArrayList<View> arrayList = viewGroup.getFocusables(n);
        this.mBestCandidateRect.set(rect);
        switch (n) {
            case 17: {
                Rect rect2 = this.mBestCandidateRect;
                int n2 = rect.width() + 1;
                rect2.offset(n2, 0);
                break;
            }
            case 66: {
                Rect rect3 = this.mBestCandidateRect;
                int n3 = -(rect.width() + 1);
                rect3.offset(n3, 0);
                break;
            }
            case 33: {
                Rect rect4 = this.mBestCandidateRect;
                int n4 = rect.height() + 1;
                rect4.offset(0, n4);
                break;
            }
            case 130: {
                Rect rect5 = this.mBestCandidateRect;
                int n5 = -(rect.height() + 1);
                rect5.offset(0, n5);
            }
        }
        View view2 = null;
        int n6 = arrayList.size();
        for (int i = 0; i < n6; ++i) {
            View view3 = arrayList.get(i);
            if (view3 == view || view3 == viewGroup) continue;
            Rect rect6 = this.mOtherRect;
            view3.getDrawingRect(rect6);
            Rect rect7 = this.mOtherRect;
            viewGroup.offsetDescendantRectToMyCoords(view3, rect7);
            Rect rect8 = this.mOtherRect;
            Rect rect9 = this.mBestCandidateRect;
            if (!this.isBetterCandidate(n, rect, rect8, rect9)) continue;
            Rect rect10 = this.mBestCandidateRect;
            Rect rect11 = this.mOtherRect;
            rect10.set(rect11);
            view2 = view3;
        }
        return view2;
    }

    public static FocusFinder getInstance() {
        return tlFocusFinder.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTouchCandidate(int n, int n2, Rect rect, int n3) {
        switch (n3) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                if (rect.left > n) return false;
                if (rect.top > n2) return false;
                int n4 = rect.bottom;
                if (n2 > n4) return false;
                return true;
            }
            case 66: {
                if (rect.left < n) return false;
                if (rect.top > n2) return false;
                int n5 = rect.bottom;
                if (n2 > n5) return false;
                return true;
            }
            case 33: {
                if (rect.top > n2) return false;
                if (rect.left > n) return false;
                int n6 = rect.right;
                if (n > n6) return false;
                return true;
            }
            case 130: 
        }
        if (rect.top < n2) return false;
        if (rect.left > n) return false;
        int n7 = rect.right;
        if (n > n7) return false;
        return true;
    }

    static int majorAxisDistance(int n, Rect rect, Rect rect2) {
        int n2 = FocusFinder.majorAxisDistanceRaw(n, rect, rect2);
        return Math.max(0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int majorAxisDistanceRaw(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                int n2 = rect.left;
                int n3 = rect2.right;
                return n2 - n3;
            }
            case 66: {
                int n4 = rect2.left;
                int n5 = rect.right;
                return n4 - n5;
            }
            case 33: {
                int n6 = rect.top;
                int n7 = rect2.bottom;
                return n6 - n7;
            }
            case 130: 
        }
        int n8 = rect2.top;
        int n9 = rect.bottom;
        return n8 - n9;
    }

    static int majorAxisDistanceToFarEdge(int n, Rect rect, Rect rect2) {
        int n2 = FocusFinder.majorAxisDistanceToFarEdgeRaw(n, rect, rect2);
        return Math.max(1, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int majorAxisDistanceToFarEdgeRaw(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                int n2 = rect.left;
                int n3 = rect2.left;
                return n2 - n3;
            }
            case 66: {
                int n4 = rect2.right;
                int n5 = rect.right;
                return n4 - n5;
            }
            case 33: {
                int n6 = rect.top;
                int n7 = rect2.top;
                return n6 - n7;
            }
            case 130: 
        }
        int n8 = rect2.bottom;
        int n9 = rect.bottom;
        return n8 - n9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int minorAxisDistance(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: 
            case 66: {
                int n2 = rect.top;
                int n3 = rect.height() / 2;
                int n4 = n2 + n3;
                int n5 = rect2.top;
                int n6 = rect2.height() / 2;
                int n7 = n5 + n6;
                return Math.abs(n4 - n7);
            }
            case 33: 
            case 130: 
        }
        int n8 = rect.left;
        int n9 = rect.width() / 2;
        int n10 = n8 + n9;
        int n11 = rect2.left;
        int n12 = rect2.width() / 2;
        int n13 = n11 + n12;
        return Math.abs(n10 - n13);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean beamBeats(int n, Rect rect, Rect rect2, Rect rect3) {
        int n2;
        boolean bl = this.beamsOverlap(n, rect, rect2);
        if (this.beamsOverlap(n, rect, rect3)) return false;
        if (!bl) {
            return false;
        }
        if (!this.isToDirectionOf(n, rect, rect3)) {
            return true;
        }
        if (n == 17) return true;
        if (n == 66) {
            return true;
        }
        int n3 = FocusFinder.majorAxisDistance(n, rect, rect2);
        if (n3 >= (n2 = FocusFinder.majorAxisDistanceToFarEdge(n, rect, rect3))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean beamsOverlap(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: 
            case 66: {
                int n2 = rect2.bottom;
                int n3 = rect.top;
                if (n2 < n3) return false;
                int n4 = rect2.top;
                int n5 = rect.bottom;
                if (n4 > n5) return false;
                return true;
            }
            case 33: 
            case 130: 
        }
        int n6 = rect2.right;
        int n7 = rect.left;
        if (n6 < n7) return false;
        int n8 = rect2.left;
        int n9 = rect.right;
        if (n8 > n9) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View findNearestTouchable(ViewGroup viewGroup, int n, int n2, int n3, int[] nArray) {
        ArrayList<View> arrayList = viewGroup.getTouchables();
        View view = null;
        int n4 = arrayList.size();
        int n5 = ViewConfiguration.get(viewGroup.mContext).getScaledEdgeSlop();
        Rect rect = new Rect();
        Rect rect2 = this.mOtherRect;
        int n6 = 0;
        while (n6 < n4) {
            View view2 = arrayList.get(n6);
            view2.getDrawingRect(rect2);
            ViewGroup viewGroup2 = viewGroup;
            View view3 = view2;
            Rect rect3 = rect2;
            boolean bl = true;
            boolean bl2 = true;
            viewGroup2.offsetRectBetweenParentAndChild(view3, rect3, bl, bl2);
            FocusFinder focusFinder = this;
            int n7 = n;
            int n8 = n2;
            Rect rect4 = rect2;
            int n9 = n3;
            if (focusFinder.isTouchCandidate(n7, n8, rect4, n9)) {
                int n10 = Integer.MAX_VALUE;
                switch (n3) {
                    case 17: {
                        int n11 = rect2.right;
                        n10 = n - n11 + 1;
                        break;
                    }
                    case 66: {
                        n10 = rect2.left;
                        break;
                    }
                    case 33: {
                        int n12 = rect2.bottom;
                        n10 = n2 - n12 + 1;
                        break;
                    }
                    case 130: {
                        n10 = rect2.top;
                        break;
                    }
                }
                if (n10 < n5 && (view == null || rect.contains(rect2) || !rect2.contains(rect) && n10 < Integer.MAX_VALUE)) {
                    int n13 = n10;
                    view = view2;
                    rect.set(rect2);
                    switch (n3) {
                        default: {
                            break;
                        }
                        case 17: {
                            int n14;
                            nArray[0] = n14 = -n10;
                            break;
                        }
                        case 66: {
                            nArray[0] = n10;
                            break;
                        }
                        case 33: {
                            int n15;
                            nArray[1] = n15 = -n10;
                            break;
                        }
                        case 130: {
                            nArray[1] = n10;
                        }
                    }
                }
            }
            ++n6;
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final View findNextFocus(ViewGroup viewGroup, View view, int n) {
        if (view != null) {
            View view2 = view.findUserSetNextFocus(viewGroup, n);
            if (view2 != null && view2.isFocusable()) {
                if (!view2.isInTouchMode()) return view2;
                if (view2.isFocusableInTouchMode()) {
                    return view2;
                }
            }
            Rect rect = this.mFocusedRect;
            view.getFocusedRect(rect);
            Rect rect2 = this.mFocusedRect;
            viewGroup.offsetDescendantRectToMyCoords(view, rect2);
        } else {
            switch (n) {
                default: {
                    break;
                }
                case 17: 
                case 33: {
                    int n2 = viewGroup.getScrollY();
                    int n3 = viewGroup.getHeight();
                    int n4 = n2 + n3;
                    int n5 = viewGroup.getScrollX();
                    int n6 = viewGroup.getWidth();
                    int n7 = n5 + n6;
                    this.mFocusedRect.set(n7, n4, n7, n4);
                    break;
                }
                case 66: 
                case 130: {
                    int n8 = viewGroup.getScrollY();
                    int n9 = viewGroup.getScrollX();
                    this.mFocusedRect.set(n9, n8, n9, n8);
                }
            }
        }
        Rect rect = this.mFocusedRect;
        return this.findNextFocus(viewGroup, view, rect, n);
    }

    public View findNextFocusFromRect(ViewGroup viewGroup, Rect rect, int n) {
        return this.findNextFocus(viewGroup, null, rect, n);
    }

    int getWeightedDistanceFor(int n, int n2) {
        int n3 = n * 13 * n;
        int n4 = n2 * n2;
        return n3 + n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isBetterCandidate(int n, Rect rect, Rect rect2, Rect rect3) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!this.isCandidate(rect, rect2, n)) {
            return false;
        }
        if (!this.isCandidate(rect, rect3, n)) {
            return true;
        }
        if (this.beamBeats(n, rect, rect2, rect3)) {
            return true;
        }
        if (this.beamBeats(n, rect, rect3, rect2)) {
            return false;
        }
        int n6 = FocusFinder.majorAxisDistance(n, rect, rect2);
        int n7 = this.getWeightedDistanceFor(n6, n5 = FocusFinder.minorAxisDistance(n, rect, rect2));
        if (n7 >= (n4 = this.getWeightedDistanceFor(n3 = FocusFinder.majorAxisDistance(n, rect, rect3), n2 = FocusFinder.minorAxisDistance(n, rect, rect3)))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isCandidate(Rect rect, Rect rect2, int n) {
        int n2;
        int n3;
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                int n4;
                int n5;
                int n6 = rect.right;
                int n7 = rect2.right;
                if (n6 <= n7) {
                    int n8 = rect.left;
                    int n9 = rect2.right;
                    if (n8 < n9) return false;
                }
                if ((n5 = rect.left) <= (n4 = rect2.left)) return false;
                return true;
            }
            case 66: {
                int n10;
                int n11;
                int n12 = rect.left;
                int n13 = rect2.left;
                if (n12 >= n13) {
                    int n14 = rect.right;
                    int n15 = rect2.left;
                    if (n14 > n15) return false;
                }
                if ((n11 = rect.right) >= (n10 = rect2.right)) return false;
                return true;
            }
            case 33: {
                int n16;
                int n17;
                int n18 = rect.bottom;
                int n19 = rect2.bottom;
                if (n18 <= n19) {
                    int n20 = rect.top;
                    int n21 = rect2.bottom;
                    if (n20 < n21) return false;
                }
                if ((n17 = rect.top) <= (n16 = rect2.top)) return false;
                return true;
            }
            case 130: 
        }
        int n22 = rect.top;
        int n23 = rect2.top;
        if (n22 >= n23) {
            int n24 = rect.bottom;
            int n25 = rect2.top;
            if (n24 > n25) return false;
        }
        if ((n3 = rect.bottom) >= (n2 = rect2.bottom)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isToDirectionOf(int n, Rect rect, Rect rect2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
            case 17: {
                int n2 = rect.left;
                int n3 = rect2.right;
                if (n2 < n3) return false;
                return true;
            }
            case 66: {
                int n4 = rect.right;
                int n5 = rect2.left;
                if (n4 > n5) return false;
                return true;
            }
            case 33: {
                int n6 = rect.top;
                int n7 = rect2.bottom;
                if (n6 < n7) return false;
                return true;
            }
            case 130: 
        }
        int n8 = rect.bottom;
        int n9 = rect2.top;
        if (n8 > n9) return false;
        return true;
    }
}

